/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class TableViewBehavior<T>
extends BehaviorBase<TableView<T>> {
    protected static final List<KeyBinding> TABLE_VIEW_BINDINGS = new ArrayList<KeyBinding>();
    private boolean isCtrlDown = false;
    private boolean isShiftDown = false;
    private TablePosition anchor;
    private Callback<Void, Integer> onScrollPageUp;
    private Callback<Void, Integer> onScrollPageDown;
    private Runnable onFocusPreviousRow;
    private Runnable onFocusNextRow;
    private Runnable onSelectPreviousRow;
    private Runnable onSelectNextRow;
    private Runnable onMoveToFirstCell;
    private Runnable onMoveToLastCell;
    private Runnable onSelectRightCell;
    private Runnable onSelectLeftCell;

    @Override
    protected void callAction(String string) {
        if ("SelectPreviousRow".equals(string)) {
            this.selectPreviousRow();
        } else if ("SelectNextRow".equals(string)) {
            this.selectNextRow();
        } else if ("SelectLeftCell".equals(string)) {
            this.selectLeftCell();
        } else if ("SelectRightCell".equals(string)) {
            this.selectRightCell();
        } else if ("SelectFirstRow".equals(string)) {
            this.selectFirstRow();
        } else if ("SelectLastRow".equals(string)) {
            this.selectLastRow();
        } else if ("SelectAll".equals(string)) {
            this.selectAll();
        } else if ("SelectAllPageUp".equals(string)) {
            this.selectAllPageUp();
        } else if ("SelectAllPageDown".equals(string)) {
            this.selectAllPageDown();
        } else if ("SelectAllToFirstRow".equals(string)) {
            this.selectAllToFirstRow();
        } else if ("SelectAllToLastRow".equals(string)) {
            this.selectAllToLastRow();
        } else if ("AlsoSelectNext".equals(string)) {
            this.alsoSelectNext();
        } else if ("AlsoSelectPrevious".equals(string)) {
            this.alsoSelectPrevious();
        } else if ("AlsoSelectLeftCell".equals(string)) {
            this.alsoSelectLeftCell();
        } else if ("AlsoSelectRightCell".equals(string)) {
            this.alsoSelectRightCell();
        } else if ("ClearSelection".equals(string)) {
            this.clearSelection();
        } else if ("ScrollUp".equals(string)) {
            this.scrollUp();
        } else if ("ScrollDown".equals(string)) {
            this.scrollDown();
        } else if ("FocusPreviousRow".equals(string)) {
            this.focusPreviousRow();
        } else if ("FocusNextRow".equals(string)) {
            this.focusNextRow();
        } else if ("FocusLeftCell".equals(string)) {
            this.focusLeftCell();
        } else if ("FocusRightCell".equals(string)) {
            this.focusRightCell();
        } else if ("Activate".equals(string)) {
            this.activate();
        } else if ("CancelEdit".equals(string)) {
            this.cancelEdit();
        } else if ("FocusFirstRow".equals(string)) {
            this.focusFirstRow();
        } else if ("FocusLastRow".equals(string)) {
            this.focusLastRow();
        } else if ("toggleFocusOwnerSelection".equals(string)) {
            this.toggleFocusOwnerSelection();
        } else if ("SelectAllToFocus".equals(string)) {
            this.selectAllToFocus();
        } else if ("FocusPageUp".equals(string)) {
            this.focusPageUp();
        } else if ("FocusPageDown".equals(string)) {
            this.focusPageDown();
        } else {
            super.callAction(string);
        }
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return TABLE_VIEW_BINDINGS;
    }

    @Override
    protected void callActionForEvent(KeyEvent keyEvent) {
        this.isShiftDown = keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isShiftDown();
        this.isCtrlDown = keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isControlDown();
        super.callActionForEvent(keyEvent);
    }

    public TableViewBehavior(TableView tableView) {
        super(tableView);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        ObservableList<TablePosition> observableList = ((TableView)this.getControl()).getSelectionModel().getSelectedCells();
        this.setAnchor(observableList.isEmpty() ? null : (TablePosition)observableList.get(0));
        if (!((TableView)this.getControl()).isFocused() && ((TableView)this.getControl()).isFocusTraversable()) {
            ((TableView)this.getControl()).requestFocus();
        }
    }

    private void setAnchor(int n, TableColumn tableColumn) {
        this.setAnchor((TablePosition)(n == -1 && tableColumn == null ? null : new TablePosition((TableView)this.getControl(), n, tableColumn)));
    }

    private void setAnchor(TablePosition tablePosition) {
        this.anchor = tablePosition;
    }

    private int getItemCount() {
        return ((TableView)this.getControl()).getItems() == null ? 0 : ((TableView)this.getControl()).getItems().size();
    }

    public void setOnScrollPageUp(Callback<Void, Integer> callback) {
        this.onScrollPageUp = callback;
    }

    public void setOnScrollPageDown(Callback<Void, Integer> callback) {
        this.onScrollPageDown = callback;
    }

    public void setOnFocusPreviousRow(Runnable runnable) {
        this.onFocusPreviousRow = runnable;
    }

    public void setOnFocusNextRow(Runnable runnable) {
        this.onFocusNextRow = runnable;
    }

    public void setOnSelectPreviousRow(Runnable runnable) {
        this.onSelectPreviousRow = runnable;
    }

    public void setOnSelectNextRow(Runnable runnable) {
        this.onSelectNextRow = runnable;
    }

    public void setOnMoveToFirstCell(Runnable runnable) {
        this.onMoveToFirstCell = runnable;
    }

    public void setOnMoveToLastCell(Runnable runnable) {
        this.onMoveToLastCell = runnable;
    }

    public void setOnSelectRightCell(Runnable runnable) {
        this.onSelectRightCell = runnable;
    }

    public void setOnSelectLeftCell(Runnable runnable) {
        this.onSelectLeftCell = runnable;
    }

    private void scrollUp() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null || tableViewSelectionModel.getSelectedCells().isEmpty()) {
            return;
        }
        TablePosition tablePosition = (TablePosition)tableViewSelectionModel.getSelectedCells().get(0);
        int n = -1;
        if (this.onScrollPageUp != null) {
            n = this.onScrollPageUp.call(null);
        }
        if (n == -1) {
            return;
        }
        tableViewSelectionModel.clearAndSelect(n, tablePosition.getTableColumn());
    }

    private void scrollDown() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null || tableViewSelectionModel.getSelectedCells().isEmpty()) {
            return;
        }
        TablePosition tablePosition = (TablePosition)tableViewSelectionModel.getSelectedCells().get(0);
        int n = -1;
        if (this.onScrollPageDown != null) {
            n = this.onScrollPageDown.call(null);
        }
        if (n == -1) {
            return;
        }
        tableViewSelectionModel.clearAndSelect(n, tablePosition.getTableColumn());
    }

    private void focusFirstRow() {
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        tableViewFocusModel.focus(0);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void focusLastRow() {
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        tableViewFocusModel.focus(this.getItemCount() - 1);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void focusPreviousRow() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        if (tableViewSelectionModel.isCellSelectionEnabled()) {
            tableViewFocusModel.focusAboveCell();
        } else {
            tableViewFocusModel.focusPrevious();
        }
        if (!this.isCtrlDown || this.anchor == null) {
            this.setAnchor(tableViewFocusModel.getFocusedIndex(), null);
        }
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    private void focusNextRow() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        if (tableViewSelectionModel.isCellSelectionEnabled()) {
            tableViewFocusModel.focusBelowCell();
        } else {
            tableViewFocusModel.focusNext();
        }
        if (!this.isCtrlDown || this.anchor == null) {
            this.setAnchor(tableViewFocusModel.getFocusedIndex(), null);
        }
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    private void focusLeftCell() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        tableViewFocusModel.focusLeftCell();
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    private void focusRightCell() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        tableViewFocusModel.focusRightCell();
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    private void focusPageUp() {
        int n = this.onScrollPageUp.call(null);
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        TableColumn tableColumn = tableViewFocusModel.getFocusedCell() == null ? null : tableViewFocusModel.getFocusedCell().getTableColumn();
        tableViewFocusModel.focus(n, tableColumn);
    }

    private void focusPageDown() {
        int n = this.onScrollPageDown.call(null);
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        TableColumn tableColumn = tableViewFocusModel.getFocusedCell() == null ? null : tableViewFocusModel.getFocusedCell().getTableColumn();
        tableViewFocusModel.focus(n, tableColumn);
    }

    private void clearSelection() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        tableViewSelectionModel.clearSelection();
    }

    private void alsoSelectPrevious() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null || tableViewSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        int n = tableViewFocusModel.getFocusedIndex();
        if (tableViewSelectionModel.isCellSelectionEnabled()) {
            TablePosition tablePosition = tableViewFocusModel.getFocusedCell();
            if (this.isShiftDown && tableViewSelectionModel.isSelected(tablePosition.getRow() - 1, tablePosition.getTableColumn())) {
                int n2 = tablePosition.getRow() - 1;
                tableViewSelectionModel.clearSelection(tableViewFocusModel.getFocusedIndex(), tablePosition.getTableColumn());
                tableViewFocusModel.focus(n2, tablePosition.getTableColumn());
            } else {
                if (!tableViewSelectionModel.isSelected(n, tablePosition.getTableColumn())) {
                    tableViewSelectionModel.select(n, tablePosition.getTableColumn());
                }
                tableViewSelectionModel.selectAboveCell();
            }
        } else if (this.isShiftDown && this.anchor != null) {
            int n3 = tableViewFocusModel.getFocusedIndex() - 1;
            this.clearSelectionOutsideRange(this.anchor.getRow(), n3);
            if (this.anchor.getRow() > n3) {
                tableViewSelectionModel.selectRange(this.anchor.getRow(), n3 - 1);
            } else {
                tableViewSelectionModel.selectRange(this.anchor.getRow(), n3 + 1);
            }
        } else {
            tableViewSelectionModel.selectPrevious();
        }
        this.onSelectPreviousRow.run();
    }

    private void alsoSelectNext() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null || tableViewSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        if (tableViewSelectionModel.isCellSelectionEnabled()) {
            TablePosition tablePosition = tableViewFocusModel.getFocusedCell();
            if (this.isShiftDown && tableViewSelectionModel.isSelected(tablePosition.getRow() + 1, tablePosition.getTableColumn())) {
                int n = tablePosition.getRow() + 1;
                tableViewSelectionModel.clearSelection(tableViewFocusModel.getFocusedIndex(), tablePosition.getTableColumn());
                tableViewFocusModel.focus(n, tablePosition.getTableColumn());
            } else {
                tableViewSelectionModel.selectBelowCell();
            }
        } else if (this.isShiftDown && this.anchor != null) {
            int n = tableViewFocusModel.getFocusedIndex() + 1;
            this.clearSelectionOutsideRange(this.anchor.getRow(), n);
            if (this.anchor.getRow() > n) {
                tableViewSelectionModel.selectRange(this.anchor.getRow(), n - 1);
            } else {
                tableViewSelectionModel.selectRange(this.anchor.getRow(), n + 1);
            }
        } else {
            tableViewSelectionModel.selectNext();
        }
        this.onSelectNextRow.run();
    }

    private void clearSelectionOutsideRange(int n, int n2) {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(tableViewSelectionModel.getSelectedIndices());
        for (int i = 0; i < arrayList.size(); ++i) {
            int n5 = (Integer)arrayList.get(i);
            if (n5 >= n3 && n5 < n4) continue;
            tableViewSelectionModel.clearSelection(n5);
        }
    }

    private void alsoSelectLeftCell() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null || tableViewSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        TablePosition tablePosition = tableViewFocusModel.getFocusedCell();
        if (tablePosition == null || tablePosition.getTableColumn() == null) {
            return;
        }
        TableColumn tableColumn = this.getColumn(tablePosition.getTableColumn(), -1);
        if (tableColumn == null) {
            return;
        }
        if (this.isShiftDown && this.anchor != null && tableViewSelectionModel.isSelected(tablePosition.getRow(), tableColumn) && (tablePosition.getRow() != this.anchor.getRow() || !tablePosition.getTableColumn().equals(tableColumn))) {
            tableViewSelectionModel.clearSelection(tablePosition.getRow(), tablePosition.getTableColumn());
            tableViewFocusModel.focus(tablePosition.getRow(), tableColumn);
        } else {
            tableViewSelectionModel.selectLeftCell();
        }
    }

    private void alsoSelectRightCell() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null || tableViewSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        TablePosition tablePosition = tableViewFocusModel.getFocusedCell();
        if (tablePosition == null || tablePosition.getTableColumn() == null) {
            return;
        }
        TableColumn tableColumn = this.getColumn(tablePosition.getTableColumn(), 1);
        if (tableColumn == null) {
            return;
        }
        if (this.isShiftDown && this.anchor != null && tableViewSelectionModel.isSelected(tablePosition.getRow(), tableColumn) && (tablePosition.getRow() != this.anchor.getRow() || !tablePosition.getTableColumn().equals(tableColumn))) {
            tableViewSelectionModel.clearSelection(tablePosition.getRow(), tablePosition.getTableColumn());
            tableViewFocusModel.focus(tablePosition.getRow(), tableColumn);
        } else {
            tableViewSelectionModel.selectRightCell();
        }
    }

    private TableColumn getColumn(TableColumn tableColumn, int n) {
        return ((TableView)this.getControl()).getVisibleLeafColumn(((TableView)this.getControl()).getVisibleLeafIndex(tableColumn) + n);
    }

    private void selectFirstRow() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        ObservableList<TablePosition> observableList = tableViewSelectionModel.getSelectedCells();
        TableColumn tableColumn = observableList.size() == 0 ? null : ((TablePosition)observableList.get(0)).getTableColumn();
        tableViewSelectionModel.clearAndSelect(0, tableColumn);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void selectLastRow() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        ObservableList<TablePosition> observableList = tableViewSelectionModel.getSelectedCells();
        TableColumn tableColumn = observableList.size() == 0 ? null : ((TablePosition)observableList.get(0)).getTableColumn();
        tableViewSelectionModel.clearAndSelect(this.getItemCount() - 1, tableColumn);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void selectPreviousRow() {
        this.selectCell(-1, 0);
        if (this.onSelectPreviousRow != null) {
            this.onSelectPreviousRow.run();
        }
    }

    private void selectNextRow() {
        this.selectCell(1, 0);
        if (this.onSelectNextRow != null) {
            this.onSelectNextRow.run();
        }
    }

    private void selectLeftCell() {
        this.selectCell(0, -1);
        if (this.onSelectLeftCell != null) {
            this.onSelectLeftCell.run();
        }
    }

    private void selectRightCell() {
        this.selectCell(0, 1);
        if (this.onSelectRightCell != null) {
            this.onSelectRightCell.run();
        }
    }

    private void selectCell(int n, int n2) {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        TablePosition tablePosition = tableViewFocusModel.getFocusedCell();
        int n3 = tablePosition.getRow();
        int n4 = tablePosition.getColumn();
        if (n < 0 && n3 == 0) {
            return;
        }
        if (n > 0 && n3 == this.getItemCount() - 1) {
            return;
        }
        if (n2 < 0 && n4 == 0) {
            return;
        }
        if (n2 > 0 && n4 == this.getVisibleLeafColumnCount(((TableView)this.getControl()).getColumns(), 0) - 1) {
            return;
        }
        TableColumn tableColumn = tablePosition.getTableColumn();
        tableColumn = this.getColumn(tableColumn, n2);
        int n5 = tablePosition.getRow() + n;
        tableViewSelectionModel.clearAndSelect(n5, tableColumn);
        this.setAnchor(n5, tableColumn);
    }

    private int getVisibleLeafColumnCount(List list, int n) {
        if (list == null || list.isEmpty()) {
            return n;
        }
        for (int i = 0; i < list.size(); ++i) {
            TableColumn tableColumn = (TableColumn)list.get(i);
            if (tableColumn.getColumns() != null && tableColumn.getColumns().isEmpty()) {
                ++n;
                continue;
            }
            n += this.getVisibleLeafColumnCount(tableColumn.getColumns(), n);
        }
        return n;
    }

    private void cancelEdit() {
        ((TableView)this.getControl()).edit(-1, null);
    }

    private void activate() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        TablePosition tablePosition = tableViewFocusModel.getFocusedCell();
        tableViewSelectionModel.select(tablePosition.getRow(), tablePosition.getTableColumn());
        ((TableView)this.getControl()).edit(tablePosition.getRow(), tablePosition.getTableColumn());
    }

    private void selectAllToFocus() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        TablePosition tablePosition = tableViewFocusModel.getFocusedCell();
        int n = tablePosition.getRow();
        int n2 = tableViewSelectionModel.getSelectedIndex();
        tableViewSelectionModel.clearSelection();
        if (!tableViewSelectionModel.isCellSelectionEnabled()) {
            int n3 = n2;
            int n4 = n2 > n ? n - 1 : n + 1;
            tableViewSelectionModel.selectRange(n3, n4);
        } else {
            int n5 = Math.min(n2, n);
            int n6 = Math.max(n2, n);
            for (int i = n5; i <= n6; ++i) {
                tableViewSelectionModel.select(i, tablePosition.getTableColumn());
            }
        }
    }

    private void selectAll() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        tableViewSelectionModel.selectAll();
    }

    private void selectAllToFirstRow() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        TablePosition tablePosition = tableViewFocusModel.getFocusedCell();
        int n = tablePosition.getRow();
        if (this.isShiftDown) {
            n = this.anchor == null ? n : this.anchor.getRow();
        }
        tableViewSelectionModel.clearSelection();
        if (!tableViewSelectionModel.isCellSelectionEnabled()) {
            tableViewSelectionModel.selectRange(0, n + 1);
            ((TableView)this.getControl()).getFocusModel().focus(0);
            this.setAnchor(n, null);
        }
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void selectAllToLastRow() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        TablePosition tablePosition = tableViewFocusModel.getFocusedCell();
        int n = tablePosition.getRow();
        if (this.isShiftDown) {
            n = this.anchor == null ? n : this.anchor.getRow();
            this.setAnchor(n, null);
        }
        tableViewSelectionModel.clearSelection();
        if (!tableViewSelectionModel.isCellSelectionEnabled()) {
            tableViewSelectionModel.selectRange(n, this.getItemCount());
        }
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void selectAllPageUp() {
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        int n = tableViewFocusModel.getFocusedIndex();
        if (this.isShiftDown) {
            n = this.anchor == null ? n : this.anchor.getRow();
            this.setAnchor(n, null);
        }
        int n2 = this.onScrollPageUp.call(null);
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        tableViewSelectionModel.clearSelection();
        tableViewSelectionModel.selectRange(n2, n + 1);
    }

    private void selectAllPageDown() {
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        int n = tableViewFocusModel.getFocusedIndex();
        if (this.isShiftDown) {
            n = this.anchor == null ? n : this.anchor.getRow();
            this.setAnchor(n, null);
        }
        int n2 = this.onScrollPageDown.call(null);
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        tableViewSelectionModel.clearSelection();
        tableViewSelectionModel.selectRange(n, n2 + 1);
    }

    private void toggleFocusOwnerSelection() {
        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.getControl()).getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        TableView.TableViewFocusModel tableViewFocusModel = ((TableView)this.getControl()).getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        TablePosition tablePosition = tableViewFocusModel.getFocusedCell();
        if (tableViewSelectionModel.isSelected(tablePosition.getRow(), tablePosition.getTableColumn())) {
            tableViewSelectionModel.clearSelection(tablePosition.getRow(), tablePosition.getTableColumn());
        } else {
            tableViewSelectionModel.select(tablePosition.getRow(), tablePosition.getTableColumn());
        }
    }

    static {
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectFirstRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectLastRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "ScrollUp"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "ScrollDown"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "SelectLeftCell"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "SelectLeftCell"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "SelectRightCell"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "SelectRightCell"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "SelectPreviousRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, "SelectPreviousRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "SelectNextRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, "SelectNextRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "TraverseLeft"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "TraverseLeft"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "SelectNextRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "SelectNextRow"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "TraverseUp"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, "TraverseUp"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "TraverseDown"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, "TraverseDown"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectAllToFirstRow").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectAllToLastRow").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "SelectAllPageUp").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "SelectAllPageDown").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "AlsoSelectPrevious").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, "AlsoSelectPrevious").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "AlsoSelectNext").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, "AlsoSelectNext").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "SelectAllToFocus").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "AlsoSelectLeftCell").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "AlsoSelectLeftCell").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "AlsoSelectRightCell").shift());
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "AlsoSelectRightCell").shift());
        if (Utils.isMac()) {
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "FocusPreviousRow").meta());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "FocusNextRow").meta());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "FocusRightCell").meta());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "FocusRightCell").meta());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "FocusLeftCell").meta());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "FocusLeftCell").meta());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.A, "SelectAll").meta());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "FocusFirstRow").meta());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "FocusLastRow").meta());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").meta());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "FocusPageUp").meta());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "FocusPageDown").meta());
        } else {
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "FocusPreviousRow").ctrl());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "FocusNextRow").ctrl());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "FocusRightCell").ctrl());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "FocusRightCell").ctrl());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "FocusLeftCell").ctrl());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "FocusLeftCell").ctrl());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.A, "SelectAll").ctrl());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "FocusFirstRow").ctrl());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "FocusLastRow").ctrl());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").ctrl());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "FocusPageUp").ctrl());
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "FocusPageDown").ctrl());
        }
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ENTER, "Activate"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "Activate"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.F2, "Activate"));
        TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, "CancelEdit"));
        if (Utils.isMac()) {
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.BACK_SLASH, "ClearSelection").meta());
        } else {
            TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.BACK_SLASH, "ClearSelection").ctrl());
        }
    }
}

