/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;

public class TableCellBehavior
extends CellBehaviorBase<TableCell> {
    private static final Map<TableView, TablePosition> map = new HashMap<TableView, TablePosition>();

    public TableCellBehavior(TableCell tableCell) {
        super(tableCell);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TableCell tableCell = (TableCell)this.getControl();
        if (!tableCell.contains(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        TableView tableView = tableCell.getTableView();
        ObservableList observableList = tableView.getItems();
        if (observableList == null || tableCell.getIndex() >= observableList.size()) {
            return;
        }
        TableView.TableViewSelectionModel tableViewSelectionModel = tableView.getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        boolean bl = !tableViewSelectionModel.isCellSelectionEnabled() ? tableCell.getTableRow().isSelected() : tableCell.isSelected();
        int n = tableCell.getIndex();
        int n2 = this.getColumn();
        TableColumn tableColumn = ((TableCell)this.getControl()).getTableColumn();
        TableView.TableViewFocusModel tableViewFocusModel = tableView.getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        if (mouseEvent.isShiftDown()) {
            if (!map.containsKey(tableView)) {
                map.put(tableView, tableViewFocusModel.getFocusedCell());
            }
        } else {
            map.remove(tableView);
        }
        if (tableViewSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            this.simpleSelect(mouseEvent);
        } else if (mouseEvent.isControlDown() || mouseEvent.isMetaDown()) {
            if (bl) {
                tableViewSelectionModel.clearSelection(n, tableColumn);
            } else {
                tableViewSelectionModel.select(n, tableColumn);
            }
        } else if (mouseEvent.isShiftDown()) {
            TablePosition tablePosition = map.containsKey(tableView) ? map.get(tableView) : tableViewFocusModel.getFocusedCell();
            int n3 = Math.min(tablePosition.getRow(), n);
            int n4 = Math.max(tablePosition.getRow(), n);
            int n5 = Math.min(tablePosition.getColumn(), n2);
            int n6 = Math.max(tablePosition.getColumn(), n2);
            tableViewSelectionModel.clearSelection();
            for (int i = n3; i <= n4; ++i) {
                for (int j = n5; j <= n6; ++j) {
                    tableViewSelectionModel.select(i, tableView.getVisibleLeafColumn(j));
                }
            }
            tableViewFocusModel.focus(new TablePosition(tableView, n, tableColumn));
        } else {
            this.simpleSelect(mouseEvent);
        }
    }

    private void simpleSelect(MouseEvent mouseEvent) {
        TableView tableView = ((TableCell)this.getControl()).getTableView();
        TableView.TableViewSelectionModel tableViewSelectionModel = tableView.getSelectionModel();
        int n = ((TableCell)this.getControl()).getIndex();
        boolean bl = tableViewSelectionModel.isSelected(n, ((TableCell)this.getControl()).getTableColumn());
        tableView.getSelectionModel().clearAndSelect(n, ((TableCell)this.getControl()).getTableColumn());
        if (mouseEvent.getClickCount() == 1 && bl) {
            tableView.edit(n, ((TableCell)this.getControl()).getTableColumn());
        } else if (mouseEvent.getClickCount() == 1) {
            tableView.edit(-1, null);
        } else if (mouseEvent.getClickCount() == 2 && ((TableCell)this.getControl()).isEditable()) {
            tableView.edit(n, ((TableCell)this.getControl()).getTableColumn());
        }
    }

    private int getColumn() {
        if (((TableCell)this.getControl()).getTableView().getSelectionModel().isCellSelectionEnabled()) {
            TableColumn tableColumn = ((TableCell)this.getControl()).getTableColumn();
            TableView tableView = ((TableCell)this.getControl()).getTableView();
            if (tableView == null || tableColumn == null) {
                return -1;
            }
            return tableView.getVisibleLeafColumns().indexOf(tableColumn);
        }
        return -1;
    }
}

