/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.skin.TabPaneSkin;
import java.util.ArrayList;
import java.util.List;
import javafx.event.Event;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;

public class TabPaneBehavior
extends BehaviorBase<TabPane> {
    private static final String HOME = "Home";
    private static final String END = "End";
    private static final String CTRL_PAGE_UP = "Ctrl_Page_Up";
    private static final String CTRL_PAGE_DOWN = "Ctrl_Page_Down";
    private static final String CTRL_TAB = "Ctrl_Tab";
    private static final String CTRL_SHIFT_TAB = "Ctrl_Shift_Tab";
    protected static final List<KeyBinding> TABPANE_BINDINGS = new ArrayList<KeyBinding>();

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return TABPANE_BINDINGS;
    }

    @Override
    protected void callAction(String string) {
        if ("TraverseLeft".equals(string) || "TraverseUp".equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                this.selectPreviousTab();
            }
        } else if ("TraverseRight".equals(string) || "TraverseDown".equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                this.selectNextTab();
            }
        } else if ("TraverseNext".equals(string)) {
            TabPane tabPane = (TabPane)this.getControl();
            TabPaneSkin tabPaneSkin = (TabPaneSkin)tabPane.getSkin();
            if (tabPaneSkin.getSelectedTabContentRegion() != null) {
                tabPaneSkin.getSelectedTabContentRegion().getImpl_traversalEngine().getTopLeftFocusableNode();
                if (tabPaneSkin.getSelectedTabContentRegion().getImpl_traversalEngine().registeredNodes.isEmpty()) {
                    super.callAction(string);
                }
            } else {
                super.callAction(string);
            }
        } else if (CTRL_TAB.equals(string) || CTRL_PAGE_DOWN.equals(string)) {
            TabPane tabPane = (TabPane)this.getControl();
            if (tabPane.getSelectionModel().getSelectedIndex() == tabPane.getTabs().size() - 1) {
                tabPane.getSelectionModel().selectFirst();
            } else {
                this.selectNextTab();
            }
            tabPane.requestFocus();
        } else if (CTRL_SHIFT_TAB.equals(string) || CTRL_PAGE_UP.equals(string)) {
            TabPane tabPane = (TabPane)this.getControl();
            if (tabPane.getSelectionModel().getSelectedIndex() == 0) {
                tabPane.getSelectionModel().selectLast();
            } else {
                this.selectPreviousTab();
            }
            tabPane.requestFocus();
        } else if (HOME.equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                ((TabPane)this.getControl()).getSelectionModel().selectFirst();
            }
        } else if (END.equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                ((TabPane)this.getControl()).getSelectionModel().selectLast();
            }
        } else {
            super.callAction(string);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        TabPane tabPane = (TabPane)this.getControl();
        tabPane.requestFocus();
    }

    public TabPaneBehavior(TabPane tabPane) {
        super(tabPane);
    }

    public void selectTab(Tab tab) {
        ((TabPane)this.getControl()).getSelectionModel().select(tab);
    }

    public void closeTab(Tab tab) {
        TabPane tabPane = (TabPane)this.getControl();
        int n = tabPane.getTabs().indexOf(tab);
        if (tab.isSelected()) {
            if (n == 0) {
                if (tabPane.getTabs().size() > 1) {
                    tabPane.getSelectionModel().selectFirst();
                }
            } else {
                tabPane.getSelectionModel().selectPrevious();
            }
        }
        if (n != -1) {
            tabPane.getTabs().remove(n);
        }
        if (tab.getOnClosed() != null) {
            Event.fireEvent(tab, new Event(Tab.CLOSED_EVENT));
        }
    }

    public void selectNextTab() {
        this.selectNextTab((Tab)((TabPane)this.getControl()).getSelectionModel().getSelectedItem());
    }

    public void selectNextTab(Tab tab) {
        TabPane tabPane = (TabPane)this.getControl();
        tabPane.getSelectionModel().select(tab);
        tabPane.getSelectionModel().selectNext();
    }

    public void selectPreviousTab() {
        this.selectPreviousTab((Tab)((TabPane)this.getControl()).getSelectionModel().getSelectedItem());
    }

    public void selectPreviousTab(Tab tab) {
        TabPane tabPane = (TabPane)this.getControl();
        tabPane.getSelectionModel().select(tab);
        tabPane.getSelectionModel().selectPrevious();
    }

    static {
        TABPANE_BINDINGS.addAll(TRAVERSAL_BINDINGS);
        TABPANE_BINDINGS.add(new KeyBinding(KeyCode.HOME, HOME));
        TABPANE_BINDINGS.add(new KeyBinding(KeyCode.END, END));
        TABPANE_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, CTRL_PAGE_UP).ctrl());
        TABPANE_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, CTRL_PAGE_DOWN).ctrl());
        TABPANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_TAB).ctrl());
        TABPANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_SHIFT_TAB).shift().ctrl());
    }
}

