/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.OrientedKeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.FocusModel;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class ListViewBehavior<T>
extends BehaviorBase<ListView<T>> {
    protected static final List<KeyBinding> LIST_VIEW_BINDINGS = new ArrayList<KeyBinding>();
    private boolean isShiftDown = false;
    private boolean isCtrlDown = false;
    private int anchor = -1;
    private Callback<Void, Integer> onScrollPageUp;
    private Callback<Void, Integer> onScrollPageDown;
    private Runnable onFocusPreviousRow;
    private Runnable onFocusNextRow;
    private Runnable onSelectPreviousRow;
    private Runnable onSelectNextRow;
    private Runnable onMoveToFirstCell;
    private Runnable onMoveToLastCell;

    @Override
    protected void callAction(String string) {
        if ("SelectPreviousRow".equals(string)) {
            this.selectPreviousRow();
        } else if ("SelectNextRow".equals(string)) {
            this.selectNextRow();
        } else if ("SelectFirstRow".equals(string)) {
            this.selectFirstRow();
        } else if ("SelectLastRow".equals(string)) {
            this.selectLastRow();
        } else if ("SelectAllToFirstRow".equals(string)) {
            this.selectAllToFirstRow();
        } else if ("SelectAllToLastRow".equals(string)) {
            this.selectAllToLastRow();
        } else if ("SelectAllPageUp".equals(string)) {
            this.selectAllPageUp();
        } else if ("SelectAllPageDown".equals(string)) {
            this.selectAllPageDown();
        } else if ("AlsoSelectNextRow".equals(string)) {
            this.alsoSelectNextRow();
        } else if ("AlsoSelectPreviousRow".equals(string)) {
            this.alsoSelectPreviousRow();
        } else if ("ClearSelection".equals(string)) {
            this.clearSelection();
        } else if ("SelectAll".equals(string)) {
            this.selectAll();
        } else if ("ScrollUp".equals(string)) {
            this.scrollPageUp();
        } else if ("ScrollDown".equals(string)) {
            this.scrollPageDown();
        } else if ("FocusPreviousRow".equals(string)) {
            this.focusPreviousRow();
        } else if ("FocusNextRow".equals(string)) {
            this.focusNextRow();
        } else if ("FocusPageUp".equals(string)) {
            this.focusPageUp();
        } else if ("FocusPageDown".equals(string)) {
            this.focusPageDown();
        } else if ("Activate".equals(string)) {
            this.activate();
        } else if ("CancelEdit".equals(string)) {
            this.cancelEdit();
        } else if ("FocusFirstRow".equals(string)) {
            this.focusFirstRow();
        } else if ("FocusLastRow".equals(string)) {
            this.focusLastRow();
        } else if ("toggleFocusOwnerSelection".equals(string)) {
            this.toggleFocusOwnerSelection();
        } else if ("SelectAllToFocus".equals(string)) {
            this.selectAllToFocus();
        } else {
            super.callAction(string);
        }
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return LIST_VIEW_BINDINGS;
    }

    @Override
    protected void callActionForEvent(KeyEvent keyEvent) {
        this.isShiftDown = keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isShiftDown();
        this.isCtrlDown = keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isControlDown();
        super.callActionForEvent(keyEvent);
    }

    public void setOnScrollPageUp(Callback<Void, Integer> callback) {
        this.onScrollPageUp = callback;
    }

    public void setOnScrollPageDown(Callback<Void, Integer> callback) {
        this.onScrollPageDown = callback;
    }

    public void setOnFocusPreviousRow(Runnable runnable) {
        this.onFocusPreviousRow = runnable;
    }

    public void setOnFocusNextRow(Runnable runnable) {
        this.onFocusNextRow = runnable;
    }

    public void setOnSelectPreviousRow(Runnable runnable) {
        this.onSelectPreviousRow = runnable;
    }

    public void setOnSelectNextRow(Runnable runnable) {
        this.onSelectNextRow = runnable;
    }

    public void setOnMoveToFirstCell(Runnable runnable) {
        this.onMoveToFirstCell = runnable;
    }

    public void setOnMoveToLastCell(Runnable runnable) {
        this.onMoveToLastCell = runnable;
    }

    public ListViewBehavior(ListView listView) {
        super(listView);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        super.mousePressed(mouseEvent);
        this.anchor = n = ((ListView)this.getControl()).getSelectionModel().getSelectedIndex();
        if (!((ListView)this.getControl()).isFocused() && ((ListView)this.getControl()).isFocusTraversable()) {
            ((ListView)this.getControl()).requestFocus();
        }
    }

    private int getRowCount() {
        ObservableList observableList = ((ListView)this.getControl()).getItems();
        if (observableList == null) {
            return 0;
        }
        return observableList.size();
    }

    private void clearSelection() {
        ((ListView)this.getControl()).getSelectionModel().clearSelection();
    }

    private void scrollPageUp() {
        int n = this.onScrollPageUp.call(null);
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.clearAndSelect(n);
    }

    private void scrollPageDown() {
        int n = this.onScrollPageDown.call(null);
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.clearAndSelect(n);
    }

    private void focusFirstRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(0);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void focusLastRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(this.getRowCount() - 1);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void focusPreviousRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        focusModel.focusPrevious();
        if (!this.isCtrlDown || this.anchor == -1) {
            this.anchor = focusModel.getFocusedIndex();
        }
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    private void focusNextRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        focusModel.focusNext();
        if (!this.isCtrlDown || this.anchor == -1) {
            this.anchor = focusModel.getFocusedIndex();
        }
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    private void focusPageUp() {
        int n = this.onScrollPageUp.call(null);
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(n);
    }

    private void focusPageDown() {
        int n = this.onScrollPageDown.call(null);
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        focusModel.focus(n);
    }

    private void alsoSelectPreviousRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (this.isShiftDown && this.anchor != -1) {
            int n2 = focusModel.getFocusedIndex() - 1;
            this.clearSelectionOutsideRange(this.anchor, n2);
            if (this.anchor > n2) {
                multipleSelectionModel.selectRange(this.anchor, n2 - 1);
            } else {
                multipleSelectionModel.selectRange(this.anchor, n2 + 1);
            }
        } else {
            multipleSelectionModel.selectPrevious();
        }
        this.onSelectPreviousRow.run();
    }

    private void alsoSelectNextRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (this.isShiftDown && this.anchor != -1) {
            int n2 = focusModel.getFocusedIndex() + 1;
            this.clearSelectionOutsideRange(this.anchor, n2);
            if (this.anchor > n2) {
                multipleSelectionModel.selectRange(this.anchor, n2 - 1);
            } else {
                multipleSelectionModel.selectRange(this.anchor, n2 + 1);
            }
        } else {
            multipleSelectionModel.selectNext();
        }
        this.onSelectNextRow.run();
    }

    private void clearSelectionOutsideRange(int n, int n2) {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(multipleSelectionModel.getSelectedIndices());
        for (int i = 0; i < arrayList.size(); ++i) {
            int n5 = (Integer)arrayList.get(i);
            if (n5 >= n3 && n5 < n4) continue;
            multipleSelectionModel.clearSelection(n5);
        }
    }

    private void selectPreviousRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (n <= 0) {
            return;
        }
        this.anchor = n - 1;
        ((ListView)this.getControl()).getSelectionModel().clearAndSelect(n - 1);
        this.onSelectPreviousRow.run();
    }

    private void selectNextRow() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (n == this.getRowCount() - 1) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        this.anchor = n + 1;
        multipleSelectionModel.clearAndSelect(n + 1);
        if (this.onSelectNextRow != null) {
            this.onSelectNextRow.run();
        }
    }

    private void selectFirstRow() {
        if (this.getRowCount() > 0) {
            ((ListView)this.getControl()).getSelectionModel().clearAndSelect(0);
            if (this.onMoveToFirstCell != null) {
                this.onMoveToFirstCell.run();
            }
        }
    }

    private void selectLastRow() {
        ((ListView)this.getControl()).getSelectionModel().clearAndSelect(this.getRowCount() - 1);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void selectAllPageUp() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (this.isShiftDown) {
            this.anchor = n = this.anchor == -1 ? n : this.anchor;
        }
        int n2 = this.onScrollPageUp.call(null);
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(n2, n + 1);
    }

    private void selectAllPageDown() {
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (this.isShiftDown) {
            this.anchor = n = this.anchor == -1 ? n : this.anchor;
        }
        int n2 = this.onScrollPageDown.call(null);
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(n, n2 + 1);
    }

    private void selectAllToFirstRow() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = multipleSelectionModel.getSelectedIndex();
        if (this.isShiftDown) {
            this.anchor = n = this.anchor == -1 ? multipleSelectionModel.getSelectedIndex() : this.anchor;
        }
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(0, n + 1);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void selectAllToLastRow() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = multipleSelectionModel.getSelectedIndex();
        if (this.isShiftDown) {
            this.anchor = n = this.anchor == -1 ? multipleSelectionModel.getSelectedIndex() : this.anchor;
        }
        multipleSelectionModel.clearSelection();
        multipleSelectionModel.selectRange(n, this.getRowCount() - 1);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void selectAll() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        multipleSelectionModel.selectAll();
    }

    private void selectAllToFocus() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        int n2 = multipleSelectionModel.getSelectedIndex();
        multipleSelectionModel.clearSelection();
        int n3 = n2;
        int n4 = n2 > n ? n - 1 : n + 1;
        multipleSelectionModel.selectRange(n3, n4);
    }

    private void cancelEdit() {
        ((ListView)this.getControl()).edit(-1);
    }

    private void activate() {
        int n = ((ListView)this.getControl()).getFocusModel().getFocusedIndex();
        ((ListView)this.getControl()).getSelectionModel().select(n);
        ((ListView)this.getControl()).edit(n);
    }

    private void toggleFocusOwnerSelection() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getControl()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = ((ListView)this.getControl()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        int n = focusModel.getFocusedIndex();
        if (multipleSelectionModel.isSelected(n)) {
            multipleSelectionModel.clearSelection(n);
        } else {
            multipleSelectionModel.select(n);
        }
    }

    static {
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectFirstRow"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectLastRow"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectAllToFirstRow").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectAllToLastRow").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "SelectAllPageUp").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "SelectAllPageDown").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "SelectAllToFocus").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "ScrollUp"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "ScrollDown"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ENTER, "Activate"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "Activate"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.F2, "Activate"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, "CancelEdit"));
        if (Utils.isMac()) {
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.A, "SelectAll").meta());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "FocusFirstRow").meta());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "FocusLastRow").meta());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").meta());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "FocusPageUp").meta());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "FocusPageDown").meta());
        } else {
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.A, "SelectAll").ctrl());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "FocusFirstRow").ctrl());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "FocusLastRow").ctrl());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").ctrl());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "FocusPageUp").ctrl());
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "FocusPageDown").ctrl());
        }
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "SelectPreviousRow").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_UP, "SelectPreviousRow").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "SelectNextRow").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_DOWN, "SelectNextRow").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "AlsoSelectPreviousRow").vertical().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_UP, "AlsoSelectPreviousRow").vertical().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "AlsoSelectNextRow").vertical().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_DOWN, "AlsoSelectNextRow").vertical().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.LEFT, "TraverseLeft").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_LEFT, "TraverseLeft").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.RIGHT, "TraverseRight").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_RIGHT, "TraverseRight").vertical());
        if (Utils.isMac()) {
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "FocusPreviousRow").vertical().meta());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "FocusNextRow").vertical().meta());
        } else {
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "FocusPreviousRow").vertical().ctrl());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "FocusNextRow").vertical().ctrl());
        }
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.LEFT, "SelectPreviousRow"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_LEFT, "SelectPreviousRow"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.RIGHT, "SelectNextRow"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_RIGHT, "SelectNextRow"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.LEFT, "AlsoSelectPreviousRow").shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_LEFT, "AlsoSelectPreviousRow").shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.RIGHT, "AlsoSelectNextRow").shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_RIGHT, "AlsoSelectNextRow").shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "TraverseUp"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_UP, "TraverseUp"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "TraverseDown"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_DOWN, "TraverseDown"));
        if (Utils.isMac()) {
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.LEFT, "FocusPreviousRow").meta());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.RIGHT, "FocusNextRow").meta());
        } else {
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.LEFT, "FocusPreviousRow").ctrl());
            LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.RIGHT, "FocusNextRow").ctrl());
        }
        if (Utils.isMac()) {
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.BACK_SLASH, "ClearSelection").meta());
        } else {
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.BACK_SLASH, "ClearSelection").ctrl());
        }
    }

    private static class ListViewKeyBinding
    extends OrientedKeyBinding {
        public ListViewKeyBinding(KeyCode keyCode, String string) {
            super(keyCode, string);
        }

        public ListViewKeyBinding(KeyCode keyCode, EventType<KeyEvent> eventType, String string) {
            super(keyCode, eventType, string);
        }

        @Override
        public boolean getVertical(Control control) {
            return ((ListView)control).getOrientation() == Orientation.VERTICAL;
        }
    }
}

