/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.png;

import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.common.PushbroomScaler;
import com.sun.javafx.iio.common.ScalerFactory;
import com.sun.javafx.iio.png.PNGDescriptor;
import com.sun.javafx.iio.png.PNGIDATChunkInputStream;
import com.sun.javafx.iio.png.PNGImageMetadata;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class PNGImageLoader
extends ImageLoaderImpl {
    static final int IHDR_TYPE = 1229472850;
    static final int PLTE_TYPE = 1347179589;
    static final int IDAT_TYPE = 1229209940;
    static final int IEND_TYPE = 1229278788;
    static final int bKGD_TYPE = 1649100612;
    static final int cHRM_TYPE = 1665684045;
    static final int gAMA_TYPE = 1732332865;
    static final int hIST_TYPE = 1749635924;
    static final int iCCP_TYPE = 1766015824;
    static final int iTXt_TYPE = 1767135348;
    static final int pHYs_TYPE = 1883789683;
    static final int sBIT_TYPE = 1933723988;
    static final int sPLT_TYPE = 1934642260;
    static final int sRGB_TYPE = 1934772034;
    static final int tEXt_TYPE = 1950701684;
    static final int tIME_TYPE = 1950960965;
    static final int tRNS_TYPE = 1951551059;
    static final int zTXt_TYPE = 2052348020;
    static final int PNG_COLOR_GRAY = 0;
    static final int PNG_COLOR_RGB = 2;
    static final int PNG_COLOR_PALETTE = 3;
    static final int PNG_COLOR_GRAY_ALPHA = 4;
    static final int PNG_COLOR_RGB_ALPHA = 6;
    static final int[] inputBandsForColorType = new int[]{1, -1, 3, 1, 2, -1, 4};
    static final int PNG_FILTER_NONE = 0;
    static final int PNG_FILTER_SUB = 1;
    static final int PNG_FILTER_UP = 2;
    static final int PNG_FILTER_AVERAGE = 3;
    static final int PNG_FILTER_PAETH = 4;
    static final int[] adam7XOffset = new int[]{0, 4, 0, 2, 0, 1, 0};
    static final int[] adam7YOffset = new int[]{0, 0, 4, 0, 2, 0, 1};
    static final int[] adam7XSubsampling = new int[]{8, 8, 4, 4, 2, 2, 1, 1};
    static final int[] adam7YSubsampling = new int[]{8, 8, 8, 4, 4, 2, 2, 1};
    private InputStream stream;
    private boolean gotHeader = false;
    private boolean gotMetadata = false;
    private PNGIDATChunkInputStream IDATStream;
    int sourceXSubsampling = -1;
    int sourceYSubsampling = -1;
    int sourceMinProgressivePass = 0;
    int sourceMaxProgressivePass = 6;
    private PNGImageMetadata metadata;
    private DataInputStream pixelStream;
    private ImageStorage.ImageType sourceType;
    private ImageStorage.ImageType destType;
    private int numDestBands;
    private ImageFrame theImage;
    byte[][] thePalette;
    private PushbroomScaler scaler;
    private boolean isInterlaced;
    private boolean isConverting;
    private boolean isScaling;
    private ROW_PROCESS rowProc;
    byte[] curr = null;
    byte[] prior = null;
    byte[] passRow = null;
    byte[] rescaledBuf = null;
    short[] shortData = null;
    byte[] convertedBuf = null;
    private int pixelsDone;
    private int totalPixels;

    public PNGImageLoader(InputStream inputStream) throws IOException {
        super(PNGDescriptor.getInstance());
        if (inputStream == null) {
            throw new IllegalArgumentException("input == null!");
        }
        this.stream = inputStream;
        this.readHeader();
    }

    public void abort() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public ImageFrame load(int n, int n2, int n3, boolean bl, boolean bl2) throws IOException {
        if (n != 0) {
            return null;
        }
        this.readImage(n2, n3, bl, bl2);
        return this.theImage;
    }

    private String readNullTerminatedString(String string, int n) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        while (n > n3++ && (n2 = this.stream.read()) != 0) {
            if (n2 == -1) {
                throw new EOFException();
            }
            byteArrayOutputStream.write(n2);
        }
        return new String(byteArrayOutputStream.toByteArray(), string);
    }

    private synchronized void readHeader() throws IOException {
        if (this.gotHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input source not set!");
        }
        byte[] byArray = new byte[8];
        ImageTools.readFully(this.stream, byArray);
        if (byArray[0] != -119 || byArray[1] != 80 || byArray[2] != 78 || byArray[3] != 71 || byArray[4] != 13 || byArray[5] != 10 || byArray[6] != 26 || byArray[7] != 10) {
            throw new IOException("Bad PNG signature!");
        }
        int n = this.stream.read() << 24 | this.stream.read() << 16 | this.stream.read() << 8 | this.stream.read();
        if (n != 13) {
            throw new IOException("Bad length for IHDR chunk!");
        }
        int n2 = this.stream.read() << 24 | this.stream.read() << 16 | this.stream.read() << 8 | this.stream.read();
        if (n2 != 1229472850) {
            throw new IOException("Bad type for IHDR chunk!");
        }
        this.metadata = new PNGImageMetadata();
        int n3 = this.stream.read() << 24 | this.stream.read() << 16 | this.stream.read() << 8 | this.stream.read();
        int n4 = this.stream.read() << 24 | this.stream.read() << 16 | this.stream.read() << 8 | this.stream.read();
        ImageTools.readFully(this.stream, byArray, 0, 5);
        int n5 = byArray[0] & 0xFF;
        int n6 = byArray[1] & 0xFF;
        int n7 = byArray[2] & 0xFF;
        int n8 = byArray[3] & 0xFF;
        int n9 = byArray[4] & 0xFF;
        this.stream.skip(4L);
        if (n3 == 0) {
            throw new IOException("Image width == 0!");
        }
        if (n4 == 0) {
            throw new IOException("Image height == 0!");
        }
        if (n5 != 1 && n5 != 2 && n5 != 4 && n5 != 8 && n5 != 16) {
            throw new IOException("Bit depth must be 1, 2, 4, 8, or 16!");
        }
        if (n6 != 0 && n6 != 2 && n6 != 3 && n6 != 4 && n6 != 6) {
            throw new IOException("Color type must be 0, 2, 3, 4, or 6!");
        }
        if (n6 == 3 && n5 == 16) {
            throw new IOException("Bad color type/bit depth combination!");
        }
        if ((n6 == 2 || n6 == 6 || n6 == 4) && n5 != 8 && n5 != 16) {
            throw new IOException("Bad color type/bit depth combination!");
        }
        if (n7 != 0) {
            throw new IOException("Unknown compression method (not 0)!");
        }
        if (n8 != 0) {
            throw new IOException("Unknown filter method (not 0)!");
        }
        if (n9 != 0 && n9 != 1) {
            throw new IOException("Unknown interlace method (not 0 or 1)!");
        }
        switch (n6) {
            case 0: {
                this.sourceType = ImageStorage.ImageType.GRAY;
                break;
            }
            case 2: {
                this.sourceType = ImageStorage.ImageType.RGB;
                break;
            }
            case 3: {
                this.sourceType = ImageStorage.ImageType.PALETTE;
                break;
            }
            case 4: {
                this.sourceType = ImageStorage.ImageType.GRAY_ALPHA;
                break;
            }
            case 6: {
                this.sourceType = ImageStorage.ImageType.RGBA;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unhandled color type");
            }
        }
        this.metadata.IHDR_present = true;
        this.metadata.IHDR_width = n3;
        this.metadata.IHDR_height = n4;
        this.metadata.IHDR_bitDepth = n5;
        this.metadata.IHDR_colorType = n6;
        this.metadata.IHDR_compressionMethod = n7;
        this.metadata.IHDR_filterMethod = n8;
        this.metadata.IHDR_interlaceMethod = n9;
        this.isInterlaced = this.metadata.IHDR_interlaceMethod != 0;
        this.gotHeader = true;
    }

    private void parse_PLTE_chunk(int n) throws IOException {
        int n2;
        if (this.metadata.PLTE_present) {
            this.emitWarning("A PNG image may not contain more than one PLTE chunk.\nThe chunk wil be ignored.");
            return;
        }
        if (this.metadata.IHDR_colorType == 0 || this.metadata.IHDR_colorType == 4) {
            this.emitWarning("A PNG gray or gray alpha image cannot have a PLTE chunk.\nThe chunk wil be ignored.");
            return;
        }
        byte[] byArray = new byte[n];
        ImageTools.readFully(this.stream, byArray);
        int n3 = n / 3;
        if (this.metadata.IHDR_colorType == 3) {
            n2 = 1 << this.metadata.IHDR_bitDepth;
            if (n3 > n2) {
                this.emitWarning("PLTE chunk contains too many entries for bit depth, ignoring extras.");
                n3 = n2;
            }
            n3 = Math.min(n3, n2);
        }
        n2 = n3 > 16 ? 256 : (n3 > 4 ? 16 : (n3 > 2 ? 4 : 2));
        this.metadata.PLTE_present = true;
        this.metadata.PLTE_red = new byte[n2];
        this.metadata.PLTE_green = new byte[n2];
        this.metadata.PLTE_blue = new byte[n2];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            this.metadata.PLTE_red[i] = byArray[n4++];
            this.metadata.PLTE_green[i] = byArray[n4++];
            this.metadata.PLTE_blue[i] = byArray[n4++];
        }
    }

    private void parse_bKGD_chunk() throws IOException {
    }

    private void parse_cHRM_chunk() throws IOException {
    }

    private void parse_gAMA_chunk() throws IOException {
    }

    private void parse_hIST_chunk(int n) throws IOException {
    }

    private void parse_iCCP_chunk(int n) throws IOException {
    }

    private void parse_iTXt_chunk(int n) throws IOException {
    }

    private void parse_pHYs_chunk() throws IOException {
    }

    private void parse_sBIT_chunk() throws IOException {
    }

    private void parse_sPLT_chunk(int n) throws IOException {
    }

    private void parse_sRGB_chunk() throws IOException {
    }

    private void parse_tEXt_chunk(int n) throws IOException {
    }

    private void parse_tIME_chunk() throws IOException {
    }

    private void parse_tRNS_chunk(int n) throws IOException {
        int n2 = this.metadata.IHDR_colorType;
        if (n2 == 3) {
            if (!this.metadata.PLTE_present) {
                this.emitWarning("tRNS chunk without prior PLTE chunk, ignoring it.");
                return;
            }
            int n3 = n;
            int n4 = this.metadata.PLTE_red.length;
            if (n3 > n4) {
                this.emitWarning("tRNS chunk has more entries than prior PLTE chunk, ignoring extras.");
                n3 = n4;
            }
            this.metadata.tRNS_alpha = new byte[n3];
            this.metadata.tRNS_colorType = 3;
            ImageTools.readFully(this.stream, this.metadata.tRNS_alpha, 0, n3);
            this.stream.skip(n - n3);
        } else if (n2 == 0) {
            if (n != 2) {
                this.emitWarning("tRNS chunk for gray image must have length 2, ignoring chunk.");
                this.stream.skip(n);
                return;
            }
            this.metadata.tRNS_gray = this.stream.read() << 8 | this.stream.read();
            this.metadata.tRNS_colorType = 0;
        } else if (n2 == 2) {
            if (n != 6) {
                this.emitWarning("tRNS chunk for RGB image must have length 6, ignoring chunk.");
                this.stream.skip(n);
                return;
            }
            this.metadata.tRNS_red = this.stream.read() << 8 | this.stream.read();
            this.metadata.tRNS_green = this.stream.read() << 8 | this.stream.read();
            this.metadata.tRNS_blue = this.stream.read() << 8 | this.stream.read();
            this.metadata.tRNS_colorType = 2;
        } else {
            this.emitWarning("Gray+Alpha and RGBS images may not have a tRNS chunk, ignoring it.");
            return;
        }
        this.metadata.tRNS_present = true;
    }

    private void parse_zTXt_chunk(int n) throws IOException {
    }

    private synchronized void readMetadata() throws IOException {
        int n;
        block22: {
            if (this.gotMetadata) {
                return;
            }
            this.readHeader();
            int n2 = this.metadata.IHDR_colorType;
            if (n2 != 3) {
                try {
                    while (true) {
                        int n3 = this.stream.read() << 24 | this.stream.read() << 16 | this.stream.read() << 8 | this.stream.read();
                        int n4 = this.stream.read() << 24 | this.stream.read() << 16 | this.stream.read() << 8 | this.stream.read();
                        if (n4 == 1229209940) {
                            this.IDATStream = new PNGIDATChunkInputStream(this.stream, n3);
                            break;
                        }
                        this.stream.skip(n3 + 4);
                    }
                }
                catch (IOException iOException) {
                    IOException iOException2 = new IOException("Error skipping PNG metadata");
                    iOException2.initCause(iOException);
                    throw iOException2;
                }
                this.gotMetadata = true;
                return;
            }
            try {
                while (true) {
                    n = this.stream.read() << 24 | this.stream.read() << 16 | this.stream.read() << 8 | this.stream.read();
                    int n5 = this.stream.read() << 24 | this.stream.read() << 16 | this.stream.read() << 8 | this.stream.read();
                    switch (n5) {
                        case 1229209940: {
                            this.IDATStream = new PNGIDATChunkInputStream(this.stream, n);
                            break block22;
                        }
                        case 1347179589: {
                            this.parse_PLTE_chunk(n);
                            break;
                        }
                        case 1951551059: {
                            this.parse_tRNS_chunk(n);
                            break;
                        }
                        default: {
                            this.stream.skip(n);
                        }
                    }
                    int n6 = this.stream.read() << 24 | this.stream.read() << 16 | this.stream.read() << 8 | this.stream.read();
                }
            }
            catch (IOException iOException) {
                IOException iOException3 = new IOException("Error reading PNG metadata");
                iOException3.initCause(iOException);
                throw iOException3;
            }
        }
        if (this.metadata.PLTE_present) {
            this.thePalette = this.metadata.tRNS_present ? (Object)new byte[4][] : (byte[][])new byte[3][];
            this.thePalette[0] = this.metadata.PLTE_red;
            this.thePalette[1] = this.metadata.PLTE_green;
            this.thePalette[2] = this.metadata.PLTE_blue;
            n = 1 << this.metadata.IHDR_bitDepth;
            if (this.metadata.PLTE_red.length < n) {
                this.thePalette[0] = new byte[n];
                System.arraycopy(this.metadata.PLTE_red, 0, this.thePalette[0], 0, this.metadata.PLTE_red.length);
                Arrays.fill(this.thePalette[0], this.metadata.PLTE_red.length, n, this.metadata.PLTE_red[this.metadata.PLTE_red.length - 1]);
            }
            if (this.metadata.PLTE_green.length < n) {
                this.thePalette[1] = new byte[n];
                System.arraycopy(this.metadata.PLTE_green, 0, this.thePalette[1], 0, this.metadata.PLTE_green.length);
                Arrays.fill(this.thePalette[1], this.metadata.PLTE_green.length, n, this.metadata.PLTE_green[this.metadata.PLTE_green.length - 1]);
            }
            if (this.metadata.PLTE_red.length < n) {
                this.thePalette[2] = new byte[n];
                System.arraycopy(this.metadata.PLTE_blue, 0, this.thePalette[2], 0, this.metadata.PLTE_blue.length);
                Arrays.fill(this.thePalette[2], this.metadata.PLTE_blue.length, n, this.metadata.PLTE_blue[this.metadata.PLTE_blue.length - 1]);
            }
            if (this.metadata.tRNS_present && this.metadata.tRNS_alpha != null) {
                this.sourceType = ImageStorage.ImageType.PALETTE_ALPHA;
                if (this.metadata.tRNS_alpha.length >= this.metadata.PLTE_red.length) {
                    this.thePalette[3] = this.metadata.tRNS_alpha;
                } else {
                    this.thePalette[3] = new byte[this.metadata.PLTE_red.length];
                    System.arraycopy(this.metadata.tRNS_alpha, 0, this.thePalette[3], 0, this.metadata.tRNS_alpha.length);
                    Arrays.fill(this.thePalette[3], this.metadata.tRNS_alpha.length, this.thePalette[3].length, (byte)-1);
                }
            }
        }
        this.gotMetadata = true;
    }

    private static void decodeSubFilter(byte[] byArray, int n, int n2, int n3) {
        for (int i = n3; i < n2; ++i) {
            int n4 = byArray[i + n] & 0xFF;
            byArray[i + n] = (byte)(n4 += byArray[i + n - n3] & 0xFF);
        }
    }

    private static void decodeUpFilter(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4 = byArray[i + n] & 0xFF;
            int n5 = byArray2[i + n2] & 0xFF;
            byArray[i + n] = (byte)(n4 + n5);
        }
    }

    private static void decodeAverageFilter(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        for (n7 = 0; n7 < n4; ++n7) {
            n6 = byArray[n7 + n] & 0xFF;
            n5 = byArray2[n7 + n2] & 0xFF;
            byArray[n7 + n] = (byte)(n6 + n5 / 2);
        }
        for (n7 = n4; n7 < n3; ++n7) {
            n6 = byArray[n7 + n] & 0xFF;
            int n8 = byArray[n7 + n - n4] & 0xFF;
            n5 = byArray2[n7 + n2] & 0xFF;
            byArray[n7 + n] = (byte)(n6 + (n8 + n5) / 2);
        }
    }

    private static int paethPredictor(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        int n5 = Math.abs(n4 - n);
        int n6 = Math.abs(n4 - n2);
        int n7 = Math.abs(n4 - n3);
        if (n5 <= n6 && n5 <= n7) {
            return n;
        }
        if (n6 <= n7) {
            return n2;
        }
        return n3;
    }

    private static void decodePaethFilter(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        for (n7 = 0; n7 < n4; ++n7) {
            n6 = byArray[n7 + n] & 0xFF;
            n5 = byArray2[n7 + n2] & 0xFF;
            byArray[n7 + n] = (byte)(n6 + n5);
        }
        for (n7 = n4; n7 < n3; ++n7) {
            n6 = byArray[n7 + n] & 0xFF;
            int n8 = byArray[n7 + n - n4] & 0xFF;
            n5 = byArray2[n7 + n2] & 0xFF;
            int n9 = byArray2[n7 + n2 - n4] & 0xFF;
            byArray[n7 + n] = (byte)(n6 + PNGImageLoader.paethPredictor(n8, n5, n9));
        }
    }

    private void skipPass(int n, int n2) throws IOException {
        if (n == 0 || n2 == 0) {
            return;
        }
        int n3 = inputBandsForColorType[this.metadata.IHDR_colorType];
        int n4 = (n3 * n * this.metadata.IHDR_bitDepth + 7) / 8;
        for (int i = 0; i < n2; ++i) {
            this.pixelStream.skipBytes(1 + n4);
        }
    }

    private void updateImageProgress(int n) {
        this.pixelsDone += n;
        this.updateImageProgress(100.0f * (float)this.pixelsDone / (float)this.totalPixels);
    }

    private void decodePass(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        byte[] byArray;
        int n15;
        if (n6 == 0 || n7 == 0) {
            return;
        }
        byte[] byArray2 = null;
        Buffer buffer = this.theImage.getImageData();
        if (!(buffer instanceof ByteBuffer)) {
            throw new UnsupportedOperationException("Only ByteBuffer is supported!");
        }
        byArray2 = ((ByteBuffer)buffer).array();
        int n16 = 0;
        int n17 = this.metadata.IHDR_width - 1;
        int n18 = 0;
        int n19 = this.metadata.IHDR_height - 1;
        int[] nArray = ImageTools.computeUpdatedPixels(new Rectangle(this.metadata.IHDR_width, this.metadata.IHDR_height), new Point2D(), n16, n18, n17, n19, this.sourceXSubsampling, this.sourceYSubsampling, n2, n3, n6, n7, n4, n5);
        int n20 = nArray[0];
        int n21 = nArray[1];
        int n22 = nArray[2];
        int n23 = nArray[4];
        int n24 = nArray[5];
        int n25 = this.metadata.IHDR_bitDepth;
        int n26 = inputBandsForColorType[this.metadata.IHDR_colorType];
        int n27 = n25 == 16 ? 2 : 1;
        n27 *= n26;
        int n28 = 8 / n25;
        int n29 = 1;
        switch (n25) {
            case 8: {
                n29 = 255;
                break;
            }
            case 4: {
                n29 = 15;
                break;
            }
            case 2: {
                n29 = 3;
                break;
            }
            case 1: {
                n29 = 1;
            }
        }
        int n30 = (n26 * n6 * n25 + 7) / 8;
        int n31 = n15 = n25 == 16 ? n30 / 2 : n30;
        if (n22 == 0) {
            for (int i = 0; i < n7; ++i) {
                this.updateImageProgress(n6);
                this.pixelStream.skipBytes(1 + n30);
            }
            return;
        }
        int n32 = n20 * this.sourceXSubsampling;
        int n33 = (n32 - n2) / n4;
        int n34 = n23 * this.sourceXSubsampling / n4;
        if (this.curr == null || this.curr.length < n30) {
            this.curr = new byte[n30];
            this.prior = new byte[n30];
            this.passRow = new byte[n30];
            if (n25 == 16) {
                this.shortData = new short[n30 / 2];
            }
        }
        byte[] byArray3 = byArray = n25 != 16 ? this.passRow : null;
        if (this.rowProc == ROW_PROCESS.CONVERT_DOWNSCALE) {
            n14 = n22 * this.numDestBands;
            if (this.convertedBuf == null || this.convertedBuf.length < n14) {
                this.convertedBuf = new byte[n14];
            }
        }
        n14 = 0;
        int[] nArray2 = new int[n26];
        for (n13 = 0; n13 < n26; ++n13) {
            nArray2[n13] = 8;
        }
        n13 = nArray2.length;
        for (int i = 0; i < n13; ++i) {
            if (nArray2[i] == n25) continue;
            n14 = 1;
            break;
        }
        Object object = null;
        if (n14 != 0) {
            n12 = (1 << n25) - 1;
            n11 = n12 / 2;
            object = new int[n13][];
            for (n10 = 0; n10 < n13; ++n10) {
                n9 = (1 << nArray2[n10]) - 1;
                object[n10] = new int[n12 + 1];
                for (n8 = 0; n8 <= n12; ++n8) {
                    object[n10][n8] = (n8 * n9 + n11) / n12;
                }
            }
        }
        int n35 = n12 = n34 == 1 && n23 == 1 && n14 == 0 ? 1 : 0;
        if (n12 != 0) {
            this.rescaledBuf = null;
            n11 = 0;
        } else if (this.rowProc == ROW_PROCESS.COPY) {
            this.rescaledBuf = byArray2;
            n11 = this.theImage.getStride();
        } else {
            n10 = this.metadata.IHDR_width * n26;
            if (this.rescaledBuf == null || this.rescaledBuf.length < n10) {
                this.rescaledBuf = new byte[this.metadata.IHDR_width * n26];
            }
            n11 = 0;
        }
        block32: for (n10 = 0; n10 < n7; ++n10) {
            int n36;
            int n37;
            int n38;
            int n39;
            this.updateImageProgress(n6);
            n9 = this.pixelStream.read();
            try {
                byte[] byArray4 = this.prior;
                this.prior = this.curr;
                this.curr = byArray4;
                this.pixelStream.readFully(this.curr, 0, n30);
            }
            catch (ZipException zipException) {
                IOException iOException = new IOException("Error deflating compressed PNG data!");
                iOException.initCause(zipException);
                throw iOException;
            }
            switch (n9) {
                case 0: {
                    break;
                }
                case 1: {
                    PNGImageLoader.decodeSubFilter(this.curr, 0, n30, n27);
                    break;
                }
                case 2: {
                    PNGImageLoader.decodeUpFilter(this.curr, 0, this.prior, 0, n30);
                    break;
                }
                case 3: {
                    PNGImageLoader.decodeAverageFilter(this.curr, 0, this.prior, 0, n30, n27);
                    break;
                }
                case 4: {
                    PNGImageLoader.decodePaethFilter(this.curr, 0, this.prior, 0, n30, n27);
                    break;
                }
                default: {
                    throw new IOException("Unknown row filter type (= " + n9 + ")!");
                }
            }
            if (n25 < 16) {
                System.arraycopy(this.curr, 0, byArray, 0, n30);
            } else {
                int n40 = 0;
                for (n39 = 0; n39 < n15; ++n39) {
                    this.shortData[n39] = (short)(this.curr[n40] << 8 | this.curr[n40 + 1] & 0xFF);
                    n40 += 2;
                }
            }
            n8 = n10 * n5 + n3;
            if (n8 < 0 || n8 >= this.metadata.IHDR_height || (n39 = n8 / this.sourceYSubsampling) < n18) continue;
            if (n39 > n19) break;
            if (n12 != 0) {
                switch (this.rowProc) {
                    case COPY: {
                        System.arraycopy(this.passRow, 0, byArray2, n39 * this.theImage.getStride(), n22 * n13);
                        continue block32;
                    }
                    case CONVERT: {
                        ImageTools.convert(n22, 1, this.sourceType, this.passRow, 0, 0, byArray2, n39 * this.theImage.getStride(), this.theImage.getStride(), this.thePalette, 0);
                        continue block32;
                    }
                    case DOWNSCALE: {
                        this.scaler.putSourceScanline(this.passRow, 0);
                        continue block32;
                    }
                    case CONVERT_DOWNSCALE: {
                        assert (this.passRow.length <= n6 * n13);
                        ImageTools.convert(n22, 1, this.sourceType, this.passRow, 0, 0, this.convertedBuf, 0, 0, this.thePalette, 0);
                        this.scaler.putSourceScanline(this.convertedBuf, 0);
                        continue block32;
                    }
                    default: {
                        assert (false);
                        continue block32;
                    }
                }
            }
            int n41 = n33;
            int n42 = n39 * n11 + n20 * n13;
            int n43 = (n23 - 1) * n13;
            if (n14 != 0) {
                int n44;
                if (n25 == 16) {
                    for (n38 = n20; n38 < n20 + n22; n38 += n23) {
                        n37 = n41 * n26;
                        for (n36 = 0; n36 < n26; ++n36) {
                            n44 = this.shortData[n37++] & 0xFFFF;
                            this.rescaledBuf[n42++] = (byte)object[n36][n44];
                        }
                        n42 += n43;
                        n41 += n34;
                    }
                } else {
                    for (n38 = n20; n38 < n20 + n22; n38 += n28 * n26) {
                        n37 = n41 * n26;
                        for (n36 = 0; n36 < n26; ++n36) {
                            n44 = byArray[n37++];
                            for (int i = 0; i < n28; ++i) {
                                int n45 = n44 >> (n28 - 1 - i) * n25 & 0xFF;
                                int n46 = n45 & n29;
                                if (n42 >= n22) continue;
                                this.rescaledBuf[n42++] = (byte)(object[n36][n46] & n29);
                            }
                        }
                        n41 += n34;
                    }
                }
            } else if (n14 == 0) {
                if (n25 == 16) {
                    for (n38 = n20; n38 < n20 + n22; n38 += n23) {
                        n37 = n41 * n26;
                        for (n36 = 0; n36 < n26; ++n36) {
                            this.rescaledBuf[n42++] = (byte)((this.shortData[n37++] & 0xFFFF) >> 8);
                        }
                        n42 += n43;
                        n41 += n34;
                    }
                } else {
                    for (n38 = n20; n38 < n20 + n22; n38 += n23) {
                        n37 = n41 * n26;
                        for (n36 = 0; n36 < n26; ++n36) {
                            this.rescaledBuf[n42++] = byArray[n37++];
                        }
                        n42 += n43;
                        n41 += n34;
                    }
                }
            }
            if (this.isInterlaced) continue;
            switch (this.rowProc) {
                case COPY: {
                    continue block32;
                }
                case CONVERT: {
                    ImageTools.convert(n22, 1, this.sourceType, this.rescaledBuf, n20 * n13, n11, byArray2, n39 * this.theImage.getStride() + n20 * n13, this.theImage.getStride(), this.thePalette, 0);
                    continue block32;
                }
                case DOWNSCALE: {
                    this.scaler.putSourceScanline(this.rescaledBuf, 0);
                    continue block32;
                }
                case CONVERT_DOWNSCALE: {
                    ImageTools.convert(n22, 1, this.sourceType, this.rescaledBuf, n20 * n13, n11, this.convertedBuf, n20 * n13, 0, this.thePalette, 0);
                    this.scaler.putSourceScanline(this.convertedBuf, 0);
                    continue block32;
                }
                default: {
                    assert (false);
                    continue block32;
                }
            }
        }
    }

    private void decodeImage(int n, int n2, boolean bl) throws IOException {
        int n3 = this.metadata.IHDR_width;
        int n4 = this.metadata.IHDR_height;
        this.pixelsDone = 0;
        this.totalPixels = n3 * n4;
        this.updateImageProgress(0);
        if (this.metadata.IHDR_interlaceMethod == 0) {
            this.decodePass(0, 0, 0, 1, 1, n3, n4);
        } else {
            int n5;
            int n6;
            int n7;
            for (int i = 0; i <= this.sourceMaxProgressivePass; ++i) {
                int n8 = adam7XOffset[i];
                n7 = adam7YOffset[i];
                n6 = adam7XSubsampling[i];
                int n9 = adam7YSubsampling[i];
                n5 = adam7XSubsampling[i + 1] - 1;
                int n10 = adam7YSubsampling[i + 1] - 1;
                if (i >= this.sourceMinProgressivePass) {
                    this.decodePass(i, n8, n7, n6, n9, (n3 + n5) / n6, (n4 + n10) / n9);
                    continue;
                }
                this.skipPass((n3 + n5) / n6, (n4 + n10) / n9);
            }
            if (this.isScaling) {
                ByteBuffer byteBuffer = (ByteBuffer)this.theImage.getImageData();
                byte[] byArray = byteBuffer.array();
                n7 = this.theImage.getStride();
                n6 = 0;
                byte[] byArray2 = new byte[n3 * this.numDestBands];
                for (n5 = 0; n5 < n4; ++n5) {
                    ImageTools.convert(n3, 1, this.sourceType, byArray, n6, n7, byArray2, 0, 0, this.thePalette, 0);
                    if (!this.scaler.putSourceScanline(byArray2, 0)) {
                        n6 += n7;
                        continue;
                    }
                    break;
                }
            } else if (this.isConverting) {
                this.theImage = ImageTools.convertImageFrame(this.theImage);
            }
        }
        if (this.isScaling) {
            this.theImage = new ImageFrame(this.destType, this.scaler.getDestination(), n, n2, n * this.numDestBands, null, null);
        }
    }

    private synchronized void readImage(int n, int n2, boolean bl, boolean bl2) throws IOException {
        if (this.theImage != null) {
            return;
        }
        this.readMetadata();
        int n3 = this.metadata.IHDR_width;
        int n4 = this.metadata.IHDR_height;
        int[] nArray = ImageTools.computeDimensions(n3, n4, n, n2, bl);
        n = nArray[0];
        n2 = nArray[1];
        this.destType = ImageTools.getConvertedType(this.sourceType);
        this.numDestBands = ImageStorage.getNumBands(this.destType);
        this.isConverting = this.destType != this.sourceType;
        boolean bl3 = this.isScaling = n != n3 || n2 != n4;
        if (!this.isConverting && !this.isScaling || this.isInterlaced && (this.isConverting || this.isScaling)) {
            this.rowProc = ROW_PROCESS.COPY;
        } else if (this.isConverting && !this.isScaling) {
            this.rowProc = ROW_PROCESS.CONVERT;
        } else {
            assert (!this.isInterlaced);
            this.rowProc = !this.isConverting && this.isScaling ? ROW_PROCESS.DOWNSCALE : ROW_PROCESS.CONVERT_DOWNSCALE;
        }
        this.sourceXSubsampling = 1;
        this.sourceYSubsampling = 1;
        this.sourceMinProgressivePass = 0;
        this.sourceMaxProgressivePass = 6;
        Inflater inflater = null;
        try {
            inflater = new Inflater();
            FilterInputStream filterInputStream = new InflaterInputStream(this.IDATStream, inflater);
            filterInputStream = new BufferedInputStream(filterInputStream);
            this.pixelStream = new DataInputStream(filterInputStream);
            this.scaler = ScalerFactory.createScaler(n3, n4, ImageStorage.getNumBands(this.destType), n, n2, bl2);
            Float f = this.metadata.gAMA_present ? Float.valueOf(this.metadata.gAMA_gamma) : null;
            Integer n5 = null;
            Integer n6 = null;
            if (this.metadata.bKGD_present) {
                if (this.metadata.IHDR_colorType == 3) {
                    n5 = this.metadata.bKGD_index;
                    this.metadata.bKGD_colorType = 3;
                } else if (this.metadata.IHDR_colorType == 0 || this.metadata.IHDR_colorType == 4) {
                    int n7 = this.metadata.bKGD_gray & 0xFF;
                    n6 = new Integer(n7 << 16 | n7 << 8 | n7 | 0xFF000000);
                } else {
                    n6 = new Integer((this.metadata.bKGD_red & 0xFF) << 16 | (this.metadata.bKGD_green & 0xFF) << 8 | this.metadata.bKGD_blue & 0xFF | 0xFF000000);
                }
            }
            ImageMetadata imageMetadata = new ImageMetadata(f, true, n5, n6, null, null, this.metadata.IHDR_width, this.metadata.IHDR_height, null, null, null);
            this.updateImageMetadata(imageMetadata);
            if (this.rowProc == ROW_PROCESS.COPY) {
                int n8 = ImageStorage.getNumBands(this.sourceType);
                int n9 = n3 * n8;
                this.theImage = new ImageFrame(this.sourceType, ByteBuffer.wrap(new byte[n4 * n9]), n3, n4, n9, this.thePalette, imageMetadata);
            } else {
                int n10 = n * this.numDestBands;
                this.theImage = new ImageFrame(this.destType, ByteBuffer.wrap(new byte[n2 * n10]), n, n2, n10, this.thePalette, imageMetadata);
            }
            this.decodeImage(n, n2, bl2);
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("Error reading PNG image data");
            iOException2.initCause(iOException);
            throw iOException2;
        }
        finally {
            if (inflater != null) {
                inflater.end();
            }
        }
    }

    private static enum ROW_PROCESS {
        COPY,
        CONVERT,
        DOWNSCALE,
        CONVERT_DOWNSCALE;

    }
}

