/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.gif;

import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.common.PushbroomScaler;
import com.sun.javafx.iio.common.ScalerFactory;
import com.sun.javafx.iio.gif.GIFDescriptor;
import com.sun.javafx.iio.gif.GIFImageMetadata;
import com.sun.javafx.iio.gif.GIFStreamMetadata;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GIFImageLoader
extends ImageLoaderImpl {
    InputStream stream = null;
    boolean gotHeader = false;
    GIFStreamMetadata streamMetadata = null;
    int currIndex = -1;
    GIFImageMetadata imageMetadata = null;
    List imageStartPosition = new ArrayList();
    int numImages = -1;
    byte[] block = new byte[255];
    int blockLength = 0;
    int bitPos = 0;
    int nextByte = 0;
    int initCodeSize;
    int clearCode;
    int eofCode;
    int next32Bits = 0;
    boolean lastBlockFound = false;
    ImageStorage.ImageType sourceType;
    ImageFrame theImage = null;
    byte[] theTile = null;
    int width = -1;
    int height = -1;
    int streamX = -1;
    int streamY = -1;
    int rowsDone = 0;
    int interlacePass = 0;
    int destWidth;
    int destHeight;
    boolean isScaling;
    PushbroomScaler scaler;
    static final int[] interlaceIncrement = new int[]{8, 8, 4, 2, -1};
    static final int[] interlaceOffset = new int[]{0, 4, 2, 1, -1};
    Rectangle sourceRegion;
    int sourceXSubsampling;
    int sourceYSubsampling;
    int sourceMinProgressivePass;
    int sourceMaxProgressivePass;
    Point2D destinationOffset;
    Rectangle destinationRegion;
    int updateMinY;
    int updateYStep;
    boolean decodeThisRow = true;
    int destY = 0;
    byte[] rowBuf;
    byte[] destBuf;
    boolean doneScaling = false;

    static short readUnsignedShort(InputStream inputStream) throws IOException {
        return (short)(inputStream.read() | inputStream.read() << 8);
    }

    public GIFImageLoader(InputStream inputStream) throws IOException {
        super(GIFDescriptor.getInstance());
        if (inputStream == null) {
            throw new IllegalArgumentException("input == null!");
        }
        this.stream = inputStream;
    }

    private void checkIndex(int n) {
    }

    public byte[][] getPalette() {
        byte[] byArray = this.imageMetadata.localColorTable != null ? this.imageMetadata.localColorTable : this.streamMetadata.globalColorTable;
        int n = byArray.length / 3;
        int n2 = n == 2 ? 1 : (n == 4 ? 2 : (n == 8 || n == 16 ? 4 : 8));
        int n3 = 1 << n2;
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            byArray2[i] = byArray[n4++];
            byArray3[i] = byArray[n4++];
            byArray4[i] = byArray[n4++];
        }
        byte[] byArray5 = null;
        if (this.imageMetadata.transparentColorFlag) {
            byArray5 = new byte[n3];
            Arrays.fill(byArray5, (byte)-1);
            int n5 = Math.min(this.imageMetadata.transparentColorIndex, n3 - 1);
            byArray5[n5] = 0;
        }
        int[] nArray = new int[]{n2};
        byte[][] byArrayArray = new byte[byArray5 != null ? 4 : 3][];
        byArrayArray[0] = byArray2;
        byArrayArray[1] = byArray3;
        byArrayArray[2] = byArray4;
        if (byArray5 != null) {
            byArrayArray[3] = byArray5;
        }
        return byArrayArray;
    }

    private void initNext32Bits() {
        this.next32Bits = this.block[0] & 0xFF;
        this.next32Bits |= (this.block[1] & 0xFF) << 8;
        this.next32Bits |= (this.block[2] & 0xFF) << 16;
        this.next32Bits |= this.block[3] << 24;
        this.nextByte = 4;
    }

    private int getCode(int n, int n2) throws IOException {
        if (this.bitPos + n > 32) {
            return this.eofCode;
        }
        int n3 = this.next32Bits >> this.bitPos & n2;
        this.bitPos += n;
        while (this.bitPos >= 8 && !this.lastBlockFound) {
            this.next32Bits >>>= 8;
            this.bitPos -= 8;
            if (this.nextByte >= this.blockLength) {
                int n4;
                this.blockLength = this.stream.read();
                if (this.blockLength == 0) {
                    this.lastBlockFound = true;
                    return n3;
                }
                int n5 = 0;
                for (int i = this.blockLength; i > 0; i -= n4) {
                    n4 = ImageTools.readFully(this.stream, this.block, n5, i);
                    n5 += n4;
                }
                this.nextByte = 0;
            }
            this.next32Bits |= this.block[this.nextByte++] << 24;
        }
        return n3;
    }

    public void initializeStringTable(int[] nArray, byte[] byArray, byte[] byArray2, int[] nArray2) {
        int n;
        int n2 = 1 << this.initCodeSize;
        for (n = 0; n < n2; ++n) {
            nArray[n] = -1;
            byArray[n] = (byte)n;
            byArray2[n] = (byte)n;
            nArray2[n] = 1;
        }
        for (n = n2; n < 4096; ++n) {
            nArray[n] = -1;
            nArray2[n] = 1;
        }
    }

    private void outputRow() {
        int n = Math.min(this.sourceRegion.width, this.destinationRegion.width * this.sourceXSubsampling);
        int n2 = this.destinationRegion.x;
        if (!this.imageMetadata.interlaceFlag || !this.isScaling) {
            ImageTools.convert(n, 1, this.sourceType, this.rowBuf, 0, this.rowBuf.length, this.destBuf, 0, this.destBuf.length, this.getPalette(), this.imageMetadata.transparentColorIndex);
        }
        if (this.sourceXSubsampling == 1) {
            if (!this.imageMetadata.interlaceFlag) {
                if (this.isScaling) {
                    if (!this.doneScaling) {
                        this.doneScaling = this.scaler.putSourceScanline(this.destBuf, 0);
                    }
                } else {
                    System.arraycopy(this.destBuf, 0, this.theTile, this.destY * this.theImage.getStride() + n2, this.destBuf.length);
                }
            } else {
                byte[] byArray = this.isScaling ? this.rowBuf : this.destBuf;
                System.arraycopy(byArray, 0, this.theTile, this.destY * this.theImage.getStride() + n2, byArray.length);
            }
        } else {
            assert (false);
            int n3 = 0;
            while (n3 < n) {
                this.theTile[this.destY * this.theImage.getStride() + n2] = this.rowBuf[n3];
                n3 += this.sourceXSubsampling;
                ++n2;
            }
        }
    }

    private void computeDecodeThisRow() {
        this.decodeThisRow = this.destY < this.destinationRegion.y + this.destinationRegion.height && this.streamY >= this.sourceRegion.y && this.streamY < this.sourceRegion.y + this.sourceRegion.height && (this.streamY - this.sourceRegion.y) % this.sourceYSubsampling == 0;
    }

    private void outputPixels(byte[] byArray, int n) {
        if (this.interlacePass < this.sourceMinProgressivePass || this.interlacePass > this.sourceMaxProgressivePass) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (this.streamX >= this.sourceRegion.x) {
                this.rowBuf[this.streamX - this.sourceRegion.x] = byArray[i];
            }
            ++this.streamX;
            if (this.streamX != this.width) continue;
            ++this.rowsDone;
            this.updateImageProgress(100.0f * (float)this.rowsDone / (float)this.height);
            if (this.decodeThisRow) {
                this.outputRow();
            }
            this.streamX = 0;
            if (this.imageMetadata.interlaceFlag) {
                this.streamY += interlaceIncrement[this.interlacePass];
                if (this.streamY >= this.height) {
                    ++this.interlacePass;
                    if (this.interlacePass > this.sourceMaxProgressivePass) {
                        return;
                    }
                    this.streamY = interlaceOffset[this.interlacePass];
                    this.startPass(this.interlacePass);
                }
            } else {
                ++this.streamY;
            }
            this.destY = this.destinationRegion.y + (this.streamY - this.sourceRegion.y) / this.sourceYSubsampling;
            this.computeDecodeThisRow();
        }
    }

    private void readHeader() throws IOException {
        if (this.gotHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.streamMetadata = new GIFStreamMetadata();
        try {
            byte[] byArray = new byte[6];
            this.stream.read(byArray);
            StringBuffer stringBuffer = new StringBuffer(3);
            stringBuffer.append((char)byArray[3]);
            stringBuffer.append((char)byArray[4]);
            stringBuffer.append((char)byArray[5]);
            this.streamMetadata.version = stringBuffer.toString();
            this.streamMetadata.logicalScreenWidth = GIFImageLoader.readUnsignedShort(this.stream);
            this.streamMetadata.logicalScreenHeight = GIFImageLoader.readUnsignedShort(this.stream);
            int n = this.stream.read();
            boolean bl = (n & 0x80) != 0;
            this.streamMetadata.colorResolution = (n >> 4 & 7) + 1;
            this.streamMetadata.sortFlag = (n & 8) != 0;
            int n2 = 1 << (n & 7) + 1;
            this.streamMetadata.backgroundColorIndex = this.stream.read();
            this.streamMetadata.pixelAspectRatio = this.stream.read();
            if (bl) {
                this.streamMetadata.globalColorTable = new byte[3 * n2];
                ImageTools.readFully(this.stream, this.streamMetadata.globalColorTable);
            } else {
                this.streamMetadata.globalColorTable = null;
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("I/O error reading header!");
            iOException2.initCause(iOException);
            throw iOException2;
        }
        this.gotHeader = true;
    }

    private boolean skipImage() throws IOException {
        try {
            while (true) {
                int n;
                int n2;
                int n3;
                if ((n3 = this.stream.read()) == 44) {
                    this.stream.skip(8L);
                    n2 = this.stream.read();
                    if ((n2 & 0x80) != 0) {
                        n = (n2 & 7) + 1;
                        this.stream.skip(3 * (1 << n));
                    }
                    this.stream.skip(1L);
                    n = 0;
                    do {
                        n = this.stream.read();
                        this.stream.skip(n);
                    } while (n > 0);
                    return true;
                }
                if (n3 == 59) {
                    return false;
                }
                if (n3 == 33) {
                    n2 = this.stream.read();
                    n = 0;
                    do {
                        n = this.stream.read();
                        this.stream.skip(n);
                    } while (n > 0);
                    continue;
                }
                if (n3 == 0) {
                    return false;
                }
                n2 = 0;
                do {
                    n2 = this.stream.read();
                    this.stream.skip(n2);
                } while (n2 > 0);
            }
        }
        catch (EOFException eOFException) {
            return false;
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("I/O error locating image!");
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    private int locateImage(int n) throws IOException {
        this.readHeader();
        return n;
    }

    private byte[] concatenateBlocks() throws IOException {
        int n;
        byte[] byArray = new byte[]{};
        while ((n = this.stream.read()) != 0) {
            byte[] byArray2 = new byte[byArray.length + n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            ImageTools.readFully(this.stream, byArray2, byArray.length, n);
            byArray = byArray2;
        }
        return byArray;
    }

    private boolean readMetadata() throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        boolean bl = false;
        try {
            this.imageMetadata = new GIFImageMetadata();
            while (!bl) {
                int n;
                int n2 = this.stream.read();
                if (n2 == 44) {
                    this.imageMetadata.imageLeftPosition = GIFImageLoader.readUnsignedShort(this.stream);
                    this.imageMetadata.imageTopPosition = GIFImageLoader.readUnsignedShort(this.stream);
                    this.imageMetadata.imageWidth = GIFImageLoader.readUnsignedShort(this.stream);
                    this.imageMetadata.imageHeight = GIFImageLoader.readUnsignedShort(this.stream);
                    n = this.stream.read();
                    boolean bl2 = (n & 0x80) != 0;
                    this.imageMetadata.interlaceFlag = (n & 0x40) != 0;
                    this.imageMetadata.sortFlag = (n & 0x20) != 0;
                    int n3 = 1 << (n & 7) + 1;
                    if (bl2) {
                        this.imageMetadata.localColorTable = new byte[3 * n3];
                        ImageTools.readFully(this.stream, this.imageMetadata.localColorTable);
                    } else {
                        this.imageMetadata.localColorTable = null;
                    }
                    return true;
                }
                if (n2 == 33) {
                    n = this.stream.read();
                    if (n == 249) {
                        int n4 = this.stream.read();
                        int n5 = this.stream.read();
                        this.imageMetadata.disposalMethod = n5 >> 2 & 3;
                        this.imageMetadata.userInputFlag = (n5 & 2) != 0;
                        this.imageMetadata.transparentColorFlag = (n5 & 1) != 0;
                        this.imageMetadata.delayTime = GIFImageLoader.readUnsignedShort(this.stream);
                        this.imageMetadata.transparentColorIndex = this.stream.read();
                        int n6 = this.stream.read();
                        continue;
                    }
                    if (n == 1) {
                        int n7 = this.stream.read();
                        this.imageMetadata.hasPlainTextExtension = true;
                        this.imageMetadata.textGridLeft = GIFImageLoader.readUnsignedShort(this.stream);
                        this.imageMetadata.textGridTop = GIFImageLoader.readUnsignedShort(this.stream);
                        this.imageMetadata.textGridWidth = GIFImageLoader.readUnsignedShort(this.stream);
                        this.imageMetadata.textGridHeight = GIFImageLoader.readUnsignedShort(this.stream);
                        this.imageMetadata.characterCellWidth = this.stream.read();
                        this.imageMetadata.characterCellHeight = this.stream.read();
                        this.imageMetadata.textForegroundColor = this.stream.read();
                        this.imageMetadata.textBackgroundColor = this.stream.read();
                        this.imageMetadata.text = this.concatenateBlocks();
                        continue;
                    }
                    if (n == 254) {
                        byte[] byArray = this.concatenateBlocks();
                        if (this.imageMetadata.comments == null) {
                            this.imageMetadata.comments = new ArrayList<byte[]>();
                        }
                        this.imageMetadata.comments.add(byArray);
                        continue;
                    }
                    if (n == 255) {
                        int n8 = this.stream.read();
                        byte[] byArray = new byte[8];
                        byte[] byArray2 = new byte[3];
                        byte[] byArray3 = new byte[n8];
                        this.stream.read(byArray3);
                        int n9 = this.copyData(byArray3, 0, byArray);
                        n9 = this.copyData(byArray3, n9, byArray2);
                        byte[] byArray4 = this.concatenateBlocks();
                        if (n9 < n8) {
                            int n10 = n8 - n9;
                            byte[] byArray5 = new byte[n10 + byArray4.length];
                            System.arraycopy(byArray3, n9, byArray5, 0, n10);
                            System.arraycopy(byArray4, 0, byArray5, n10, byArray4.length);
                            byArray4 = byArray5;
                        }
                        if (this.imageMetadata.applicationIDs == null) {
                            this.imageMetadata.applicationIDs = new ArrayList<byte[]>();
                            this.imageMetadata.authenticationCodes = new ArrayList<byte[]>();
                            this.imageMetadata.applicationData = new ArrayList<byte[]>();
                        }
                        this.imageMetadata.applicationIDs.add(byArray);
                        this.imageMetadata.authenticationCodes.add(byArray2);
                        this.imageMetadata.applicationData.add(byArray4);
                        continue;
                    }
                    int n11 = 0;
                    do {
                        n11 = this.stream.read();
                        this.stream.skip(n11);
                    } while (n11 > 0);
                    continue;
                }
                if (n2 == 59) {
                    bl = true;
                    continue;
                }
                throw new IOException("Unexpected block type " + n2 + "!");
            }
        }
        catch (EOFException eOFException) {
            bl = true;
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("I/O error reading image metadata!");
            iOException2.initCause(iOException);
            throw iOException2;
        }
        return !bl;
    }

    private int copyData(byte[] byArray, int n, byte[] byArray2) {
        int n2 = byArray2.length;
        int n3 = byArray.length - n;
        if (n2 > n3) {
            n2 = n3;
        }
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return n + n2;
    }

    private void startPass(int n) {
        int n2 = 0;
        int n3 = 1;
        if (this.imageMetadata.interlaceFlag) {
            n2 = interlaceOffset[this.interlacePass];
            n3 = interlaceIncrement[this.interlacePass];
        }
        int[] nArray = ImageTools.computeUpdatedPixels(this.sourceRegion, this.destinationOffset, this.destinationRegion.x, this.destinationRegion.y, this.destinationRegion.x + this.destinationRegion.width - 1, this.destinationRegion.y + this.destinationRegion.height - 1, this.sourceXSubsampling, this.sourceYSubsampling, 0, n2, this.destinationRegion.width, (this.destinationRegion.height + n3 - 1) / n3, 1, n3);
        this.updateMinY = nArray[1];
        this.updateYStep = nArray[5];
    }

    public ImageFrame read(int n, int n2, int n3, boolean bl, boolean bl2) throws IOException {
        ByteBuffer byteBuffer;
        int n4;
        int n5;
        int n6;
        ImageStorage.ImageType imageType;
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.checkIndex(n);
        int n7 = this.locateImage(n);
        if (n7 != n) {
            throw new IndexOutOfBoundsException("imageIndex out of bounds!");
        }
        if (!this.readMetadata()) {
            return null;
        }
        this.width = this.imageMetadata.imageWidth;
        this.height = this.imageMetadata.imageHeight;
        this.sourceType = this.imageMetadata.transparentColorFlag ? ImageStorage.ImageType.PALETTE_TRANS : ImageStorage.ImageType.PALETTE;
        int[] nArray = ImageTools.computeDimensions(this.width, this.height, n2, n3, bl);
        this.destWidth = n2 = nArray[0];
        this.destHeight = n3 = nArray[1];
        this.isScaling = n2 != this.width || n3 != this.height;
        Integer n8 = null;
        if (this.streamMetadata.globalColorTable != null) {
            n8 = this.streamMetadata.backgroundColorIndex;
        }
        Integer n9 = null;
        if (this.imageMetadata.transparentColorFlag) {
            n9 = this.imageMetadata.transparentColorIndex;
        }
        ImageMetadata imageMetadata = new ImageMetadata(null, true, n8, null, n9, 10 * this.imageMetadata.delayTime, this.imageMetadata.imageWidth, this.imageMetadata.imageHeight, this.imageMetadata.imageLeftPosition, this.imageMetadata.imageTopPosition, this.imageMetadata.disposalMethod);
        this.updateImageMetadata(imageMetadata);
        ImageStorage.ImageType imageType2 = ImageTools.getConvertedType(this.sourceType);
        int n10 = ImageStorage.getNumBands(imageType2);
        byte[][] byArray = null;
        ImageMetadata imageMetadata2 = imageMetadata;
        if (this.isScaling) {
            this.scaler = ScalerFactory.createScaler(this.width, this.height, n10, n2, n3, bl2);
            if (this.imageMetadata.interlaceFlag) {
                imageType = this.sourceType;
                n6 = this.width;
                n5 = this.height;
                byArray = this.getPalette();
                imageMetadata2 = imageMetadata;
                n4 = 4 * ((this.width + 3) / 4);
                byteBuffer = ByteBuffer.wrap(new byte[this.height * n4]);
            } else {
                imageType = imageType2;
                n6 = n2;
                n5 = n3;
                n4 = n2 * n10;
                byteBuffer = this.scaler.getDestination();
            }
        } else {
            imageType = imageType2;
            n6 = n2;
            n5 = n3;
            n4 = n2 * n10;
            byteBuffer = ByteBuffer.wrap(new byte[n3 * n4]);
        }
        this.theImage = new ImageFrame(imageType, byteBuffer, n6, n5, n4, byArray, imageMetadata2);
        this.theTile = ((ByteBuffer)this.theImage.getImageData()).array();
        this.streamX = 0;
        this.streamY = 0;
        this.rowsDone = 0;
        this.interlacePass = 0;
        this.sourceRegion = new Rectangle(this.width, this.height);
        this.destinationRegion = new Rectangle(0, 0, 0, 0);
        this.destinationOffset = new Point2D();
        this.destinationRegion = new Rectangle(this.width, this.height);
        this.sourceXSubsampling = 1;
        this.sourceYSubsampling = 1;
        this.sourceMinProgressivePass = 0;
        this.sourceMaxProgressivePass = 3;
        this.destY = this.destinationRegion.y + (this.streamY - this.sourceRegion.y) / this.sourceYSubsampling;
        this.computeDecodeThisRow();
        this.updateImageProgress(0.0f);
        this.startPass(0);
        this.rowBuf = new byte[this.width];
        this.destBuf = new byte[this.width * n10];
        try {
            int n11;
            this.initCodeSize = this.stream.read();
            int n12 = this.blockLength = this.stream.read();
            int n13 = 0;
            while (n12 > 0) {
                n11 = ImageTools.readFully(this.stream, this.block, n13, n12);
                n12 -= n11;
                n13 += n11;
            }
            this.bitPos = 0;
            this.nextByte = 0;
            this.lastBlockFound = false;
            this.interlacePass = 0;
            this.initNext32Bits();
            this.clearCode = 1 << this.initCodeSize;
            this.eofCode = this.clearCode + 1;
            int n14 = 0;
            int[] nArray2 = new int[4096];
            byte[] byArray2 = new byte[4096];
            byte[] byArray3 = new byte[4096];
            int[] nArray3 = new int[4096];
            byte[] byArray4 = new byte[4096];
            this.initializeStringTable(nArray2, byArray2, byArray3, nArray3);
            int n15 = (1 << this.initCodeSize) + 2;
            int n16 = this.initCodeSize + 1;
            int n17 = (1 << n16) - 1;
            while (true) {
                int n18;
                int n19;
                int n20;
                if ((n11 = this.getCode(n16, n17)) == this.clearCode) {
                    this.initializeStringTable(nArray2, byArray2, byArray3, nArray3);
                    n15 = (1 << this.initCodeSize) + 2;
                    n16 = this.initCodeSize + 1;
                    n17 = (1 << n16) - 1;
                    n11 = this.getCode(n16, n17);
                    if (n11 == this.eofCode) {
                        this.updateImageProgress(100.0f);
                        return this.theImage;
                    }
                } else {
                    if (n11 == this.eofCode) {
                        if (this.imageMetadata.interlaceFlag && this.isScaling) {
                            ByteBuffer byteBuffer2 = (ByteBuffer)this.theImage.getImageData();
                            byte[] byArray5 = byteBuffer2.array();
                            n20 = this.theImage.getStride();
                            int n21 = 0;
                            byte[] byArray6 = new byte[this.width * n10];
                            for (int i = 0; i < this.height; ++i) {
                                ImageTools.convert(this.width, 1, this.sourceType, byArray5, n21, n20, byArray6, 0, 0, byArray, n9);
                                if (this.scaler.putSourceScanline(byArray6, 0)) break;
                                n21 += n20;
                            }
                            this.theImage = new ImageFrame(imageType2, this.scaler.getDestination(), n2, n3, n2 * n10, null, imageMetadata2);
                        }
                        this.updateImageProgress(100.0f);
                        return this.theImage;
                    }
                    if (n11 < n15) {
                        n19 = n11;
                    } else {
                        n19 = n14;
                        if (n11 != n15) {
                            this.emitWarning("Out-of-sequence code!");
                        }
                    }
                    n18 = n15++;
                    nArray2[n18] = n20 = n14;
                    byArray2[n18] = byArray3[n19];
                    byArray3[n18] = byArray3[n20];
                    nArray3[n18] = nArray3[n20] + 1;
                    if (n15 == 1 << n16 && n15 < 4096) {
                        n17 = (1 << ++n16) - 1;
                    }
                }
                n19 = n11;
                n18 = nArray3[n19];
                for (n20 = n18 - 1; n20 >= 0; --n20) {
                    byArray4[n20] = byArray2[n19];
                    n19 = nArray2[n19];
                }
                this.outputPixels(byArray4, n18);
                n14 = n11;
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("Error reading GIF image data");
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    public void reset() {
        this.resetStreamSettings();
    }

    private void resetStreamSettings() {
        this.gotHeader = false;
        this.streamMetadata = null;
        this.currIndex = -1;
        this.imageMetadata = null;
        this.imageStartPosition = new ArrayList();
        this.numImages = -1;
        this.blockLength = 0;
        this.bitPos = 0;
        this.nextByte = 0;
        this.next32Bits = 0;
        this.lastBlockFound = false;
        this.theImage = null;
        this.theTile = null;
        this.width = -1;
        this.height = -1;
        this.streamX = -1;
        this.streamY = -1;
        this.rowsDone = 0;
        this.interlacePass = 0;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ImageFrame load(int n, int n2, int n3, boolean bl, boolean bl2) throws IOException {
        return this.read(n, n2, n3, bl, bl2);
    }
}

