/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.Utils;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.Value;
import com.sun.javafx.css.converters.StringConverter;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.scene.text.Font;

public final class URLConverter
extends StyleConverter<Value[], String> {
    public static URLConverter getInstance() {
        return Holder.INSTANCE;
    }

    private URLConverter() {
    }

    @Override
    public String convert(Value<Value[], String> value, Font font) {
        String string = null;
        try {
            Value[] valueArray = value.getValue();
            Object object = StringConverter.getInstance().convert(valueArray[0], font);
            object = ((String)object).startsWith("url(") ? Utils.stripQuotes(((String)object).substring(4, ((String)object).length() - 1)) : Utils.stripQuotes((String)object);
            URL uRL = (URL)valueArray[1].getValue();
            URL uRL2 = null;
            if (uRL == null) {
                try {
                    uRL2 = new URL((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    uRL2 = classLoader.getResource((String)object);
                }
            } else {
                uRL2 = new URL(uRL, (String)object);
            }
            if (uRL2 != null) {
                string = uRL2.toExternalForm();
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("caught " + malformedURLException + " in 'URLType.convert'");
        }
        return string;
    }

    public String toString() {
        return "URLType";
    }

    public static final class SequenceConverter
    extends StyleConverter<Value<Value[], String>[], String[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public String[] convert(Value<Value<Value[], String>[], String[]> value, Font font) {
            Value<Value[], String>[] valueArray = value.getValue();
            String[] stringArray = new String[valueArray.length];
            for (int i = 0; i < valueArray.length; ++i) {
                stringArray[i] = URLConverter.getInstance().convert((Value)valueArray[i], font);
            }
            return stringArray;
        }

        public String toString() {
            return "URLSeqType";
        }
    }

    private static class Holder {
        static URLConverter INSTANCE = new URLConverter();
        static SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }
}

