/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.css.Size;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.Value;
import javafx.geometry.Insets;
import javafx.scene.text.Font;

public final class InsetsConverter
extends StyleConverter<Value<?, Size>[], Insets> {
    public static InsetsConverter getInstance() {
        return Holder.INSTANCE;
    }

    private InsetsConverter() {
    }

    @Override
    public Insets convert(Value<Value<?, Size>[], Insets> value, Font font) {
        Value<?, Size>[] valueArray = value.getValue();
        double d = valueArray[0].convert(font).pixels(font);
        double d2 = valueArray.length > 1 ? valueArray[1].convert(font).pixels(font) : d;
        double d3 = valueArray.length > 2 ? valueArray[2].convert(font).pixels(font) : d;
        double d4 = valueArray.length > 3 ? valueArray[3].convert(font).pixels(font) : d2;
        return new Insets(d, d2, d3, d4);
    }

    public String toString() {
        return "InsetsConverter";
    }

    public static final class SequenceConverter
    extends StyleConverter<Value<Value<?, Size>[], Insets>[], Insets[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public Insets[] convert(Value<Value<Value<?, Size>[], Insets>[], Insets[]> value, Font font) {
            Value<Value<?, Size>[], Insets>[] valueArray = value.getValue();
            Insets[] insetsArray = new Insets[valueArray.length];
            for (int i = 0; i < valueArray.length; ++i) {
                insetsArray[i] = InsetsConverter.getInstance().convert((Value)valueArray[i], font);
            }
            return insetsArray;
        }

        public String toString() {
            return "InsetsSequenceConverter";
        }
    }

    private static class Holder {
        static InsetsConverter INSTANCE = new InsetsConverter();
        static SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }
}

