/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.Utils;
import com.sun.javafx.css.FontUnits;
import com.sun.javafx.css.Size;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.Value;
import java.util.List;
import java.util.Map;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public final class FontConverter
extends com.sun.javafx.css.StyleConverter<Value[], Font> {
    public static FontConverter getInstance() {
        return Holder.INSTANCE;
    }

    private FontConverter() {
    }

    @Override
    public Font convert(Value<Value[], Font> value, Font font) {
        Object object;
        Object object2;
        Value[] valueArray = value.getValue();
        Font font2 = font != null ? font : Font.getDefault();
        String string = valueArray[0] != null ? Utils.stripQuotes((String)valueArray[0].convert(font2)) : font2.getFamily();
        double d = font2.getSize();
        if (valueArray[1] != null) {
            object2 = (Value)valueArray[1].getValue();
            object = (Size)((Value)object2).convert(font2);
            d = object.pixels(font2.getSize(), font2);
        }
        object2 = valueArray[2] != null ? (FontWeight)((Object)valueArray[2].convert(font2)) : FontWeight.NORMAL;
        object = valueArray[3] != null ? (FontPosture)((Object)valueArray[3].convert(font2)) : FontPosture.REGULAR;
        Font font3 = Font.font(string, (FontWeight)((Object)object2), (FontPosture)((Object)object), d);
        return font3;
    }

    @Override
    public Font convert(Map<StyleableProperty, Object> map) {
        Font font = Font.getDefault();
        double d = font.getSize();
        String string = font.getFamily();
        FontWeight fontWeight = FontWeight.NORMAL;
        FontPosture fontPosture = FontPosture.REGULAR;
        List<StyleableProperty> list = StyleableProperty.FONT.getSubProperties();
        for (int i = 0; i < list.size(); ++i) {
            StyleableProperty styleableProperty = list.get(i);
            Object object = map.get(styleableProperty);
            if (object == null) continue;
            if (styleableProperty.getProperty().endsWith("font-size")) {
                d = ((Number)object).doubleValue();
                continue;
            }
            if (styleableProperty.getProperty().endsWith("font-family")) {
                string = Utils.stripQuotes((String)object);
                continue;
            }
            if (styleableProperty.getProperty().endsWith("font-weight")) {
                fontWeight = (FontWeight)((Object)object);
                continue;
            }
            if (!styleableProperty.getProperty().endsWith("font-style")) continue;
            fontPosture = (FontPosture)((Object)object);
        }
        Font font2 = Font.font(string, fontWeight, fontPosture, d);
        return font2;
    }

    public String toString() {
        return "FontConverter";
    }

    public static final class WeightConverter
    extends com.sun.javafx.css.StyleConverter<FontUnits.Weight, FontWeight> {
        public static WeightConverter getInstance() {
            return Holder.INSTANCE;
        }

        private WeightConverter() {
        }

        @Override
        public FontWeight convert(Value<FontUnits.Weight, FontWeight> value, Font font) {
            FontUnits.Weight weight = value.getValue();
            if (FontUnits.Weight.INHERIT != weight && FontUnits.Weight.BOLDER != weight && FontUnits.Weight.LIGHTER != weight) {
                return weight.toFontWeight();
            }
            if (font != null) {
                FontWeight fontWeight = FontWeight.NORMAL;
                if (FontUnits.Weight.INHERIT == weight) {
                    return fontWeight;
                }
                if (FontUnits.Weight.BOLDER == weight) {
                    return FontUnits.Weight.toWeight(fontWeight).bolder().toFontWeight();
                }
                if (FontUnits.Weight.LIGHTER == weight) {
                    return FontUnits.Weight.toWeight(fontWeight).lighter().toFontWeight();
                }
                return weight.toFontWeight();
            }
            return weight.toFontWeight();
        }

        public String toString() {
            return "Font.WeightConverter";
        }

        private static class Holder {
            static WeightConverter INSTANCE = new WeightConverter();

            private Holder() {
            }
        }
    }

    public static final class StyleConverter
    extends com.sun.javafx.css.StyleConverter<FontUnits.Style, FontPosture> {
        public static StyleConverter getInstance() {
            return Holder.INSTANCE;
        }

        private StyleConverter() {
        }

        @Override
        public FontPosture convert(Value<FontUnits.Style, FontPosture> value, Font font) {
            FontUnits.Style style = value.getValue();
            if (FontUnits.Style.INHERIT != style) {
                return style.toFontPosture();
            }
            if (font != null) {
                return FontPosture.REGULAR;
            }
            return FontPosture.REGULAR;
        }

        public String toString() {
            return "Font.StyleConverter";
        }

        private static class Holder {
            static StyleConverter INSTANCE = new StyleConverter();

            private Holder() {
            }
        }
    }

    private static class Holder {
        static FontConverter INSTANCE = new FontConverter();

        private Holder() {
        }
    }
}

