/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.Value;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public final class ColorConverter
extends StyleConverter<String, Color> {
    public static ColorConverter getInstance() {
        return Holder.COLOR_INSTANCE;
    }

    private ColorConverter() {
    }

    @Override
    public Color convert(Value<String, Color> value, Font font) {
        String string = value.getValue();
        if (string == null || string.isEmpty() || "null".equals(string)) {
            return Color.TRANSPARENT;
        }
        try {
            return Color.web(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("not a color: " + value);
            return Color.BLACK;
        }
    }

    public String toString() {
        return "ColorConverter";
    }

    private static class Holder {
        static ColorConverter COLOR_INSTANCE = new ColorConverter();

        private Holder() {
        }
    }
}

