/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.StringStore;
import com.sun.javafx.css.StyleConverter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class Value<V, T> {
    private final V value;
    private final StyleConverter<V, T> converter;
    private final boolean lookup;
    private final boolean containsLookups;
    private final boolean needsFont;
    Value resolved;
    private static final String newline = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });
    private static int indent = 0;
    private int hc = -1;
    private static final byte NULL_VALUE = 0;
    private static final byte VALUE = 1;
    private static final byte VALUE_ARRAY = 2;
    private static final byte ARRAY_OF_VALUE_ARRAY = 3;
    private static final byte STRING = 4;
    private static final byte COLOR = 5;
    private static final byte ENUM = 6;
    private static final byte BOOLEAN = 7;
    private static final byte URL = 8;
    private static final byte SIZE = 9;

    public final V getValue() {
        return this.value;
    }

    public final StyleConverter<V, T> getConverter() {
        return this.converter;
    }

    public final boolean isLookup() {
        return this.lookup;
    }

    public final boolean isContainsLookups() {
        return this.containsLookups;
    }

    private static boolean getContainsLookupsFlag(Object object) {
        boolean bl;
        block4: {
            block6: {
                block5: {
                    block3: {
                        bl = false;
                        if (!(object instanceof Size)) break block3;
                        bl = false;
                        break block4;
                    }
                    if (!(object instanceof Value)) break block5;
                    Value value = (Value)object;
                    bl = value.lookup || value.containsLookups;
                    break block4;
                }
                if (!(object instanceof Value[])) break block6;
                Value[] valueArray = (Value[])object;
                for (int i = 0; i < valueArray.length && !bl; ++i) {
                    if (valueArray[i] == null) continue;
                    bl = bl || valueArray[i].lookup || valueArray[i].containsLookups;
                }
                break block4;
            }
            if (!(object instanceof Value[][])) break block4;
            Value[][] valueArray = (Value[][])object;
            for (int i = 0; i < valueArray.length && !bl; ++i) {
                if (valueArray[i] == null) continue;
                for (int j = 0; j < valueArray[i].length && !bl; ++j) {
                    if (valueArray[i][j] == null) continue;
                    bl = bl || valueArray[i][j].lookup || valueArray[i][j].containsLookups;
                }
            }
        }
        return bl;
    }

    public boolean isNeedsFont() {
        if (this.resolved != null && this.resolved != this) {
            return this.resolved.needsFont;
        }
        return this.needsFont;
    }

    private static boolean getNeedsFontFlag(Object object) {
        boolean bl;
        block4: {
            block6: {
                block5: {
                    block3: {
                        bl = false;
                        if (!(object instanceof Size)) break block3;
                        bl = !((Size)object).isAbsolute();
                        break block4;
                    }
                    if (!(object instanceof Value)) break block5;
                    Value value = (Value)object;
                    bl = value.needsFont;
                    break block4;
                }
                if (!(object instanceof Value[])) break block6;
                Value[] valueArray = (Value[])object;
                for (int i = 0; i < valueArray.length && !bl; ++i) {
                    if (valueArray[i] == null) continue;
                    bl = valueArray[i].needsFont;
                }
                break block4;
            }
            if (!(object instanceof Value[][])) break block4;
            Value[][] valueArray = (Value[][])object;
            for (int i = 0; i < valueArray.length && !bl; ++i) {
                if (valueArray[i] == null) continue;
                for (int j = 0; j < valueArray[i].length && !bl; ++j) {
                    if (valueArray[j] == null) continue;
                    bl = valueArray[i][j].needsFont;
                }
            }
        }
        return bl;
    }

    public Value(V v, StyleConverter<V, T> styleConverter, boolean bl) {
        this.value = v;
        this.converter = styleConverter;
        this.lookup = bl;
        this.containsLookups = bl || Value.getContainsLookupsFlag(v);
        this.needsFont = Value.getNeedsFontFlag(v);
    }

    public Value(V v, StyleConverter<V, T> styleConverter) {
        this(v, styleConverter, false);
    }

    private Value() {
        this(null, null);
    }

    void nullResolved() {
        if (this.resolved == this || this.resolved == null) {
            return;
        }
        V v = this.resolved.getValue();
        if (v instanceof Value[]) {
            Value[] valueArray = (Value[])v;
            for (int i = 0; i < valueArray.length; ++i) {
                if (valueArray[i] == null) continue;
                valueArray[i].nullResolved();
            }
        } else if (v instanceof Value[][]) {
            Value[][] valueArray = (Value[][])v;
            for (int i = 0; i < valueArray.length; ++i) {
                if (valueArray[i] == null) continue;
                for (int j = 0; j < valueArray[i].length; ++j) {
                    if (valueArray[i][j] == null) continue;
                    valueArray[i][j].nullResolved();
                }
            }
        }
        this.resolved = null;
    }

    public T convert(Font font) {
        if (this.resolved != null && this.resolved != this) {
            return this.resolved.convert(font);
        }
        return (T)(this.converter != null ? this.converter.convert(this, font) : this.value);
    }

    private static String spaces() {
        return new String(new char[indent]).replace('\u0000', ' ');
    }

    private static void indent() {
        indent += 2;
    }

    private static void outdent() {
        indent = Math.max(0, indent - 2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Value.spaces()).append(this.lookup ? "<Value lookup=\"true\">" : "<Value>").append(newline);
        Value.indent();
        this.appendValue(stringBuilder, this.value, "value");
        if (this.resolved != null && this.resolved != this) {
            this.appendValue(stringBuilder, this.resolved, "resolved");
        }
        stringBuilder.append(Value.spaces()).append("<converter>").append(this.converter).append("</converter>").append(newline);
        Value.outdent();
        stringBuilder.append(Value.spaces()).append("</Value>").append(newline);
        return stringBuilder.toString();
    }

    private void appendValue(StringBuilder stringBuilder, Object object, String string) {
        if (object instanceof Value[][]) {
            Value[][] valueArray = (Value[][])object;
            stringBuilder.append(Value.spaces()).append('<').append(string).append(" layers=\"").append(valueArray.length).append("\">").append(newline);
            Value.indent();
            for (Value[] valueArray2 : valueArray) {
                stringBuilder.append(Value.spaces()).append("<layer>").append(newline);
                Value.indent();
                for (Value value : valueArray2) {
                    if (value == null) {
                        stringBuilder.append(Value.spaces()).append("null").append(newline);
                        continue;
                    }
                    stringBuilder.append(value);
                }
                Value.outdent();
                stringBuilder.append(Value.spaces()).append("</layer>").append(newline);
            }
            Value.outdent();
            stringBuilder.append(Value.spaces()).append("</").append(string).append('>').append(newline);
        } else if (object instanceof Value[]) {
            Value[] valueArray = (Value[])object;
            stringBuilder.append(Value.spaces()).append('<').append(string).append(" values=\"").append(valueArray.length).append("\">").append(newline);
            Value.indent();
            for (Value value : valueArray) {
                if (value == null) {
                    stringBuilder.append(Value.spaces()).append("null").append(newline);
                    continue;
                }
                stringBuilder.append(value);
            }
            Value.outdent();
            stringBuilder.append(Value.spaces()).append("</").append(string).append('>').append(newline);
        } else if (object instanceof Value) {
            stringBuilder.append(Value.spaces()).append('<').append(string).append('>').append(newline);
            Value.indent();
            stringBuilder.append(object);
            Value.outdent();
            stringBuilder.append(Value.spaces()).append("</").append(string).append('>').append(newline);
        } else {
            stringBuilder.append(Value.spaces()).append('<').append(string).append('>');
            stringBuilder.append(object);
            stringBuilder.append("</").append(string).append('>').append(newline);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Value) {
            Value value = (Value)object;
            if (this.value instanceof Value[][]) {
                if (!(value.value instanceof Value[][])) {
                    return false;
                }
                Value[][] valueArray = (Value[][])this.value;
                Value[][] valueArray2 = (Value[][])value.value;
                if (valueArray.length != valueArray2.length) {
                    return false;
                }
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] == null && valueArray2[i] == null) continue;
                    if (valueArray[i] == null || valueArray2[i] == null) {
                        return false;
                    }
                    if (valueArray[i].length != valueArray2[i].length) {
                        return false;
                    }
                    for (int j = 0; j < valueArray[i].length; ++j) {
                        Value value2 = valueArray[i][j];
                        Value value3 = valueArray2[i][j];
                        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (this.value instanceof Value[]) {
                if (!(value.value instanceof Value[])) {
                    return false;
                }
                Value[] valueArray = (Value[])this.value;
                Value[] valueArray3 = (Value[])value.value;
                if (valueArray.length != valueArray3.length) {
                    return false;
                }
                for (int i = 0; i < valueArray.length; ++i) {
                    Value value4 = valueArray[i];
                    Value value5 = valueArray3[i];
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) continue;
                    return false;
                }
                return true;
            }
            if (value.value instanceof Value[][] || value.value instanceof Value[]) {
                return false;
            }
            return this.value != null ? this.value.equals(value.value) : value.value == null;
        }
        return false;
    }

    public int hashCode() {
        if (this.hc == -1) {
            this.hc = 17;
            if (this.value instanceof Value[][]) {
                Value[][] valueArray = (Value[][])this.value;
                for (int i = 0; i < valueArray.length; ++i) {
                    for (int j = 0; j < valueArray[i].length; ++j) {
                        Value value = valueArray[i][j];
                        this.hc = 37 * this.hc + (value != null && value.value != null ? value.value.hashCode() : 0);
                    }
                }
            } else if (this.value instanceof Value[]) {
                Value[] valueArray = (Value[])this.value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] == null || valueArray[i].value == null) continue;
                    Value value = valueArray[i];
                    this.hc = 37 * this.hc + (value != null && value.value != null ? value.value.hashCode() : 0);
                }
            } else {
                this.hc = 37 * this.hc + (this.value != null ? this.value.hashCode() : 0);
            }
        }
        return this.hc;
    }

    public void writeBinary(DataOutputStream dataOutputStream, StringStore stringStore) throws IOException {
        dataOutputStream.writeBoolean(this.lookup);
        dataOutputStream.writeBoolean(this.converter != null);
        if (this.converter != null) {
            this.converter.writeBinary(dataOutputStream, stringStore);
        }
        if (this.value instanceof Value) {
            dataOutputStream.writeByte(1);
            ((Value)this.value).writeBinary(dataOutputStream, stringStore);
        } else if (this.value instanceof Value[]) {
            dataOutputStream.writeByte(2);
            Value[] valueArray = (Value[])this.value;
            dataOutputStream.writeInt(valueArray.length);
            for (int i = 0; i < valueArray.length; ++i) {
                if (valueArray[i] != null) {
                    dataOutputStream.writeByte(1);
                    valueArray[i].writeBinary(dataOutputStream, stringStore);
                    continue;
                }
                dataOutputStream.writeByte(0);
            }
        } else if (this.value instanceof Value[][]) {
            dataOutputStream.writeByte(3);
            Value[][] valueArray = (Value[][])this.value;
            dataOutputStream.writeInt(valueArray.length);
            for (int i = 0; i < valueArray.length; ++i) {
                Value[] valueArray2 = valueArray[i];
                dataOutputStream.writeInt(valueArray2.length);
                for (int j = 0; j < valueArray2.length; ++j) {
                    if (valueArray2[j] != null) {
                        dataOutputStream.writeByte(1);
                        valueArray2[j].writeBinary(dataOutputStream, stringStore);
                        continue;
                    }
                    dataOutputStream.writeByte(0);
                }
            }
        } else if (this.value instanceof Color) {
            Color color = (Color)this.value;
            dataOutputStream.writeByte(5);
            dataOutputStream.writeLong(Double.doubleToLongBits(color.getRed()));
            dataOutputStream.writeLong(Double.doubleToLongBits(color.getGreen()));
            dataOutputStream.writeLong(Double.doubleToLongBits(color.getBlue()));
            dataOutputStream.writeLong(Double.doubleToLongBits(color.getOpacity()));
        } else if (this.value instanceof Enum) {
            Enum enum_ = (Enum)this.value;
            int n = stringStore.addString(enum_.name());
            int n2 = stringStore.addString(enum_.getClass().getName());
            dataOutputStream.writeByte(6);
            dataOutputStream.writeShort(n);
            dataOutputStream.writeShort(n2);
        } else if (this.value instanceof Boolean) {
            Boolean bl = (Boolean)this.value;
            dataOutputStream.writeByte(7);
            dataOutputStream.writeBoolean(bl);
        } else if (this.value instanceof Size) {
            Size size = (Size)this.value;
            dataOutputStream.writeByte(9);
            double d = size.getValue();
            long l = Double.doubleToLongBits(d);
            dataOutputStream.writeLong(l);
            int n = stringStore.addString(size.getUnits().name());
            dataOutputStream.writeShort(n);
        } else if (this.value instanceof String) {
            dataOutputStream.writeByte(4);
            int n = stringStore.addString((String)this.value);
            dataOutputStream.writeShort(n);
        } else if (this.value instanceof URL) {
            dataOutputStream.writeByte(8);
            int n = stringStore.addString(((URL)this.value).toString());
            dataOutputStream.writeShort(n);
        } else if (this.value == null) {
            dataOutputStream.writeByte(0);
        } else {
            throw new InternalError("cannot writeBinary " + this);
        }
    }

    public static Value readBinary(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        boolean bl = dataInputStream.readBoolean();
        boolean bl2 = dataInputStream.readBoolean();
        StyleConverter styleConverter = bl2 ? StyleConverter.readBinary(dataInputStream, stringArray) : null;
        byte by = dataInputStream.readByte();
        if (by == 1) {
            Value value = Value.readBinary(dataInputStream, stringArray);
            return new Value(value, styleConverter, bl);
        }
        if (by == 2) {
            int n = dataInputStream.readInt();
            Value[] valueArray = new Value[n];
            for (int i = 0; i < n; ++i) {
                byte by2 = dataInputStream.readByte();
                valueArray[i] = by2 == 1 ? Value.readBinary(dataInputStream, stringArray) : null;
            }
            return new Value(valueArray, styleConverter, bl);
        }
        if (by == 3) {
            int n = dataInputStream.readInt();
            Value[][] valueArray = new Value[n][0];
            for (int i = 0; i < n; ++i) {
                int n2 = dataInputStream.readInt();
                valueArray[i] = new Value[n2];
                for (int j = 0; j < n2; ++j) {
                    byte by3 = dataInputStream.readByte();
                    valueArray[i][j] = by3 == 1 ? Value.readBinary(dataInputStream, stringArray) : null;
                }
            }
            return new Value(valueArray, styleConverter, bl);
        }
        if (by == 5) {
            double d = Double.longBitsToDouble(dataInputStream.readLong());
            double d2 = Double.longBitsToDouble(dataInputStream.readLong());
            double d3 = Double.longBitsToDouble(dataInputStream.readLong());
            double d4 = Double.longBitsToDouble(dataInputStream.readLong());
            return new Value(Color.color(d, d2, d3, d4), styleConverter, bl);
        }
        if (by == 6) {
            short s = dataInputStream.readShort();
            short s2 = dataInputStream.readShort();
            String string = stringArray[s];
            String string2 = stringArray[s2];
            Value value = null;
            try {
                Class<?> clazz = Class.forName(string2);
                value = new Value(Enum.valueOf(clazz, string), styleConverter, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(classNotFoundException.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(illegalArgumentException.toString());
            }
            catch (NullPointerException nullPointerException) {
                System.err.println(nullPointerException.toString());
            }
            return value;
        }
        if (by == 7) {
            Boolean bl3 = dataInputStream.readBoolean();
            return new Value(bl3, styleConverter, bl);
        }
        if (by == 9) {
            double d = Double.longBitsToDouble(dataInputStream.readLong());
            SizeUnits sizeUnits = SizeUnits.PX;
            String string = stringArray[dataInputStream.readShort()];
            try {
                sizeUnits = Enum.valueOf(SizeUnits.class, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(illegalArgumentException.toString());
            }
            catch (NullPointerException nullPointerException) {
                System.err.println(nullPointerException.toString());
            }
            return new Value(new Size(d, sizeUnits), styleConverter, bl);
        }
        if (by == 4) {
            String string = stringArray[dataInputStream.readShort()];
            return new Value(string, styleConverter, bl);
        }
        if (by == 8) {
            String string = stringArray[dataInputStream.readShort()];
            try {
                URL uRL = new URL(string);
                return new Value(uRL, styleConverter, bl);
            }
            catch (MalformedURLException malformedURLException) {
                throw new InternalError("Excpeption in Value.readBinary: " + malformedURLException);
            }
        }
        if (by == 0) {
            return new Value(null, styleConverter, bl);
        }
        throw new InternalError("unknown type: " + by);
    }
}

