/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.Rule;
import com.sun.javafx.css.StringStore;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public final class Stylesheet {
    private final URL url;
    private Source source = Source.AUTHOR;
    private final List<Rule> rules;

    public URL getUrl() {
        return this.url;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        if (this.source != source) {
            this.source = source;
            for (Rule rule : this.rules) {
                rule.source = source;
            }
        }
    }

    public Stylesheet() {
        this.url = null;
        this.rules = new ArrayList<Rule>();
    }

    public Stylesheet(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("URL argument to Stylesheet constructor may not be null");
        }
        this.url = uRL;
        this.rules = new ArrayList<Rule>();
    }

    public void addRule(Rule rule) {
        rule.stylesheet = this;
        rule.source = this.source;
        this.rules.add(rule);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Stylesheet) {
            Stylesheet stylesheet = (Stylesheet)object;
            return this.url == null ? stylesheet.url == null : this.url.equals(stylesheet.url);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/* ");
        if (this.url != null) {
            stringBuilder.append(this.url);
        }
        if (this.rules.isEmpty()) {
            stringBuilder.append(" */");
        } else {
            stringBuilder.append(" */\n");
            for (int i = 0; i < this.rules.size(); ++i) {
                stringBuilder.append(this.rules.get(i));
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void writeBinary(DataOutputStream dataOutputStream, StringStore stringStore) throws IOException {
        int n = stringStore.addString(this.source.name());
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(this.rules.size());
        for (Rule rule : this.rules) {
            rule.writeBinary(dataOutputStream, stringStore);
        }
    }

    private void readBinary(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        short s = dataInputStream.readShort();
        this.setSource(Source.valueOf(stringArray[s]));
        int n = dataInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            this.addRule(Rule.readBinary(dataInputStream, stringArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stylesheet loadBinary(URL uRL) {
        if (uRL == null) {
            return null;
        }
        Stylesheet stylesheet = null;
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            inputStream = uRL.openStream();
            bufferedInputStream = new BufferedInputStream(inputStream, 40960);
            filterInputStream = new DataInputStream(bufferedInputStream);
            short s = ((DataInputStream)filterInputStream).readShort();
            if (s != 2) {
                throw new IOException(uRL.toString() + " wrong file version. got " + s + " expected 2");
            }
            String[] stringArray = StringStore.readBinary((DataInputStream)filterInputStream);
            stylesheet = new Stylesheet(uRL);
            stylesheet.readBinary((DataInputStream)filterInputStream, stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            iOException.printStackTrace(System.err);
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                } else if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                } else if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return stylesheet;
    }

    public static enum Source {
        USER_AGENT,
        USER,
        AUTHOR,
        INLINE;

    }
}

