/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.Logging;
import com.sun.javafx.css.CSSEvent;
import com.sun.javafx.css.CSSListener;
import com.sun.javafx.css.CompoundSelector;
import com.sun.javafx.css.Declaration;
import com.sun.javafx.css.Match;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.SimpleSelector;
import com.sun.javafx.css.Style;
import com.sun.javafx.css.StyleHelper;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.parser.CSSParser;
import com.sun.javafx.logging.PlatformLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.PopupWindow;
import javafx.stage.Window;

public class StyleManager {
    private Stylesheet defaultUserAgentStylesheet;
    private ObservableList<Stylesheet> userAgentStylesheets = FXCollections.observableArrayList();
    private ObservableList<Stylesheet> authorStylesheets = FXCollections.observableArrayList();
    private Map<String, Integer> stylesheetMap = new HashMap<String, Integer>(){

        @Override
        public void clear() {
            super.clear();
            StyleManager.this.authorStylesheets.clear();
            StyleManager.this.userAgentStylesheets.clear();
        }
    };
    private Map<WeakReference<Scene>, StylesheetContainer> containerMap;
    private StylesheetContainer defaultContainer;
    private final Map<String, Long> pseudoclassMasks = new HashMap<String, Long>();
    static int hits = 0;
    static int misses = 0;
    static int puts = 0;
    static int tries = 0;
    private List<CSSListener> listeners;

    public static StyleManager getInstance() {
        return Holder.INSTANCE;
    }

    private static PlatformLogger logger() {
        return Holder.LOGGER;
    }

    private void addUserAgentStylesheet(String string, Stylesheet stylesheet) {
        if (stylesheet != null) {
            stylesheet.setSource(Stylesheet.Source.USER_AGENT);
        }
        int n = this.userAgentStylesheets.size();
        this.userAgentStylesheets.add(stylesheet);
        this.stylesheetMap.put(string, n);
    }

    private Stylesheet getUserAgentStylesheet(String string) {
        Integer n = this.stylesheetMap.get(string);
        int n2 = n != null ? n : -1;
        int n3 = this.userAgentStylesheets.size();
        if (-1 < n2 && n2 < n3) {
            return (Stylesheet)this.userAgentStylesheets.get(n2);
        }
        return null;
    }

    private void addAuthorStylesheet(String string, Stylesheet stylesheet) {
        if (stylesheet != null) {
            stylesheet.setSource(Stylesheet.Source.AUTHOR);
            int n = this.authorStylesheets.size();
            this.authorStylesheets.add(stylesheet);
            this.stylesheetMap.put(string, n);
        } else {
            this.stylesheetMap.put(string, -1);
        }
    }

    private Stylesheet getAuthorStylesheet(String string) {
        Integer n = this.stylesheetMap.get(string);
        int n2 = n != null ? n : -1;
        int n3 = this.authorStylesheets.size();
        if (-1 < n2 && n2 < n3) {
            return (Stylesheet)this.authorStylesheets.get(n2);
        }
        return null;
    }

    private void expunge(Map<WeakReference<Scene>, StylesheetContainer> map) {
        ArrayList<WeakReference<Scene>> arrayList = null;
        for (WeakReference<Scene> weakReference : map.keySet()) {
            if (weakReference.get() != null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<WeakReference<Scene>>();
            }
            arrayList.add(weakReference);
        }
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; 0 <= i; --i) {
                WeakReference<Scene> weakReference;
                weakReference = map.remove(arrayList.remove(i));
                ((StylesheetContainer)((Object)weakReference)).destroy();
            }
        }
    }

    private void put(Map<WeakReference<Scene>, StylesheetContainer> map, Scene scene, StylesheetContainer stylesheetContainer) {
        this.expunge(map);
        map.put(new WeakReference<Scene>(scene), stylesheetContainer);
    }

    private StylesheetContainer get(Map<WeakReference<Scene>, StylesheetContainer> map, Scene scene) {
        this.expunge(map);
        for (Map.Entry<WeakReference<Scene>, StylesheetContainer> entry : map.entrySet()) {
            if (!scene.equals(entry.getKey().get())) continue;
            return entry.getValue();
        }
        return null;
    }

    private StylesheetContainer remove(Map<WeakReference<Scene>, StylesheetContainer> map, Scene scene) {
        this.expunge(map);
        WeakReference<Scene> weakReference = null;
        for (WeakReference<Scene> weakReference2 : map.keySet()) {
            if (!scene.equals(weakReference2.get())) continue;
            weakReference = weakReference2;
            break;
        }
        Object object = null;
        if (weakReference != null) {
            object = map.remove(weakReference);
            weakReference.clear();
        }
        return object;
    }

    private StyleManager() {
    }

    private static URL getURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return classLoader.getResource(string);
            }
            return null;
        }
    }

    private Stylesheet loadStylesheet(final String string) {
        block8: {
            Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    String string2 = System.getProperty("binary.css");
                    return !string.endsWith(".bss") && string2 != null ? Boolean.valueOf(string2) : false;
                }
            });
            try {
                String string2 = bl != false ? ".css" : ".bss";
                String string3 = string.endsWith(".css") || string.endsWith(".bss") ? string.substring(0, string.length() - 4) : string;
                URL uRL = StyleManager.getURL(string3 + string2);
                if (uRL == null && (bl = Boolean.valueOf(bl == false)).booleanValue()) {
                    uRL = StyleManager.getURL(string3 + ".css");
                }
                Stylesheet stylesheet = null;
                if (uRL != null && !bl.booleanValue() && (stylesheet = Stylesheet.loadBinary(uRL)) == null && (bl = Boolean.valueOf(bl == false)).booleanValue()) {
                    uRL = StyleManager.getURL(string3 + ".css");
                }
                if (uRL != null && bl.booleanValue()) {
                    stylesheet = CSSParser.getInstance().parse(uRL);
                }
                if (stylesheet == null && StyleManager.logger().isLoggable(900)) {
                    StyleManager.logger().warning(String.format("Resource \"%s\" not found.", uRL));
                }
                return stylesheet;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (StyleManager.logger().isLoggable(800)) {
                    StyleManager.logger().info("Could not find stylesheet: " + string);
                }
            }
            catch (IOException iOException) {
                if (!StyleManager.logger().isLoggable(800)) break block8;
                StyleManager.logger().info("Could not load stylesheet: " + string);
            }
        }
        return null;
    }

    public void addUserAgentStylesheet(String string) {
        if (string == null || string.trim().isEmpty()) {
            return;
        }
        if (this.stylesheetMap.containsKey(string)) {
            return;
        }
        Stylesheet stylesheet = this.loadStylesheet(string);
        this.addUserAgentStylesheet(string, stylesheet);
    }

    public void setDefaultUserAgentStylesheet(String string) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("null arg fname");
        }
        Stylesheet stylesheet = this.loadStylesheet(string);
        if (stylesheet != null) {
            stylesheet.setSource(Stylesheet.Source.USER_AGENT);
            this.setDefaultUserAgentStylesheet(stylesheet);
        }
    }

    public void setDefaultUserAgentStylesheet(Stylesheet stylesheet) {
        this.defaultUserAgentStylesheet = stylesheet;
        if (this.defaultUserAgentStylesheet != null) {
            this.defaultUserAgentStylesheet.setSource(Stylesheet.Source.USER_AGENT);
        }
        if (this.defaultContainer != null) {
            this.defaultContainer.destroy();
        }
        this.defaultContainer = null;
        if (this.containerMap != null) {
            for (StylesheetContainer object : this.containerMap.values()) {
                object.destroy();
            }
            this.containerMap.clear();
        }
        Iterator<Object> iterator = Window.impl_getWindows();
        while (iterator.hasNext()) {
            Scene scene = ((Window)iterator.next()).getScene();
            if (scene == null) continue;
            this.updateStylesheets(scene);
            scene.getRoot().impl_processCSS(true);
        }
    }

    public void clearCachedValues(Scene scene) {
        StyleHelper.pseudoclassMasksByNode.clear();
    }

    public void reloadStylesheets(Scene scene) {
        this.authorStylesheets.clear();
        this.updateStylesheets(scene);
        scene.getRoot().impl_reapplyCSS();
    }

    public void replaceStylesheet(Scene scene, Stylesheet stylesheet) {
        StylesheetContainer stylesheetContainer;
        StylesheetContainer stylesheetContainer2 = stylesheetContainer = this.containerMap != null ? this.get(this.containerMap, scene) : null;
        if (stylesheetContainer != null) {
            int n = stylesheetContainer.stylesheets.indexOf(stylesheet);
            if (n > -1) {
                stylesheetContainer.stylesheets.set(n, stylesheet);
            } else {
                stylesheetContainer.stylesheets.add(stylesheet);
            }
            stylesheetContainer.clearCaches();
        } else {
            if (this.containerMap == null) {
                this.containerMap = new HashMap<WeakReference<Scene>, StylesheetContainer>();
            }
            stylesheetContainer = new StylesheetContainer(null);
            stylesheetContainer.stylesheets.add(stylesheet);
            this.put(this.containerMap, scene, stylesheetContainer);
        }
        scene.getRoot().impl_reapplyCSS();
    }

    public void updateStylesheets(Scene scene) {
        Object object;
        if (scene.getWindow() == null) {
            return;
        }
        if (this.containerMap != null && (object = this.remove(this.containerMap, scene)) != null) {
            ((StylesheetContainer)object).destroy();
        }
        if (scene.getStylesheets().size() == 0) {
            return;
        }
        object = new ArrayList();
        for (int i = 0; i < scene.getStylesheets().size(); ++i) {
            String string = (String)scene.getStylesheets().get(i);
            string = string.trim();
            try {
                Stylesheet stylesheet = this.getAuthorStylesheet(string);
                if (stylesheet != null) {
                    object.add(stylesheet);
                    continue;
                }
                stylesheet = this.loadStylesheet(string);
                this.addAuthorStylesheet(string, stylesheet);
                if (stylesheet == null) continue;
                object.add(stylesheet);
                continue;
            }
            catch (Exception exception) {
                System.err.printf("Cannot add stylesheet. %s\n", exception.getLocalizedMessage());
            }
        }
        if (this.containerMap == null) {
            this.containerMap = new HashMap<WeakReference<Scene>, StylesheetContainer>();
        }
        StylesheetContainer stylesheetContainer = new StylesheetContainer((Collection)object);
        this.put(this.containerMap, scene, stylesheetContainer);
    }

    public long getPseudoclassMask(String string) {
        Long l = this.pseudoclassMasks.get(string);
        if (l == null) {
            int n = this.pseudoclassMasks.size();
            l = 1L << n;
            this.pseudoclassMasks.put(string, l);
        }
        return l;
    }

    long getPseudoclassMask(List<String> list) {
        long l = 0L;
        int n = list != null ? list.size() : -1;
        for (int i = 0; i < n; ++i) {
            long l2 = this.getPseudoclassMask(list.get(i));
            l |= l2;
        }
        return l;
    }

    List<String> getPseudoclassStrings(long l) {
        if (l == 0L) {
            return Collections.EMPTY_LIST;
        }
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        for (Map.Entry<String, Long> entry : this.pseudoclassMasks.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        ArrayList arrayList = new ArrayList();
        for (long i = 0L; i < 64L; ++i) {
            String string;
            long l2 = 1L << (int)i & l;
            if (l2 == 0L || (string = (String)hashMap.get(l2)) == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Reference<StyleHelper> getStyleHelper(Node node) {
        assert (node != null && node.getScene() != null);
        boolean bl = this.containerMap == null;
        StylesheetContainer stylesheetContainer = null;
        if (!bl) {
            EventTarget eventTarget;
            Window window = null;
            if (node != null && node.getScene() != null) {
                window = node.getScene().getWindow();
                while (window instanceof PopupWindow) {
                    eventTarget = (PopupWindow)window;
                    window = ((PopupWindow)eventTarget).getOwnerWindow();
                }
            }
            if ((eventTarget = window == null ? node.getScene() : window.getScene()) != null) {
                stylesheetContainer = this.get(this.containerMap, (Scene)eventTarget);
            }
            boolean bl2 = bl = stylesheetContainer == null;
        }
        if (bl) {
            if (this.defaultContainer == null) {
                this.defaultContainer = new StylesheetContainer(null);
            }
            return this.defaultContainer.getStyleHelper(node);
        }
        return stylesheetContainer.getStyleHelper(node);
    }

    public List<Style> getStyles(Scene scene) {
        StylesheetContainer stylesheetContainer = this.get(this.containerMap, scene);
        if (stylesheetContainer == null) {
            if (this.defaultContainer == null) {
                this.defaultContainer = new StylesheetContainer(null);
            }
            return this.defaultContainer.getStyles(scene);
        }
        return stylesheetContainer.getStyles(scene);
    }

    public void addCSSListener(CSSListener cSSListener) {
        if (this.listeners != null) {
            if (!this.listeners.contains(cSSListener)) {
                this.listeners.add(cSSListener);
            }
        } else {
            this.listeners = new ArrayList<CSSListener>();
            this.listeners.add(cSSListener);
        }
    }

    public void removeCSSListener(CSSListener cSSListener) {
        if (this.listeners != null) {
            this.listeners.remove(cSSListener);
        }
    }

    void notifyCSSListeners(CSSEvent cSSEvent) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                this.listeners.get(i).notify(cSSEvent);
            }
        }
    }

    private static class Key {
        String className;
        String id;
        List<String> styleClass;

        private Key() {
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.className.equals(key.className) && (this.id == null && key.id == null || this.id != null && this.id.equals(key.id)) && (this.styleClass == null && key.styleClass == null || this.styleClass != null && this.styleClass.containsAll(key.styleClass));
            }
            return false;
        }

        public int hashCode() {
            int n = this.className.hashCode();
            n = 31 * (n + (this.id == null || this.id.isEmpty() ? 1231 : this.id.hashCode()));
            n = 31 * (n + (this.styleClass == null || this.styleClass.isEmpty() ? 1237 : ((Object)this.styleClass).hashCode()));
            return n;
        }

        public String toString() {
            return "Key [" + this.className + ", " + String.valueOf(this.id) + ", " + String.valueOf(this.styleClass) + "]";
        }
    }

    private static class Cache {
        private final List<Rule> rules;
        private final long pseudoclassStateMask;
        private final boolean impactsChildren;
        private final Map<Long, Reference<StyleHelper>> cache;

        Cache(List<Rule> list, long l, boolean bl) {
            this.rules = list;
            this.pseudoclassStateMask = l;
            this.impactsChildren = bl;
            this.cache = new HashMap<Long, Reference<StyleHelper>>();
        }

        private void clear() {
            for (Reference<StyleHelper> reference : this.cache.values()) {
                StyleHelper styleHelper = reference.get();
                if (styleHelper == null) continue;
                styleHelper.valueCache = null;
                styleHelper.clearStyleMap();
                reference.clear();
            }
            this.cache.clear();
            this.rules.clear();
        }

        private Reference<StyleHelper> lookup(Node node, StylesheetContainer stylesheetContainer) {
            Object object;
            if (!this.impactsChildren) {
                boolean bl;
                boolean bl2;
                String string = node.getStyle();
                boolean bl3 = bl2 = string != null && !string.isEmpty();
                if (this.rules.isEmpty() && this.pseudoclassStateMask == 0L && !bl2 && !(bl = false)) {
                    return null;
                }
            }
            long l = 0L;
            long l2 = 1L;
            int n = this.rules.size();
            for (int i = 0; i < n; ++i) {
                object = this.rules.get(i);
                if (((Rule)object).applies(node)) {
                    l |= l2;
                }
                l2 <<= 1;
            }
            if (this.cache.containsKey(l)) {
                Reference<StyleHelper> reference = this.cache.get(l);
                if (reference.get() != null) {
                    return reference;
                }
                this.cache.remove(l);
            }
            List<Style> list = this.getStyles(node);
            StyleHelper styleHelper = StyleHelper.create(list, this.pseudoclassStateMask, ++stylesheetContainer.helperCount);
            styleHelper.valueCache = stylesheetContainer.valueCache;
            object = new WeakReference<StyleHelper>(styleHelper);
            this.cache.put(l, (Reference<StyleHelper>)object);
            return object;
        }

        private List<Style> getStyles(Node node) {
            if (this.rules == null || this.rules.isEmpty()) {
                return null;
            }
            ArrayList<Style> arrayList = new ArrayList<Style>(this.rules.size());
            int n = 0;
            int n2 = this.rules.size();
            for (int i = 0; i < n2; ++i) {
                Rule rule = this.rules.get(i);
                List<Match> list = rule.matches(node);
                int n3 = list.size();
                for (int j = 0; j < n3; ++j) {
                    Match match = list.get(j);
                    if (match == null) continue;
                    int n4 = rule.declarations.size();
                    for (int k = 0; k < n4; ++k) {
                        Declaration declaration = rule.declarations.get(k);
                        Style style = new Style(rule, match.selector, match.pseudoclasses, declaration.propertyName, declaration.cssValue, declaration.important, match.specificity, n++);
                        arrayList.add(style);
                    }
                }
            }
            Collections.sort(arrayList);
            return arrayList;
        }
    }

    private static class StylesheetContainer {
        private final List<Stylesheet> stylesheets;
        private final Map<Key, Cache> cacheMap = new HashMap<Key, Cache>();
        private final Key key = new Key();
        private final ListChangeListener<Stylesheet> listChangeListener;
        private final Map<Reference<StyleHelper.StyleCacheKey>, List<StyleHelper.CacheEntry>> valueCache;
        private int helperCount;

        private StylesheetContainer(Collection<Stylesheet> collection) {
            this.stylesheets = new ArrayList<Stylesheet>();
            if (StyleManager.getInstance().defaultUserAgentStylesheet != null) {
                this.stylesheets.add(StyleManager.getInstance().defaultUserAgentStylesheet);
            }
            this.stylesheets.addAll(StyleManager.getInstance().userAgentStylesheets);
            if (collection != null) {
                this.stylesheets.addAll(collection);
            }
            this.listChangeListener = new ListChangeListener<Stylesheet>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends Stylesheet> change) {
                    while (change.next()) {
                        List<? extends Stylesheet> list = change.getRemoved();
                        StylesheetContainer.this.stylesheets.removeAll(list);
                        list = change.getAddedSubList();
                        StylesheetContainer.this.stylesheets.addAll(list);
                        StylesheetContainer.this.clearCaches();
                    }
                }
            };
            StyleManager.getInstance().userAgentStylesheets.addListener(this.listChangeListener);
            this.valueCache = new HashMap<Reference<StyleHelper.StyleCacheKey>, List<StyleHelper.CacheEntry>>();
            this.helperCount = 0;
        }

        private void destroy() {
            StyleManager.getInstance().userAgentStylesheets.removeListener(this.listChangeListener);
            this.stylesheets.clear();
            this.clearCaches();
        }

        private void clearCaches() {
            for (Map.Entry<Reference<StyleHelper.StyleCacheKey>, List<StyleHelper.CacheEntry>> object : this.valueCache.entrySet()) {
                for (StyleHelper.CacheEntry cacheEntry : object.getValue()) {
                    cacheEntry.values.clear();
                }
                object.getKey().clear();
                object.getValue().clear();
            }
            this.valueCache.clear();
            for (Cache cache : this.cacheMap.values()) {
                cache.clear();
            }
            this.cacheMap.clear();
            this.helperCount = 0;
        }

        private Reference<StyleHelper> getStyleHelper(Node node) {
            String string = node.getClass().getName();
            String string2 = node.getId();
            ObservableList<String> observableList = node.getStyleClass();
            this.key.className = string;
            this.key.id = string2;
            this.key.styleClass = observableList;
            Cache cache = this.cacheMap.get(this.key);
            this.key.styleClass = null;
            if (cache == null) {
                ArrayList<Rule> arrayList = new ArrayList<Rule>();
                long l = 0L;
                boolean bl = node instanceof Parent;
                boolean bl2 = false;
                int n = this.stylesheets.size();
                for (int i = 0; i < n; ++i) {
                    Stylesheet stylesheet = this.stylesheets.get(i);
                    List<Rule> list = stylesheet.getRules();
                    int n2 = list.size();
                    for (int j = 0; j < n2; ++j) {
                        Rule rule = list.get(j);
                        boolean bl3 = rule.mightApply(string, string2, observableList);
                        if (bl3) {
                            arrayList.add(rule);
                        }
                        if (!bl3 && !bl) continue;
                        int n3 = rule.selectors.size();
                        for (int k = 0; k < n3; ++k) {
                            Selector selector;
                            Selector selector2 = rule.selectors.get(k);
                            if (selector2 instanceof CompoundSelector) {
                                selector = (CompoundSelector)selector2;
                                if (bl3) {
                                    SimpleSelector simpleSelector = selector.selectors.get(selector.selectors.size() - 1);
                                    l |= StyleManager.getInstance().getPseudoclassMask(simpleSelector.pseudoclasses);
                                    continue;
                                }
                                if (!bl) continue;
                                int n4 = selector.selectors.size() - 1;
                                for (int i2 = 0; i2 < n4; ++i2) {
                                    SimpleSelector simpleSelector = selector.selectors.get(i2);
                                    if (!simpleSelector.mightApply(string, string2, observableList)) continue;
                                    l |= StyleManager.getInstance().getPseudoclassMask(simpleSelector.pseudoclasses);
                                    bl2 = true;
                                }
                                continue;
                            }
                            if (!bl3) continue;
                            selector = (SimpleSelector)selector2;
                            l |= StyleManager.getInstance().getPseudoclassMask(((SimpleSelector)selector).pseudoclasses);
                        }
                    }
                }
                cache = new Cache(arrayList, l, bl2);
                Key key = new Key();
                key.className = string;
                key.id = string2;
                n = observableList.size();
                key.styleClass = new ArrayList<String>(n);
                for (int i = 0; i < n; ++i) {
                    key.styleClass.add((String)observableList.get(i));
                }
                this.cacheMap.put(key, cache);
            }
            return cache.lookup(node, this);
        }

        StyleHelper getStyleHelper(Scene scene) {
            StyleHelper styleHelper = StyleHelper.create(this.getStyles(scene), 0L, ++this.helperCount);
            styleHelper.valueCache = this.valueCache;
            return styleHelper;
        }

        List<Style> getStyles(Scene scene) {
            if (this.stylesheets.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            int n = 0;
            ArrayList<Style> arrayList = new ArrayList<Style>();
            for (int i = 0; i < this.stylesheets.size(); ++i) {
                Stylesheet stylesheet = this.stylesheets.get(i);
                for (int j = 0; j < stylesheet.getRules().size(); ++j) {
                    Rule rule = stylesheet.getRules().get(j);
                    List<Match> list = rule.matches(scene);
                    for (int k = 0; k < list.size(); ++k) {
                        Match match = list.get(k);
                        for (int i2 = 0; i2 < rule.declarations.size(); ++i2) {
                            Declaration declaration = rule.declarations.get(i2);
                            Style style = new Style(rule, match.selector, match.pseudoclasses, declaration.propertyName, declaration.cssValue, declaration.important, match.specificity, n++);
                            arrayList.add(style);
                        }
                    }
                }
            }
            Collections.sort(arrayList);
            return arrayList;
        }
    }

    private static class Holder {
        private static StyleManager INSTANCE = new StyleManager();
        private static PlatformLogger LOGGER = Logging.getCSSLogger();

        private Holder() {
        }
    }
}

