/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.Logging;
import com.sun.javafx.css.CSSEvent;
import com.sun.javafx.css.Declaration;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.Style;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.Value;
import com.sun.javafx.css.converters.FontConverter;
import com.sun.javafx.css.parser.CSSParser;
import com.sun.javafx.logging.PlatformLogger;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.text.Font;

public class StyleHelper {
    private static final PlatformLogger LOGGER = Logging.getCSSLogger();
    private static final Object SKIP = new int[0];
    private final int helperIndex;
    Map<Reference<StyleCacheKey>, List<CacheEntry>> valueCache;
    private final Map<String, List<Style>> smap;
    private final long pseudoclassStateMask;
    private static final Map<String, Map<String, Style>> authorStylesCache = new HashMap<String, Map<String, Style>>();
    static final Map<Node, Long> pseudoclassMasksByNode = new HashMap<Node, Long>();

    public static StyleHelper create(List<Style> list, long l, int n) {
        StyleHelper styleHelper = new StyleHelper(list, l, n);
        return styleHelper;
    }

    public int getHelperIndex() {
        return this.helperIndex;
    }

    public void clearCachedValues(Reference<StyleCacheKey> reference) {
        if (reference != null && this.valueCache != null) {
            List<CacheEntry> list = this.valueCache.remove(reference);
            if (list == null || list.isEmpty()) {
                return;
            }
            for (CacheEntry cacheEntry : list) {
                if (cacheEntry.values == null) continue;
                cacheEntry.values.clear();
            }
            reference.clear();
            list.clear();
        }
    }

    public Reference<StyleCacheKey> createStyleCacheKey(Node node) {
        WeakReference<StyleCacheKey> weakReference;
        Object object;
        int[] nArray = StyleCacheKey.getIndices(node, 0);
        assert (this.valueCache != null);
        ArrayList<Reference<StyleCacheKey>> arrayList = null;
        Reference<StyleCacheKey> reference = null;
        for (Reference<StyleCacheKey> reference2 : this.valueCache.keySet()) {
            object = reference2.get();
            if (object == null) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Reference<StyleCacheKey>>();
                }
                arrayList.add(reference2);
                continue;
            }
            if (!Arrays.equals(((StyleCacheKey)object).indices, nArray)) continue;
            reference = reference2;
            break;
        }
        if (arrayList != null) {
            for (Reference reference2 : arrayList) {
                object = this.valueCache.remove(reference2).iterator();
                while (object.hasNext()) {
                    weakReference = object.next();
                    ((CacheEntry)((Object)weakReference)).values.clear();
                }
            }
        }
        if (reference != null) {
            return reference;
        }
        Object object2 = new long[nArray.length];
        object2[0] = this.pseudoclassStateMask;
        boolean bl = true;
        for (object = node.getParent(); object != null; object = ((Node)object).getParent()) {
            weakReference = ((Node)object).impl_getStyleHelper();
            object2[++var6_10] = weakReference != null ? ((StyleHelper)((Object)weakReference)).pseudoclassStateMask : 0L;
        }
        weakReference = new WeakReference<StyleCacheKey>(new StyleCacheKey(nArray, (long[])object2));
        this.valueCache.put(weakReference, new ArrayList());
        return weakReference;
    }

    private CacheEntry getCacheEntry(Node node) {
        return this.getCacheEntry(node, StyleHelper.getAllPseudoClassStates(node, 0));
    }

    private CacheEntry getCacheEntry(Node node, long[] lArray) {
        Reference<StyleCacheKey> reference = node.impl_getStyleCacheKey();
        List<CacheEntry> list = this.valueCache.get(reference);
        if (list == null) {
            return null;
        }
        StyleCacheKey styleCacheKey = reference.get();
        if (styleCacheKey == null) {
            for (CacheEntry cacheEntry : list) {
                cacheEntry.values.clear();
            }
            this.valueCache.remove(reference);
            return null;
        }
        long[] lArray2 = new long[styleCacheKey.pclassMask.length];
        assert (lArray2.length == lArray.length);
        for (int i = 0; i < lArray2.length; ++i) {
            lArray2[i] = styleCacheKey.pclassMask[i] & lArray[i];
        }
        CacheEntry cacheEntry = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CacheEntry cacheEntry2 = list.get(i);
            long[] lArray3 = cacheEntry2.states;
            if (!Arrays.equals(lArray2, lArray3)) continue;
            cacheEntry = cacheEntry2;
            break;
        }
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(lArray2);
            list.add(cacheEntry);
        }
        return cacheEntry;
    }

    void clearStyleMap() {
        for (List<Style> list : this.smap.values()) {
            list.clear();
        }
        this.smap.clear();
    }

    private StyleHelper(List<Style> list, long l, int n) {
        this.pseudoclassStateMask = l;
        this.smap = new HashMap<String, List<Style>>();
        this.helperIndex = n;
        int n2 = list != null ? list.size() : 0;
        for (int i = 0; i < n2; ++i) {
            Style style = list.get(i);
            String string = style.property;
            List<Style> list2 = this.smap.get(string);
            if (list2 == null) {
                list2 = new ArrayList<Style>(5);
                this.smap.put(string, list2);
            }
            list2.add(style);
        }
    }

    public boolean isPseudoclassUsed(String string) {
        long l = StyleManager.getInstance().getPseudoclassMask(string);
        return (this.pseudoclassStateMask & l) == l;
    }

    private Map<String, Style> getStyles(Stylesheet stylesheet) {
        HashMap<String, Style> hashMap = new HashMap<String, Style>();
        if (stylesheet != null) {
            int n = 0;
            List<Rule> list = stylesheet.getRules();
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                Rule rule = list.get(i);
                List<Declaration> list2 = rule.getDeclarations();
                int n3 = list2.size();
                for (int j = 0; j < n3; ++j) {
                    Declaration declaration = list2.get(j);
                    Style style = new Style(rule, Selector.getUniversalSelector(), null, declaration.propertyName, declaration.cssValue, declaration.important, 0, n++);
                    hashMap.put(declaration.propertyName, style);
                }
            }
        }
        return hashMap;
    }

    private Map<String, Style> getStyles(Node node) {
        String string = node.getStyle();
        if (string == null || string.isEmpty()) {
            return null;
        }
        Map<String, Style> map = authorStylesCache.get(string);
        if (map == null) {
            Stylesheet stylesheet = CSSParser.getInstance().parseStyle(string);
            if (stylesheet != null) {
                stylesheet.setSource(Stylesheet.Source.INLINE);
            }
            map = this.getStyles(stylesheet);
            authorStylesCache.put(string, map);
        }
        return map;
    }

    long getPseudoClassState(Node node) {
        if (pseudoclassMasksByNode.containsKey(node)) {
            Long l = pseudoclassMasksByNode.get(node);
            return l;
        }
        long l = 0L;
        if (this.pseudoclassStateMask != 0L) {
            l = node.impl_getPseudoClassState();
        }
        pseudoclassMasksByNode.put(node, l);
        return l;
    }

    private static long[] getAllPseudoClassStates(Node node, int n) {
        if (node == null) {
            return new long[n];
        }
        long[] lArray = StyleHelper.getAllPseudoClassStates(node.getParent(), ++n);
        StyleHelper styleHelper = node.impl_getStyleHelper();
        lArray[n - 1] = styleHelper != null ? styleHelper.getPseudoClassState(node) : 0L;
        return lArray;
    }

    private static CSSEventImpl getCSSEventInstance() {
        return CSSEventImpl.INSTANCE;
    }

    private Font getInheritedFont(Node node, Map<String, Style> map, CacheEntry cacheEntry) {
        if (node == null) {
            return Font.getDefault();
        }
        StyleHelper styleHelper = node.impl_getStyleHelper();
        return styleHelper.inheritFont(node, map, cacheEntry);
    }

    private Font inheritFont(Node node, Map<String, Style> map, CacheEntry cacheEntry) {
        Font font;
        CalculatedValue calculatedValue;
        boolean bl;
        StyleableProperty styleableProperty = StyleableProperty.FONT;
        List<StyleableProperty> list = StyleableProperty.getStyleables(node.impl_getClassToStyle());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            StyleableProperty styleableProperty2 = list.get(i);
            if (styleableProperty2.getConverter() != FontConverter.getInstance()) continue;
            styleableProperty = styleableProperty2;
            break;
        }
        String string = styleableProperty.getProperty();
        String string2 = "*inherited*".concat(string);
        boolean bl2 = bl = map == null;
        if (bl) {
            calculatedValue = cacheEntry.values.get(string);
            if (calculatedValue == null) {
                calculatedValue = cacheEntry.values.get(string2);
            }
            if (calculatedValue != null && calculatedValue.value instanceof Font) {
                return (Font)calculatedValue.value;
            }
        }
        calculatedValue = this.inherit(node, styleableProperty, map, null, cacheEntry);
        boolean bl3 = calculatedValue.value instanceof Font;
        Font font2 = font = bl3 ? (Font)calculatedValue.value : Font.getDefault();
        if (bl && calculatedValue.isCacheable) {
            CalculatedValue calculatedValue2 = new CalculatedValue(font, bl3 ? calculatedValue.source : null, bl3);
            cacheEntry.values.put(bl3 ? string : string2, calculatedValue2);
        }
        return font;
    }

    public void transitionToState(Node node) {
        StyleHelper.getCSSEventInstance().node = node;
        long[] lArray = StyleHelper.getAllPseudoClassStates(node, 0);
        long l = lArray != null && lArray.length > 0 ? lArray[0] : 0L;
        Map<String, Style> map = this.getStyles(node);
        CacheEntry cacheEntry = this.getCacheEntry(node, lArray);
        if (cacheEntry == null) {
            return;
        }
        List<StyleableProperty> list = StyleableProperty.getStyleables(node.impl_getClassToStyle());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            StyleableProperty styleableProperty = list.get(i);
            String string = styleableProperty.getProperty();
            if (!node.impl_cssSettable(styleableProperty)) continue;
            boolean bl = map == null && cacheEntry != null;
            CalculatedValue calculatedValue = null;
            if (bl && (calculatedValue = cacheEntry.values.get(string)) != null && calculatedValue.source == Stylesheet.Source.USER_AGENT && node.impl_cssUserSetProperty(styleableProperty)) continue;
            if (calculatedValue == null) {
                calculatedValue = this.lookup(node, styleableProperty, l, map, node, cacheEntry);
                if (bl && calculatedValue.isCacheable) {
                    cacheEntry.values.put(string, calculatedValue);
                }
            }
            if ((object = calculatedValue.value) == SKIP) continue;
            if (LOGGER.isLoggable(500)) {
                LOGGER.fine("call " + node + ".impl_cssSet(" + string + ", " + object + ")");
            }
            CSSEventImpl cSSEventImpl = StyleHelper.getCSSEventInstance();
            cSSEventImpl.styleableProperty = styleableProperty;
            cSSEventImpl.value = object;
            cSSEventImpl.type = CSSEvent.Type.APPLYING_STYLE;
            StyleManager.getInstance().notifyCSSListeners(cSSEventImpl);
            node.impl_cssSet(styleableProperty, object);
            cSSEventImpl.type = CSSEvent.Type.APPLIED_STYLE;
            StyleManager.getInstance().notifyCSSListeners(cSSEventImpl);
        }
    }

    public void transitionToState(Scene scene, List<String> list) {
    }

    private Style getStyle(Node node, String string, long l, Map<String, Style> map) {
        assert (node != null && string != null) : String.valueOf(node) + ", " + String.valueOf(string);
        Style style = map != null ? map.get(string) : null;
        List<Style> list = this.smap.get(string);
        if ((list == null || list.isEmpty()) && style == null) {
            return null;
        }
        Style style2 = null;
        int n = list == null ? 0 : list.size();
        for (int i = 0; i < n; ++i) {
            Selector selector;
            Style style3 = list.get(i);
            Selector selector2 = selector = style3 == null ? null : style3.selector;
            if (selector == null || !selector.stateMatches(node, l)) continue;
            style2 = style3;
            break;
        }
        if (style != null && (style2 == null || style.compareTo(style2) < 0)) {
            style2 = style;
        }
        return style2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CalculatedValue lookup(Node node, StyleableProperty styleableProperty, long l, Map<String, Style> map, Node node2, CacheEntry cacheEntry) {
        Object object;
        String string = styleableProperty.getProperty();
        Style style = this.getStyle(node, string, l, map);
        StyleHelper.getCSSEventInstance().rule = style != null ? style.rule : null;
        List<StyleableProperty> list = styleableProperty.getSubProperties();
        int n = list != null ? list.size() : 0;
        StyleConverter styleConverter = styleableProperty.getConverter();
        if (style == null && n == 0) {
            return this.handleNoStyleFound(node, styleableProperty, map, node2, cacheEntry);
        }
        if (style != null) {
            if (style.rule.stylesheet.getSource() == Stylesheet.Source.USER_AGENT && node.impl_cssUserSetProperty(styleableProperty)) {
                return new CalculatedValue(SKIP, null, true);
            }
            object = style.cssValue;
            if (object != null && "inherit".equals(((Value)object).getValue())) {
                return this.inherit(node, styleableProperty, map, node2, cacheEntry);
            }
        }
        if (style == null && n > 0) {
            object = new HashMap();
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                StyleableProperty styleableProperty2 = list.get(i);
                CalculatedValue calculatedValue = this.lookup(node, styleableProperty2, l, map, node2, cacheEntry);
                if (calculatedValue.value == SKIP) continue;
                object.put(styleableProperty2, calculatedValue.value);
                bl = bl && calculatedValue.isCacheable;
            }
            if (object.isEmpty()) {
                return this.handleNoStyleFound(node, styleableProperty, map, node2, cacheEntry);
            }
            Object var15_17 = null;
            try {
                var15_17 = styleConverter.convert((Map<StyleableProperty, Object>)object);
            }
            catch (ClassCastException classCastException) {
                if (LOGGER.isLoggable(900)) {
                    LOGGER.warning("caught: ", classCastException);
                    LOGGER.warning("styleable = " + styleableProperty);
                    LOGGER.warning("node = " + node.toString());
                }
                return new CalculatedValue(SKIP, null, true);
            }
            return new CalculatedValue(var15_17, null, bl);
        }
        object = style.cssValue;
        if (style.value == null && object != null && !"null".equals(((Value)object).getValue())) {
            Font font;
            Object var14_14 = null;
            Value value = this.resolveLookups(node, (Value)object, l, map);
            try {
                Font font2 = font = value.isNeedsFont() ? this.getInheritedFont(node2, map, cacheEntry) : null;
                if (font == null) {
                    font = Font.getDefault();
                }
                var14_14 = value.getConverter() != null ? value.convert(font) : styleableProperty.getConverter().convert(value, font);
            }
            catch (ClassCastException classCastException) {
                if (LOGGER.isLoggable(900)) {
                    LOGGER.warning("caught: ", classCastException);
                    LOGGER.warning("styleable = " + styleableProperty);
                    LOGGER.warning("resolved = " + value);
                    LOGGER.warning("node = " + node.toString());
                }
                CalculatedValue calculatedValue = new CalculatedValue(SKIP, null, true);
                return calculatedValue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (LOGGER.isLoggable(900)) {
                    LOGGER.warning("caught: ", illegalArgumentException);
                    LOGGER.fine("styleable = " + styleableProperty);
                    LOGGER.fine("node = " + node.toString());
                }
                CalculatedValue calculatedValue = new CalculatedValue(SKIP, null, true);
                return calculatedValue;
            }
            catch (NullPointerException nullPointerException) {
                if (LOGGER.isLoggable(900)) {
                    LOGGER.warning("caught: ", nullPointerException);
                    LOGGER.fine("styleable = " + styleableProperty);
                    LOGGER.fine("node = " + node.toString());
                }
                CalculatedValue calculatedValue = new CalculatedValue(SKIP, null, true);
                return calculatedValue;
            }
            finally {
                value.nullResolved();
            }
            Object object2 = font = style.rule != null ? style.rule.source : null;
            if (!style.cssValue.isLookup() && !style.cssValue.isContainsLookups()) {
                style.value = var14_14;
            }
            return new CalculatedValue(var14_14, (Stylesheet.Source)((Object)font), font != Stylesheet.Source.INLINE);
        }
        Stylesheet.Source source = style.rule != null ? style.rule.source : null;
        return new CalculatedValue(style.value, source, source != Stylesheet.Source.INLINE);
    }

    private CalculatedValue handleNoStyleFound(Node node, StyleableProperty styleableProperty, Map<String, Style> map, Node node2, CacheEntry cacheEntry) {
        if (styleableProperty.isInherits()) {
            CalculatedValue calculatedValue = this.inherit(node, styleableProperty, map, node2, cacheEntry);
            if (calculatedValue.value == SKIP) {
                return calculatedValue;
            }
            if (calculatedValue.source == Stylesheet.Source.USER_AGENT && node.impl_cssUserSetProperty(styleableProperty)) {
                return new CalculatedValue(SKIP, null, true);
            }
            return calculatedValue;
        }
        if (node.impl_cssUserSetProperty(styleableProperty)) {
            return new CalculatedValue(SKIP, null, true);
        }
        if (this.smap.containsKey(styleableProperty.getProperty())) {
            Value value = styleableProperty.getInitialValue();
            Font font = value != null && value.isNeedsFont() ? this.getInheritedFont(node2, map, cacheEntry) : null;
            Object var8_9 = value != null ? value.convert(font) : null;
            return new CalculatedValue(var8_9, null, false);
        }
        return new CalculatedValue(SKIP, null, true);
    }

    private CalculatedValue inherit(Node node, StyleableProperty styleableProperty, Map<String, Style> map, Node node2, CacheEntry cacheEntry) {
        StyleHelper styleHelper;
        Parent parent = node.getParent();
        StyleHelper styleHelper2 = styleHelper = parent == null ? null : parent.impl_getStyleHelper();
        while (parent != null && styleHelper == null) {
            if ((parent = parent.getParent()) == null) continue;
            styleHelper = parent.impl_getStyleHelper();
        }
        if (parent == null) {
            return new CalculatedValue(SKIP, null, true);
        }
        return styleHelper.lookup(parent, styleableProperty, styleHelper.getPseudoClassState(parent), this.getStyles(parent), node2, cacheEntry);
    }

    private Value resolveRef(Node node, String string, long l, Map<String, Style> map) {
        Style style = this.getStyle(node, string, l, map);
        if (style != null) {
            return style.cssValue;
        }
        Node node2 = node;
        StyleHelper styleHelper = this;
        if (l > 0L) {
            return this.resolveRef(node, string, 0L, map);
        }
        node2 = node.getParent();
        StyleHelper styleHelper2 = styleHelper = node2 == null ? null : node2.impl_getStyleHelper();
        while (node2 != null && styleHelper == null) {
            if ((node2 = node2.getParent()) == null) continue;
            styleHelper = node2.impl_getStyleHelper();
        }
        if (node2 == null || styleHelper == null) {
            return null;
        }
        return styleHelper.resolveRef(node2, string, styleHelper.getPseudoClassState(node2), this.getStyles(node2));
    }

    private Value resolveLookups(Node node, Value value, long l, Map<String, Style> map) {
        block6: {
            Object object;
            Object v;
            block5: {
                if (value.isLookup() && (v = value.getValue()) instanceof String && (object = this.resolveRef(node, (String)v, l, map)) != null) {
                    return this.resolveLookups(node, (Value)object, l, map);
                }
                if (!value.isContainsLookups()) {
                    return value;
                }
                v = value.getValue();
                if (!(v instanceof Value[][])) break block5;
                object = (Value[][])v;
                for (int i = 0; i < ((Value[][])object).length; ++i) {
                    for (int j = 0; j < object[i].length; ++j) {
                        if (object[i][j] == null) continue;
                        object[i][j].resolved = this.resolveLookups(node, object[i][j], l, map);
                    }
                }
                break block6;
            }
            if (!(v instanceof Value[])) break block6;
            object = (Value[])v;
            for (int i = 0; i < ((Value[][])object).length; ++i) {
                if (object[i] == null) continue;
                object[i].resolved = this.resolveLookups(node, (Value)object[i], l, map);
            }
        }
        return value;
    }

    private static class CSSEventImpl
    implements CSSEvent {
        private CSSEvent.Type type;
        private StyleableProperty styleableProperty;
        private Rule rule;
        private Object value;
        private Node node;
        private static CSSEventImpl INSTANCE = new CSSEventImpl();

        @Override
        public CSSEvent.Type getType() {
            return this.type;
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return this.styleableProperty;
        }

        @Override
        public Rule getRule() {
            return this.rule;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CSSEvent {type: ");
            if (this.type != null) {
                stringBuilder.append(this.type.toString());
            }
            stringBuilder.append(", rule: ");
            if (this.rule != null) {
                stringBuilder.append(this.rule.toString());
            }
            stringBuilder.append(", property: ");
            if (this.styleableProperty != null) {
                stringBuilder.append(this.styleableProperty.getProperty());
            }
            stringBuilder.append(", node: ");
            if (this.node != null) {
                stringBuilder.append(this.node.toString());
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        private CSSEventImpl() {
        }
    }

    private static class CalculatedValue {
        final Object value;
        final boolean isCacheable;
        final Stylesheet.Source source;

        CalculatedValue(Object object, Stylesheet.Source source, boolean bl) {
            this.value = object;
            this.source = source;
            this.isCacheable = bl;
        }
    }

    static class CacheEntry {
        final long[] states;
        final Map<String, CalculatedValue> values;

        CacheEntry(long[] lArray) {
            this.states = lArray;
            this.values = new HashMap<String, CalculatedValue>();
        }
    }

    public static final class StyleCacheKey {
        private final int[] indices;
        private final long[] pclassMask;

        private StyleCacheKey(int[] nArray, long[] lArray) {
            this.indices = nArray;
            this.pclassMask = lArray;
        }

        private static int[] getIndices(Node node, int n) {
            if (node == null) {
                return new int[n];
            }
            int[] nArray = StyleCacheKey.getIndices(node.getParent(), ++n);
            StyleHelper styleHelper = node.impl_getStyleHelper();
            nArray[n - 1] = styleHelper != null ? styleHelper.helperIndex : 0;
            return nArray;
        }
    }
}

