/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.Declaration;
import com.sun.javafx.css.Match;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.StringStore;
import com.sun.javafx.css.Stylesheet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Scene;

public final class Rule {
    final List<Selector> selectors;
    final List<Declaration> declarations;
    Stylesheet stylesheet;
    Stylesheet.Source source;

    public List<Selector> getSelectors() {
        return this.selectors;
    }

    public List<Declaration> getDeclarations() {
        return this.declarations;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    public Stylesheet.Source getSource() {
        return this.stylesheet.getSource();
    }

    public Rule(List<Selector> list, List<Declaration> list2) {
        this.selectors = list;
        this.declarations = list2;
    }

    private Rule() {
        this(null, null);
    }

    List<Match> matches(Node node) {
        ArrayList<Match> arrayList = new ArrayList<Match>();
        for (int i = 0; i < this.selectors.size(); ++i) {
            Selector selector = this.selectors.get(i);
            arrayList.add(selector.matches(node));
        }
        return arrayList;
    }

    List<Match> matches(Scene scene) {
        ArrayList<Match> arrayList = new ArrayList<Match>();
        for (int i = 0; i < this.selectors.size(); ++i) {
            Selector selector = this.selectors.get(i);
            arrayList.add(selector.matches(scene));
        }
        return arrayList;
    }

    public boolean mightApply(String string, String string2, List<String> list) {
        for (int i = 0; i < this.selectors.size(); ++i) {
            Selector selector = this.selectors.get(i);
            if (!selector.mightApply(string, string2, list)) continue;
            return true;
        }
        return false;
    }

    public boolean applies(Node node) {
        for (int i = 0; i < this.selectors.size(); ++i) {
            Selector selector = this.selectors.get(i);
            if (!selector.applies(node)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.selectors.size() > 0) {
            stringBuilder.append(this.selectors.get(0));
        }
        for (int i = 1; i < this.selectors.size(); ++i) {
            stringBuilder.append(',');
            stringBuilder.append(this.selectors.get(i));
        }
        stringBuilder.append("{\n");
        for (Declaration declaration : this.declarations) {
            stringBuilder.append("\t");
            stringBuilder.append(declaration);
            stringBuilder.append("\n");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    void writeBinary(DataOutputStream dataOutputStream, StringStore stringStore) throws IOException {
        Object object;
        int n;
        dataOutputStream.writeShort(this.selectors.size());
        for (n = 0; n < this.selectors.size(); ++n) {
            object = this.selectors.get(n);
            ((Selector)object).writeBinary(dataOutputStream, stringStore);
        }
        dataOutputStream.writeShort(this.declarations.size());
        for (n = 0; n < this.declarations.size(); ++n) {
            object = this.declarations.get(n);
            ((Declaration)object).writeBinary(dataOutputStream, stringStore);
        }
    }

    static Rule readBinary(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        Object object;
        int n;
        int n2 = dataInputStream.readShort();
        ArrayList<Selector> arrayList = new ArrayList<Selector>(n2);
        for (n = 0; n < n2; ++n) {
            object = Selector.readBinary(dataInputStream, stringArray);
            arrayList.add((Selector)object);
        }
        n = dataInputStream.readShort();
        object = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Declaration declaration = Declaration.readBinary(dataInputStream, stringArray);
            object.add(declaration);
        }
        return new Rule(arrayList, (List<Declaration>)object);
    }
}

