/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import java.util.Arrays;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;

public abstract class ExpressionHelper<T> {
    protected final ObservableValue<T> expression;

    private ExpressionHelper(ObservableValue<T> observableValue) {
        this.expression = observableValue;
    }

    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> expressionHelper, ObservableValue<T> observableValue, InvalidationListener invalidationListener) {
        if (observableValue == null || invalidationListener == null) {
            throw new NullPointerException();
        }
        observableValue.getValue();
        return expressionHelper == null ? new SingleInvalidation(observableValue, invalidationListener) : expressionHelper.addListener(invalidationListener);
    }

    public static <T> ExpressionHelper<T> removeListener(ExpressionHelper<T> expressionHelper, InvalidationListener invalidationListener) {
        if (invalidationListener == null) {
            throw new NullPointerException();
        }
        return expressionHelper == null ? null : expressionHelper.removeListener(invalidationListener);
    }

    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> expressionHelper, ObservableValue<T> observableValue, ChangeListener<? super T> changeListener) {
        if (observableValue == null || changeListener == null) {
            throw new NullPointerException();
        }
        return expressionHelper == null ? new SingleChange(observableValue, changeListener) : expressionHelper.addListener(changeListener);
    }

    public static <T> ExpressionHelper<T> removeListener(ExpressionHelper<T> expressionHelper, ChangeListener<? super T> changeListener) {
        if (changeListener == null) {
            throw new NullPointerException();
        }
        return expressionHelper == null ? null : expressionHelper.removeListener(changeListener);
    }

    public static <T> void fireValueChangedEvent(ExpressionHelper<T> expressionHelper) {
        if (expressionHelper != null) {
            expressionHelper.fireValueChangedEvent();
        }
    }

    protected static int trim(int n, InvalidationListener[] invalidationListenerArray) {
        for (int i = 0; i < n; ++i) {
            InvalidationListener invalidationListener = invalidationListenerArray[i];
            if (!(invalidationListener instanceof WeakInvalidationListener) || !((WeakInvalidationListener)invalidationListener).wasGarbageCollected()) continue;
            int n2 = n - i - 1;
            if (n2 > 0) {
                System.arraycopy(invalidationListenerArray, i + 1, invalidationListenerArray, i, n2);
            }
            invalidationListenerArray[--n] = null;
            --i;
        }
        return n;
    }

    protected static <T> int trim(int n, ChangeListener<? super T>[] changeListenerArray) {
        for (int i = 0; i < n; ++i) {
            ChangeListener<? super T> changeListener = changeListenerArray[i];
            if (!(changeListener instanceof WeakChangeListener) || !((WeakChangeListener)changeListener).wasGarbageCollected()) continue;
            int n2 = n - i - 1;
            if (n2 > 0) {
                System.arraycopy(changeListenerArray, i + 1, changeListenerArray, i, n2);
            }
            changeListenerArray[--n] = null;
            --i;
        }
        return n;
    }

    protected abstract ExpressionHelper<T> addListener(InvalidationListener var1);

    protected abstract ExpressionHelper<T> removeListener(InvalidationListener var1);

    protected abstract ExpressionHelper<T> addListener(ChangeListener<? super T> var1);

    protected abstract ExpressionHelper<T> removeListener(ChangeListener<? super T> var1);

    protected abstract void fireValueChangedEvent();

    private static class MultipleInvalidationMultipleChange<T>
    extends ExpressionHelper<T> {
        private InvalidationListener[] invalidationListeners;
        private ChangeListener<? super T>[] changeListeners;
        private int invalidationSize;
        private int changeSize;
        private boolean locked;
        private T oldValue;

        private MultipleInvalidationMultipleChange(ObservableValue<T> observableValue, InvalidationListener invalidationListener, int n, ChangeListener<? super T> ... changeListenerArray) {
            super(observableValue);
            this.invalidationListeners = new InvalidationListener[]{invalidationListener};
            this.invalidationSize = 1;
            this.changeListeners = changeListenerArray;
            this.changeSize = n;
            this.oldValue = observableValue.getValue();
        }

        private MultipleInvalidationMultipleChange(ObservableValue<T> observableValue, ChangeListener<? super T> changeListener, int n, InvalidationListener ... invalidationListenerArray) {
            super(observableValue);
            this.invalidationListeners = invalidationListenerArray;
            this.invalidationSize = n;
            this.changeListeners = new ChangeListener[]{changeListener};
            this.changeSize = 1;
            this.oldValue = observableValue.getValue();
        }

        @Override
        protected ExpressionHelper<T> addListener(InvalidationListener invalidationListener) {
            int n = this.invalidationListeners.length;
            if (this.locked) {
                int n2 = this.invalidationSize < n ? n : n * 3 / 2 + 1;
                this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, n2);
            } else if (this.invalidationSize == n) {
                this.invalidationSize = ExpressionHelper.trim(this.invalidationSize, this.invalidationListeners);
                if (this.invalidationSize == n) {
                    int n3 = n * 3 / 2 + 1;
                    this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, n3);
                }
            }
            this.invalidationListeners[this.invalidationSize++] = invalidationListener;
            return this;
        }

        @Override
        protected ExpressionHelper<T> removeListener(InvalidationListener invalidationListener) {
            if (this.locked) {
                this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, this.invalidationListeners.length);
            }
            for (int i = 0; i < this.invalidationSize; ++i) {
                if (!invalidationListener.equals(this.invalidationListeners[i])) continue;
                if (this.invalidationSize == 1) {
                    return new MultipleChange(this.expression, this.changeSize, (ChangeListener[])this.changeListeners);
                }
                int n = this.invalidationSize - i - 1;
                if (n > 0) {
                    System.arraycopy(this.invalidationListeners, i + 1, this.invalidationListeners, i, n);
                }
                this.invalidationListeners[--this.invalidationSize] = null;
                break;
            }
            return this;
        }

        @Override
        protected ExpressionHelper<T> addListener(ChangeListener<? super T> changeListener) {
            int n = this.changeListeners.length;
            if (this.locked) {
                int n2 = this.changeSize < n ? n : n * 3 / 2 + 1;
                this.changeListeners = Arrays.copyOf(this.changeListeners, n2);
            } else if (this.changeSize == n) {
                this.changeSize = ExpressionHelper.trim(this.changeSize, this.changeListeners);
                if (this.changeSize == n) {
                    int n3 = n * 3 / 2 + 1;
                    this.changeListeners = Arrays.copyOf(this.changeListeners, n3);
                }
            }
            this.changeListeners[this.changeSize++] = changeListener;
            return this;
        }

        @Override
        protected ExpressionHelper<T> removeListener(ChangeListener<? super T> changeListener) {
            if (this.locked) {
                this.changeListeners = Arrays.copyOf(this.changeListeners, this.changeListeners.length);
            }
            for (int i = 0; i < this.changeSize; ++i) {
                if (!changeListener.equals(this.changeListeners[i])) continue;
                if (this.changeSize == 1) {
                    return new MultipleInvalidation(this.expression, this.invalidationSize, this.invalidationListeners);
                }
                int n = this.changeSize - i - 1;
                if (n > 0) {
                    System.arraycopy(this.changeListeners, i + 1, this.changeListeners, i, n);
                }
                this.changeListeners[--this.changeSize] = null;
                break;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void fireValueChangedEvent() {
            boolean bl;
            Object t = this.expression.getValue();
            boolean bl2 = t == null ? this.oldValue != null : (bl = !t.equals(this.oldValue));
            if (bl) {
                InvalidationListener[] invalidationListenerArray = this.invalidationListeners;
                int n = this.invalidationSize;
                ChangeListener<? super T>[] changeListenerArray = this.changeListeners;
                int n2 = this.changeSize;
                try {
                    int n3;
                    this.locked = true;
                    for (n3 = 0; n3 < n; ++n3) {
                        invalidationListenerArray[n3].invalidated(this.expression);
                    }
                    for (n3 = 0; n3 < n2; ++n3) {
                        changeListenerArray[n3].changed(this.expression, this.oldValue, t);
                    }
                }
                finally {
                    this.locked = false;
                    this.oldValue = t;
                }
            }
        }
    }

    private static class MultipleChange<T>
    extends ExpressionHelper<T> {
        private ChangeListener<? super T>[] listeners;
        private T oldValue;
        private int size;
        private boolean locked;

        private MultipleChange(ObservableValue<T> observableValue, int n, ChangeListener<? super T> ... changeListenerArray) {
            super(observableValue);
            this.size = n;
            this.listeners = changeListenerArray;
            this.oldValue = observableValue.getValue();
        }

        @Override
        protected ExpressionHelper<T> addListener(InvalidationListener invalidationListener) {
            return new MultipleInvalidationMultipleChange(this.expression, invalidationListener, this.size, (ChangeListener[])this.listeners);
        }

        @Override
        protected ExpressionHelper<T> removeListener(InvalidationListener invalidationListener) {
            return this;
        }

        @Override
        protected ExpressionHelper<T> addListener(ChangeListener<? super T> changeListener) {
            int n = this.listeners.length;
            if (this.locked) {
                int n2 = this.size < n ? n : n * 3 / 2 + 1;
                this.listeners = Arrays.copyOf(this.listeners, n2);
            } else if (this.size == n) {
                this.size = ExpressionHelper.trim(this.size, this.listeners);
                if (this.size == n) {
                    int n3 = n * 3 / 2 + 1;
                    this.listeners = Arrays.copyOf(this.listeners, n3);
                } else if (this.size == 0) {
                    return new SingleChange(this.expression, changeListener);
                }
            }
            this.listeners[this.size++] = changeListener;
            return this;
        }

        @Override
        protected ExpressionHelper<T> removeListener(ChangeListener<? super T> changeListener) {
            if (this.locked) {
                this.listeners = Arrays.copyOf(this.listeners, this.listeners.length);
            }
            for (int i = 0; i < this.size; ++i) {
                if (!changeListener.equals(this.listeners[i])) continue;
                if (this.size == 2) {
                    return new SingleChange(this.expression, this.listeners[1 - i]);
                }
                int n = this.size - i - 1;
                if (n > 0) {
                    System.arraycopy(this.listeners, i + 1, this.listeners, i, n);
                }
                this.listeners[--this.size] = null;
                break;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void fireValueChangedEvent() {
            boolean bl;
            Object t = this.expression.getValue();
            boolean bl2 = t == null ? this.oldValue != null : (bl = !t.equals(this.oldValue));
            if (bl) {
                ChangeListener<? super T>[] changeListenerArray = this.listeners;
                int n = this.size;
                try {
                    this.locked = true;
                    for (int i = 0; i < n; ++i) {
                        changeListenerArray[i].changed(this.expression, this.oldValue, t);
                    }
                }
                finally {
                    this.locked = false;
                    this.oldValue = t;
                }
            }
        }
    }

    private static class MultipleInvalidation<T>
    extends ExpressionHelper<T> {
        private InvalidationListener[] listeners;
        private int size;
        private boolean locked;

        private MultipleInvalidation(ObservableValue<T> observableValue, int n, InvalidationListener ... invalidationListenerArray) {
            super(observableValue);
            this.size = n;
            this.listeners = invalidationListenerArray;
        }

        @Override
        protected ExpressionHelper<T> addListener(InvalidationListener invalidationListener) {
            int n = this.listeners.length;
            if (this.locked) {
                int n2 = this.size < n ? n : n * 3 / 2 + 1;
                this.listeners = Arrays.copyOf(this.listeners, n2);
            } else if (this.size == n) {
                this.size = ExpressionHelper.trim(this.size, this.listeners);
                if (this.size == n) {
                    int n3 = n * 3 / 2 + 1;
                    this.listeners = Arrays.copyOf(this.listeners, n3);
                } else if (this.size == 0) {
                    return new SingleInvalidation(this.expression, invalidationListener);
                }
            }
            this.listeners[this.size++] = invalidationListener;
            return this;
        }

        @Override
        protected ExpressionHelper<T> removeListener(InvalidationListener invalidationListener) {
            if (this.locked) {
                this.listeners = Arrays.copyOf(this.listeners, this.listeners.length);
            }
            for (int i = 0; i < this.size; ++i) {
                if (!invalidationListener.equals(this.listeners[i])) continue;
                if (this.size == 2) {
                    return new SingleInvalidation(this.expression, this.listeners[1 - i]);
                }
                int n = this.size - i - 1;
                if (n > 0) {
                    System.arraycopy(this.listeners, i + 1, this.listeners, i, n);
                }
                this.listeners[--this.size] = null;
                break;
            }
            return this;
        }

        @Override
        protected ExpressionHelper<T> addListener(ChangeListener<? super T> changeListener) {
            return new MultipleInvalidationMultipleChange(this.expression, (ChangeListener)changeListener, this.size, this.listeners);
        }

        @Override
        protected ExpressionHelper<T> removeListener(ChangeListener<? super T> changeListener) {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void fireValueChangedEvent() {
            InvalidationListener[] invalidationListenerArray = this.listeners;
            int n = this.size;
            try {
                this.locked = true;
                for (int i = 0; i < n; ++i) {
                    invalidationListenerArray[i].invalidated(this.expression);
                }
            }
            finally {
                this.locked = false;
            }
        }
    }

    private static class SingleInvalidationSingleChange<T>
    extends ExpressionHelper<T> {
        private final InvalidationListener invalidationListener;
        private final ChangeListener<? super T> changeListener;
        private T oldValue;

        private SingleInvalidationSingleChange(ObservableValue<T> observableValue, InvalidationListener invalidationListener, ChangeListener<? super T> changeListener) {
            super(observableValue);
            this.invalidationListener = invalidationListener;
            this.changeListener = changeListener;
            this.oldValue = observableValue.getValue();
        }

        @Override
        protected ExpressionHelper<T> addListener(InvalidationListener invalidationListener) {
            return new MultipleInvalidationMultipleChange(this.expression, (ChangeListener)this.changeListener, 2, new InvalidationListener[]{this.invalidationListener, invalidationListener});
        }

        @Override
        protected ExpressionHelper<T> removeListener(InvalidationListener invalidationListener) {
            return invalidationListener.equals(this.invalidationListener) ? new SingleChange(this.expression, this.changeListener) : this;
        }

        @Override
        protected ExpressionHelper<T> addListener(ChangeListener<? super T> changeListener) {
            return new MultipleInvalidationMultipleChange(this.expression, this.invalidationListener, 2, new ChangeListener[]{this.changeListener, changeListener});
        }

        @Override
        protected ExpressionHelper<T> removeListener(ChangeListener<? super T> changeListener) {
            return changeListener.equals(this.changeListener) ? new SingleInvalidation(this.expression, this.invalidationListener) : this;
        }

        @Override
        protected void fireValueChangedEvent() {
            boolean bl;
            Object t = this.expression.getValue();
            boolean bl2 = t == null ? this.oldValue != null : (bl = !t.equals(this.oldValue));
            if (bl) {
                this.invalidationListener.invalidated(this.expression);
                this.changeListener.changed(this.expression, this.oldValue, t);
                this.oldValue = t;
            }
        }
    }

    private static class SingleChange<T>
    extends ExpressionHelper<T> {
        private final ChangeListener<? super T> listener;
        private T oldValue;

        private SingleChange(ObservableValue<T> observableValue, ChangeListener<? super T> changeListener) {
            super(observableValue);
            this.listener = changeListener;
            this.oldValue = observableValue.getValue();
        }

        @Override
        protected ExpressionHelper<T> addListener(InvalidationListener invalidationListener) {
            return new SingleInvalidationSingleChange(this.expression, invalidationListener, this.listener);
        }

        @Override
        protected ExpressionHelper<T> removeListener(InvalidationListener invalidationListener) {
            return this;
        }

        @Override
        protected ExpressionHelper<T> addListener(ChangeListener<? super T> changeListener) {
            return new MultipleChange(this.expression, 2, new ChangeListener[]{this.listener, changeListener});
        }

        @Override
        protected ExpressionHelper<T> removeListener(ChangeListener<? super T> changeListener) {
            return changeListener.equals(this.listener) ? null : this;
        }

        @Override
        protected void fireValueChangedEvent() {
            boolean bl;
            Object t = this.expression.getValue();
            boolean bl2 = t == null ? this.oldValue != null : (bl = !t.equals(this.oldValue));
            if (bl) {
                this.listener.changed(this.expression, this.oldValue, t);
                this.oldValue = t;
            }
        }
    }

    private static class SingleInvalidation<T>
    extends ExpressionHelper<T> {
        private final InvalidationListener listener;

        private SingleInvalidation(ObservableValue<T> observableValue, InvalidationListener invalidationListener) {
            super(observableValue);
            this.listener = invalidationListener;
        }

        @Override
        protected ExpressionHelper<T> addListener(InvalidationListener invalidationListener) {
            return new MultipleInvalidation(this.expression, 2, new InvalidationListener[]{this.listener, invalidationListener});
        }

        @Override
        protected ExpressionHelper<T> removeListener(InvalidationListener invalidationListener) {
            return invalidationListener.equals(this.listener) ? null : this;
        }

        @Override
        protected ExpressionHelper<T> addListener(ChangeListener<? super T> changeListener) {
            return new SingleInvalidationSingleChange(this.expression, this.listener, changeListener);
        }

        @Override
        protected ExpressionHelper<T> removeListener(ChangeListener<? super T> changeListener) {
            return this;
        }

        @Override
        protected void fireValueChangedEvent() {
            this.listener.invalidated(this.expression);
        }
    }
}

