/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.SystemClipboard;
import com.sun.glass.ui.win.WinHTMLCodec;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WinSystemClipboard
extends SystemClipboard {
    protected long ptr = 0L;
    static byte[] terminator;
    static String defaultCharset;

    static native void initIDs();

    protected WinSystemClipboard(String name) {
        super(name);
        this.create();
    }

    @Override
    protected native boolean isOwner();

    protected native void create();

    protected native void dispose();

    protected native void push(Object[] var1, int var2);

    protected native boolean pop();

    protected byte[] fosSerialize(String mime, long index) {
        Pixels pxls;
        Object data = this.getLocalData(mime);
        if (data instanceof ByteBuffer) {
            byte[] b = ((ByteBuffer)data).array();
            if ("text/html".equals(mime)) {
                b = WinHTMLCodec.encode(b);
            }
            return b;
        }
        if (data instanceof String) {
            String st = ((String)data).replace("\n", "\r\n");
            if ("text/html".equals(mime)) {
                try {
                    byte[] bytes = st.getBytes("UTF-8");
                    ByteBuffer ba = ByteBuffer.allocate(bytes.length + 1);
                    ba.put(bytes);
                    ba.put((byte)0);
                    return WinHTMLCodec.encode(ba.array());
                }
                catch (UnsupportedEncodingException ex) {
                    return null;
                }
            }
            ByteBuffer ba = ByteBuffer.allocate((st.length() + 1) * 2);
            try {
                ba.put(st.getBytes(defaultCharset));
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
            ba.put(terminator);
            return ba.array();
        }
        if ("application/x-java-file-list".equals(mime)) {
            String[] ast = (String[])data;
            if (ast != null && ast.length > 0) {
                int size = 0;
                for (String st : ast) {
                    size += (st.length() + 1) * 2;
                }
                size += 2;
                try {
                    ByteBuffer ba = ByteBuffer.allocate(size);
                    for (String st : ast) {
                        ba.put(st.getBytes(defaultCharset));
                        ba.put(terminator);
                    }
                    ba.put(terminator);
                    return ba.array();
                }
                catch (UnsupportedEncodingException ex) {}
            }
        } else if ("application/x-java-rawimage".equals(mime) && (pxls = (Pixels)data) != null) {
            ByteBuffer ba = ByteBuffer.allocate(pxls.getWidth() * pxls.getHeight() * 4 + 8);
            ba.putInt(pxls.getWidth());
            ba.putInt(pxls.getHeight());
            ba.put(pxls.asByteBuffer());
            return ba.array();
        }
        return null;
    }

    @Override
    protected void pushToSystem(HashMap<String, Object> cacheData, int supportedActions) {
        this.push(cacheData.keySet().toArray(), supportedActions);
    }

    protected native byte[] popBytes(String var1, long var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object popFromSystem(String mime) {
        if (!this.pop()) {
            return null;
        }
        byte[] data = this.popBytes(mime, -1L);
        if (data != null) {
            if ("text/plain".equals(mime) || "text/uri-list".equals(mime)) {
                try {
                    return new String(data, 0, data.length - 2, defaultCharset);
                }
                catch (UnsupportedEncodingException ex) {
                    return null;
                }
            }
            if ("text/html".equals(mime) || "text/rtf".equals(mime)) {
                try {
                    if (!"text/html".equals(mime)) return new String(data, 0, data.length, "UTF-8");
                    data = WinHTMLCodec.decode(data);
                    return new String(data, 0, data.length, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    return null;
                }
            }
            if (!"application/x-java-file-list".equals(mime)) {
                if (!"application/x-java-rawimage".equals(mime)) return ByteBuffer.wrap(data);
                ByteBuffer size = ByteBuffer.wrap(data, 0, 8);
                return Application.GetApplication().createPixels(size.getInt(), size.getInt(), ByteBuffer.wrap(data, 8, data.length - 8));
            }
            try {
                String st = new String(data, 0, data.length, defaultCharset);
                return st.split("\u0000");
            }
            catch (UnsupportedEncodingException ex) {
                return null;
            }
        }
        if (!"text/uri-list".equals(mime)) return null;
        String[] ret = (String[])this.popFromSystem("application/x-java-file-list");
        if (ret == null) return null;
        String out = "";
        int i = 0;
        while (i < ret.length) {
            String fileName = ret[i];
            fileName = fileName.replace("\\", "/");
            if (!out.isEmpty()) {
                out = out + "\r\n";
            }
            out = out + "file:/" + fileName;
            ++i;
        }
        return out;
    }

    protected native String[] popMimesFromSystem();

    @Override
    protected String[] mimesFromSystem() {
        if (!this.pop()) {
            return null;
        }
        return this.popMimesFromSystem();
    }

    @Override
    public String toString() {
        return "Windows System Clipboard";
    }

    @Override
    protected void close() {
        this.dispose();
        this.ptr = 0L;
    }

    public long getPtr() {
        return this.ptr;
    }

    @Override
    protected native void pushTargetActionToSystem(int var1);

    protected native int popSupportedSourceActions();

    @Override
    protected int supportedSourceActionsFromSystem() {
        if (!this.pop()) {
            return 0;
        }
        return this.popSupportedSourceActions();
    }

    static {
        Application.loadNativeLibrary();
        WinSystemClipboard.initIDs();
        terminator = new byte[]{0, 0};
        defaultCharset = "UTF-16LE";
    }
}

