/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Window;
import com.sun.glass.utils.Disposer;
import com.sun.glass.utils.DisposerRecord;
import java.lang.ref.WeakReference;
import java.util.Map;

public abstract class View {
    private long ptr;
    private Window window;
    private final Pen pen;
    private EventHandler eventHandler;
    private int width = -1;
    private int height = -1;
    private boolean isValid = false;
    private boolean isVisible = false;
    private boolean inFullscreen = false;
    protected int dirtyX = 0;
    protected int dirtyY = 0;
    protected int dirtyWidth = 0;
    protected int dirtyHeight = 0;
    private final ViewDisposerRecord disposerRecord;
    private static WeakReference<View> lastClickedView = null;
    private static int lastClickedButton;
    private static long lastClickedTime;
    private static int lastClickedX;
    private static int lastClickedY;
    private static int clickCount;
    private static boolean dragProcessed;
    private ClipboardAssistance dropSourceAssistant;
    ClipboardAssistance dropTargetAssistant;

    public static long getMultiClickTime() {
        return Application.GetApplication().staticView_getMultiClickTime();
    }

    public static int getMultiClickMaxX() {
        return Application.GetApplication().staticView_getMultiClickMaxX();
    }

    public static int getMultiClickMaxY() {
        return Application.GetApplication().staticView_getMultiClickMaxY();
    }

    protected abstract void _enableInputMethodEvents(long var1, boolean var3);

    protected abstract long _create(Map var1);

    protected View(Pen pen) {
        this.ptr = this._create(pen.getCapabilities());
        if (this.ptr == 0L) {
            throw new RuntimeException("could not create platform view");
        }
        this.pen = pen;
        this.pen.setView(this);
        this.disposerRecord = new ViewDisposerRecord(this.ptr);
        Disposer.addRecord(this, this.disposerRecord);
    }

    private void checkNotClosed() {
        if (this.ptr == 0L) {
            throw new IllegalStateException("The view has already been closed");
        }
    }

    public boolean isClosed() {
        return this.ptr == 0L;
    }

    protected abstract long _getNativeView(long var1);

    public long getNativeView() {
        this.checkNotClosed();
        return this._getNativeView(this.ptr);
    }

    public Window getWindow() {
        return this.window;
    }

    public Pen getPen() {
        return this.pen;
    }

    protected abstract int _getX(long var1);

    public int getX() {
        this.checkNotClosed();
        return this._getX(this.ptr);
    }

    protected abstract int _getY(long var1);

    public int getY() {
        this.checkNotClosed();
        return this._getY(this.ptr);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected abstract void _setParent(long var1, long var3);

    void setWindow(Window window) {
        this.checkNotClosed();
        this.window = window;
        this._setParent(this.ptr, window == null ? 0L : window.getNativeWindow());
        this.setValid(this.ptr != 0L && window != null);
    }

    void setVisible(boolean visible) {
        if (this.isVisible != visible) {
            this.isVisible = visible;
        }
    }

    protected void setValid(boolean valid) {
        this.isValid = valid;
    }

    protected boolean isValid() {
        return this.isValid;
    }

    protected abstract boolean _close(long var1);

    public void close() {
        if (this.ptr == 0L) {
            return;
        }
        Window host = this.getWindow();
        if (host != null) {
            host.setView(null);
        }
        this.isValid = false;
        this._close(this.ptr);
        this.ptr = 0L;
        this.disposerRecord.ptr = 0L;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    private void handleViewEvent(long time, int type) {
        if (this.eventHandler != null) {
            this.eventHandler.handleViewEvent(this, time, type);
        }
    }

    private void handleKeyEvent(long time, int action, int keyCode, char[] keyChars, int modifiers) {
        if (this.eventHandler != null) {
            this.eventHandler.handleKeyEvent(this, time, action, keyCode, keyChars, modifiers);
        }
    }

    private void handleMouseEvent(long time, int type, int button, int x, int y, int xAbs, int yAbs, int clickCount, int modifiers, boolean isPopupTrigger) {
        if (this.eventHandler != null) {
            this.eventHandler.handleMouseEvent(this, time, type, button, x, y, xAbs, yAbs, clickCount, modifiers, isPopupTrigger);
        }
    }

    private void handleInputMethodEvent(long time, String text, int[] clauseBoundary, int[] attrBoundary, byte[] attrValue, int commitCount, int cursorPos) {
        if (this.eventHandler != null) {
            this.eventHandler.handleInputMethodEvent(time, text, clauseBoundary, attrBoundary, attrValue, commitCount, cursorPos);
        }
    }

    public void enableInputMethodEvents(boolean enable) {
        this._enableInputMethodEvents(this.ptr, enable);
    }

    private double[] getInputMethodCandidatePos(int offset) {
        if (this.eventHandler != null) {
            return this.eventHandler.getInputMethodCandidatePos(offset);
        }
        return null;
    }

    private void handleDragStart(int button, int x, int y, int xAbs, int yAbs, ClipboardAssistance dropSourceAssistant) {
        if (this.eventHandler != null) {
            this.eventHandler.handleDragStart(this, button, x, y, xAbs, yAbs, dropSourceAssistant);
        }
    }

    private void handleDragEnd(int performedAction) {
        if (this.eventHandler != null) {
            this.eventHandler.handleDragEnd(this, performedAction);
        }
    }

    private int handleDragEnter(int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
        if (this.eventHandler != null) {
            return this.eventHandler.handleDragEnter(this, x, y, xAbs, yAbs, recommendedDropAction, dropTargetAssistant);
        }
        return recommendedDropAction;
    }

    private int handleDragOver(int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
        if (this.eventHandler != null) {
            return this.eventHandler.handleDragOver(this, x, y, xAbs, yAbs, recommendedDropAction, dropTargetAssistant);
        }
        return recommendedDropAction;
    }

    private void handleDragLeave(ClipboardAssistance dropTargetAssistant) {
        if (this.eventHandler != null) {
            this.eventHandler.handleDragLeave(this, dropTargetAssistant);
        }
    }

    private int handleDragDrop(int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
        if (this.eventHandler != null) {
            return this.eventHandler.handleDragDrop(this, x, y, xAbs, yAbs, recommendedDropAction, dropTargetAssistant);
        }
        return 0;
    }

    protected abstract void _repaint(long var1);

    public void scheduleRepaint() {
        this.checkNotClosed();
        this._repaint(this.ptr);
    }

    protected abstract boolean _begin(long var1, boolean var3);

    public void lock() {
        this.checkNotClosed();
        this._begin(this.ptr, this.isValid());
    }

    protected abstract void _end(long var1, boolean var3, boolean var4);

    public void unlock(boolean flush) {
        this.checkNotClosed();
        this._end(this.ptr, this.isValid(), flush);
    }

    protected abstract void _uploadPixels(long var1, Pixels var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadPixels(Pixels pixels) {
        this.checkNotClosed();
        this.lock();
        try {
            this._uploadPixels(this.ptr, pixels);
        }
        finally {
            this.unlock(false);
        }
    }

    protected abstract boolean _enterFullscreen(long var1, boolean var3, boolean var4, boolean var5);

    public boolean enterFullscreen(boolean animate, boolean keepRatio, boolean hideCursor) {
        this.checkNotClosed();
        return this._enterFullscreen(this.ptr, animate, keepRatio, hideCursor);
    }

    protected abstract void _exitFullscreen(long var1, boolean var3);

    public void exitFullscreen(boolean animate) {
        this.checkNotClosed();
        this._exitFullscreen(this.ptr, animate);
    }

    public boolean isInFullscreen() {
        return this.inFullscreen;
    }

    public boolean toggleFullscreen(boolean animate, boolean keepRatio, boolean hideCursor) {
        this.checkNotClosed();
        if (!this.inFullscreen) {
            this.enterFullscreen(animate, keepRatio, hideCursor);
        } else {
            this.exitFullscreen(animate);
        }
        this._repaint(this.ptr);
        return this.inFullscreen;
    }

    protected void handleViewEvent(int type) {
        if (type == 431) {
            if (this.isValid()) {
                this.handleViewEvent(System.nanoTime(), type);
                this.getPen().paint(System.nanoTime(), this.getWidth(), this.getHeight());
            }
        } else {
            switch (type) {
                case 422: {
                    this.setValid(false);
                    break;
                }
                case 421: {
                    this.setValid(true);
                    break;
                }
                case 441: {
                    this.inFullscreen = true;
                    break;
                }
                case 442: {
                    this.inFullscreen = false;
                }
            }
            this.handleViewEvent(System.nanoTime(), type);
            if (type == 421 || type == 422) {
                this.handleViewEvent(System.nanoTime(), 433);
            }
        }
    }

    protected void notifyResize(int width, int height) {
        if (this.width == width && this.height == height) {
            return;
        }
        this.width = width;
        this.height = height;
        this.handleViewEvent(System.nanoTime(), 432);
    }

    protected void notifyRepaint(int x, int y, int width, int height) {
        this.dirtyX = x;
        this.dirtyY = y;
        this.dirtyWidth = width;
        this.dirtyHeight = height;
        this.handleViewEvent(431);
    }

    protected void notifyMouse(int type, int button, int x, int y, int xAbs, int yAbs, int modifiers, boolean isPopupTrigger) {
        if (this.window != null && this.window.handleMouseEvent(type, button, x, y, xAbs, yAbs)) {
            return;
        }
        long now = System.nanoTime();
        if (type == 221) {
            View lastClickedView;
            View view = lastClickedView = View.lastClickedView == null ? null : (View)View.lastClickedView.get();
            if (lastClickedView == this && lastClickedButton == button && now - lastClickedTime <= 1000000L * View.getMultiClickTime() && Math.abs(x - lastClickedX) <= View.getMultiClickMaxX() && Math.abs(y - lastClickedY) <= View.getMultiClickMaxY()) {
                ++clickCount;
            } else {
                clickCount = 1;
                View.lastClickedView = new WeakReference<View>(this);
                lastClickedButton = button;
                lastClickedX = x;
                lastClickedY = y;
            }
            lastClickedTime = now;
        }
        this.handleMouseEvent(now, type, button, x, y, xAbs, yAbs, clickCount, modifiers, isPopupTrigger);
        if (type == 223) {
            if (!dragProcessed) {
                this.notifyDragStart(button, x, y, xAbs, yAbs);
                dragProcessed = true;
            }
        } else {
            dragProcessed = false;
        }
    }

    protected void notifyScroll(int x, int y, int xAbs, int yAbs, double deltaX, double deltaY, int modifiers, int lines, int chars, int defaultLines, int defaultChars, double xMultiplier, double yMultiplier) {
        if (this.eventHandler != null) {
            this.eventHandler.handleScrollEvent(this, System.nanoTime(), x, y, xAbs, yAbs, deltaX, deltaY, modifiers, lines, chars, defaultLines, defaultChars, xMultiplier, yMultiplier);
        }
    }

    protected void notifyKey(int type, int keyCode, char[] keyChars, int modifiers) {
        this.handleKeyEvent(System.nanoTime(), type, keyCode, keyChars, modifiers);
    }

    protected void notifyInputMethod(String text, int[] clauseBoundary, int[] attrBoundary, byte[] attrValue, int committedTextLength, int caretPos, int visiblePos) {
        this.handleInputMethodEvent(System.nanoTime(), text, clauseBoundary, attrBoundary, attrValue, committedTextLength, caretPos);
    }

    protected double[] notifyInputMethodCandidatePosRequest(int offset) {
        double[] ret = this.getInputMethodCandidatePos(offset);
        if (ret == null) {
            ret = new double[]{0.0, 0.0};
        }
        return ret;
    }

    protected void notifyDragStart(int button, int x, int y, int xAbs, int yAbs) {
        this.dropSourceAssistant = new ClipboardAssistance("DND"){

            public void actionPerformed(int performedAction) {
                View.this.notifyDragEnd(performedAction);
            }
        };
        this.handleDragStart(button, x, y, xAbs, yAbs, this.dropSourceAssistant);
        if (this.dropSourceAssistant != null) {
            this.dropSourceAssistant.close();
            this.dropSourceAssistant = null;
        }
    }

    protected void notifyDragEnd(int performedAction) {
        this.handleDragEnd(performedAction);
        if (this.dropSourceAssistant != null) {
            this.dropSourceAssistant.close();
            this.dropSourceAssistant = null;
        }
    }

    protected int notifyDragEnter(int x, int y, int xAbs, int yAbs, int recommendedDropAction) {
        this.dropTargetAssistant = new ClipboardAssistance("DND"){

            public void flush() {
                throw new UnsupportedOperationException("Flush is forbidden from target!");
            }
        };
        return this.handleDragEnter(x, y, xAbs, yAbs, recommendedDropAction, this.dropTargetAssistant);
    }

    protected int notifyDragOver(int x, int y, int xAbs, int yAbs, int recommendedDropAction) {
        return this.handleDragOver(x, y, xAbs, yAbs, recommendedDropAction, this.dropTargetAssistant);
    }

    protected void notifyDragLeave() {
        this.handleDragLeave(this.dropTargetAssistant);
        this.dropTargetAssistant.close();
    }

    protected int notifyDragDrop(int x, int y, int xAbs, int yAbs, int recommendedDropAction) {
        int performedAction = this.handleDragDrop(x, y, xAbs, yAbs, recommendedDropAction, this.dropTargetAssistant);
        this.dropTargetAssistant.close();
        return performedAction;
    }

    static {
        dragProcessed = false;
    }

    private static class ViewDisposerRecord
    implements DisposerRecord {
        public volatile long ptr;

        public ViewDisposerRecord(long ptr) {
            this.ptr = ptr;
        }

        public void dispose() {
            if (this.ptr != 0L) {
                // empty if block
            }
        }
    }

    public static final class Capability {
        public static final int k3dKeyValue = 0;
        public static final int kSyncKeyValue = 1;
        public static final int k3dProjectionKeyValue = 2;
        public static final int k3dProjectionAngleKeyValue = 3;
        public static final int k3dDepthKeyValue = 4;
        public static final Object k3dKey = new Integer(0);
        public static final Object kSyncKey = new Integer(1);
        public static final Object k3dProjectionKey = new Integer(2);
        public static final Object k3dProjectionAngleKey = new Integer(3);
        public static final Object k3dDepthKey = new Integer(4);
    }

    public static class EventHandler {
        public void handleViewEvent(View view, long time, int type) {
        }

        public void handleKeyEvent(View view, long time, int action, int keyCode, char[] keyChars, int modifiers) {
        }

        public void handleMouseEvent(View view, long time, int type, int button, int x, int y, int xAbs, int yAbs, int clickCount, int modifiers, boolean isPopupTrigger) {
        }

        public void handleScrollEvent(View view, long time, int x, int y, int xAbs, int yAbs, double deltaX, double deltaY, int modifiers, int lines, int chars, int defaultLines, int defaultChars, double xMultiplier, double yMultiplier) {
        }

        public void handleInputMethodEvent(long time, String text, int[] clauseBoundary, int[] attrBoundary, byte[] attrValue, int commitCount, int cursorPos) {
        }

        public double[] getInputMethodCandidatePos(int offset) {
            return null;
        }

        public void handleDragStart(View view, int button, int x, int y, int xAbs, int yAbs, ClipboardAssistance dropSourceAssistant) {
        }

        public void handleDragEnd(View view, int performedAction) {
        }

        public int handleDragEnter(View view, int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
            return recommendedDropAction;
        }

        public int handleDragOver(View view, int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
            return recommendedDropAction;
        }

        public void handleDragLeave(View view, ClipboardAssistance dropTargetAssistant) {
        }

        public int handleDragDrop(View view, int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
            return 0;
        }
    }
}

