/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class Platform {
    public static String MAC = "Mac";
    public static String WINDOWS = "Win";
    public static String X11 = "X11";
    public static String UNKNOWN = "unknown";
    private static String type = null;

    public static synchronized String DeterminePlatform() {
        if (type == null) {
            String userPlatform = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("glass.platform");
                }
            });
            if (userPlatform != null) {
                type = userPlatform.equals("macosx") ? MAC : (userPlatform.equals("windows") ? WINDOWS : (userPlatform.equals("linux") ? X11 : (userPlatform.equals("x11") ? X11 : userPlatform)));
                return type;
            }
            String osName = System.getProperty("os.name");
            String osNameLowerCase = osName.toLowerCase();
            if (osNameLowerCase.startsWith("mac") || osNameLowerCase.startsWith("darwin")) {
                type = MAC;
            } else if (osNameLowerCase.startsWith("wind")) {
                type = WINDOWS;
            } else if (osNameLowerCase.startsWith("linux")) {
                type = X11;
            }
        }
        return type;
    }
}

