/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.PlatformFactory;
import com.sun.glass.ui.delegate.MenuItemDelegate;

public class MenuItem {
    public static final MenuItem Separator = null;
    private final MenuItemDelegate delegate;
    private String title;
    private Callback callback;
    private boolean enabled;
    private boolean checked;
    private int shortcutKey;
    private int shortcutModifiers;
    private Pixels pixels;

    protected MenuItem(String title) {
        this(title, null);
    }

    protected MenuItem(String title, Callback callback) {
        this(title, callback, 0, 0);
    }

    protected MenuItem(String title, Callback callback, int shortcutKey, int shortcutModifiers) {
        this(title, callback, shortcutKey, shortcutModifiers, null);
    }

    protected MenuItem(String title, Callback callback, int shortcutKey, int shortcutModifiers, Pixels pixels) {
        this.title = title;
        this.callback = callback;
        this.shortcutKey = shortcutKey;
        this.shortcutModifiers = shortcutModifiers;
        this.enabled = true;
        this.checked = false;
        this.delegate = PlatformFactory.getPlatformFactory().createMenuItemDelegate(this);
        if (!this.delegate.createMenuItem(title, callback, shortcutKey, shortcutModifiers, pixels, this.enabled, this.checked)) {
            throw new RuntimeException("MenuItem creation error.");
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (this.delegate.setTitle(title)) {
            this.title = title;
        }
    }

    public Callback getCallback() {
        return this.callback;
    }

    public void setCallback(Callback callback) {
        if (this.delegate.setCallback(callback)) {
            this.callback = callback;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.delegate.setEnabled(enabled)) {
            this.enabled = enabled;
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        if (this.delegate.setChecked(checked)) {
            this.checked = checked;
        }
    }

    public int getShortcutKey() {
        return this.shortcutKey;
    }

    public int getShortcutModifiers() {
        return this.shortcutModifiers;
    }

    public void setShortcut(int shortcutKey, int shortcutModifiers) {
        if (this.delegate.setShortcut(shortcutKey, shortcutModifiers)) {
            this.shortcutKey = shortcutKey;
            this.shortcutModifiers = shortcutModifiers;
        }
    }

    public Pixels getPixels() {
        return this.pixels;
    }

    public void setPixels(Pixels pixels) {
        if (this.delegate.setPixels(pixels)) {
            this.pixels = pixels;
        }
    }

    MenuItemDelegate getDelegate() {
        return this.delegate;
    }

    public static interface Callback {
        public void action();
    }
}

