/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx;

import com.sun.javafx.scene.control.skin.ProgressBarSkin;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;

public class FXProgressBarSkin
extends ProgressBarSkin {
    Rectangle topGradient = new Rectangle(0.0, 0.0, new RadialGradient(0.05, 0.0, 0.5, 0.0, this.gradientRadius, true, CycleMethod.NO_CYCLE, new Stop(0.0, Color.rgb(255, 255, 255, 0.82)), new Stop(0.13, Color.rgb(255, 255, 255, 0.82)), new Stop(0.98, Color.rgb(255, 255, 255, 0.0))));
    Rectangle bottomGradient = new Rectangle(0.0, 0.0, new RadialGradient(0.05, 0.0, 0.5, 1.0, this.gradientRadius, true, CycleMethod.NO_CYCLE, new Stop(0.0, Color.rgb(255, 255, 255, 0.82)), new Stop(0.13, Color.rgb(255, 255, 255, 0.82)), new Stop(0.98, Color.rgb(255, 255, 255, 0.0))));
    Rectangle verticalLines;
    double gradientMargin = 4.0;
    double gradientRadius = 0.55;
    double gradientTweak = 1.4;

    public FXProgressBarSkin(ProgressBar control) {
        super(control);
        this.topGradient.setManaged(false);
        this.bottomGradient.setManaged(false);
        ((StackPane)this.getChildren().get(1)).getChildren().addAll((Node[])new Node[]{this.topGradient, this.bottomGradient});
        this.verticalLines = new Rectangle(0.0, 0.0, new LinearGradient(0.0, 0.0, 14.0, 0.0, false, CycleMethod.REPEAT, new Stop(0.0, Color.TRANSPARENT), new Stop(0.93, Color.TRANSPARENT), new Stop(0.93, Color.rgb(184, 184, 184, 0.2)), new Stop(1.0, Color.rgb(184, 184, 184, 0.2))));
        this.verticalLines.setManaged(false);
        this.getChildren().add(this.verticalLines);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        StackPane bar = (StackPane)this.getChildren().get(1);
        if (!bar.getChildren().contains(this.topGradient)) {
            bar.getChildren().add(this.topGradient);
        }
        if (!bar.getChildren().contains(this.bottomGradient)) {
            bar.getChildren().add(this.bottomGradient);
        }
        if (!this.getChildren().contains(this.verticalLines)) {
            this.getChildren().add(this.verticalLines);
        }
        Insets insets = this.getInsets();
        double x = insets.getLeft();
        double y = insets.getTop();
        double w = this.getWidth() - (insets.getLeft() + insets.getRight());
        double h = this.getHeight() - (insets.getTop() + insets.getBottom());
        double barWidth = bar.getWidth();
        double barHeight = bar.getHeight();
        this.topGradient.setX(x + this.gradientMargin);
        this.topGradient.setY(y + 0.5);
        this.topGradient.setWidth(barWidth - 2.0 * this.gradientMargin);
        this.topGradient.setHeight(barHeight * 0.3 / this.gradientRadius * this.gradientTweak);
        this.bottomGradient.setX(x + this.gradientMargin);
        this.bottomGradient.setWidth(barWidth - 2.0 * this.gradientMargin);
        double gh = barHeight * 0.21 / this.gradientRadius * this.gradientTweak;
        this.bottomGradient.setY(barHeight - gh - 0.5);
        this.bottomGradient.setHeight(gh);
        this.verticalLines.setX(x);
        this.verticalLines.setY(y);
        this.verticalLines.setWidth(w);
        this.verticalLines.setHeight(h);
    }
}

