﻿using AdaptiveSoft.AdaptivePOS.IntegracaoPosSitef.DAO;
using Devart.Data.PostgreSql;
using IntegracaoPosSitef.Models;
using IntegracaoPosSitef.Util;
using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Web.Mvc;
using PagedList;
using System.Threading;
using System.Text;
using System.Security.Cryptography;
using System.Xml;
using System.IO;
using ICSharpCode.SharpZipLib.Zip;

namespace IntegracaoPosSitef.Controllers
{
    public class PetrosController : Controller
    {
        AutenticadorController autenticador = new AutenticadorController();
        string idAtendente = string.Empty;
        private static NLog.Logger logger = NLog.LogManager.GetCurrentClassLogger();
        private const int CARTAO_CREDITO = 4;
        private const int CARTAO_DEBITO = 5;
        private const int DINHEIRO = 1;

        public struct TipoMovimentoVenda
        {
            public const int POR_TERMINAL = 1;
            public const int POR_OPERADOR = 2;
            public const int POR_OPERADOR_COM_CONTROLE_IDENTIFICADOR = 3;
        }

        public struct TipoFiltroAbastecimento
        {
            public const int EXIBE_TODOS = 1;
            public const int GRUPO_TERMINAL = 2;
            public const int GRUPO_MOVIMENTO = 3;
            public const int ATENDENTE = 4;
        }

        public ActionResult Index()
        {
            logger.Trace(string.Empty);
            logger.Debug("Tentando autenticador o POS.");

            if (autenticador.validaBrowser())
            {
                logger.Debug("Página Inicial");

                try
                {
                    LimpaAbastecimentos();
                }
                catch (Exception ex)
                {
                    Object erro = ex.Message;
                    logger.Error(erro);
                    return View("TrataErrosIndex", erro);
                }

                string idTerminalPosWireless = string.Empty;
                string erroValidacao = string.Empty;
                if (!doValidaTerminalPosWireless(out idTerminalPosWireless, out erroValidacao))
                {
                    Object erro = erroValidacao;
                    logger.Error(erro);
                    return View("TrataErrosIndex", erro);
                }

                return View();
            }
            else
                return RedirectToAction("browserInvalido", "Browser");
        }
        public ActionResult ColetaInfoTerminal(Info info)
        {
            logger.Trace(string.Empty);
            logger.Debug("Tentando autenticador o POS.");

            if (autenticador.validaBrowser())
            {
                logger.Debug("Página Inicial");

                try
                {
                    LimpaAbastecimentos();
                }
                catch (Exception ex)
                {
                    Object erro = ex.Message;
                    logger.Error(erro);
                    return View("TrataErrosIndex", erro);
                }

#if DEBUG
                info = new Info();
                info.MODALIDADE_APL = "2";
#endif

                if (!info.MODALIDADE_APL.Equals("2") && !info.MODALIDADE_APL.Equals("3"))
                {
                    Object erro = "Modalidade de aplicacao configura é invalida [" + info.MODALIDADE_APL + (info.MODALIDADE_APL.Equals("1") ? " - Automação Imprime e Confirma" : " - Browser Imprime e Automação Confirma") + "]";
                    logger.Error(erro);
                    return View("TrataErrosIndex", erro);
                }

                ConnectionFactory cf = new ConnectionFactory();
                PgSqlConnection conexao = null;
                try
                {
                    string idTerminalPosWireless = string.Empty;
                    string erroValidacao = string.Empty;
                    if (!doValidaTerminalPosWireless(out idTerminalPosWireless, out erroValidacao))
                    {
                        Object erro = erroValidacao;
                        logger.Error(erro);
                        return View("TrataErrosIndex", erro);
                    }

                    int tipoMovimento = ParametroInteiro("tipo_movimento_venda");

                    List<Usuario> listaUsuarios = new List<Usuario>();
                    logger.Debug("Tentando obter lista de Usuarios.");

                    string SQLListaUsuarios = string.Empty;
                    if (tipoMovimento == 1)
                    {
                        SQLListaUsuarios = @"SELECT  id_usuario,
	                                                nome,
	                                                conta
                                            FROM    usuario
                                            WHERE   registro_excluido = 'N'
                                            AND EXISTS (SELECT 1 FROM movimento_venda WHERE situacao = 1 AND DATE(data_movimento) = CURRENT_DATE)
                                            ORDER BY nome ASC;";
                    }
                    else
                    {
                        SQLListaUsuarios = @"SELECT  id_usuario,
	                                                nome,
	                                                conta
                                            FROM    usuario
                                            WHERE   registro_excluido = 'N'
                                            AND EXISTS (SELECT 1 FROM movimento_venda WHERE situacao = 1 AND DATE(data_movimento) = CURRENT_DATE AND id_usuario = usuario.id_usuario)
                                            ORDER BY nome ASC;";
                    }

                    PgSqlDataReader dr = cf.ObtemComando(SQLListaUsuarios, ref conexao).ExecuteReader();

                    while (dr.Read())
                    {
                        Usuario usuarioList = new Usuario();

                        usuarioList.IdUsuario = (string)dr["id_usuario"];
                        usuarioList.Login = (string)dr["conta"];

                        string nome = dr["nome"].ToString().Length > 17 ? dr["nome"].ToString().Substring(0, 17).ToUpper() : usuarioList.Nome = dr["nome"].ToString().ToUpper();
                        byte[] bytes = System.Text.Encoding.GetEncoding("iso-8859-8").GetBytes(nome);
                        usuarioList.Nome = System.Text.Encoding.UTF8.GetString(bytes);

                        listaUsuarios.Add(usuarioList);
                    }

                    return View("Login", listaUsuarios);
                }
                catch (Exception ex)
                {
                    Object erro = ex.Message;
                    logger.Error(erro);
                    return View("TrataErrosIndex", erro);
                }
                finally
                {
                    cf.FechaConexao(conexao);
                }
            }
            else
                return RedirectToAction("browserInvalido", "Browser");
        }
        public ActionResult LoginInicio(Usuario usuario)
        {
            logger.Trace(string.Empty);
            logger.Debug("Tentando autenticador o POS.");

            if (autenticador.validaBrowser())
            {
                try
                {
                    ConnectionFactory cf = new ConnectionFactory();
                    PgSqlConnection conexao = new PgSqlConnection();
                    try
                    {
                        logger.Debug("Validando senha usuario.");

                        string SQLObtemAbastecimentosSemAtendente = @"SELECT
                                        id_atendente
                                    FROM usuario 
                                    WHERE id_usuario = '" + usuario.IdUsuario + @"'
                                    AND senha_numerica = UPPER(MD5(UPPER(MD5(UPPER(MD5(UPPER(MD5('" + usuario.Senha + "')) || id_usuario ))))));";

                        PgSqlDataReader drUsuario = cf.ObtemComando(SQLObtemAbastecimentosSemAtendente, ref conexao).ExecuteReader();

                        if (drUsuario.Read())
                        {
                            logger.Debug("Usuario logado.");
                            usuario.idUsuarioLogado = usuario.IdUsuario;
                            logger.Debug("idUsuarioLogado=" + usuario.idUsuarioLogado);
                            usuario.idAtendenteLogado = (drUsuario["id_atendente"] is DBNull) ? string.Empty : (string)drUsuario["id_atendente"];
                            logger.Debug("idAtendenteLogado=" + usuario.idAtendenteLogado);

                            return RedirectToAction("ListaAbastecimentos", usuario);
                        }
                        else
                        {
                            logger.Debug("Login invalido.");
                            Object erro = "Login invalido.";
                            return View("TrataErrosIndex", erro);
                        }
                    }
                    catch (Exception ex)
                    {
                        Object erro = "Erro ao verificar login. " + ex.Message;
                        logger.Error("Erro ao verificar login. " + ex.ToString());
                        return View("TrataErrosIndex", erro);
                    }
                    finally
                    {
                        cf.FechaConexao(conexao);
                    }
                }
                catch (Exception ex)
                {
                    logger.Error(ex.ToString());
                    return View("TrataErrosIndex", ex.ToString());
                }
            }
            else
            {
                return RedirectToAction("browserInvalido", "Browser");
            }
        }
        public ActionResult ListaAbastecimentos(Usuario usuario, int? pagina)
        {
            logger.Trace(string.Empty);
            logger.Debug("Tentando autenticador o POS.");

            if (autenticador.validaBrowser())
            {
                List<Abastecimento> listaAbastecimentos = new List<Abastecimento>();

                try
                {
                    LimpaAbastecimentos();
                }
                catch (Exception ex)
                {
                    Object erro = ex.Message;
                    logger.Error(erro);
                    usuario.ErroMensagem = erro.ToString();
                    return View("TrataErrosGenerico", usuario);
                }

                if (usuario.idUsuarioLogado.Equals(string.Empty))
                {
                    logger.Debug("Usuario não identificado voltar para login.");
                    return RedirectToAction("Index");
                }
                if (usuario.idAtendenteLogado == null)
                    usuario.idAtendenteLogado = string.Empty;
                logger.Debug("Buscando abastecimentos livres.");

                PgSqlDataReader drAbastecimentos;
                PgSqlConnection conexao = null;
                ConnectionFactory cf = new ConnectionFactory();
                try
                {
                    #region PESQUISA ABASTECIMENTOS
                    string SQLObtemAbastecimentos = string.Empty;
                    int tipoMovimentoVenda = ParametroInteiro("tipo_movimento_venda");
                    int tipoFiltroAbastecimento = ParametroInteiro("tipo_filtro_abastecimento");

                    if (tipoFiltroAbastecimento == TipoFiltroAbastecimento.EXIBE_TODOS)
                    {
                        if (tipoMovimentoVenda == TipoMovimentoVenda.POR_TERMINAL)
                        {
                            SQLObtemAbastecimentos = @"SELECT
                                        ab.id_abastecimento,
						                ab.total,
						                bc.numero,
						                bc.denominacao
                                FROM 	abastecimento AS ab
                                    INNER JOIN bico_combustivel AS bc ON (ab.id_bico_combustivel = bc.id_bico_combustivel)
                                WHERE   (ab.situacao IN (1, 7))
                                AND     (ab.id_terminal_pos_wireless IS NULL)
                                AND     (ab.id_prevenda IS NULL)
                                AND     (ab.marcador = 'N')
                                AND 	(ab.id_terminal IS NULL OR ab.id_terminal IN (SELECT id_terminal FROM movimento_venda WHERE situacao = 1 AND data_movimento = CURRENT_DATE))
                                ORDER BY data_abastecimento DESC;";
                        }
                        else
                        {
                            SQLObtemAbastecimentos = @"SELECT 
                                        ab.id_abastecimento,
						                ab.total,
						                bc.numero,
						                bc.denominacao
                                FROM	abastecimento AS ab
                                    INNER JOIN bico_combustivel AS bc ON (ab.id_bico_combustivel = bc.id_bico_combustivel)
                                WHERE   (ab.situacao IN (1, 7))
                                AND     (ab.id_terminal_pos_wireless IS NULL)
                                AND     (ab.id_prevenda IS NULL)
                                AND     (ab.marcador = 'N')
                                AND     (ab.id_movimento_venda IS NULL OR ab.id_movimento_venda IN (SELECT id_movimento_venda FROM movimento_venda WHERE situacao = 1 AND data_movimento = CURRENT_DATE AND id_usuario = '" + usuario.idUsuarioLogado + @"'))
                                ORDER BY data_abastecimento DESC;";

                            //          if (usuario.idAtendenteLogado.Equals(string.Empty))
                            //              SQLObtemAbastecimentos += @"AND ab.id_atendente IS NULL
                            //                  ORDER BY data_abastecimento DESC;";
                            //          else
                            //              SQLObtemAbastecimentos += @"AND (ab.id_atendente IS NULL OR ab.id_atendente = '" + usuario.idAtendenteLogado + @"')
                            //ORDER BY data_abastecimento DESC;";
                        }
                    }
                    else if (tipoFiltroAbastecimento == TipoFiltroAbastecimento.GRUPO_TERMINAL)
                    {
                        if (tipoMovimentoVenda == TipoMovimentoVenda.POR_TERMINAL)
                        {
                            SQLObtemAbastecimentos = @"SELECT
                                        ab.id_abastecimento,
						                ab.total,
						                bc.numero,
						                bc.denominacao
                                FROM	abastecimento AS ab
                                    INNER JOIN bico_combustivel AS bc ON (ab.id_bico_combustivel = bc.id_bico_combustivel)
                                WHERE   (ab.situacao IN (1, 7))
                                AND     (ab.id_terminal_pos_wireless IS NULL)
                                AND     (ab.id_prevenda IS NULL)
                                AND     (ab.marcador = 'N')
                                AND 	(((bc.id_grupo_bico IN (SELECT id_grupo_bico FROM terminal WHERE id_terminal IN (SELECT id_terminal FROM movimento_venda WHERE situacao = 1 AND data_movimento = CURRENT_DATE)))
                                        AND (ab.id_terminal IS NULL)) OR (ab.id_terminal IN (SELECT id_terminal FROM movimento_venda WHERE situacao = 1 AND data_movimento = CURRENT_DATE)))
                                ORDER BY data_abastecimento DESC;";
                        }
                        else
                        {
                            SQLObtemAbastecimentos = @"SELECT	
                                        ab.id_abastecimento,
						                ab.total,
						                bc.numero,
						                bc.denominacao
                                FROM	abastecimento AS ab
                                    INNER JOIN bico_combustivel AS bc ON (ab.id_bico_combustivel = bc.id_bico_combustivel)
                                WHERE   (ab.situacao IN (1, 7))
                                AND     (ab.id_terminal_pos_wireless IS NULL)
                                AND     (ab.id_prevenda IS NULL)
                                AND     (ab.marcador = 'N')
                                AND 	(((bc.id_grupo_bico IN (SELECT id_grupo_bico FROM terminal WHERE id_terminal IN (SELECT id_terminal FROM movimento_venda WHERE situacao = 1 AND data_movimento = CURRENT_DATE AND id_usuario = '" + usuario.idUsuarioLogado + @"')))
                                        AND (ab.id_movimento_venda IS NULL)) OR (ab.id_movimento_venda IN (SELECT id_movimento_venda FROM movimento_venda WHERE situacao = 1 AND data_movimento = CURRENT_DATE AND id_usuario = '" + usuario.idUsuarioLogado + @"'))) 
                                ORDER BY data_abastecimento DESC;";

                            //          if (usuario.idAtendenteLogado.Equals(string.Empty))
                            //              SQLObtemAbastecimentos += @"AND ab.id_atendente IS NULL
                            //                  ORDER BY data_abastecimento DESC;";
                            //          else
                            //              SQLObtemAbastecimentos += @"AND (ab.id_atendente IS NULL OR ab.id_atendente = '" + usuario.idAtendenteLogado + @"')
                            //ORDER BY data_abastecimento DESC;";
                        }
                    }
                    else if (tipoFiltroAbastecimento == TipoFiltroAbastecimento.GRUPO_MOVIMENTO)
                    {
                        if (tipoMovimentoVenda == TipoMovimentoVenda.POR_TERMINAL)
                        {
                            SQLObtemAbastecimentos = @"SELECT	
                                        ab.id_abastecimento,
						                ab.total,
						                bc.numero,
						                bc.denominacao
                                FROM	abastecimento AS ab
                                    INNER JOIN bico_combustivel AS bc ON (ab.id_bico_combustivel = bc.id_bico_combustivel)
                                WHERE   (ab.situacao IN (1, 7))
                                AND     (ab.id_terminal_pos_wireless IS NULL)
                                AND     (ab.id_prevenda IS NULL)
                                AND     (ab.marcador = 'N')
                                AND 	(((bc.id_grupo_bico IN (SELECT id_grupo_bico FROM movimento_venda WHERE situacao = 1 AND data_movimento = CURRENT_DATE))
                                        AND (ab.id_terminal IS NULL)) OR (ab.id_terminal IN (SELECT id_terminal FROM movimento_venda WHERE situacao = 1 AND data_movimento = CURRENT_DATE))) 
                                ORDER BY data_abastecimento DESC;";
                        }
                        else
                        {
                            SQLObtemAbastecimentos = @"SELECT	
                                        ab.id_abastecimento,
						                ab.total,
						                bc.numero,
						                bc.denominacao
                                FROM	abastecimento AS ab
                                    INNER JOIN bico_combustivel AS bc ON (ab.id_bico_combustivel = bc.id_bico_combustivel)
                                WHERE   (ab.situacao IN (1, 7))
                                AND     (ab.id_terminal_pos_wireless IS NULL)
                                AND     (ab.id_prevenda IS NULL)
                                AND     (ab.marcador = 'N')
                                AND 	(((bc.id_grupo_bico IN (SELECT id_grupo_bico FROM movimento_venda WHERE situacao = 1 AND data_movimento = CURRENT_DATE AND id_usuario = '" + usuario.idUsuarioLogado + @"'))
                                        AND (ab.id_movimento_venda IS NULL)) OR (ab.id_movimento_venda IN (SELECT id_movimento_venda FROM movimento_venda WHERE situacao = 1 AND data_movimento = CURRENT_DATE AND id_usuario = '" + usuario.idUsuarioLogado + @"'))) 
                                ORDER BY data_abastecimento DESC;";

                            //          if (usuario.idAtendenteLogado.Equals(string.Empty))
                            //              SQLObtemAbastecimentos += @"AND ab.id_atendente IS NULL
                            //                  ORDER BY data_abastecimento DESC;";
                            //          else
                            //              SQLObtemAbastecimentos += @"AND (ab.id_atendente IS NULL OR ab.id_atendente = '" + usuario.idAtendenteLogado + @"')
                            //ORDER BY data_abastecimento DESC;";
                        }
                    }
                    else
                    {
                        SQLObtemAbastecimentos = @"SELECT	
                                        ab.id_abastecimento,
						                ab.total,
						                bc.numero,
						                bc.denominacao
                            FROM	abastecimento AS ab
                                INNER JOIN bico_combustivel AS bc ON (ab.id_bico_combustivel = bc.id_bico_combustivel)
                            WHERE   (ab.situacao IN (1, 7))
                            AND     (ab.id_terminal_pos_wireless IS NULL)
                            AND     (ab.id_prevenda IS NULL)
                            AND     (ab.marcador = 'N')
                            AND 	(ab.id_atendente = '" + usuario.idAtendenteLogado + @"' OR ab.id_atendente IS NULL)
                            ORDER BY data_abastecimento DESC;";
                    }

                    drAbastecimentos = cf.ObtemComando(SQLObtemAbastecimentos, ref conexao).ExecuteReader();
                    #endregion


                    logger.Debug("Tentando obter lista de abastecimentos.");

                    while (drAbastecimentos.Read())
                    {
                        Abastecimento abastecimento = new Abastecimento();

                        abastecimento.idAbastecimento = drAbastecimentos["id_abastecimento"] as int?;
                        abastecimento.total = Math.Round((decimal)drAbastecimentos["total"], 2);
                        abastecimento.numeroBico = (int)drAbastecimentos["numero"];
                        abastecimento.denominacaoBico = (string)drAbastecimentos["denominacao"];
                        abastecimento.idUsuarioLogado = usuario.idUsuarioLogado;
                        abastecimento.idAtendenteLogado = usuario.idAtendenteLogado;

                        listaAbastecimentos.Add(abastecimento);
                    }

                    if (listaAbastecimentos.Count == 0)
                    {
                        Object erro = "Nenhum abastecimento disponível. Verifique se está sendo recebido em outro terminal.";
                        logger.Error(erro);
                        usuario.ErroMensagem = erro.ToString();
                        return View("TrataErrosGenerico", usuario);
                    }

                    int paginaTamanho = 10;
                    int paginaNumero = (pagina ?? 1);
                    logger.Debug("Pagina: " + paginaNumero);

                    logger.Debug("Lista de abastecimentos obtida mostrando na tela do POS.");
                    return View(listaAbastecimentos.ToPagedList(paginaNumero, paginaTamanho));
                }
                catch (Exception ex)
                {
                    Object erro = ex.Message;
                    logger.Error(erro);
                    usuario.ErroMensagem = erro.ToString();
                    return View("TrataErrosGenerico", usuario);
                }
                finally
                {
                    cf.FechaConexao(conexao);
                }
            }
            else
            {
                return RedirectToAction("browserInvalido", "Browser");
            }
        }
        public ActionResult CnpjCpf(Abastecimento abastecimento)
        {
            logger.Trace(string.Empty);
            logger.Debug("Tentando autenticador o POS.");

            if (autenticador.validaBrowser())
            {
                ConnectionFactory cf = new ConnectionFactory();
                PgSqlConnection conexao = new PgSqlConnection();

                string idTerminalPosWireless = string.Empty;
                string erroValidacao = string.Empty;

                try
                {
                    logger.Debug("idUsuarioLogado=" + abastecimento.idUsuarioLogado);
                    logger.Debug("idAtendenteLogado=" + abastecimento.idAtendenteLogado);
                    if (abastecimento.idUsuarioLogado.Equals(string.Empty))
                    {
                        logger.Debug("Usuario não identificado voltar para login.");
                        return RedirectToAction("Index");
                    }
                    if (abastecimento.idAtendenteLogado == null)
                        abastecimento.idAtendenteLogado = string.Empty;

                    if (!doValidaTerminalPosWireless(out idTerminalPosWireless, out erroValidacao))
                    {
                        Object erro = erroValidacao;
                        logger.Error(erro);
                        Usuario usuario = new Usuario();
                        usuario.ErroMensagem = erro.ToString();
                        usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                        usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                        return View("TrataErrosGenerico", usuario);
                    }

                    logger.Debug("Tentando atualizar e bloquear o abastecimento=[" + abastecimento.idAbastecimento + "].");

                    string SQLBloqueiaAbastecimento = @"UPDATE abastecimento
                                            SET id_terminal_pos_wireless = '" + idTerminalPosWireless + @"' 
                                            WHERE id_abastecimento = " + abastecimento.idAbastecimento + @"
                                            AND id_terminal_pos_wireless IS NULL
                                            AND id_prevenda IS NULL
                                            AND situacao IN (1, 7)
                                            AND marcador = 'N'
                                            AND emitir_venda = 'N'
                                            AND id_forma_recebimento_tef IS NULL
                                            AND COALESCE(codigo_bandeira_tef, '') = ''
                                            AND COALESCE(codigo_rede_tef, '') = ''
                                            AND COALESCE(codigo_tipo_transacao_tef, '') = ''
                                            AND (NOT EXISTS (SELECT 1 FROM item_venda AS iv
			                                                INNER JOIN venda AS v ON (v.id_venda = iv.id_venda)
		                                                    WHERE	iv.id_abastecimento = abastecimento.id_abastecimento
		                                                    AND	    iv.cancelado = 'N'
                	                                        AND	    v.situacao <> 4))
                                            AND (NOT EXISTS (SELECT 1 FROM afericao
		                                                    WHERE	id_abastecimento = abastecimento.id_abastecimento
		                                                    AND	    cancelado = 'N'));";

                    cf.ExecutaComando(SQLBloqueiaAbastecimento, ref conexao);

                    logger.Debug("Conferindo o bloqueio.");

                    string SQLConfereBloqueio = @"SELECT    1
                                                FROM    abastecimento
                                                WHERE   id_terminal_pos_wireless = '" + idTerminalPosWireless + @"'
                                                AND     id_abastecimento = " + abastecimento.idAbastecimento + ";";

                    PgSqlDataReader drAbatecimento = cf.ObtemComando(SQLConfereBloqueio, ref conexao).ExecuteReader();

                    if (drAbatecimento.Read())
                    {
                        logger.Debug("Abastecimento =[" + abastecimento.idAbastecimento + "] atualizado.");
                        logger.Debug("Abastecimento bloqueado para uso do TEF.");
                    }
                    else
                    {
                        Object erro = "Abastecimento nao disponivel. Verifique se o mesmo esta sendo recebido em outro terminal.";
                        logger.Error(erro);
                        Usuario usuario = new Usuario();
                        usuario.ErroMensagem = erro.ToString();
                        usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                        usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                        return View("TrataErrosGenerico", usuario);
                    }

                    logger.Debug("Verifica se abastecimento tem Cliente.");
                    string SQLObtemAbastecimento = @"SELECT * FROM abastecimento WHERE id_abastecimento = " + abastecimento.idAbastecimento + ";";

                    PgSqlDataReader drAbastecimento = cf.ObtemComando(SQLObtemAbastecimento, ref conexao).ExecuteReader();

                    if (drAbastecimento.Read())
                    {
                        if (!(drAbastecimento["id_cliente"] is DBNull))
                        {
                            logger.Debug("Abastecimento com cliente. id_cliente=" + (string)drAbastecimento["id_cliente"]);
                            string parametro = ParametroAlfanumerico("permitir_informar_cnpj_cpf_abastecimento_identificado_tefwifi");
                            logger.Debug("permitir_informar_cnpj_cpf_abastecimento_identificado_tefwifi=" + parametro);

                            if (parametro.Equals("S"))
                            {
                                logger.Debug("Verificando cnpj_cpf do cliente");
                                string SQLObtemCliente = @"SELECT cnpj_cpf FROM cliente WHERE id_cliente = '" + (string)drAbastecimento["id_cliente"] + "';";

                                PgSqlDataReader drCliente = cf.ObtemComando(SQLObtemAbastecimento, ref conexao).ExecuteReader();

                                drCliente.Read();

                                if (!(drCliente["cnpj_cpf"] is DBNull) && !((string)drCliente["cnpj_cpf"]).Equals(string.Empty))
                                {
                                    logger.Debug("cnpj_cpf=" + (string)drCliente["cnpj_cpf"]);
                                    return RedirectToAction("Baixa", abastecimento);
                                }
                                else
                                    logger.Debug("Cliente sem cnpj_cpf");
                            }
                            else
                                return RedirectToAction("Baixa", abastecimento);
                        }
                        else
                            logger.Debug("Abastecimento sem cliente.");
                    }

                    return View(abastecimento);
                }
                catch (Exception ex)
                {
                    logger.Error(ex.ToString());
                    Usuario usuario = new Usuario();
                    usuario.ErroMensagem = ex.ToString();
                    usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                    usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                    return View("TrataErrosGenerico", usuario);
                }
                finally
                {
                    cf.FechaConexao(conexao);
                }
            }
            else
            {
                return RedirectToAction("browserInvalido", "Browser");
            }
        }
        public ActionResult Baixa(Abastecimento abastecimento)
        {
            logger.Trace(string.Empty);
            logger.Debug("Tentando autenticador o POS.");

            if (autenticador.validaBrowser())
            {
                ConnectionFactory cf = new ConnectionFactory();
                PgSqlConnection conexao = new PgSqlConnection();
                try
                {
                    logger.Debug("idUsuarioLogado=" + abastecimento.idUsuarioLogado);
                    logger.Debug("idAtendenteLogado=" + abastecimento.idAtendenteLogado);
                    if (abastecimento.idUsuarioLogado.Equals(string.Empty))
                    {
                        logger.Debug("Usuario não identificado voltar para login.");
                        return RedirectToAction("Index");
                    }
                    if (abastecimento.idAtendenteLogado == null)
                        abastecimento.idAtendenteLogado = string.Empty;

                    const int TIPO_TEF = 3;
                    IniciaTransacao iniciaTransacao = new IniciaTransacao();

                    string idTerminalPosWireless = string.Empty;
                    string erroValidacao = string.Empty;
                    bool pagamentoCredito = true;
                    bool pagamentoCreditoParcelado = false;
                    bool pagamentoDebito = true;
                    bool pagamentoDinheiro = true;
                    string idCliente = string.Empty;

                    if (!doValidaTerminalPosWireless(out idTerminalPosWireless, out erroValidacao))
                    {
                        Object erro = erroValidacao;
                        logger.Error(erro);
                        Usuario usuario = new Usuario();
                        usuario.ErroMensagem = erro.ToString();
                        usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                        usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                        return View("TrataErrosGenerico", usuario);
                    }

                    logger.Debug("Validando CNPJ/CPF.");

                    if (abastecimento.cnpjCpf != null && !abastecimento.cnpjCpf.Equals(string.Empty))
                    {
                        logger.Debug("CNPJ/CPF=" + abastecimento.cnpjCpf);

                        string mensagem = string.Empty;
                        if (abastecimento.cnpjCpf.Length == 11 && !validaCPF(abastecimento.cnpjCpf, ref mensagem))
                        {
                            abastecimento.MensagemErro = mensagem;
                            logger.Debug(abastecimento.MensagemErro);
                            return View("TrataErrosCnpjCpf", abastecimento);
                        }
                        else if (abastecimento.cnpjCpf.Length == 14 && !validaCNPJ(abastecimento.cnpjCpf, ref mensagem))
                        {
                            abastecimento.MensagemErro = mensagem;
                            logger.Debug(abastecimento.MensagemErro);
                            return View("TrataErrosCnpjCpf", abastecimento);
                        }
                        else if (abastecimento.cnpjCpf.Length != 11 && abastecimento.cnpjCpf.Length != 14)
                        {
                            abastecimento.MensagemErro = "A quantidade de caracteres do CNPJ/CPF informado é inválida.";
                            logger.Debug(abastecimento.MensagemErro);
                            return View("TrataErrosCnpjCpf", abastecimento);
                        }
                    }
                    else
                        logger.Debug("CNPJ/CPF não informado pelo operador.");

                    if (abastecimento.cnpjCpf != null && !abastecimento.cnpjCpf.Equals(string.Empty))
                    {
                        logger.Debug("Tentando atualizar com CNPJ/CPF o abastecimento=[" + abastecimento.idAbastecimento + "].");

                        string SQLBloqueiaAbastecimento = @"UPDATE abastecimento
                                        SET cnpj_cpf = '" + abastecimento.cnpjCpf + @"',
                                            id_cliente = NULL,
                                            id_veiculo_cliente = NULL
                                        WHERE id_abastecimento = " + abastecimento.idAbastecimento + ";";

                        cf.ExecutaComando(SQLBloqueiaAbastecimento, ref conexao);

                        logger.Debug("Abastecimento =[" + abastecimento.idAbastecimento + "] atualizado com CNPJ/CPF.");
                    }

                    logger.Debug("Conferindo o bloqueio. idAbastecimento=" + abastecimento.idAbastecimento);

                    string SQLConfereBloqueio = @"SELECT    1
                                                FROM    abastecimento
                                                WHERE   id_terminal_pos_wireless = '" + idTerminalPosWireless + @"'
                                                AND     situacao IN (1, 7)
                                                AND     id_abastecimento = " + abastecimento.idAbastecimento + ";";

                    PgSqlDataReader drAbatecimento = cf.ObtemComando(SQLConfereBloqueio, ref conexao).ExecuteReader();

                    if (drAbatecimento.Read())
                    {
                        logger.Debug("Abastecimento bloqueado para uso do TEF.");
                    }
                    else
                    {
                        Object erro = "Nenhum abastecimento disponivel. Verifique se o mesmo está sendo recebido em outro terminal.";
                        logger.Error(erro);
                        Usuario usuario = new Usuario();
                        usuario.ErroMensagem = erro.ToString();
                        usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                        usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                        return View("TrataErrosGenerico", usuario);
                    }

                    logger.Debug("Obtendo dados do abastecimento.");

                    string SQLObtemAbastecimento = @"SELECT * FROM abastecimento WHERE id_abastecimento = " + abastecimento.idAbastecimento + ";";

                    PgSqlDataReader drAbastecimento = cf.ObtemComando(SQLObtemAbastecimento, ref conexao).ExecuteReader();

                    drAbastecimento.Read();

                    logger.Debug("Obtendo dados da venda.");

                    string SQLDadosVenda = @"SELECT
                                        it.descricao,
                                        bc.numero,
                                        bc.permite_recebimento_cartao_credito,
                                        bc.permite_recebimento_cartao_debito,
                                        bc.permite_recebimento_especie
                                    FROM item AS it
                                        INNER JOIN local_estoque AS le ON (le.id_item_tanque = it.id_item)
	                                    INNER JOIN bico_combustivel AS bc ON (bc.id_tanque = le.id_local_estoque)
                                    WHERE bc.id_bico_combustivel = '" + (string)drAbastecimento["id_bico_combustivel"] + "';";

                    PgSqlDataReader drItem = cf.ObtemComando(SQLDadosVenda, ref conexao).ExecuteReader();

                    drItem.Read();

                    logger.Debug("Validando dados do abastecimento.");

                    if (((int)drAbastecimento["situacao"] != 1 && (int)drAbastecimento["situacao"] != 7) || (drAbastecimento["id_terminal_pos_wireless"] is DBNull))
                    {
                        Object erro = "Nenhum abastecimento disponível. Verifique se o mesmo está sendo recebido em outro terminal.";
                        logger.Error(erro);
                        Usuario usuario = new Usuario();
                        usuario.ErroMensagem = erro.ToString();
                        usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                        usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                        return View("TrataErrosGenerico", usuario);
                    }

                    logger.Debug("Carregando dados a serem mostrados no POS.");

                    abastecimento.idAbastecimento = (int)drAbastecimento["id_abastecimento"];

                    string denominacaoBico = (string)drItem["descricao"];
                    byte[] bytes = System.Text.Encoding.GetEncoding("iso-8859-8").GetBytes(denominacaoBico);

                    abastecimento.denominacaoBico = System.Text.Encoding.UTF8.GetString(bytes);
                    abastecimento.numeroBico = (int)drItem["numero"];
                    abastecimento.situacaoAbastecimento = (int)drAbastecimento["situacao"];
                    abastecimento.id_terminal_pos_wireless = idTerminalPosWireless;
                    abastecimento.preco = (decimal)drAbastecimento["preco"];
                    abastecimento.quantidade = (decimal)drAbastecimento["quantidade"];
                    abastecimento.total = (decimal)drAbastecimento["total"];

                    if (!((string)drAbastecimento["cnpj_cpf"]).Equals(string.Empty))
                    {
                        logger.Debug("Verificando se existe cliente com CNPJ/CPF do abastecimento.");
                        logger.Debug("cnpj_cpf=" + (string)drAbastecimento["cnpj_cpf"]);

                        string SQLCliente = @"SELECT id_cliente FROM cliente
                                                WHERE cnpj_cpf = '" + (string)drAbastecimento["cnpj_cpf"] + "';";

                        PgSqlDataReader drCliente = cf.ObtemComando(SQLCliente, ref conexao).ExecuteReader();

                        if (drCliente.Read())
                            idCliente = (string)drCliente["id_cliente"];
                    }

                    logger.Debug("id_cliente=" + (drAbastecimento["id_cliente"] is DBNull ? string.Empty : (string)drAbastecimento["id_cliente"]));
                    logger.Debug("idCliente=" + idCliente);
                    if (idCliente.Equals(string.Empty) && !(drAbastecimento["id_cliente"] is DBNull))
                        idCliente = (string)drAbastecimento["id_cliente"];

                    if (string.IsNullOrEmpty(idCliente))
                    {
                        idCliente = ParametroAlfanumerico("id_consumidor_padrao");
                        logger.Debug("Utilizando consumidor padrão.");
                    }

                    if (!string.IsNullOrEmpty(idCliente))
                    {
                        logger.Debug("Verificando restrição de pagamento do cliente.");
                        logger.Debug("idCliente=" + idCliente);

                        string SQLRestricaoCliente = @"SELECT * FROM restricao_cliente_forma_recebimento
                                                        WHERE id_cliente = '" + idCliente + "';";

                        PgSqlDataReader drRestricaoCliente = cf.ObtemComando(SQLRestricaoCliente, ref conexao).ExecuteReader();

                        if (drRestricaoCliente.Read())
                        {
                            Object erro = "Cliente tem restricao de Forma de Recebimento, não pode ser baixado no TEF WIFI.";
                            logger.Error(erro);
                            Usuario usuario = new Usuario();
                            usuario.ErroMensagem = erro.ToString();
                            usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                            usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                            return View("TrataErrosGenerico", usuario);
                        }

                        pagamentoCredito = false;
                        pagamentoDebito = false;
                        pagamentoDinheiro = false;

                        SQLRestricaoCliente = @"SELECT restringir_tipo_recebimento FROM cliente
                                                WHERE id_cliente = '" + idCliente + "';";

                        drRestricaoCliente = cf.ObtemComando(SQLRestricaoCliente, ref conexao).ExecuteReader();

                        bool habilitaRestricaoCliente = false;

                        if (drRestricaoCliente.Read())
                            habilitaRestricaoCliente = ((string)drRestricaoCliente["restringir_tipo_recebimento"]).Equals("S");

                        logger.Debug("habilitaRestricaoCliente=" + habilitaRestricaoCliente);
                        if (habilitaRestricaoCliente)
                        {
                            SQLRestricaoCliente = @"SELECT id_tipo_recebimento FROM restricao_tipo_recebto_cliente
                                                        WHERE id_cliente = '" + idCliente + "';";

                            drRestricaoCliente = cf.ObtemComando(SQLRestricaoCliente, ref conexao).ExecuteReader();

                            while (drRestricaoCliente.Read())
                            {
                                if (((int)drRestricaoCliente["id_tipo_recebimento"]) == CARTAO_CREDITO)
                                {
                                    pagamentoCredito = true;
                                }
                                else if (((int)drRestricaoCliente["id_tipo_recebimento"]) == CARTAO_DEBITO)
                                {
                                    pagamentoDebito = true;
                                }
                                else if (((int)drRestricaoCliente["id_tipo_recebimento"]) == DINHEIRO)
                                {
                                    pagamentoDinheiro = true;
                                }
                            }
                        }
                        else
                        {
                            pagamentoCredito = true;
                            pagamentoDebito = true;
                            pagamentoDinheiro = true;
                        }
                    }

                    logger.Debug("pagamentoCredito=" + pagamentoCredito);
                    logger.Debug("pagamentoDebito=" + pagamentoDebito);
                    logger.Debug("pagamentoDinheiro=" + pagamentoDinheiro);

                    logger.Debug("Verificando bloqueio de pagamento do Bico.");

                    if (((string)drItem["permite_recebimento_cartao_credito"]).Equals("N"))
                    {
                        pagamentoCredito = false;
                    }

                    if (((string)drItem["permite_recebimento_cartao_debito"]).Equals("N"))
                    {
                        pagamentoDebito = false;
                    }

                    if (((string)drItem["permite_recebimento_especie"]).Equals("N"))
                    {
                        pagamentoDinheiro = false;
                    }

                    logger.Debug("pagamentoCredito=" + pagamentoCredito);
                    logger.Debug("pagamentoDebito=" + pagamentoDebito);
                    logger.Debug("pagamentoDinheiro=" + pagamentoDinheiro);

                    logger.Debug("Verificando existencia de forma de recebimento para o tipo de recebimento.");

                    if (pagamentoCredito)
                    {
                        string SQLFormaRecebimento = @"SELECT 	1
                                                        FROM 	forma_recebimento
                                                        WHERE 	id_tipo_recebimento = 4 LIMIT 1;";

                        PgSqlDataReader drFormaRecebimento = cf.ObtemComando(SQLFormaRecebimento, ref conexao).ExecuteReader();

                        if (!drFormaRecebimento.Read())
                            pagamentoCredito = false;
                        else
                        {
                            SQLFormaRecebimento = @"SELECT 	1
                                                    FROM 	forma_recebimento
                                                    WHERE 	id_tipo_recebimento = 4 
                                                    AND		permite_parcelamento = 'S' LIMIT 1;";

                            drFormaRecebimento = cf.ObtemComando(SQLFormaRecebimento, ref conexao).ExecuteReader();

                            if (drFormaRecebimento.Read())
                                pagamentoCreditoParcelado = true;
                        }
                    }

                    if (pagamentoDebito)
                    {
                        string SQLFormaRecebimento = @"SELECT 	1
                                                        FROM 	forma_recebimento
                                                        WHERE 	id_tipo_recebimento = 5 LIMIT 1;";

                        PgSqlDataReader drFormaRecebimento = cf.ObtemComando(SQLFormaRecebimento, ref conexao).ExecuteReader();

                        if (!drFormaRecebimento.Read())
                            pagamentoDebito = false;
                    }

                    if (pagamentoDinheiro)
                    {
                        string SQLFormaRecebimento = @"SELECT 	1
                                                        FROM 	forma_recebimento
                                                        WHERE 	id_tipo_recebimento = 1 LIMIT 1;";

                        PgSqlDataReader drFormaRecebimento = cf.ObtemComando(SQLFormaRecebimento, ref conexao).ExecuteReader();

                        if (!drFormaRecebimento.Read())
                            pagamentoDinheiro = false;
                    }

                    logger.Debug("pagamentoCredito=" + pagamentoCredito);
                    logger.Debug("pagamentoCreditoParcelado=" + pagamentoCreditoParcelado);
                    logger.Debug("pagamentoDebito=" + pagamentoDebito);
                    logger.Debug("pagamentoDinheiro=" + pagamentoDinheiro);

                    logger.Debug("abastecimento.total.ToString(N2)=" + abastecimento.total.ToString("N2"));

                    logger.Debug("Valida permissão parcelamento TEF e Dinheiro.");

                    if (ParametroAlfanumerico("permite_parcelamento_tef_wifi").Equals("N"))
                        pagamentoCreditoParcelado = false;

                    if (ParametroAlfanumerico("permite_pagamento_dinheiro_tef_wifi").Equals("N"))
                        pagamentoDinheiro = false;

                    logger.Debug("pagamentoDinheiro=" + pagamentoDinheiro);
                    logger.Debug("pagamentoCreditoParcelado=" + pagamentoCreditoParcelado);

                    logger.Debug("Obtendo dados do TEF.");
                    string[] configuracaoSITEF = new string[0];
                    string loja = string.Empty;

                    string SQLDadosTEF = @"SELECT * FROM concentrador_tef WHERE id_tipo_concentrador_tef = " + TIPO_TEF + " AND registro_excluido = 'N';";

                    PgSqlDataReader dr = cf.ObtemComando(SQLDadosTEF, ref conexao).ExecuteReader();

                    if (dr.Read())
                    {
                        logger.Debug("Validando dados do TEF.");
                        do
                        {
                            string configuracao = (string)dr["configuracao"];
                            configuracaoSITEF = configuracao.Split(new string[] { ";" }, StringSplitOptions.None);
                            foreach (string config in configuracaoSITEF)
                            {
                                if (config.Contains("LOJA"))
                                {
                                    string[] detalhe = config.Split(new string[] { "=" }, StringSplitOptions.None);
                                    loja = detalhe[1].Trim();
                                    break;
                                }
                            }

                        } while (dr.Read());

                        if (loja.Equals(string.Empty))
                        {
                            Object erro = "Configuração do TEF no Petros inválida.";
                            logger.Error(erro);
                            Usuario usuario = new Usuario();
                            usuario.ErroMensagem = erro.ToString();
                            usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                            usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                            return View("TrataErrosGenerico", usuario);
                        }

                        logger.Debug("Carregando dados da transação.");

                        string transacaoHabilitada = string.Empty;

                        if (pagamentoDebito)
                            transacaoHabilitada += "16";//16: Débito à vista;

                        if (pagamentoCredito)
                        {
                            if (!transacaoHabilitada.Equals(string.Empty))
                                transacaoHabilitada += ";";
                            //26: Crédito à vista; 
                            //27: Cartão de crédito parcelado com financiamento do estabelecimento;
                            //28: Cartão de crédito parcelado com financiamento da administradora
                            transacaoHabilitada += "26";

                            if (pagamentoCreditoParcelado)
                                transacaoHabilitada += ";27;28";
                        }

                        iniciaTransacao.abastecimento = abastecimento;
                        iniciaTransacao.empresa = loja;
                        iniciaTransacao.tipoTransacao = "1"; // Transacao Financeira
                        iniciaTransacao.transacaoHabilitada = transacaoHabilitada;
                        iniciaTransacao.codCliente = "";
                        iniciaTransacao.compCupom = "";
                        iniciaTransacao.compData = "";
                        iniciaTransacao.compHora = "";
                        iniciaTransacao.imp01 = "";
                        iniciaTransacao.sac01 = abastecimento.idAbastecimento.ToString();
                        iniciaTransacao.sac02 = abastecimento.idUsuarioLogado;
                        iniciaTransacao.sac03 = abastecimento.idAtendenteLogado;
                        iniciaTransacao.pagamentoDinheiro = pagamentoDinheiro;
                        iniciaTransacao.pagamentoDebito = pagamentoDebito;
                        iniciaTransacao.pagamentoCredito = pagamentoCredito;
                        iniciaTransacao.pagamentoCreditoParcelado = pagamentoCreditoParcelado;

                        logger.Debug("Enviando transação para o POS - Selecionar Tipo de Pagamento");
                        return View(iniciaTransacao);
                    }
                    else
                    {
                        Object erro = "Não foi encontrado nenhum TEF compatível com o SITEF. Verifique as configurações do TEF.";
                        logger.Error(erro);
                        Usuario usuario = new Usuario();
                        usuario.ErroMensagem = erro.ToString();
                        usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                        usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                        return View("TrataErrosGenerico", usuario);
                    }
                }
                catch (Exception ex)
                {
                    logger.Error(ex.ToString());
                    Usuario usuario = new Usuario();
                    usuario.ErroMensagem = ex.ToString();
                    usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                    usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                    return View("TrataErrosGenerico", usuario);
                }
                finally
                {
                    cf.FechaConexao(conexao);
                }
            }
            else
            {
                return RedirectToAction("browserInvalido", "Browser");
            }
        }
        public ActionResult BaixaConfirma(IniciaTransacao iniciaTransacao)
        {
            logger.Trace(string.Empty);
            logger.Debug("Tentando autenticador o POS.");

            if (autenticador.validaBrowser())
            {
                ConnectionFactory cf = new ConnectionFactory();
                PgSqlConnection conexao = new PgSqlConnection();
                try
                {
                    logger.Debug("idUsuarioLogado=" + iniciaTransacao.sac02);
                    logger.Debug("idAtendenteLogado=" + iniciaTransacao.sac03);
                    if (iniciaTransacao.sac02.Equals(string.Empty))
                    {
                        logger.Debug("Usuario não identificado voltar para login.");
                        return RedirectToAction("Index");
                    }
                    if (iniciaTransacao.sac03 == null)
                        iniciaTransacao.sac03 = string.Empty;

                    string idTerminalPosWireless = string.Empty;
                    string erroValidacao = string.Empty;
                    iniciaTransacao.abastecimento = new Abastecimento();

                    if (!doValidaTerminalPosWireless(out idTerminalPosWireless, out erroValidacao))
                    {
                        Object erro = erroValidacao;
                        logger.Error(erro);
                        Usuario usuario = new Usuario();
                        usuario.ErroMensagem = erro.ToString();
                        usuario.idUsuarioLogado = iniciaTransacao.sac02;
                        usuario.idAtendenteLogado = iniciaTransacao.sac03;
                        return View("TrataErrosGenerico", usuario);
                    }

                    logger.Debug("iniciaTransacao.sac01=" + iniciaTransacao.sac01);
                    logger.Debug("iniciaTransacao.sac02=" + iniciaTransacao.sac02);
                    logger.Debug("iniciaTransacao.sac03=" + iniciaTransacao.sac03);

                    logger.Debug("iniciaTransacao.abastecimento.TipoRecebimento=" + iniciaTransacao.tipoRecebimento);
                    logger.Debug("iniciaTransacao.pagamentoCredito=" + iniciaTransacao.pagamentoCredito);
                    logger.Debug("iniciaTransacao.pagamentoCreditoParcelado=" + iniciaTransacao.pagamentoCreditoParcelado);
                    logger.Debug("iniciaTransacao.pagamentoDebito=" + iniciaTransacao.pagamentoDebito);
                    logger.Debug("iniciaTransacao.pagamentoDinheiro=" + iniciaTransacao.pagamentoDinheiro);

                    logger.Debug("Verificar tipo Recebimento Troco");

                    iniciaTransacao.permiteTroco = false;
                    iniciaTransacao.valorMaximoTroco = 0;
                    string SQLObtemTipoRecebimento = @"SELECT permite_troco,
                                                            troco_maximo
                                                    FROM tipo_recebimento
                                                    WHERE id_tipo_recebimento = " + iniciaTransacao.tipoRecebimento + ";";

                    PgSqlDataReader drTipoRecebimento = cf.ObtemComando(SQLObtemTipoRecebimento, ref conexao).ExecuteReader();

                    if (drTipoRecebimento.Read())
                    {
                        iniciaTransacao.permiteTroco = ((string)drTipoRecebimento["permite_troco"]).Equals("S");
                        iniciaTransacao.valorMaximoTroco = (decimal)drTipoRecebimento["troco_maximo"];

                        logger.Debug("iniciaTransacao.permiteTroco=" + iniciaTransacao.permiteTroco);
                        logger.Debug("iniciaTransacao.valorMaximoTroco=" + iniciaTransacao.valorMaximoTroco);
                    }

                    logger.Debug("Obtendo dados do abastecimento. iniciaTransacao.sac01=" + iniciaTransacao.sac01);

                    string SQLObtemAbastecimento = @"SELECT ab.id_abastecimento,
                                                            ab.situacao,
                                                            ab.preco,
                                                            ab.quantidade,
                                                            ab.total,
                                                            COALESCE(ab.cnpj_cpf, '') AS cnpj_cpf,
                                                            COALESCE(ab.id_cliente, '') AS id_cliente,
                                                            bc.numero,
                                                            (SELECT descricao FROM item WHERE id_item = le.id_item_tanque) AS descricao,
                                                            (SELECT id_item FROM item WHERE id_item = le.id_item_tanque) AS id_item
                                                    FROM abastecimento AS ab
                                                    INNER JOIN bico_combustivel AS bc ON (bc.id_bico_combustivel = ab.id_bico_combustivel)
                                                    INNER JOIN local_estoque AS le ON (le.id_local_estoque = bc.id_tanque)
                                                    WHERE id_abastecimento = " + iniciaTransacao.sac01 + ";";

                    PgSqlDataReader drAbastecimento = cf.ObtemComando(SQLObtemAbastecimento, ref conexao).ExecuteReader();

                    drAbastecimento.Read();

                    logger.Debug("Carregando dados a serem mostrados no POS.");

                    iniciaTransacao.abastecimento.idAbastecimento = (int)drAbastecimento["id_abastecimento"];

                    string denominacaoBico = (string)drAbastecimento["descricao"];
                    byte[] bytes = System.Text.Encoding.GetEncoding("iso-8859-8").GetBytes(denominacaoBico);

                    iniciaTransacao.abastecimento.denominacaoBico = System.Text.Encoding.UTF8.GetString(bytes);
                    iniciaTransacao.abastecimento.numeroBico = (int)drAbastecimento["numero"];
                    iniciaTransacao.abastecimento.situacaoAbastecimento = (int)drAbastecimento["situacao"];
                    iniciaTransacao.abastecimento.id_terminal_pos_wireless = idTerminalPosWireless;
                    iniciaTransacao.abastecimento.preco = (decimal)drAbastecimento["preco"];
                    iniciaTransacao.abastecimento.quantidade = (decimal)drAbastecimento["quantidade"];
                    iniciaTransacao.abastecimento.total = (decimal)drAbastecimento["total"];
                    iniciaTransacao.totalAbastecimento = (decimal)drAbastecimento["total"];
                    iniciaTransacao.abastecimento.ValorRecebido = iniciaTransacao.abastecimento.total;
                    iniciaTransacao.abastecimento.ValorRecebidoString = iniciaTransacao.abastecimento.total.ToString("N2");
                    iniciaTransacao.valorRecebidoString = iniciaTransacao.abastecimento.total.ToString("N2");
                    iniciaTransacao.abastecimento.IdItem = (string)drAbastecimento["id_item"];

                    string idCliente = string.Empty;
                    if (!((string)drAbastecimento["cnpj_cpf"]).Equals(string.Empty))
                    {
                        logger.Debug("Verificando se existe cliente com CNPJ/CPF do abastecimento.");
                        logger.Debug("cnpj_cpf=" + (string)drAbastecimento["cnpj_cpf"]);

                        string SQLCliente = @"SELECT id_cliente FROM cliente
                                                WHERE cnpj_cpf = '" + (string)drAbastecimento["cnpj_cpf"] + "';";

                        PgSqlDataReader drCliente = cf.ObtemComando(SQLCliente, ref conexao).ExecuteReader();

                        if (drCliente.Read())
                            idCliente = (string)drCliente["id_cliente"];
                    }
                    else if (!((string)drAbastecimento["id_cliente"]).Equals(string.Empty))
                        idCliente = (string)drAbastecimento["id_cliente"];

                    if (string.IsNullOrEmpty(idCliente))
                    {
                        idCliente = ParametroAlfanumerico("id_consumidor_padrao");
                        logger.Debug("Utilizando consumidor padrão.");
                    }

                    iniciaTransacao.abastecimento.IdCliente = idCliente;
                    logger.Debug("abastecimento.IdCliente=" + iniciaTransacao.abastecimento.IdCliente);
                    logger.Debug("abastecimento.ValorRecebidoString=" + iniciaTransacao.abastecimento.ValorRecebidoString);

                    if (!iniciaTransacao.abastecimento.IdCliente.Equals(string.Empty))
                    {
                        iniciaTransacao.abastecimento.TipoRecebimento = iniciaTransacao.tipoRecebimento;

                        logger.Debug("iniciaTransacao.abastecimento.TipoRecebimento=" + iniciaTransacao.abastecimento.TipoRecebimento);
                        logger.Debug("iniciaTransacao.pagamentoCredito=" + iniciaTransacao.pagamentoCredito);
                        logger.Debug("iniciaTransacao.pagamentoCreditoParcelado=" + iniciaTransacao.pagamentoCreditoParcelado);
                        logger.Debug("iniciaTransacao.pagamentoDebito=" + iniciaTransacao.pagamentoDebito);
                        logger.Debug("iniciaTransacao.pagamentoDinheiro=" + iniciaTransacao.pagamentoDinheiro);

                        if (iniciaTransacao.pagamentoDinheiro)
                        {
                            logger.Debug("Verificando parametro id_forma_recebimento_padrao.");
                            string idFormaRecebimentoPadro = ParametroAlfanumerico("id_forma_recebimento_padrao");
                            iniciaTransacao.abastecimento.IdFormaRecebimento = idFormaRecebimentoPadro;
                            logger.Debug("id_forma_recebimento_padrao=" + iniciaTransacao.abastecimento.IdFormaRecebimento);
                        }
                        else
                            iniciaTransacao.abastecimento.IdFormaRecebimento = string.Empty;

                        string mensagem = string.Empty;
                        iniciaTransacao.abastecimento = doVerificaCondicaoVendaCliente(iniciaTransacao.abastecimento, out mensagem);

                        if (iniciaTransacao.abastecimento == null)
                        {
                            Object erro = mensagem;
                            logger.Error(erro);
                            Usuario usuario = new Usuario();
                            usuario.ErroMensagem = erro.ToString();
                            usuario.idUsuarioLogado = iniciaTransacao.sac02;
                            usuario.idAtendenteLogado = iniciaTransacao.sac03;
                            return View("TrataErrosGenerico", usuario);
                        }
                        else
                        {
                            iniciaTransacao.totalAbastecimento = iniciaTransacao.abastecimento.total;
                            iniciaTransacao.valorRecebidoString = iniciaTransacao.abastecimento.total.ToString("N2");
                        }
                    }

                    logger.Debug("Carregando dados da transação.");

                    string transacaoHabilitada = string.Empty;

                    if (iniciaTransacao.pagamentoDebito)
                        transacaoHabilitada += "16";//16: Débito à vista;

                    if (iniciaTransacao.pagamentoCredito)
                    {
                        if (!transacaoHabilitada.Equals(string.Empty))
                            transacaoHabilitada += ";";
                        //26: Crédito à vista; 
                        //27: Cartão de crédito parcelado com financiamento do estabelecimento;
                        //28: Cartão de crédito parcelado com financiamento da administradora
                        transacaoHabilitada += "26";

                        if (iniciaTransacao.pagamentoCreditoParcelado)
                            transacaoHabilitada += ";27;28";
                    }

                    iniciaTransacao.transacaoHabilitada = transacaoHabilitada;

                    logger.Debug("iniciaTransacao.permiteTroco=" + iniciaTransacao.permiteTroco);
                    if (iniciaTransacao.permiteTroco)
                        return View(iniciaTransacao);
                    else
                        return RedirectToAction("ValorRecebimento", iniciaTransacao);
                }
                catch (Exception ex)
                {
                    logger.Error(ex.ToString());
                    Usuario usuario = new Usuario();
                    usuario.ErroMensagem = ex.ToString();
                    usuario.idUsuarioLogado = iniciaTransacao.sac02;
                    usuario.idAtendenteLogado = iniciaTransacao.sac03;
                    return View("TrataErrosGenerico", usuario);
                }
                finally
                {
                    cf.FechaConexao(conexao);
                }
            }
            else
            {
                return RedirectToAction("browserInvalido", "Browser");
            }
        }
        public ActionResult ValorRecebimento(IniciaTransacao iniciaTransacao)
        {
            logger.Trace(string.Empty);
            logger.Debug("Tentando autenticador o POS.");

            if (autenticador.validaBrowser())
            {
                ConnectionFactory cf = new ConnectionFactory();
                PgSqlConnection conexao = new PgSqlConnection();
                try
                {
                    logger.Debug("idUsuarioLogado=" + iniciaTransacao.sac02);
                    logger.Debug("idAtendenteLogado=" + iniciaTransacao.sac03);
                    if (iniciaTransacao.sac02.Equals(string.Empty))
                    {
                        logger.Debug("Usuario não identificado voltar para login.");
                        return RedirectToAction("Index");
                    }
                    if (iniciaTransacao.sac03 == null)
                        iniciaTransacao.sac03 = string.Empty;

                    string idTerminalPosWireless = string.Empty;
                    string erroValidacao = string.Empty;
                    iniciaTransacao.abastecimento = new Abastecimento();

                    if (!doValidaTerminalPosWireless(out idTerminalPosWireless, out erroValidacao))
                    {
                        Object erro = erroValidacao;
                        logger.Error(erro);
                        Usuario usuario = new Usuario();
                        usuario.ErroMensagem = erro.ToString();
                        usuario.idUsuarioLogado = iniciaTransacao.sac02;
                        usuario.idAtendenteLogado = iniciaTransacao.sac03;
                        return View("TrataErrosGenerico", usuario);
                    }

                    logger.Debug("iniciaTransacao.sac01=" + iniciaTransacao.sac01);
                    logger.Debug("iniciaTransacao.sac02=" + iniciaTransacao.sac02);
                    logger.Debug("iniciaTransacao.sac03=" + iniciaTransacao.sac03);
                    decimal valorRecebido = 0;
                    logger.Debug("Validando Valor Recebido.");

                    if (!decimal.TryParse(iniciaTransacao.valorRecebidoString, out valorRecebido))
                    {
                        iniciaTransacao.mensagemErro = "Valor recebido [" + iniciaTransacao.valorRecebidoString + "] e invalido.";
                        return View("TrataErrosValorRecebimento", iniciaTransacao);
                    }

                    if (valorRecebido < iniciaTransacao.totalAbastecimento)
                    {
                        iniciaTransacao.mensagemErro = "Valor recebido [" + valorRecebido.ToString("N2") + "] deve ser igual o maior que o valor do abastecimento [" + iniciaTransacao.totalAbastecimento.ToString("N2") + "]";
                        return View("TrataErrosValorRecebimento", iniciaTransacao);
                    }

                    decimal troco = valorRecebido - iniciaTransacao.totalAbastecimento;
                    if (troco > iniciaTransacao.valorMaximoTroco)
                    {
                        iniciaTransacao.mensagemErro = "Valor troco [" + troco.ToString("N2") + "] valor maximo de troco permitido [" + iniciaTransacao.valorMaximoTroco.ToString("N2") + "]";
                        return View("TrataErrosValorRecebimento", iniciaTransacao);
                    }

                    logger.Debug("Tentando atualizar abastecimento=[" + iniciaTransacao.sac01 + "] com valor recebido [" + valorRecebido + "].");
                    logger.Debug("valor_recebido=" + valorRecebido.ToString("N2").Replace(".", "").Replace(",", "."));

                    string SQLAbastecimento = @"UPDATE abastecimento
                                            SET valor_recebido = :valor_recebido
                                            WHERE id_abastecimento = " + iniciaTransacao.sac01 + ";";

                    var cmd = cf.ObtemComando(SQLAbastecimento, ref conexao);
                    var parValorRecibido = cmd.CreateParameter();
                    parValorRecibido.DbType = System.Data.DbType.Decimal;
                    parValorRecibido.ParameterName = "valor_recebido";
                    parValorRecibido.Value = valorRecebido;
                    cmd.Parameters.Add(parValorRecibido);
                    cmd.ExecuteNonQuery();

                    logger.Debug("Abastecimento =[" + iniciaTransacao.sac01 + "] atualizado.");

                    logger.Debug("iniciaTransacao.abastecimento.TipoRecebimento=" + iniciaTransacao.tipoRecebimento);
                    logger.Debug("iniciaTransacao.pagamentoCredito=" + iniciaTransacao.pagamentoCredito);
                    logger.Debug("iniciaTransacao.pagamentoCreditoParcelado=" + iniciaTransacao.pagamentoCreditoParcelado);
                    logger.Debug("iniciaTransacao.pagamentoDebito=" + iniciaTransacao.pagamentoDebito);
                    logger.Debug("iniciaTransacao.pagamentoDinheiro=" + iniciaTransacao.pagamentoDinheiro);

                    logger.Debug("Obtendo dados do abastecimento. iniciaTransacao.sac01=" + iniciaTransacao.sac01);

                    string SQLObtemAbastecimento = @"SELECT ab.id_abastecimento,
                                                            ab.situacao,
                                                            ab.preco,
                                                            ab.quantidade,
                                                            ab.total,
                                                            COALESCE(ab.cnpj_cpf, '') AS cnpj_cpf,
                                                            COALESCE(ab.id_cliente, '') AS id_cliente,
                                                            bc.numero,
                                                            (SELECT descricao FROM item WHERE id_item = le.id_item_tanque) AS descricao,
                                                            (SELECT id_item FROM item WHERE id_item = le.id_item_tanque) AS id_item,
                                                            acrescimo,
                                                            desconto
                                                    FROM abastecimento AS ab
                                                    INNER JOIN bico_combustivel AS bc ON (bc.id_bico_combustivel = ab.id_bico_combustivel)
                                                    INNER JOIN local_estoque AS le ON (le.id_local_estoque = bc.id_tanque)
                                                    WHERE id_abastecimento = " + iniciaTransacao.sac01 + ";";

                    PgSqlDataReader drAbastecimento = cf.ObtemComando(SQLObtemAbastecimento, ref conexao).ExecuteReader();

                    drAbastecimento.Read();

                    logger.Debug("Carregando dados a serem mostrados no POS.");

                    iniciaTransacao.abastecimento.idAbastecimento = (int)drAbastecimento["id_abastecimento"];

                    string denominacaoBico = (string)drAbastecimento["descricao"];
                    byte[] bytes = System.Text.Encoding.GetEncoding("iso-8859-8").GetBytes(denominacaoBico);

                    iniciaTransacao.abastecimento.denominacaoBico = System.Text.Encoding.UTF8.GetString(bytes);
                    iniciaTransacao.abastecimento.numeroBico = (int)drAbastecimento["numero"];
                    iniciaTransacao.abastecimento.situacaoAbastecimento = (int)drAbastecimento["situacao"];
                    iniciaTransacao.abastecimento.id_terminal_pos_wireless = idTerminalPosWireless;
                    iniciaTransacao.abastecimento.preco = (decimal)drAbastecimento["preco"];
                    iniciaTransacao.abastecimento.quantidade = (decimal)drAbastecimento["quantidade"];
                    iniciaTransacao.abastecimento.total = (decimal)drAbastecimento["total"];
                    iniciaTransacao.abastecimento.desconto = (decimal)drAbastecimento["desconto"];
                    iniciaTransacao.abastecimento.acrescimo = (decimal)drAbastecimento["acrescimo"];
                    iniciaTransacao.abastecimento.ValorRecebido = valorRecebido;
                    iniciaTransacao.abastecimento.ValorRecebidoString = valorRecebido.ToString("N2");
                    iniciaTransacao.abastecimento.IdItem = (string)drAbastecimento["id_item"];

                    if (iniciaTransacao.abastecimento.ValorRecebido < iniciaTransacao.abastecimento.total)
                    {
                        iniciaTransacao.mensagemErro = "Valor recebido [" + iniciaTransacao.abastecimento.ValorRecebido.ToString("N2") + "] deve ser igual o maior que o valor do abastecimento [" + iniciaTransacao.abastecimento.total.ToString("N2") + "]";
                        return View("TrataErrosValorRecebimento", iniciaTransacao);
                    }

                    logger.Debug("abastecimento.ValorRecebidoString=" + iniciaTransacao.abastecimento.ValorRecebidoString);

                    logger.Debug("Carregando dados da transação.");

                    string transacaoHabilitada = string.Empty;

                    if (iniciaTransacao.pagamentoDebito)
                        transacaoHabilitada += "16";//16: Débito à vista;

                    if (iniciaTransacao.pagamentoCredito)
                    {
                        if (!transacaoHabilitada.Equals(string.Empty))
                            transacaoHabilitada += ";";
                        //26: Crédito à vista; 
                        //27: Cartão de crédito parcelado com financiamento do estabelecimento;
                        //28: Cartão de crédito parcelado com financiamento da administradora
                        transacaoHabilitada += "26";

                        if (iniciaTransacao.pagamentoCreditoParcelado)
                            transacaoHabilitada += ";27;28";
                    }

                    iniciaTransacao.transacaoHabilitada = transacaoHabilitada;

                    logger.Debug("Enviando transação para o POS.");
                    return View(iniciaTransacao);
                }
                catch (Exception ex)
                {
                    logger.Error(ex.ToString());
                    Usuario usuario = new Usuario();
                    usuario.ErroMensagem = ex.ToString();
                    usuario.idUsuarioLogado = iniciaTransacao.sac02;
                    usuario.idAtendenteLogado = iniciaTransacao.sac03;
                    return View("TrataErrosGenerico", usuario);
                }
                finally
                {
                    cf.FechaConexao(conexao);
                }
            }
            else
            {
                return RedirectToAction("browserInvalido", "Browser");
            }
        }
        public ActionResult RetornoTransacao(RetornoTransacao retorno)
        {
            logger.Trace(string.Empty);
            logger.Debug("Tentando autenticador o POS.");

            if (autenticador.validaBrowser())
            {
                try
                {
                    logger.Debug("Carregando tabelas.");

                    int largura = 42;
                    #region Variaveis
                    int sac01 = retorno.SAC_01;
                    if (retorno.SAC_02 == null)
                        retorno.SAC_02 = string.Empty;
                    if (retorno.SAC_03 == null)
                        retorno.SAC_03 = string.Empty;
                    string[] comp1Via = new string[retorno.COMP_1VIA == null ? 0 : retorno.COMP_1VIA.Length];
                    string[] comp2Via = new string[retorno.COMP_2VIA == null ? 0 : retorno.COMP_2VIA.Length];
                    string[] compDadosConf = new string[retorno.COMP_DADOS_CONF == null ? 0 : retorno.COMP_DADOS_CONF.Length];
                    retorno.CompHoraCupom = "0";
                    retorno.CompDataCupom = "0";

                    Tabelas tabelas = new Tabelas();
                    retorno.RedeAutNome = tabelas.GetNomeRede(retorno.REDE_AUT);
                    retorno.BandeiraNome = tabelas.GetNomeBandeira(retorno.BANDEIRA);
                    string tipoParc = tabelas.GetNomeTipoParcelamento(retorno.TIPO_PARC);
                    retorno.CodRespNome = tabelas.GetNomeCodResp(retorno.CODRESP);
                    retorno.CodTransNome = tabelas.GetNomeCodigoTransacao(retorno.CODTRANS);
                    string tipoTrn = tabelas.GetNomeTipoTrn(retorno.TIPO_TRN);
                    string nsuSitef = retorno.NSU_SITEF;
                    string nsuHost = retorno.NSU_HOST;

                    retorno.CNPJEstabelecimento = ParametroAlfanumerico("cnpj_empresa");
                    retorno.CNPJEstabelecimento = retorno.CNPJEstabelecimento.Substring(0, 2) + "." + retorno.CNPJEstabelecimento.Substring(2, 3) + "." +
                        retorno.CNPJEstabelecimento.Substring(5, 3) + "/" + retorno.CNPJEstabelecimento.Substring(8, 4) + "-" + retorno.CNPJEstabelecimento.Substring(12, 2);
                    retorno.CNPJEstabelecimento = ("CNPJ: " + retorno.CNPJEstabelecimento).PadRight(largura, ' ').Substring(0, 42);
                    #endregion

                    logger.Debug("Validando retorno da transação.");

                    #region Validações

                    if (comp1Via.Length > 0)
                    {
                        for (int i = 0; i < comp1Via.Length; i++)
                        {
                            comp1Via[i] = retorno.COMP_1VIA[i].ToString();
                        }
                    }

                    if (comp2Via.Length > 0)
                    {
                        for (int i = 0; i < comp2Via.Length; i++)
                        {
                            comp2Via[i] = retorno.COMP_2VIA == null ? "0" : retorno.COMP_2VIA[i].ToString();
                        }
                    }

                    if (compDadosConf.Length > 0)
                    {
                        for (int i = 0; i < compDadosConf.Length; i++)
                        {
                            compDadosConf[i] = retorno.COMP_DADOS_CONF == null ? "0" : retorno.COMP_DADOS_CONF[i].ToString();
                        }
                    }

                    if (!(retorno.COMP_HORA_FISCAL == 0))
                    {
                        retorno.CompHoraCupom = retorno.COMP_HORA_FISCAL.ToString("000000").Substring(0, 2) + ":"
                                            + retorno.COMP_HORA_FISCAL.ToString("000000").Substring(2, 2) + ":"
                                            + retorno.COMP_HORA_FISCAL.ToString("000000").Substring(4, 2);
                    }

                    if (!(retorno.COMP_DATA_FISCAL == 0))
                    {
                        retorno.CompDataCupom = retorno.COMP_DATA_FISCAL.ToString("00000000").Substring(6, 2) + "/"
                                        + retorno.COMP_DATA_FISCAL.ToString("00000000").Substring(4, 2) + "/"
                                        + retorno.COMP_DATA_FISCAL.ToString("00000000").Substring(0, 4);
                    }

                    if (comp1Via.Length == 1)
                    {
                        string[] split = comp1Via[0].Split(new char[] { '@' });
                        comp1Via = split;

                        if (comp1Via.Length > 1)
                            retorno.Comp1Linha1 = comp1Via[0].PadRight(largura, ' ').Substring(0, 42);
                        if (comp1Via.Length > 2)
                            retorno.Comp1Linha2 = comp1Via[1].PadRight(largura, ' ').Substring(0, 42);
                        if (comp1Via.Length > 3)
                            retorno.Comp1Linha3 = comp1Via[2].PadRight(largura, ' ').Substring(0, 42);
                        if (comp1Via.Length > 4)
                            retorno.Comp1Linha4 = comp1Via[3].PadRight(largura, ' ').Substring(0, 42);
                        if (comp1Via.Length > 5)
                            retorno.Comp1Linha5 = comp1Via[4].PadRight(largura, ' ').Substring(0, 42);
                        if (comp1Via.Length > 6)
                            retorno.Comp1Linha6 = comp1Via[5].PadRight(largura, ' ').Substring(0, 42);
                        if (comp1Via.Length > 7)
                            retorno.Comp1Linha7 = comp1Via[6].PadRight(largura, ' ').Substring(0, 42);
                        if (comp1Via.Length > 8)
                            retorno.Comp1Linha8 = comp1Via[7].PadRight(largura, ' ').Substring(0, 42);
                        if (comp1Via.Length > 9)
                            retorno.Comp1Linha9 = comp1Via[8].PadRight(largura, ' ').Substring(0, 42);
                        if (comp1Via.Length > 10)
                            retorno.Comp1Linha10 = comp1Via[9].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp1Linha10 = string.Empty;

                        if (comp1Via.Length > 11)
                            retorno.Comp1Linha11 = comp1Via[10].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp1Linha11 = string.Empty;

                        if (comp1Via.Length > 12)
                            retorno.Comp1Linha12 = comp1Via[11].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp1Linha12 = string.Empty;

                        if (comp1Via.Length > 13)
                            retorno.Comp1Linha13 = comp1Via[12].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp1Linha13 = string.Empty;

                        if (comp1Via.Length > 14)
                            retorno.Comp1Linha14 = comp1Via[13].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp1Linha14 = string.Empty;

                        if (comp1Via.Length > 15)
                            retorno.Comp1Linha15 = comp1Via[14].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp1Linha15 = string.Empty;

                        if (comp1Via.Length > 16)
                            retorno.Comp1Linha16 = comp1Via[15].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp1Linha16 = string.Empty;

                        if (comp1Via.Length > 17)
                            retorno.Comp1Linha17 = comp1Via[16].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp1Linha17 = string.Empty;

                        if (comp1Via.Length > 18)
                            retorno.Comp1Linha18 = comp1Via[17].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp1Linha18 = string.Empty;

                        if (comp1Via.Length > 19)
                            retorno.Comp1Linha19 = comp1Via[18].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp1Linha19 = string.Empty;

                        if (comp1Via.Length > 20)
                            retorno.Comp1Linha20 = comp1Via[19].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp1Linha20 = string.Empty;
                    }

                    if (comp2Via.Length == 1)
                    {
                        string[] split = comp2Via[0].Split(new char[] { '@' });
                        comp2Via = split;

                        if (comp2Via.Length > 1)
                            retorno.Comp2Linha1 = comp2Via[0].PadRight(largura, ' ').Substring(0, 42);
                        if (comp2Via.Length > 2)
                            retorno.Comp2Linha2 = comp2Via[1].PadRight(largura, ' ').Substring(0, 42);
                        if (comp2Via.Length > 3)
                            retorno.Comp2Linha3 = comp2Via[2].PadRight(largura, ' ').Substring(0, 42);
                        if (comp2Via.Length > 4)
                            retorno.Comp2Linha4 = comp2Via[3].PadRight(largura, ' ').Substring(0, 42);
                        if (comp2Via.Length > 5)
                            retorno.Comp2Linha5 = comp2Via[4].PadRight(largura, ' ').Substring(0, 42);
                        if (comp2Via.Length > 6)
                            retorno.Comp2Linha6 = comp2Via[5].PadRight(largura, ' ').Substring(0, 42);
                        if (comp2Via.Length > 7)
                            retorno.Comp2Linha7 = comp2Via[6].PadRight(largura, ' ').Substring(0, 42);
                        if (comp2Via.Length > 8)
                            retorno.Comp2Linha8 = comp2Via[7].PadRight(largura, ' ').Substring(0, 42);
                        if (comp2Via.Length > 9)
                            retorno.Comp2Linha9 = comp2Via[8].PadRight(largura, ' ').Substring(0, 42);
                        if (comp2Via.Length > 10)
                            retorno.Comp2Linha10 = comp2Via[9].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp2Linha10 = string.Empty;

                        if (comp2Via.Length > 11)
                            retorno.Comp2Linha11 = comp2Via[10].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp2Linha11 = string.Empty;

                        if (comp2Via.Length > 12)
                            retorno.Comp2Linha12 = comp2Via[11].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp2Linha12 = string.Empty;

                        if (comp2Via.Length > 13)
                            retorno.Comp2Linha13 = comp2Via[12].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp2Linha13 = string.Empty;

                        if (comp2Via.Length > 14)
                            retorno.Comp2Linha14 = comp2Via[13].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp2Linha14 = string.Empty;

                        if (comp2Via.Length > 15)
                            retorno.Comp2Linha15 = comp2Via[14].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp2Linha15 = string.Empty;

                        if (comp2Via.Length > 16)
                            retorno.Comp2Linha16 = comp2Via[15].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp2Linha16 = string.Empty;

                        if (comp2Via.Length > 17)
                            retorno.Comp2Linha17 = comp2Via[16].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp2Linha17 = string.Empty;

                        if (comp2Via.Length > 18)
                            retorno.Comp2Linha18 = comp2Via[17].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp2Linha18 = string.Empty;

                        if (comp2Via.Length > 19)
                            retorno.Comp2Linha19 = comp2Via[18].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp2Linha19 = string.Empty;

                        if (comp2Via.Length > 20)
                            retorno.Comp2Linha20 = comp2Via[19].PadRight(largura, ' ').Substring(0, 42);
                        else
                            retorno.Comp2Linha20 = string.Empty;
                    }


                    if (comp1Via.Length > 0)
                    {
                        for (int i = 0; i < comp1Via.Length; i++)
                        {
                            logger.Debug("Comp1Via=" + comp1Via[i]);
                        }
                    }
                    else
                    {
                        logger.Debug("Comp1Via=" + comp1Via.ToString());
                    }

                    if (comp2Via.Length > 0)
                    {
                        for (int i = 0; i < comp2Via.Length; i++)
                        {
                            logger.Debug("comp2Via=" + comp2Via[i]);
                        }
                    }
                    else
                    {
                        logger.Debug("comp2Via=" + comp2Via.ToString());
                    }

                    if (compDadosConf.Length > 0)
                    {
                        for (int i = 0; i < compDadosConf.Length; i++)
                        {
                            logger.Debug("compDadosConf=" + compDadosConf[i]);
                        }
                    }
                    else
                    {
                        logger.Debug("compDadosConf=" + compDadosConf.ToString());
                    }

                    if (retorno.COMP_1VIA == null)
                    {
                        retorno.COMP_1VIA = new string[0];
                    }

                    if (retorno.COMP_2VIA == null)
                    {
                        retorno.COMP_2VIA = new string[0];
                    }
                    #endregion

                    logger.Debug("retorno.VALOR=" + retorno.VALOR);
                    retorno.VALOR = retorno.VALOR / 100;
                    logger.Debug("retorno.VALOR=" + retorno.VALOR);

                    #region LogTransações
                    logger.Info("========================Retorno de Transação========================");
                    logger.Info("Empresa=" + retorno.EMPRESA.ToString() + "|TipoTransacao=" + tipoTrn);
                    logger.Info("Terminal=" + retorno.TERMINAL.ToString() + "|CodResp=" + retorno.CodRespNome);
                    logger.Info("CodTrans=" + retorno.CodTransNome + "|Valor=" + retorno.VALOR.ToString("N2"));
                    logger.Info("RedeAut=" + retorno.RedeAutNome + "|Bandeira=" + retorno.BandeiraNome);
                    logger.Info("NumPrc=" + retorno.NUM_PARC.ToString() + "|TipoPrc=" + tipoParc);
                    logger.Info("NsuSitef=" + nsuSitef + "|NsuAutorizador=" + nsuHost);
                    logger.Info("CodAutorização=" + retorno.COD_AUTORIZACAO + "|VlrTroco=" + retorno.VLRTROCO.ToString("N2"));
                    logger.Info("CompData=" + retorno.CompDataCupom + "|CompHora=" + retorno.CompHoraCupom);
                    logger.Info("Sac01=" + sac01);
                    logger.Info("========================Final do Retorno da Transação========================");
                    #endregion

                    if (retorno.CODRESP == 0 && Convert.ToInt32(nsuSitef) > 0)
                    {
                        int tentativas = 0;
                        bool salvo = false;
                        retorno.TransacaoAprovada = true;

                        while (!salvo && tentativas <= 5)
                        {
                            logger.Debug("tentativas=" + tentativas);

                            ConnectionFactory cf = new ConnectionFactory();
                            PgSqlConnection conexao = new PgSqlConnection();
                            try
                            {
                                logger.Debug("sac01=" + sac01);
                                logger.Debug("sac02=" + retorno.SAC_02);
                                logger.Debug("sac03=" + retorno.SAC_03);

                                if (sac01 == 0)
                                {
                                    logger.Debug("Tentando localizar o abastecimento.");

                                    string idTerminalWireless = string.Empty;
                                    string erroValidacao = string.Empty;
                                    if (!doValidaTerminalPosWireless(out idTerminalWireless, out erroValidacao))
                                    {
                                        Object erro = erroValidacao;
                                        logger.Error(erro);
                                        Usuario usuario = new Usuario();
                                        usuario.ErroMensagem = erro.ToString();
                                        usuario.idUsuarioLogado = retorno.SAC_02;
                                        usuario.idAtendenteLogado = retorno.SAC_03;
                                        return View("TrataErrosGenerico", usuario);
                                    }

                                    logger.Debug("valor_recebido=" + retorno.VALOR.ToString("N2").Replace(".", "").Replace(",", "."));
                                    string valorSQL = ((int)Math.Truncate(retorno.VALOR * 100)).ToString();
                                    logger.Debug("valorSQL=" + valorSQL);
                                    if (valorSQL.Length <= 2)
                                        valorSQL = "0." + valorSQL;
                                    else
                                        valorSQL = valorSQL.Insert((valorSQL.Length - 2), ".");
                                    logger.Debug("valorSQL=" + valorSQL);

                                    String SQLAbastecimento = @"SELECT id_abastecimento
                                                    FROM abastecimento
                                                    WHERE id_terminal_pos_wireless = '" + idTerminalWireless + @"'
                                                    AND COALESCE(codigo_bandeira_tef, '') = ''
                                                    AND COALESCE(codigo_rede_tef, '') = ''
                                                    AND COALESCE(codigo_tipo_transacao_tef, '') = ''
                                                    AND id_forma_recebimento_tef IS NULL
                                                    AND valor_recebido = :valor_recebido
                                                    AND situacao IN (1, 7);";

                                    var cmd = cf.ObtemComando(SQLAbastecimento, ref conexao);
                                    var parValorRecibido = cmd.CreateParameter();
                                    parValorRecibido.DbType = System.Data.DbType.Decimal;
                                    parValorRecibido.ParameterName = "valor_recebido";
                                    parValorRecibido.Value = retorno.VALOR;
                                    cmd.Parameters.Add(parValorRecibido);

                                    PgSqlDataReader drAbatecimento = cmd.ExecuteReader();

                                    if (drAbatecimento.Read())
                                    {
                                        sac01 = (int)drAbatecimento["id_abastecimento"];
                                        retorno.SAC_01 = sac01;
                                        logger.Debug("Abastecimento localizado ID = " + sac01);
                                    }
                                    else
                                    {
                                        Object erro = "Abastecimento não foi localizado. Cancele a transação e faça novamente.";
                                        logger.Error(erro);
                                        Usuario usuario = new Usuario();
                                        usuario.ErroMensagem = erro.ToString();
                                        usuario.idUsuarioLogado = retorno.SAC_02;
                                        usuario.idAtendenteLogado = retorno.SAC_03;
                                        return View("TrataErrosGenerico", usuario);
                                    }
                                }

                                logger.Debug("Validando status do abastecimento retornado na transação.");

                                string idCliente = string.Empty;
                                string cnpjCpf = string.Empty;
                                decimal total = 0;

                                String SQLObtemAbastecRetornado = @"SELECT id_abastecimento,
                                                                            total,
                                                                            COALESCE(id_cliente, '')::TEXT AS id_cliente,
                                                                            cnpj_cpf
                                                                    FROM abastecimento
                                                                    WHERE id_abastecimento = " + sac01 + @"
                                                                    AND situacao IN (1, 7);";

                                using (PgSqlDataReader dr = cf.ObtemComando(SQLObtemAbastecRetornado, ref conexao).ExecuteReader())
                                {
                                    logger.Debug("Atualizando abastecimento com dados retornados do SITEF.");
                                    if (dr.Read())
                                    {
                                        idCliente = (string)dr["id_cliente"];
                                        cnpjCpf = (string)dr["cnpj_cpf"];
                                        total = (decimal)dr["total"];

                                        logger.Debug("NUM_PARC=" + retorno.NUM_PARC);
                                        if (retorno.NUM_PARC > 0 && retorno.TIPO_PARC.Equals("00"))
                                        {
                                            logger.Error("Quantidade de parcelas recebida do SiTef é invalido para o tipo de parcelamento A vista, parcela será ajustada.");
                                            retorno.NUM_PARC = 0;
                                            logger.Debug("NUM_PARC=" + retorno.NUM_PARC);
                                        }

                                        String SQLAtualizaAbastecimento = @"UPDATE abastecimento
                                                                SET codigo_rede_tef = '" + retorno.REDE_AUT.Trim() + @"', 
                                                                    codigo_bandeira_tef = '" + retorno.BANDEIRA.Trim() + @"', 
                                                                    codigo_tipo_transacao_tef = '" + retorno.CODTRANS.Trim() + retorno.TIPO_PARC.Trim() + @"', 
                                                                    id_tipo_concentrador_tef = 3, 
                                                                    quantidade_parcela = " + retorno.NUM_PARC + @", 
                                                                    nsu = '" + nsuHost + @"'
                                                                WHERE id_abastecimento = " + (int)dr["id_abastecimento"] + ";";

                                        cf.ExecutaComando(SQLAtualizaAbastecimento, ref conexao);

                                        logger.Debug("Abastecimento Atualizado ID = " + sac01);
                                    }
                                    else
                                    {
                                        Object erro = "Erro ao atualizar o abastecimento. Abastecimento não esta pendente. Cancele a transação e faça novamente.";
                                        logger.Error("Erro ao atualizar o abastecimento. Abastecimento não esta pendente ID = " + sac01);
                                        Usuario usuario = new Usuario();
                                        usuario.ErroMensagem = erro.ToString();
                                        usuario.idUsuarioLogado = retorno.SAC_02;
                                        usuario.idAtendenteLogado = retorno.SAC_03;
                                        return View("TrataErrosGenerico", usuario);
                                    }
                                }

                                retorno.EmitirVenda = false;
                                logger.Debug("idCliente=" + idCliente);
                                logger.Debug("cnpjCpf=" + cnpjCpf);
                                logger.Debug("total=" + total);

                                if ((!(idCliente.Equals(string.Empty) && cnpjCpf.Equals(string.Empty)) ||
                                        total < ParametroDecimal("valor_maximo_venda_nfc_sat_sem_consumidor_identificado")) &&
                                        !retorno.SAC_02.Equals(string.Empty) &&
                                        ParametroAlfanumerico("permite_emitir_venda_tef_wifi").Equals("S"))
                                {
                                    string idMovimentoVenda;
                                    string idTerminal;
                                    if (!retorno.EmitirVenda)
                                    {
                                        if (VerificaMovimentoEmitirVenda(sac01, retorno.SAC_02, out idMovimentoVenda, out idTerminal))
                                        {
                                            retorno.EmitirVenda = true;
                                        }
                                    }
                                }

                                salvo = true;
                                tentativas++;
                            }
                            catch (Exception ex)
                            {
                                Object erro = "Erro ao atualizar o abastecimento. " + ex.Message;
                                logger.Error("Erro ao atualizar o abastecimento. " + ex.ToString());
                                if (tentativas >= 5)
                                {
                                    Usuario usuario = new Usuario();
                                    usuario.ErroMensagem = erro.ToString();
                                    usuario.idUsuarioLogado = retorno.SAC_02;
                                    usuario.idAtendenteLogado = retorno.SAC_03;
                                    return View("TrataErrosGenerico", usuario);
                                }

                                tentativas++;
                            }
                            finally
                            {
                                cf.FechaConexao(conexao);
                            }
                        }
                    }
                    else if (retorno.TIPO_TRN == 2 && retorno.CODTRANS.Equals("00") && retorno.CODRESP == 0 && comp1Via.Length > 0)
                    {
                        logger.Debug("RetornoTransacaoReimpressao");
                        return View("RetornoTransacaoReimpressao", retorno);
                    }
                    else
                    {
                        retorno.EmitirVenda = false;
                        retorno.TransacaoAprovada = false;
                    }

                    logger.Debug("RetornoTransacao");
                    return View("RetornoTransacao", retorno);
                }
                catch (Exception ex)
                {
                    logger.Error(ex.ToString());
                    Usuario usuario = new Usuario();
                    usuario.ErroMensagem = "Erro ao baixar transacao, retorno pode ter vindo invalido do SiTef, entrar em contato com o suporte da adquirente.";
                    usuario.idUsuarioLogado = retorno.SAC_02;
                    usuario.idAtendenteLogado = retorno.SAC_03;
                    return View("TrataErrosGenerico", usuario);
                }
            }
            else
            {
                return RedirectToAction("browserInvalido", "Browser");
            }
        }
        public ActionResult SegundaVia(RetornoTransacao retorno)
        {
            logger.Trace(string.Empty);
            logger.Debug("Tentando autenticador o POS.");

            if (autenticador.validaBrowser())
            {
                logger.Debug("RetornoTransacaoSegundaVia");
                return View("RetornoTransacaoSegundaVia", retorno);
            }
            else
            {
                return RedirectToAction("browserInvalido", "Browser");
            }
        }
        public ActionResult BaixaDinheiro(Abastecimento abastecimento)
        {
            logger.Trace(string.Empty);
            logger.Debug("Tentando autenticador o POS.");

            if (autenticador.validaBrowser())
            {
                try
                {
                    RetornoTransacao retorno = new Models.RetornoTransacao
                    {
                        BandeiraNome = "Dinheiro",
                        RedeAutNome = "Dinheiro",
                        CompDataCupom = string.Empty,
                        CompHoraCupom = string.Empty,
                        CodRespNome = "Aprovado",
                        SAC_01 = (int)abastecimento.idAbastecimento,
                        NSU_HOST = string.Empty,
                        NSU_SITEF = string.Empty,
                        TransacaoAprovada = true,
                        SAC_02 = abastecimento.idUsuarioLogado,
                        SAC_03 = abastecimento.idAtendenteLogado
                    };

                    string idFormaRecebimentoPadro = string.Empty;
                    ConnectionFactory cf = new ConnectionFactory();
                    PgSqlConnection conexao = new PgSqlConnection();
                    try
                    {
                        logger.Debug("Verificando parametro id_forma_recebimento_padrao.");

                        idFormaRecebimentoPadro = ParametroAlfanumerico("id_forma_recebimento_padrao");

                        logger.Debug("id_forma_recebimento_padrao=" + idFormaRecebimentoPadro);
                        logger.Debug("idAbastecimento=" + abastecimento.idAbastecimento);
                        logger.Debug("idUsuarioLogado=" + abastecimento.idUsuarioLogado);
                        logger.Debug("idAtendenteLogado=" + abastecimento.idAtendenteLogado);
                        logger.Debug("preco=" + abastecimento.preco);

                        if (abastecimento.idAbastecimento == 0)
                        {
                            logger.Debug("Tentando localizar o abastecimento.");

                            string idTerminalWireless = string.Empty;
                            string erroValidacao = string.Empty;
                            if (!doValidaTerminalPosWireless(out idTerminalWireless, out erroValidacao))
                            {
                                Object erro = erroValidacao + ". Cancele a transação e faça novamente.";
                                logger.Error(erro);
                                Usuario usuario = new Usuario();
                                usuario.ErroMensagem = erro.ToString();
                                usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                                usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                                return View("TrataErrosGenerico", usuario);
                            }

                            logger.Debug("valor_recebido=" + abastecimento.total.ToString("N2").Replace(".", "").Replace(",", "."));

                            string SQLAbastecimento = @"SELECT id_abastecimento
                                                FROM    abastecimento
                                                WHERE   id_terminal_pos_wireless = '" + idTerminalWireless + @"'
                                                AND     COALESCE(codigo_bandeira_tef, '') = ''
                                                AND     COALESCE(codigo_rede_tef, '') = ''
                                                AND     COALESCE(codigo_tipo_transacao_tef, '') = ''
                                                AND     id_forma_recebimento_tef IS NULL
                                                AND     total = :total
                                                AND     situacao IN (1, 7);";

                            var cmd = cf.ObtemComando(SQLAbastecimento, ref conexao);
                            var parTotal = cmd.CreateParameter();
                            parTotal.DbType = System.Data.DbType.Decimal;
                            parTotal.ParameterName = "total";
                            parTotal.Value = abastecimento.total;
                            cmd.Parameters.Add(parTotal);

                            PgSqlDataReader drAbatecimento = cmd.ExecuteReader();

                            if (drAbatecimento.Read())
                            {
                                abastecimento.idAbastecimento = (int)drAbatecimento["id_abastecimento"];
                                logger.Debug("Abastecimento localizado ID = " + abastecimento.idAbastecimento);
                            }
                            else
                            {
                                Object erro = "Abastecimento não foi localizado. Cancele a transação e faça novamente.";
                                logger.Error(erro);
                                Usuario usuario = new Usuario();
                                usuario.ErroMensagem = erro.ToString();
                                usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                                usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                                return View("TrataErrosGenerico", usuario);
                            }
                        }

                        logger.Debug("Validando status do abastecimento retornado na transação.");

                        string idCliente = string.Empty;
                        string cnpjCpf = string.Empty;
                        decimal total = 0;

                        string SQLObtemAbastecRetornado = @"SELECT   a.id_abastecimento,
                                                                    b.permite_recebimento_especie,
                                                                    a.total,
                                                                    COALESCE(a.id_cliente, '')::TEXT AS id_cliente,
                                                                    a.cnpj_cpf
                                                            FROM    abastecimento AS a
                                                            INNER JOIN bico_combustivel AS b ON (a.id_bico_combustivel = b.id_bico_combustivel)
                                                            WHERE   id_abastecimento = " + abastecimento.idAbastecimento + @"
                                                            AND     situacao IN (1, 7);";

                        using (PgSqlDataReader dr = cf.ObtemComando(SQLObtemAbastecRetornado, ref conexao).ExecuteReader())
                        {
                            logger.Debug("Atualizando abastecimento com pagamento em Dinheiro.");
                            if (dr.Read())
                            {
                                if (((string)dr["permite_recebimento_especie"]).Equals("N"))
                                {
                                    Object erro = "Pagamento em tipo de recebimento Especie nao permitido para o bico.";
                                    logger.Error(erro);
                                    Usuario usuario = new Usuario();
                                    usuario.ErroMensagem = erro.ToString();
                                    usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                                    usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                                    return View("TrataErrosGenerico", usuario);
                                }

                                string SQLAtualizaAbastecimento = @"UPDATE abastecimento
                                                            SET id_forma_recebimento_tef = '" + idFormaRecebimentoPadro + @"'
                                                            WHERE id_abastecimento = " + (int)dr["id_abastecimento"] + ";";

                                cf.ExecutaComando(SQLAtualizaAbastecimento, ref conexao);

                                idCliente = (string)dr["id_cliente"];
                                cnpjCpf = (string)dr["cnpj_cpf"];
                                total = (decimal)dr["total"];

                                #region LogTransações
                                logger.Info("========================Retorno de Transação========================");
                                logger.Info("Pagamento Realizado em DINHEIRO");
                                logger.Info("idFormaRecebimentoPadro=" + idFormaRecebimentoPadro);
                                logger.Info("idAbastecimento=" + abastecimento.idAbastecimento);
                                logger.Info("========================Final do Retorno da Transação========================");
                                #endregion
                            }
                        }

                        retorno.EmitirVenda = false;
                        logger.Debug("idCliente=" + idCliente);
                        logger.Debug("cnpjCpf=" + cnpjCpf);
                        logger.Debug("total=" + total);

                        if ((!(idCliente.Equals(string.Empty) && cnpjCpf.Equals(string.Empty)) ||
                            total < ParametroDecimal("valor_maximo_venda_nfc_sat_sem_consumidor_identificado")) &&
                            !abastecimento.idUsuarioLogado.Equals(string.Empty) &&
                            ParametroAlfanumerico("permite_emitir_venda_tef_wifi").Equals("S"))
                        {
                            string idMovimentoVenda;
                            string idTerminal;
                            if (!retorno.EmitirVenda)
                            {
                                if (VerificaMovimentoEmitirVenda((int)abastecimento.idAbastecimento, abastecimento.idUsuarioLogado, out idMovimentoVenda, out idTerminal))
                                {
                                    retorno.EmitirVenda = true;
                                }
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        Object erro = "Erro ao atualizar o abastecimento. " + ex.Message;
                        logger.Error("Erro ao atualizar o abastecimento. " + ex.ToString());
                        Usuario usuario = new Usuario();
                        usuario.ErroMensagem = erro.ToString();
                        usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                        usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                        return View("TrataErrosGenerico", usuario);
                    }
                    finally
                    {
                        cf.FechaConexao(conexao);
                    }

                    return View("RetornoTransacao", retorno);
                }
                catch (Exception ex)
                {
                    logger.Error(ex.ToString());
                    Usuario usuario = new Usuario();
                    usuario.ErroMensagem = ex.ToString();
                    usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                    usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                    return View("TrataErrosGenerico", usuario);
                }
            }
            else
            {
                return RedirectToAction("browserInvalido", "Browser");
            }
        }
        public bool VerificaMovimentoEmitirVenda(int idAbastecimento, string idUsuario, out string idMovimentoVenda, out string idTerminal)
        {
            logger.Trace(string.Empty);
            logger.Debug("Verificando Movimento Aberto Emitir Venda.");

            bool retorno = false;
            idMovimentoVenda = string.Empty;
            idTerminal = string.Empty;

            ConnectionFactory cf = new ConnectionFactory();
            PgSqlConnection conexao = new PgSqlConnection();
            try
            {
                if (ParametroInteiro("tipo_movimento_venda") == TipoMovimentoVenda.POR_TERMINAL)
                {
                    logger.Debug("Verificando se existe movimento aberto.");

                    string SQLBuscaMovimento = @"SELECT mv.id_movimento_venda,
                                                        mv.id_terminal
                                                FROM    movimento_venda AS mv
                                                INNER JOIN terminal AS tr ON (mv.id_terminal = tr.id_terminal)
                                                WHERE   mv.situacao = 1
                                                AND     mv.data_movimento = '" + DateTime.Now.Year + "-" + DateTime.Now.Month + "-" + DateTime.Now.Day + @"'
                                                AND     (tr.driver_ecf = 'AdaptiveNFCe' 
                                                        OR tr.driver_ecf = 'AdaptiveCFeSAT') LIMIT 1;";

                    using (PgSqlDataReader drBusca = cf.ObtemComando(SQLBuscaMovimento, ref conexao).ExecuteReader())
                    {
                        if (drBusca.Read())
                        {
                            idMovimentoVenda = (string)drBusca["id_movimento_venda"];
                            logger.Debug("idMovimentoVenda=" + idMovimentoVenda);
                            idTerminal = (string)drBusca["id_terminal"];
                            logger.Debug("idTerminal=" + idTerminal);
                            retorno = true;
                        }
                        else
                        {
                            Object erro = "Não foi encontrado movimento aberto para a data de hoje [" + DateTime.Now.ToString("dd/MM/yyyy") + "]";
                            logger.Info(erro);
                            retorno = false;
                        }
                    }
                }
                else // Por Operador
                {
                    if (!idUsuario.Equals(string.Empty))
                    {
                        logger.Debug("Verificando se existe movimento aberto.");

                        string SQLBuscaMovimento = @"SELECT mv.id_movimento_venda,
                                                                    mv.id_terminal
                                                            FROM    movimento_venda AS mv
                                                            INNER JOIN terminal AS tr ON (mv.id_terminal = tr.id_terminal)
                                                            WHERE   mv.situacao = 1
                                                            AND     mv.data_movimento = '" + DateTime.Now.Year + "-" + DateTime.Now.Month + "-" + DateTime.Now.Day + @"'
                                                            AND     mv.id_usuario = '" + idUsuario + @"'
                                                            AND     (tr.driver_ecf = 'AdaptiveNFCe' 
                                                                    OR tr.driver_ecf = 'AdaptiveCFeSAT') LIMIT 1;";

                        using (PgSqlDataReader drBusca = cf.ObtemComando(SQLBuscaMovimento, ref conexao).ExecuteReader())
                        {
                            if (drBusca.Read())
                            {
                                idMovimentoVenda = (string)drBusca["id_movimento_venda"];
                                logger.Debug("idMovimentoVenda=" + idMovimentoVenda);
                                idTerminal = (string)drBusca["id_terminal"];
                                logger.Debug("idTerminal=" + idTerminal);
                                retorno = true;
                            }
                            else
                            {
                                Object erro = "Não foi encontrado movimento aberto para o usuario do abastecimento. (Movimento deve ter a data de hoje [" + DateTime.Now.ToString("dd/MM/yyyy") + "] e ser de NFC ou SAT)";
                                logger.Info(erro);
                                retorno = false;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Object erro = "Erro ao tentar localizar movimento de venda aberto. " + ex.Message;
                logger.Error(erro);
                retorno = false;
            }
            finally
            {
                cf.FechaConexao(conexao);
            }

            logger.Debug("retorno=" + retorno);
            return retorno;
        }
        public ActionResult EmitirVenda(Abastecimento abastecimento)
        {
            logger.Trace(string.Empty);
            logger.Debug("Tentando autenticador o POS.");

            if (autenticador.validaBrowser())
            {
                try
                {
                    logger.Debug("idUsuarioLogado=" + abastecimento.idUsuarioLogado);
                    logger.Debug("idAtendenteLogado=" + abastecimento.idAtendenteLogado);
                    if (abastecimento.idUsuarioLogado.Equals(string.Empty))
                    {
                        logger.Debug("Usuario não identificado voltar para login.");
                        return RedirectToAction("Index");
                    }
                    if (abastecimento.idAtendenteLogado == null)
                        abastecimento.idAtendenteLogado = string.Empty;

                    if (ParametroAlfanumerico("permite_emitir_venda_tef_wifi").Equals("N"))
                    {
                        Object erro = "Erro nao e permitido emitir venda no Terminal WiFi.";
                        logger.Error("Erro não é permitido emitir venda no Terminal WiFi.");
                        Usuario usuario = new Usuario();
                        usuario.ErroMensagem = erro.ToString();
                        usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                        usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                        return View("TrataErrosGenerico", usuario);
                    }

                    ConnectionFactory cf = new ConnectionFactory();
                    PgSqlConnection conexao = new PgSqlConnection();
                    try
                    {
                        logger.Debug("Inicio emitir venda.");

                        string idMovimentoVenda = string.Empty;
                        string idTerminal = string.Empty;

                        if (VerificaMovimentoEmitirVenda((int)abastecimento.idAbastecimento, abastecimento.idUsuarioLogado, out idMovimentoVenda, out idTerminal))
                        {
                            if (!idMovimentoVenda.Equals(string.Empty))
                            {
                                logger.Debug("Atualizar abastecimento para emitir venda.");

                                String SQLAtualizaAbastecimento = @"UPDATE  abastecimento
                                                                    SET     id_movimento_venda = '" + idMovimentoVenda + @"',
                                                                            id_terminal = '" + idTerminal + @"',
                                                                            emitir_venda = 'S',
                                                                            marcador = 'S'
                                                                    WHERE   id_abastecimento = " + abastecimento.idAbastecimento + @"
                                                                    AND     marcador = 'N'
                                                                    AND     emitir_venda = 'N'
											                        AND     (NOT EXISTS (SELECT 1 FROM item_venda AS iv
			                                                                        INNER JOIN venda AS v ON (v.id_venda = iv.id_venda)
		                                                                            WHERE	iv.id_abastecimento = abastecimento.id_abastecimento
		                                                                            AND	    iv.cancelado = 'N'
                	                                                                AND	    v.situacao <> 4))
                                                                    AND     (NOT EXISTS (SELECT 1 FROM afericao
		                                                                            WHERE	id_abastecimento = abastecimento.id_abastecimento
		                                                                            AND	    cancelado = 'N'));";

                                cf.ExecutaComando(SQLAtualizaAbastecimento, ref conexao);

                                logger.Debug("Conferindo emissão de venda.");

                                string SQLConfereBloqueio = @"SELECT    1
                                                            FROM    abastecimento
                                                            WHERE   emitir_venda = 'S'
                                                            AND     marcador = 'S'
                                                            AND     id_terminal = '" + idTerminal + @"'
                                                            AND     id_movimento_venda = '" + idMovimentoVenda + @"'
                                                            AND     id_abastecimento = " + abastecimento.idAbastecimento + ";";

                                PgSqlDataReader drAbatecimento = cf.ObtemComando(SQLConfereBloqueio, ref conexao).ExecuteReader();

                                if (drAbatecimento.Read())
                                {
                                    logger.Debug("Abastecimento [" + abastecimento.idAbastecimento + "] atualizado para emitir venda.");
                                    return VerificarVendaEmitida(abastecimento);
                                }
                                else
                                {
                                    Object erro = "Abastecimento nao disponivel. Verifique se o mesmo esta sendo baixado em outro terminal.";
                                    logger.Error(erro);
                                    Usuario usuario = new Usuario();
                                    usuario.ErroMensagem = erro.ToString();
                                    usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                                    usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                                    return View("TrataErrosGenerico", usuario);
                                }
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        Object erro = "Erro ao atualizar o abastecimento para emitir venda. " + ex.Message;
                        logger.Error("Erro ao atualizar o abastecimento para emitir venda. " + ex.ToString());
                        Usuario usuario = new Usuario();
                        usuario.ErroMensagem = erro.ToString();
                        usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                        usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                        return View("TrataErrosGenerico", usuario);
                    }
                    finally
                    {
                        cf.FechaConexao(conexao);
                    }

                    return RedirectToAction("Index");
                }
                catch (Exception ex)
                {
                    logger.Error(ex.ToString());
                    Usuario usuario = new Usuario();
                    usuario.ErroMensagem = ex.ToString();
                    usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                    usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                    return View("TrataErrosGenerico", usuario);
                }
            }
            else
            {
                return RedirectToAction("browserInvalido", "Browser");
            }
        }
        public ActionResult VerificarVendaEmitida(Abastecimento abastecimento)
        {
            logger.Trace(string.Empty);
            logger.Debug("Tentando autenticador o POS.");

            if (autenticador.validaBrowser())
            {
                try
                {
                    ConnectionFactory cf = new ConnectionFactory();
                    PgSqlConnection conexao = new PgSqlConnection();
                    try
                    {
                        logger.Debug("Aguardando PDV Emitir venda.");

                        string SQLVerificaVendaFinalizada = @"SELECT 	v.id_venda,
                                                                        v.situacao,
                                                                        v.numero_protocolo_nfce,
                                                                        t.driver_ecf,
                                                                        e.configuracao,
                                                                        e.modelo
                                                              FROM 	    venda AS v
                                                              INNER JOIN item_venda AS iv ON (v.id_venda = iv.id_venda)
                                                              INNER JOIN ecf AS e ON (e.numero_serie_ecf = v.numero_serie_ecf)
                                                              INNER JOIN movimento_venda AS mv ON (mv.id_movimento_venda = v.id_movimento_venda)
                                                              INNER JOIN terminal AS t ON (mv.id_terminal = t.id_terminal)
                                                              WHERE 	iv.id_abastecimento = " + abastecimento.idAbastecimento + @"
                                                              AND 	    v.situacao = 3
                                                              LIMIT 1;";
                        int tentativas = 1;

                        while (tentativas <= 60)
                        {
                            PgSqlDataReader drVenda = cf.ObtemComando(SQLVerificaVendaFinalizada, ref conexao).ExecuteReader();

                            if (drVenda.Read())
                            {
                                logger.Debug("Venda localizada e finalizada.");

                                #region SQL NFCe
                                string SQLNFCe = @"SELECT	
	                                                    v.id_venda,
                                                        v.id_cliente,
	                                                    v.numero_cupom,
	                                                    v.chave_acesso_nfce,
	                                                    v.numero_ccf AS codigo_numerico_nfce,
                                                        v.placa,
                                                        v.unidade_consumidora,
                                                        v.odometro,
                                                        v.motorista,
                                                        v.quilometragem, 
                                                        v.ie_rg_rodape,
                                                        v.numero_autorizacao,
                                                        v.opcional_1,
                                                        v.opcional_2,
                                                        v.opcional_3,
                                                        v.opcional_4,
                                                        v.opcional_5,
	                                                    'VENDA' AS natureza_op,
	                                                    0 AS indicador_forma_pagamento,
	                                                    '65' AS codigo_modelo_doc_fiscal,
	                                                    COALESCE(v.fim_venda, v.data_cupom) AS data_cupom, 
	                                                    me.codigo_ibge AS codigo_ibge_empresa,
	                                                    '4' AS formato_impressao_danfe,
	                                                    (SELECT valor_alfanumerico FROM sis_parametro WHERE id_parametro = 'cnpj_empresa') AS cnpj_cpf_empresa,
	                                                    (SELECT valor_alfanumerico FROM sis_parametro WHERE id_parametro = 'razao_social_empresa') AS nome_empresa,
	                                                    (SELECT valor_alfanumerico FROM sis_parametro WHERE id_parametro = 'nome_empresa') AS fantasia_empresa,
	                                                    (SELECT valor_alfanumerico FROM sis_parametro WHERE id_parametro = 'logradouro_endereco') AS logradouro_empresa,
	                                                    (SELECT valor_alfanumerico FROM sis_parametro WHERE id_parametro = 'numero_endereco') AS nro_empresa,
	                                                    (SELECT valor_alfanumerico FROM sis_parametro WHERE id_parametro = 'complemento_endereco') AS complemento_empresa,
	                                                    (SELECT valor_alfanumerico FROM sis_parametro WHERE id_parametro = 'bairro_endereco') AS bairro_empresa,
	                                                    me.codigo_ibge AS codigo_ibge_ender_empresa,
	                                                    me.nome AS municipio_ender_empresa,
	                                                    me.sigla_uf AS uf_ender_empresa,
	                                                    (SELECT valor_alfanumerico FROM sis_parametro WHERE id_parametro = 'cep_endereco') AS cep_empresa,
	                                                    (SELECT valor_alfanumerico FROM sis_parametro WHERE id_parametro = 'fone_empresa') AS telefone_empresa,
	                                                    (SELECT valor_alfanumerico FROM sis_parametro WHERE id_parametro = 'fax_empresa') AS fax_empresa,
	                                                    (SELECT valor_alfanumerico FROM sis_parametro WHERE id_parametro = 'email_empresa') AS email_empresa,
	                                                    c.cnpj_cpf AS cnpj_cpf_cliente,
	                                                    c.nome AS nome_cliente,
	                                                    v.cliente_rodape,
	                                                    v.cnpj_cpf_rodape, 
	                                                    c.numero AS nro_cliente, 
	                                                    c.complemento AS complemento_cliente,
	                                                    c.bairro AS bairro_cliente, 
	                                                    c.email_nfe, 
	                                                    c.logradouro AS logradouro_cliente,
	                                                    mc.codigo_ibge AS codigo_ibge_cliente,
	                                                    mc.nome AS municipio_cliente,
	                                                    mc.sigla_uf AS uf_cliente,
	                                                    c.cep AS cep_cliente, 
	                                                    c.telefone AS telefone_cliente, 
	                                                    c.inscricao_estadual AS inscricao_estadual_cliente, 
	                                                    '' AS observacao, 
	                                                    '' AS informacao_adicional_fiscal, 
	                                                    '' AS informacao_complementar_contrib, 
	                                                    v.total_venda,
	                                                    COALESCE  ((SELECT        SUM(i.acrescimo + i.acrescimo_automatico)
	                                                    FROM            item_venda i
	                                                    WHERE        i.id_venda = v.id_venda AND i.cancelado = 'N'), 0) AS acrescimo, 
	                                                    COALESCE ((SELECT        SUM(i.desconto + i.desconto_automatico)
	                                                    FROM            item_venda i
	                                                    WHERE        i.id_venda = v.id_venda AND i.cancelado = 'N'), 0) AS desconto, 
	                                                    COALESCE ((SELECT        SUM(i.desconto + i.desconto_automatico)
	                                                    FROM            item_venda i INNER JOIN
						                                                      item AS it ON it.id_item = i.id_item
	                                                    WHERE        i.id_venda = v.id_venda AND it.tipo_item = 2 AND i.cancelado = 'N'), 0) AS desconto_issqn, 
	                                                    COALESCE ((SELECT        SUM(i.desconto + i.desconto_automatico)
	                                                    FROM            item_venda i INNER JOIN
						                                                      item AS it ON it.id_item = i.id_item
	                                                    WHERE        i.id_venda = v.id_venda AND it.tipo_item = 1 AND i.cancelado = 'N'), 0.00) AS desconto_icms, 
	                                                    v.contingencia_offline,
	                                                    mdf.serie AS serie_modelo_doc_fiscal,
	                                                    cdfe.inicio_contingencia,
	                                                    cdfe.motivo AS justificativa,
                                                        v.xml_nfce
                                                    FROM	venda AS v 
	                                                    INNER JOIN modelo_documento_fiscal AS mdf ON mdf.id_modelo_documento_fiscal = v.id_modelo_documento_fiscal
	                                                    INNER JOIN cliente AS c ON c.id_cliente = v.id_cliente 
	                                                    LEFT OUTER JOIN municipio AS mc ON mc.id_municipio = c.id_municipio
	                                                    INNER JOIN municipio AS me ON me.id_municipio = (SELECT valor_alfanumerico FROM sis_parametro WHERE id_parametro = 'id_municipio_empresa')
	                                                    LEFT OUTER JOIN contingencia_dfe AS cdfe ON cdfe.id_contingencia_dfe = v.id_contingencia_dfe
                                                    WHERE        v.id_venda = " + (int)drVenda["id_venda"] + ";";
                                #endregion

                                PgSqlDataReader drBuscaNFCe = cf.ObtemComando(SQLNFCe, ref conexao).ExecuteReader();

                                if (drBuscaNFCe.Read())
                                {
                                    if (((string)drVenda["driver_ecf"]).Equals("AdaptiveNFCe"))
                                    {
                                        #region DANFE NFCe
                                        int largura = 42;
                                        Danfe danfe = new Danfe();

                                        danfe.ItemOpc = string.Empty;
                                        danfe.ItemTrib = string.Empty;

                                        #region TITULO
                                        string cnpj = (string)drBuscaNFCe["cnpj_cpf_empresa"];
                                        danfe.CNPJ = cnpj.Substring(0, 2) + "." + cnpj.Substring(2, 3) + "." + cnpj.Substring(5, 3) + "/"
                                                    + cnpj.Substring(8, 4) + "-" + cnpj.Substring(12, 2);
                                        danfe.NomeEmpresa = (string)drBuscaNFCe["nome_empresa"];
                                        danfe.Endereco1 = (string)drBuscaNFCe["logradouro_empresa"] + ", " + (string)drBuscaNFCe["nro_empresa"] + " - "
                                                        + (string)drBuscaNFCe["complemento_empresa"] + " - " + (string)drBuscaNFCe["bairro_empresa"];
                                        danfe.Endereco2 = (string)drBuscaNFCe["municipio_ender_empresa"] + " - " + (string)drBuscaNFCe["uf_ender_empresa"];

                                        danfe.EmitidaContingencia = false;
                                        if (((string)drVenda["numero_protocolo_nfce"]).Equals(string.Empty))
                                            danfe.EmitidaContingencia = true;
                                        #endregion

                                        decimal totalTributosFederais = 0;
                                        decimal totalTributosEstaduais = 0;
                                        decimal totalTributosMunicipais = 0;

                                        decimal quantidadeItens = 0;
                                        decimal totalItens = 0;
                                        decimal totalAcrescimo = 0;
                                        decimal totalDesconto = 0;

                                        #region DETALHAMENTO ITENS
                                        #region SQL Item NFCe
                                        string SQLItensNFCe = @"SELECT	iv.id_item_venda,
                                                                    i.id_item,
                                                                    i.codigo AS codigo_item,
                                                                    COALESCE(i.codigo_barra, '') AS codigo_barra,
                                                                    RPAD(i.descricao, 120) AS denominacao_item,
                                                                    COALESCE(i.codigo_ncm, '') AS codigo_ncm,
                                                                    i.codigo_servico,
                                                                    i.codigo_anp,
                                                                    i.descricao_anp,
                                                                    iv.cfop,
                                                                    i.sigla_unidade,
                                                                    iv.quantidade,
                                                                    iv.preco,
                                                                    iv.total_item,
                                                                    0.00 AS rateio_frete,
                                                                    0.00 AS rateio_seguro,
                                                                    iv.desconto + iv.desconto_automatico AS desconto,
                                                                    0.00 AS rateio_despesa_acessoria,
                                                                    iv.acrescimo + iv.acrescimo_automatico AS acrescimo,
                                                                    i.tipo_item,
                                                                    i.origem_produto,
                                                                    iv.id_tipo_tributacao_icms,
                                                                    COALESCE(cst_icms.codigo, '') AS codigo_cst_icms,
                                                                    iv.base_icms,
                                                                    iv.base_icms_reduzida,
                                                                    iv.aliquota_icms,
                                                                    iv.icms,
                                                                    iv.base_icms_substituicao,
                                                                    iv.icms_substituicao,
                                                                    iv.base_icms_st_retido,
                                                                    iv.icms_st_retido,
                                                                    iv.id_tipo_tributacao_pis,
                                                                    COALESCE(cst_pis.codigo, '') AS codigo_cst_pis,
                                                                    iv.base_pis,
                                                                    iv.aliquota_pis,
                                                                    iv.pis,
                                                                    iv.id_tipo_tributacao_cofins,
                                                                    COALESCE(cst_cofins.codigo, '') AS codigo_cst_cofins,
                                                                    iv.base_cofins,
                                                                    iv.aliquota_cofins,
                                                                    iv.cofins,
                                                                    iv.base_iss,
                                                                    iv.aliquota_iss,
                                                                    iv.iss,
                                                                    CASE WHEN tt.tipo_tributacao = 2 THEN 'I' ELSE 'N' END AS situacao_tributaria,
                                                                        COALESCE(tt.reducao_base, 0) AS reducao_base,
                                                                        b.numero AS bico,
                                                                        bc.numero AS bomba,
                                                                        le.numero_tanque AS tanque,
                                                                        a.encerrante_inicial,
                                                                        a.encerrante,
                                                                        i.codigo_cest,
                                                                        i.carga_tributaria_estadual, 
                                                                        i.carga_tributaria_federal, 
                                                                        i.carga_tributaria_municipal
                                                                    FROM    item_venda AS iv
                                                                        INNER JOIN venda AS v ON (v.id_venda = iv.id_venda)
                                                                        INNER JOIN item AS i ON (i.id_item = iv.id_item)
                                                                        LEFT OUTER JOIN cst AS cst_icms ON (cst_icms.id_cst = iv.id_cst_icms)
                                                                        LEFT OUTER JOIN tipo_tributacao_ecf AS tt ON (tt.id_tipo_tributacao_ecf = iv.id_tipo_tributacao_icms)
                                                                        LEFT OUTER JOIN cst AS cst_pis ON (cst_pis.id_cst = iv.id_cst_pis)
                                                                        LEFT OUTER JOIN cst AS cst_cofins ON (cst_cofins.id_cst = iv.id_cst_cofins)
                                                                        LEFT OUTER JOIN abastecimento AS a ON (a.id_abastecimento = iv.id_abastecimento)
                                                                        LEFT OUTER JOIN bico_combustivel AS b ON (b.id_bico_combustivel = a.id_bico_combustivel)
                                                                        LEFT OUTER JOIN bomba_combustivel AS bc ON (bc.id_bomba_combustivel = b.id_bomba_combustivel)
                                                                        LEFT OUTER JOIN local_estoque AS le ON (le.id_local_estoque = b.id_tanque)
                                                                WHERE   iv.id_venda = " + (int)drVenda["id_venda"] + @"
                                                                AND iv.cancelado = 'N'";
                                        #endregion

                                        PgSqlDataReader drBuscaItemNFCe = cf.ObtemComando(SQLItensNFCe, ref conexao).ExecuteReader();

                                        if (drBuscaItemNFCe.Read())
                                        {
                                            quantidadeItens += (decimal)drBuscaItemNFCe["quantidade"];
                                            totalAcrescimo += (decimal)drBuscaItemNFCe["acrescimo"];
                                            totalDesconto += (decimal)drBuscaItemNFCe["desconto"];
                                            totalItens += ((decimal)drBuscaItemNFCe["total_item"] - (decimal)drBuscaItemNFCe["acrescimo"] + (decimal)drBuscaItemNFCe["desconto"]);

                                            decimal tributosFederais = Math.Round(((decimal)drBuscaItemNFCe["total_item"] * (decimal)drBuscaItemNFCe["carga_tributaria_federal"]) / 100, 2, MidpointRounding.ToEven);
                                            decimal tributosMunicipais = 0;
                                            decimal tributosEstaduais = 0;
                                            totalTributosFederais += tributosFederais;
                                            if (((int)drBuscaItemNFCe["tipo_item"]) == 2) //serviço
                                            {
                                                tributosMunicipais = Math.Round(((decimal)drBuscaItemNFCe["total_item"] * (decimal)drBuscaItemNFCe["carga_tributaria_municipal"]) / 100, 2, MidpointRounding.ToEven); ;
                                                totalTributosMunicipais += tributosMunicipais;
                                            }
                                            else
                                            {
                                                tributosEstaduais = Math.Round(((decimal)drBuscaItemNFCe["total_item"] * (decimal)drBuscaItemNFCe["carga_tributaria_estadual"]) / 100, 2, MidpointRounding.ToEven);
                                                totalTributosEstaduais += tributosEstaduais;
                                            }

                                            string item1 = string.Empty;
                                            if (((string)drBuscaItemNFCe["codigo_barra"]).Equals(string.Empty))
                                                item1 = item1 + (string)drBuscaItemNFCe["codigo_item"];
                                            else
                                                item1 = item1 + (string)drBuscaItemNFCe["codigo_barra"];

                                            item1 = item1.PadRight(14).Substring(0, 14) + " ";

                                            int tamanhoDescricao = largura - (item1.Length);

                                            danfe.Item1 = item1 + ((string)drBuscaItemNFCe["denominacao_item"]).PadRight(tamanhoDescricao).Substring(0, tamanhoDescricao);

                                            string item2 = ((decimal)drBuscaItemNFCe["quantidade"]).ToString(getFormatString((decimal)drBuscaItemNFCe["quantidade"])).PadLeft(9) + " ";
                                            item2 = item2 + (string)drBuscaItemNFCe["sigla_unidade"] + " ";
                                            item2 = item2 + ((decimal)drBuscaItemNFCe["preco"]).ToString("N3").PadLeft(16) + " ";

                                            string totalItem = Math.Round((decimal)drBuscaItemNFCe["quantidade"] * (decimal)drBuscaItemNFCe["preco"], 2).ToString("N2");
                                            danfe.Item2 = item2.PadRight(largura - totalItem.Length).Substring(0, largura - totalItem.Length) + totalItem;

                                            string item3 = string.Empty;
                                            if (((decimal)drBuscaItemNFCe["desconto"]) > 0)
                                                item3 = "Desconto: " + ((decimal)drBuscaItemNFCe["desconto"]).ToString("N2") + "  ";
                                            else if (((decimal)drBuscaItemNFCe["acrescimo"]) > 0)
                                                item3 = "Acrescimo: " + ((decimal)drBuscaItemNFCe["acrescimo"]).ToString("N2") + "  ";

                                            danfe.ItemOpc = item3.PadRight(largura).Substring(0, largura);

                                            if (ParametroAlfanumerico("detalhar_tributo_lei_12741_nfce").Equals("S"))
                                            {
                                                string sTribDetalhe = "Trib. R$: " + tributosFederais.ToString("N2") + " Federal";
                                                if (tributosEstaduais > 0)
                                                    sTribDetalhe += " e " + tributosEstaduais.ToString("N2") + " Estadual";
                                                else if (tributosMunicipais > 0)
                                                    sTribDetalhe += " e " + tributosMunicipais.ToString("N2") + " Municipal";

                                                danfe.ItemTrib = sTribDetalhe;
                                            }
                                        }
                                        #endregion

                                        #region TOTAIS
                                        string sQuantidadeItens = quantidadeItens.ToString("N3");
                                        string sQtd = "Qtde. Total de Itens".PadRight(largura - sQuantidadeItens.Length) + sQuantidadeItens;
                                        danfe.QtdTotalItem = sQtd;

                                        string sTotalItemFormatado = totalItens.ToString("N2");
                                        string sTotalItem = "Valor Total R$".PadRight(largura - sTotalItemFormatado.Length) + sTotalItemFormatado;
                                        danfe.ValorTotal = sTotalItem;

                                        if (totalAcrescimo > 0)
                                        {
                                            string sAcrescimoFormatado = totalAcrescimo.ToString("N2");
                                            string sAcrescimo = "Acrescimo R$".PadRight(largura - sAcrescimoFormatado.Length) + sAcrescimoFormatado;
                                            danfe.AcrescimoTotal = sAcrescimo;
                                        }

                                        if (totalDesconto > 0)
                                        {
                                            string sDescontoFormatado = totalDesconto.ToString("N2");
                                            string sDesconto = "Desconto R$".PadRight(largura - sDescontoFormatado.Length) + sDescontoFormatado;
                                            danfe.DescontoTotal = sDesconto;
                                        }

                                        string totalNota = ((decimal)drBuscaNFCe["total_venda"]).ToString("N2");
                                        string total = "Valor a Pagar R$".PadRight(largura - totalNota.Length) + totalNota;
                                        danfe.ValorPagar = total;

                                        danfe.FormaPagamento = "FORMA PAGAMENTO".PadRight(largura - 13) + "VALOR PAGO R$";

                                        string SQLRecebimentoNFCe = @"SELECT	r.id_recebimento_venda,
	                                                                        f.id_tipo_recebimento,
	                                                                        r.valor_recebido,
	                                                                        r.valor_troco,
	                                                                        COALESCE(cf.cnpj_cpf, '') AS cnpj_credenciadora,
	                                                                        f.denominacao AS denominacao_bandeira,
	                                                                        r.nsu,
                                                                            tr.denominacao AS denominacao_tipo_recebimento
                                                                        FROM	recebimento_venda AS r
	                                                                        INNER JOIN forma_recebimento AS f ON (f.id_forma_recebimento = r.id_forma_recebimento)
                                                                            INNER JOIN tipo_recebimento AS tr ON (f.id_tipo_recebimento = tr.id_tipo_recebimento)
	                                                                        LEFT OUTER JOIN cliente AS cf ON (cf.id_cliente = f.id_pessoa_financeiro)
	                                                                        LEFT OUTER JOIN bandeira_tef AS bt ON (bt.id_bandeira_tef = f.id_bandeira_tef)
                                                                        WHERE 	r.id_venda = " + (int)drVenda["id_venda"] + ";";

                                        PgSqlDataReader drBuscaRecebimentoNFCe = cf.ObtemComando(SQLRecebimentoNFCe, ref conexao).ExecuteReader();

                                        if (drBuscaRecebimentoNFCe.Read())
                                        {
                                            decimal troco = 0;

                                            string valorPag = ((decimal)drBuscaRecebimentoNFCe["valor_recebido"]).ToString("N2");
                                            string forma = ((string)drBuscaRecebimentoNFCe["denominacao_tipo_recebimento"]).PadRight(largura - valorPag.Length) + valorPag;

                                            danfe.Pagamento = forma;
                                            troco += (decimal)drBuscaRecebimentoNFCe["valor_troco"];

                                            string valorTroco = troco.ToString("N2");
                                            string stroco = "Troco R$".PadRight(largura - valorTroco.Length) + valorTroco;
                                            danfe.Troco = stroco;
                                        }
                                        #endregion

                                        bool homologacao = false;
                                        if (((string)drVenda["modelo"]).Equals("NFCE-H"))
                                            homologacao = true;

                                        string chaveAcessoNFCe = (string)drBuscaNFCe["chave_acesso_nfce"];

                                        #region CONSULTA PELA CHAVE DE ACESSO
                                        if (homologacao)
                                        {
                                            danfe.UrlChave = ParametroAlfanumerico("url_consulta_danfe_nfce_homolog");
                                        }
                                        else
                                        {
                                            danfe.UrlChave = ParametroAlfanumerico("url_consulta_danfe_nfce_produca");
                                        }

                                        string sChaveAcesso = chaveAcessoNFCe.Insert(4, " ").Insert(9, " ").Insert(14, " ").Insert(19, " ").Insert(24, " ")
                                            .Insert(29, " ").Insert(34, " ").Insert(39, " ").Insert(44, " ").Insert(49, " ");

                                        danfe.Chave = sChaveAcesso;
                                        #endregion

                                        #region CONSUMIDOR
                                        bool consumidorPadrao = ((string)drBuscaNFCe["id_cliente"]).Equals(ParametroAlfanumerico("id_consumidor_padrao"));

                                        danfe.EnderecoCliente1 = string.Empty;
                                        danfe.EnderecoCliente2 = string.Empty;

                                        string cnpjCpfCliente = (string)drBuscaNFCe["cnpj_cpf_cliente"];
                                        string nomeCliente = (string)drBuscaNFCe["nome_cliente"];
                                        if (consumidorPadrao)
                                        {
                                            cnpjCpfCliente = (string)drBuscaNFCe["cnpj_cpf_rodape"];
                                            nomeCliente = (string)drBuscaNFCe["cliente_rodape"];
                                        }
                                        else if (cnpjCpfCliente.Equals("") && ParametroAlfanumerico("permite_informar_dados_cliente_inicio_venda_cliente_sem_cnpj_cpf").Equals("S"))
                                        {
                                            cnpjCpfCliente = (string)drBuscaNFCe["cnpj_cpf_rodape"];
                                            nomeCliente = (string)drBuscaNFCe["cliente_rodape"];
                                        }

                                        if (cnpjCpfCliente.Length == 0)
                                            danfe.Consumidor = "CONSUMIDOR NAO IDENTIFICADO";
                                        else
                                        {
                                            if (cnpjCpfCliente.Length <= 11)
                                                danfe.Consumidor = "Consumidor CPF: " + cnpjCpfCliente;
                                            else
                                                danfe.Consumidor = "Consumidor CNPJ: " + cnpjCpfCliente;

                                            if (!nomeCliente.Equals(string.Empty))
                                                danfe.NomeCliente = nomeCliente;
                                        }
                                        if (!consumidorPadrao && !((string)drBuscaNFCe["logradouro_cliente"]).Equals(string.Empty))
                                        {
                                            danfe.EnderecoCliente1 = (string)drBuscaNFCe["logradouro_cliente"] + ", " + (string)drBuscaNFCe["nro_cliente"] + " - " + (string)drBuscaNFCe["complemento_cliente"] + " - " + (string)drBuscaNFCe["bairro_cliente"];
                                            danfe.EnderecoCliente2 = (string)drBuscaNFCe["municipio_cliente"] + " - " + (string)drBuscaNFCe["uf_cliente"];
                                        }
                                        #endregion

                                        #region NFC-E
                                        danfe.NumeroNFC = "NFC-e NR: " + ((int)drBuscaNFCe["numero_cupom"]).ToString() + " Série:" + Convert.ToInt16((string)drBuscaNFCe["serie_modelo_doc_fiscal"]).ToString()
                                            + " " + ((DateTime)drBuscaNFCe["data_cupom"]).ToString("dd/MM/yyyy HH:mm:ss");

                                        if (!((string)drVenda["numero_protocolo_nfce"]).Equals(string.Empty))
                                        {
                                            danfe.Protocolo = "Protocolo de Autorização: " + ((string)drVenda["numero_protocolo_nfce"]);
                                            danfe.DataAutorizacao = "Data de Autorização: " + ((DateTime)drBuscaNFCe["data_cupom"]).ToString("dd/MM/yyyy HH:mm:ss");
                                        }

                                        if (homologacao)
                                        {
                                            danfe.Homologacao1 = "EMITIDA EM AMBIENTE DE HOMOLOGAÇÃO";
                                            danfe.Homologacao2 = "SEM VALOR FISCAL";

                                        }
                                        #endregion

                                        #region QRCODE
                                        decimal icms = 0;
                                        string digestValue = string.Empty;
                                        if (((string)drBuscaNFCe["contingencia_offline"]).Equals("N"))
                                        {
                                            byte[] xmlDescompactado;
                                            DescompactarZip((byte[])drBuscaNFCe["xml_nfce"], out xmlDescompactado);

                                            XmlDocument docCompleto = new XmlDocument();
                                            docCompleto.PreserveWhitespace = false;
                                            docCompleto.LoadXml(Encoding.UTF8.GetString(xmlDescompactado));

                                            digestValue = docCompleto.GetElementsByTagName("DigestValue")[0].InnerText;

                                            XmlDocument docIcmsTot = new XmlDocument();
                                            docIcmsTot.PreserveWhitespace = false;
                                            docIcmsTot.LoadXml(docCompleto.GetElementsByTagName("ICMSTot")[0].OuterXml);

                                            icms = Convert.ToDecimal(docIcmsTot.GetElementsByTagName("vICMS")[0].InnerText);
                                        }

                                        DateTime dataCupom = (DateTime)drBuscaNFCe["data_cupom"];

                                        danfe.TextQRCode = obtemQrCode(homologacao, chaveAcessoNFCe, cnpjCpfCliente, dataCupom, (decimal)drBuscaNFCe["total_venda"], icms, digestValue);
                                        logger.Debug("danfe.TextQRCode=" + danfe.TextQRCode);
                                        #endregion

                                        #region TRIBUTOS E INFORMACOES ADICIONAIS
                                        string sTotTrib = (totalTributosEstaduais + totalTributosFederais + totalTributosMunicipais).ToString("F2");
                                        string sTotalTrib = "Total R$ " + sTotTrib;

                                        danfe.TributoTotal = sTotalTrib;

                                        string sTrib = "R$: " + totalTributosFederais.ToString("F2") + " Federal";
                                        if (totalTributosEstaduais > 0 && totalTributosMunicipais > 0)
                                            sTrib = "Trib aprox R$: " + totalTributosFederais.ToString("F2") + " Fed, " + totalTributosEstaduais.ToString("F2") + " Est e " + totalTributosMunicipais.ToString("F2") + " Mun";
                                        else if (totalTributosEstaduais > 0)
                                            sTrib += " e " + totalTributosEstaduais.ToString("F2") + " Estadual";
                                        else if (totalTributosMunicipais > 0)
                                            sTrib += " e " + totalTributosMunicipais.ToString("F2") + " Municipal";

                                        danfe.Tributo = sTrib;

                                        IList<string> rodape = new List<string>(); 
                                        obtemRodapeCupom(cf, conexao, drBuscaNFCe, out rodape);

                                        int n = 1;
                                        foreach (string linha in rodape)
                                        {
                                            if (n == 1) { 
                                                danfe.mensagem1 = linha;
                                                logger.Trace(linha);
                                                n++;
                                            }
                                            else if (n == 2)
                                            {
                                                danfe.mensagem2 = linha;
                                                logger.Trace(linha);
                                                n++;
                                            }
                                            else if (n == 3)
                                            {
                                                danfe.mensagem3 = linha;
                                                logger.Trace(linha);
                                                n++;
                                            }
                                            else if (n == 4)
                                            {
                                                danfe.mensagem4 = linha;
                                                logger.Trace(linha);
                                                n++;
                                            }
                                            else if (n == 5)
                                            {
                                                danfe.mensagem5 = linha;
                                                logger.Trace(linha);
                                                n++;
                                            }
                                            else if (n == 6)
                                            {
                                                danfe.mensagem6 = linha;
                                                logger.Trace(linha);
                                                n++;
                                            }
                                            else if (n == 7)
                                            {
                                                danfe.mensagem7 = linha;
                                                logger.Trace(linha);
                                                n++;
                                            }
                                            else if (n == 8)
                                            {
                                                danfe.mensagem8 = linha;
                                                logger.Trace(linha);
                                                n++;
                                            }
                                        }
                                        #endregion
                                        #endregion

                                        danfe.idUsuarioLogado = abastecimento.idUsuarioLogado;
                                        danfe.idAtendenteLogado = abastecimento.idAtendenteLogado;
                                        return View("ImprimirDANFENFC", danfe);
                                    }
                                    else if (((string)drVenda["driver_ecf"]).Equals("AdaptiveCFeSAT"))
                                    {
                                        #region DANFE CF-e-SAT
                                        int largura = 42;
                                        Danfe danfe = new Danfe();

                                        danfe.ItemOpc = string.Empty;
                                        danfe.ItemTrib = string.Empty;

                                        danfe.NomeEmpresa = (string)drBuscaNFCe["nome_empresa"];

                                        string cnpj = (string)drBuscaNFCe["cnpj_cpf_empresa"];
                                        if (cnpj.Length == 14)
                                            cnpj += cnpj.Substring(0, 2) + "." + cnpj.Substring(2, 3)
                                                + "." + cnpj.Substring(5, 3) + "/" + cnpj.Substring(8, 4) + "-" + cnpj.Substring(12, 2);

                                        danfe.CNPJ = cnpj;
                                        danfe.InscEstadual = ParametroAlfanumerico("inscricao_estadual_empresa");
                                        danfe.Endereco1 = (string)drBuscaNFCe["logradouro_empresa"] + ", " + (string)drBuscaNFCe["nro_empresa"] + " - "
                                                        + (string)drBuscaNFCe["complemento_empresa"] + " - " + (string)drBuscaNFCe["bairro_empresa"];
                                        danfe.Endereco2 = (string)drBuscaNFCe["municipio_ender_empresa"] + " - " + (string)drBuscaNFCe["uf_ender_empresa"];

                                        danfe.NumeroNFC = ((int)drBuscaNFCe["numero_cupom"]).ToString("D6");

                                        bool consumidorPadrao = ((string)drBuscaNFCe["id_cliente"]).Equals(ParametroAlfanumerico("id_consumidor_padrao"));

                                        string cnpjCpfCliente = (string)drBuscaNFCe["cnpj_cpf_cliente"];
                                        string nomeCliente = (string)drBuscaNFCe["nome_cliente"];
                                        if (consumidorPadrao)
                                        {
                                            cnpjCpfCliente = (string)drBuscaNFCe["cnpj_cpf_rodape"];
                                            nomeCliente = (string)drBuscaNFCe["cliente_rodape"];
                                        }
                                        else if (cnpjCpfCliente.Equals("") && ParametroAlfanumerico("permite_informar_dados_cliente_inicio_venda_cliente_sem_cnpj_cpf").Equals("S"))
                                        {
                                            cnpjCpfCliente = (string)drBuscaNFCe["cnpj_cpf_rodape"];
                                            nomeCliente = (string)drBuscaNFCe["cliente_rodape"];
                                        }

                                        danfe.Consumidor = cnpjCpfCliente;
                                        if (!nomeCliente.Equals(string.Empty))
                                            danfe.NomeCliente = nomeCliente;
                                        if (!consumidorPadrao && !((string)drBuscaNFCe["logradouro_cliente"]).Equals(string.Empty))
                                        {
                                            danfe.EnderecoCliente1 = (string)drBuscaNFCe["logradouro_cliente"] + ", " + (string)drBuscaNFCe["nro_cliente"] + " - "
                                                                   + (string)drBuscaNFCe["complemento_cliente"] + " - " + (string)drBuscaNFCe["bairro_cliente"];
                                            danfe.EnderecoCliente2 = (string)drBuscaNFCe["municipio_cliente"] + " - " + (string)drBuscaNFCe["uf_cliente"];
                                        }

                                        decimal totalTributosFederais = 0;
                                        decimal totalTributosEstaduais = 0;
                                        decimal totalTributosMunicipais = 0;

                                        #region SQL Item NFCe
                                        string SQLItensNFCe = @"SELECT	iv.id_item_venda,
                                                                    i.id_item,
                                                                    i.codigo AS codigo_item,
                                                                    COALESCE(i.codigo_barra, '') AS codigo_barra,
                                                                    RPAD(i.descricao, 120) AS denominacao_item,
                                                                    COALESCE(i.codigo_ncm, '') AS codigo_ncm,
                                                                    i.codigo_servico,
                                                                    i.codigo_anp,
                                                                    i.descricao_anp,
                                                                    iv.cfop,
                                                                    i.sigla_unidade,
                                                                    iv.quantidade,
                                                                    iv.preco,
                                                                    iv.total_item,
                                                                    0.00 AS rateio_frete,
                                                                    0.00 AS rateio_seguro,
                                                                    iv.desconto + iv.desconto_automatico AS desconto,
                                                                    0.00 AS rateio_despesa_acessoria,
                                                                    iv.acrescimo + iv.acrescimo_automatico AS acrescimo,
                                                                    i.tipo_item,
                                                                    i.origem_produto,
                                                                    iv.id_tipo_tributacao_icms,
                                                                    COALESCE(cst_icms.codigo, '') AS codigo_cst_icms,
                                                                    iv.base_icms,
                                                                    iv.base_icms_reduzida,
                                                                    iv.aliquota_icms,
                                                                    iv.icms,
                                                                    iv.base_icms_substituicao,
                                                                    iv.icms_substituicao,
                                                                    iv.base_icms_st_retido,
                                                                    iv.icms_st_retido,
                                                                    iv.id_tipo_tributacao_pis,
                                                                    COALESCE(cst_pis.codigo, '') AS codigo_cst_pis,
                                                                    iv.base_pis,
                                                                    iv.aliquota_pis,
                                                                    iv.pis,
                                                                    iv.id_tipo_tributacao_cofins,
                                                                    COALESCE(cst_cofins.codigo, '') AS codigo_cst_cofins,
                                                                    iv.base_cofins,
                                                                    iv.aliquota_cofins,
                                                                    iv.cofins,
                                                                    iv.base_iss,
                                                                    iv.aliquota_iss,
                                                                    iv.iss,
                                                                    CASE WHEN tt.tipo_tributacao = 2 THEN 'I' ELSE 'N' END AS situacao_tributaria,
                                                                        COALESCE(tt.reducao_base, 0) AS reducao_base,
                                                                        b.numero AS bico,
                                                                        bc.numero AS bomba,
                                                                        le.numero_tanque AS tanque,
                                                                        a.encerrante_inicial,
                                                                        a.encerrante,
                                                                        i.codigo_cest,
                                                                        i.carga_tributaria_estadual, 
                                                                        i.carga_tributaria_federal, 
                                                                        i.carga_tributaria_municipal
                                                                    FROM    item_venda AS iv
                                                                        INNER JOIN venda AS v ON (v.id_venda = iv.id_venda)
                                                                        INNER JOIN item AS i ON (i.id_item = iv.id_item)
                                                                        LEFT OUTER JOIN cst AS cst_icms ON (cst_icms.id_cst = iv.id_cst_icms)
                                                                        LEFT OUTER JOIN tipo_tributacao_ecf AS tt ON (tt.id_tipo_tributacao_ecf = iv.id_tipo_tributacao_icms)
                                                                        LEFT OUTER JOIN cst AS cst_pis ON (cst_pis.id_cst = iv.id_cst_pis)
                                                                        LEFT OUTER JOIN cst AS cst_cofins ON (cst_cofins.id_cst = iv.id_cst_cofins)
                                                                        LEFT OUTER JOIN abastecimento AS a ON (a.id_abastecimento = iv.id_abastecimento)
                                                                        LEFT OUTER JOIN bico_combustivel AS b ON (b.id_bico_combustivel = a.id_bico_combustivel)
                                                                        LEFT OUTER JOIN bomba_combustivel AS bc ON (bc.id_bomba_combustivel = b.id_bomba_combustivel)
                                                                        LEFT OUTER JOIN local_estoque AS le ON (le.id_local_estoque = b.id_tanque)
                                                                WHERE   iv.id_venda = " + (int)drVenda["id_venda"] + @"
                                                                AND iv.cancelado = 'N'";
                                        #endregion

                                        PgSqlDataReader drBuscaItemNFCe = cf.ObtemComando(SQLItensNFCe, ref conexao).ExecuteReader();

                                        int i = 1;
                                        if (drBuscaItemNFCe.Read())
                                        {
                                            decimal tributosFederais = Math.Round(((decimal)drBuscaItemNFCe["total_item"] * (decimal)drBuscaItemNFCe["carga_tributaria_federal"]) / 100, 2, MidpointRounding.ToEven);
                                            decimal tributosMunicipais = 0;
                                            decimal tributosEstaduais = 0;
                                            totalTributosFederais += tributosFederais;
                                            if ((int)drBuscaItemNFCe["tipo_item"] == 2) //serviço
                                            {
                                                tributosMunicipais = Math.Round(((decimal)drBuscaItemNFCe["total_item"] * (decimal)drBuscaItemNFCe["carga_tributaria_municipal"]) / 100, 2, MidpointRounding.ToEven); ;
                                                totalTributosMunicipais += tributosMunicipais;
                                            }
                                            else
                                            {
                                                tributosEstaduais = Math.Round(((decimal)drBuscaItemNFCe["total_item"] * (decimal)drBuscaItemNFCe["carga_tributaria_estadual"]) / 100, 2, MidpointRounding.ToEven);
                                                totalTributosEstaduais += tributosEstaduais;
                                            }

                                            string item1 = i.ToString("D3") + "  ";
                                            if (((string)drBuscaItemNFCe["codigo_barra"]).Equals(string.Empty))
                                                item1 = item1 + (string)drBuscaItemNFCe["codigo_item"];
                                            else
                                                item1 = item1 + (string)drBuscaItemNFCe["codigo_barra"];

                                            item1 = item1.PadRight(19).Substring(0, 19) + " ";

                                            int tamanhoDescricao = largura - (item1.Length);

                                            item1 = item1 + ((string)drBuscaItemNFCe["denominacao_item"]).PadRight(tamanhoDescricao).Substring(0, tamanhoDescricao);

                                            danfe.Item1 = item1;

                                            string item2 = ((decimal)drBuscaItemNFCe["quantidade"]).ToString(getFormatString((decimal)drBuscaItemNFCe["quantidade"])).PadLeft(9) + " ";
                                            item2 = item2 + (string)drBuscaItemNFCe["sigla_unidade"] + " ";
                                            item2 = item2 + ((decimal)drBuscaItemNFCe["preco"]).ToString("N3").PadLeft(16) + " ";

                                            string totalItem = Math.Round((decimal)drBuscaItemNFCe["quantidade"] * (decimal)drBuscaItemNFCe["preco"], 2).ToString("N2");
                                            item2 = item2.PadRight(largura - totalItem.Length).Substring(0, largura - totalItem.Length) + totalItem;

                                            danfe.Item2 = item2;

                                            string item3 = string.Empty;
                                            if ((decimal)drBuscaItemNFCe["desconto"] > 0)
                                                item3 = "Desconto: " + ((decimal)drBuscaItemNFCe["desconto"]).ToString("N2").PadLeft(18).PadRight(largura).Substring(0, largura);
                                            else if ((decimal)drBuscaItemNFCe["acrescimo"] > 0)
                                                item3 = "Acréscimo: " + ((decimal)drBuscaItemNFCe["acrescimo"]).ToString("N2").PadLeft(18).PadRight(largura).Substring(0, largura);

                                            if (!item3.Equals(string.Empty))
                                                danfe.ItemOpc = item3;

                                            if (ParametroAlfanumerico("detalhar_tributo_lei_12741_nfce").Equals("S"))
                                            {
                                                string sTribDetalhe = "Trib. R$: " + tributosFederais.ToString("N2") + " Federal";
                                                if (tributosEstaduais > 0)
                                                    sTribDetalhe += " e " + tributosEstaduais.ToString("N2") + " Estadual";
                                                else if (tributosMunicipais > 0)
                                                    sTribDetalhe += " e " + tributosMunicipais.ToString("N2") + " Municipal";

                                                danfe.ItemTrib = sTribDetalhe;
                                            }
                                        }

                                        string totalNota = ((decimal)drBuscaNFCe["total_venda"]).ToString("N2");
                                        string total = "Valor Total R$:".PadRight(largura - totalNota.Length) + totalNota;

                                        danfe.ValorTotal = total;

                                        string SQLRecebimentoNFCe = @"SELECT	r.id_recebimento_venda,
	                                                                        f.id_tipo_recebimento,
	                                                                        r.valor_recebido,
	                                                                        r.valor_troco,
	                                                                        COALESCE(cf.cnpj_cpf, '') AS cnpj_credenciadora,
	                                                                        f.denominacao AS denominacao_bandeira,
	                                                                        r.nsu,
                                                                            tr.denominacao AS denominacao_tipo_recebimento
                                                                        FROM	recebimento_venda AS r
	                                                                        INNER JOIN forma_recebimento AS f ON (f.id_forma_recebimento = r.id_forma_recebimento)
                                                                            INNER JOIN tipo_recebimento AS tr ON (f.id_tipo_recebimento = tr.id_tipo_recebimento)
	                                                                        LEFT OUTER JOIN cliente AS cf ON (cf.id_cliente = f.id_pessoa_financeiro)
	                                                                        LEFT OUTER JOIN bandeira_tef AS bt ON (bt.id_bandeira_tef = f.id_bandeira_tef)
                                                                        WHERE 	r.id_venda = " + (int)drVenda["id_venda"] + ";";

                                        PgSqlDataReader drBuscaRecebimentoNFCe = cf.ObtemComando(SQLRecebimentoNFCe, ref conexao).ExecuteReader();

                                        if (drBuscaRecebimentoNFCe.Read())
                                        {
                                            string valorPag = ((decimal)drBuscaRecebimentoNFCe["valor_recebido"]).ToString("N2");
                                            string forma = ((string)drBuscaRecebimentoNFCe["denominacao_tipo_recebimento"]).PadRight(largura - valorPag.Length) + valorPag;

                                            danfe.Pagamento = forma;
                                            decimal troco = (decimal)drBuscaRecebimentoNFCe["valor_troco"];

                                            string valorTroco = troco.ToString("N2");
                                            string stroco = "Troco: ".PadRight(largura - valorTroco.Length) + valorTroco;
                                            danfe.Troco = stroco;
                                        }

                                        string sTotTrib = (totalTributosEstaduais + totalTributosFederais + totalTributosMunicipais).ToString("N2");
                                        string sTotalTrib = "(Lei federal 12.741/12) - Total R$ ".PadRight(largura - sTotTrib.Length) + sTotTrib;

                                        danfe.TributoTotal = sTotalTrib;

                                        string sTrib = "R$: " + totalTributosFederais.ToString("N2") + " Federal";
                                        if (totalTributosEstaduais > 0 && totalTributosMunicipais > 0)
                                            sTrib = "Trib aprox R$: " + totalTributosFederais.ToString("N2") + " Fed, " + totalTributosEstaduais.ToString("N2") + " Est e " + totalTributosMunicipais.ToString("N2") + " Mun";
                                        else if (totalTributosEstaduais > 0)
                                            sTrib += " e " + totalTributosEstaduais.ToString("N2") + " Estadual";
                                        else if (totalTributosMunicipais > 0)
                                            sTrib += " e " + totalTributosMunicipais.ToString("N2") + " Municipal";

                                        string NumeroSerieSAT = string.Empty;
                                        string configuracao = (string)drVenda["configuracao"];

                                        IDictionary<string, string> Configuracoes = new Dictionary<string, string>();
                                        string[] configs = configuracao.Split(new string[] { ";" }, StringSplitOptions.RemoveEmptyEntries);
                                        foreach (string config in configs)
                                        {
                                            if (config.Contains("="))
                                            {
                                                string[] chaveValor = config.Split(new string[] { "=" }, StringSplitOptions.None);
                                                Configuracoes.Add(chaveValor[0], chaveValor[1]);
                                            }

                                        }
                                        if (Configuracoes.ContainsKey("NUM_SAT"))
                                            NumeroSerieSAT = Configuracoes["NUM_SAT"];

                                        danfe.NumeroSAT = NumeroSerieSAT;
                                        danfe.DataAutorizacao = ((DateTime)drBuscaNFCe["data_cupom"]).ToString("dd/MM/yyyy HH:mm:ss");

                                        string chaveAcesso = ((string)drBuscaNFCe["chave_acesso_nfce"]).Replace("CFe", "");

                                        for (int j = 0; j < 10; j++)
                                        {
                                            chaveAcesso = chaveAcesso.Insert(40 - (j * 4), "  ");
                                        }
                                        danfe.Chave = chaveAcesso;

                                        string chaveAcessoSemCFe = ((string)drBuscaNFCe["chave_acesso_nfce"]).StartsWith("CFe") ? ((string)drBuscaNFCe["chave_acesso_nfce"]).Remove(0, 3) : ((string)drBuscaNFCe["chave_acesso_nfce"]);

                                        danfe.ChaveCodBarra = chaveAcessoSemCFe;

                                        byte[] xmlDescompactado;
                                        DescompactarZip((byte[])drBuscaNFCe["xml_nfce"], out xmlDescompactado);

                                        XmlDocument docCompleto = new XmlDocument();
                                        docCompleto.PreserveWhitespace = false;
                                        docCompleto.LoadXml(Encoding.UTF8.GetString(xmlDescompactado));

                                        string assinaturaQRCODE = docCompleto.GetElementsByTagName("assinaturaQRCODE")[0].InnerText;

                                        string sQRCode = chaveAcessoSemCFe + "|" + ((DateTime)drBuscaNFCe["data_cupom"]).ToString("yyyyMMddHHmmss")
                                            + "|" + ((decimal)drBuscaNFCe["total_venda"]).ToString("N2").Replace(".", "").Replace(",", ".").Replace(" ", "") + "|" + cnpjCpfCliente + "|" + assinaturaQRCODE;

                                        danfe.TextQRCode = sQRCode;
                                        #endregion

                                        danfe.idUsuarioLogado = abastecimento.idUsuarioLogado;
                                        danfe.idAtendenteLogado = abastecimento.idAtendenteLogado;
                                        return View("ImprimirDANFESAT", danfe);
                                    }
                                }
                            }
                            else
                            {
                                logger.Debug("Venda não localizada ou não emitida.");
                                logger.Debug("Tentativa = " + tentativas);
                                tentativas++;
                                Thread.Sleep(1000);
                            }
                        }

                        if (tentativas > 60)
                        {
                            logger.Debug("Venda não localizada ou não emitida em 60 segundos - Perguntar.");
                            abastecimento.MensagemErro = "Venda não localizada ou não emitida em 60 segundos, selecione uma opcao:";
                            return View("TrataErrosEmitirVenda", abastecimento);
                        }
                    }
                    catch (Exception ex)
                    {
                        Object erro = "Erro ao verificar venda emitida. " + ex.Message;
                        logger.Error("Erro ao verificar venda emitida. " + ex.ToString());
                        Usuario usuario = new Usuario();
                        usuario.ErroMensagem = ex.ToString();
                        usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                        usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                        return View("TrataErrosGenerico", usuario);
                    }
                    finally
                    {
                        cf.FechaConexao(conexao);
                    }

                    return RedirectToAction("Index");
                }
                catch (Exception ex)
                {
                    logger.Error(ex.ToString());
                    Usuario usuario = new Usuario();
                    usuario.ErroMensagem = ex.ToString();
                    usuario.idUsuarioLogado = abastecimento.idUsuarioLogado;
                    usuario.idAtendenteLogado = abastecimento.idAtendenteLogado;
                    return View("TrataErrosGenerico", usuario);
                }
            }
            else
            {
                return RedirectToAction("browserInvalido", "Browser");
            }
        }
        private bool obtemRodapeCupom(ConnectionFactory cf, PgSqlConnection conexao, PgSqlDataReader vendaRow, out IList<string> mensagemIF)
        {
            mensagemIF = new List<string>();
            try
            {                            
                PgSqlDataReader drItemVendaCombustivel = cf.ObtemComando(@"SELECT	iv.id_item_venda,
                                                                        le.id_item_tanque AS id_item,
                                                                        bb.numero AS bomba,
                                                                        bc.numero,
                                                                        le.numero_tanque,
                                                                        a.encerrante,
                                                                        a.encerrante_inicial,
                                                                        iv.quantidade,
                                                                        iv.total_item,
                                                                        a.data_abastecimento,
                                                                        a.situacao,
                                                                        a.id_abastecimento,
                                                                        iv.cancelado
                                                                    FROM    item_venda AS iv
                                                                        INNER JOIN bico_combustivel AS bc ON(bc.id_bico_combustivel = iv.id_bico_combustivel)
                                                                        INNER JOIN bomba_combustivel AS bb ON(bb.id_bomba_combustivel = bc.id_bomba_combustivel)
                                                                        INNER JOIN local_estoque AS le ON(le.id_local_estoque = bc.id_tanque)
                                                                        INNER JOIN abastecimento AS a ON(a.id_abastecimento = iv.id_abastecimento)
                                                                    WHERE(iv.id_venda = " + vendaRow["id_venda"] + @")
                                                                    ORDER BY bc.numero, a.id_abastecimento", ref conexao).ExecuteReader();
                decimal totalLitragemMedia = 0;
                if (drItemVendaCombustivel.Read())
                {
                    bool imprimeTanqueEBomba = false;

                    string tBico = imprimeTanqueEBomba ? "#CF:BI" : "#CF:B";
                    string tBicoCanc = imprimeTanqueEBomba ? "#CC:BI" : "#CC:B";
                    string tTanque = "TQ:";
                    string tBomba = "BO:";
                    string tEi = "EI";
                    string tEf = "EF";

                    if (((string)drItemVendaCombustivel["cancelado"]).Equals("N"))
                        totalLitragemMedia += ((decimal)drItemVendaCombustivel["quantidade"]);

                    string linha;

                    linha = tBico + (drItemVendaCombustivel["numero"]).ToString().PadLeft(2, '0').Substring(0, 2);
                    if (imprimeTanqueEBomba)
                    {
                        linha += " " + tBomba + (drItemVendaCombustivel["bomba"]).ToString().PadLeft(2, '0').Substring(0, 2);
                        linha += " " + tTanque + (drItemVendaCombustivel["numero_tanque"]).ToString().PadLeft(2, '0').Substring(0, 2);
                    }
                    linha += " " + tEi + String.Format("{0:0.000}", ((decimal)drItemVendaCombustivel["encerrante_inicial"])).PadLeft(11, '0').Substring(0, 11);
                    linha += " " + tEf + String.Format("{0:0.000}", ((decimal)drItemVendaCombustivel["encerrante"])).PadLeft(11, '0').Substring(0, 11);
                    linha += " V" + String.Format("{0:0.000}", ((decimal)drItemVendaCombustivel["quantidade"]));

                    if (((int)drItemVendaCombustivel["situacao"]) == 5)
                    {
                        linha += "M";
                    }
                    else if (((int)drItemVendaCombustivel["situacao"]) == 6)
                    {
                        linha += "A";
                    }

                    mensagemIF.Add(linha);

                    if (((string)drItemVendaCombustivel["cancelado"]).Equals("S"))
                    {
                        linha = tBicoCanc + (drItemVendaCombustivel["numero"]).ToString().PadLeft(2, '0').Substring(0, 2);
                        if (imprimeTanqueEBomba)
                        {
                            linha += " " + tBomba + (drItemVendaCombustivel["bomba"]).ToString().PadLeft(2, '0').Substring(0, 2);
                            linha += " " + tTanque + (drItemVendaCombustivel["numero_tanque"]).ToString().PadLeft(2, '0').Substring(0, 2);
                        }
                        linha += " " + tEi + String.Format("{0:0.000}", ((decimal)drItemVendaCombustivel["encerrante_inicial"])).PadLeft(11, '0').Substring(0, 11);
                        linha += " " + tEf + String.Format("{0:0.000}", ((decimal)drItemVendaCombustivel["encerrante"])).PadLeft(11, '0').Substring(0, 11);
                        linha += " V" + String.Format("{0:0.000}", ((decimal)drItemVendaCombustivel["quantidade"]));

                        mensagemIF.Add(linha);
                    }
                    
                }
                
                if ((ParametroInteiro("configuracao_impressao_rodape") & 2097152) == 2097152)
                {

                    PgSqlDataReader dtEnderecoCliente = cf.ObtemComando(@"SELECT * FROM endereco_cliente WHERE (id_cliente = '" + ((string)vendaRow["id_cliente"]) + "' AND registro_excluido = 'N')", ref conexao).ExecuteReader();

                    if (dtEnderecoCliente.Read())
                    {
                        string endereco = string.Empty;
                        if (!dtEnderecoCliente["logradouro"].ToString().Replace(" ", "").Equals(string.Empty))
                            endereco += dtEnderecoCliente["tipoLogradouro"] + " ";

                        if (!dtEnderecoCliente["numero"].ToString().Replace(" ", "").Equals(string.Empty))
                            endereco += dtEnderecoCliente["numero"].ToString() + " ";

                        if (!dtEnderecoCliente["bairro"].ToString().Replace(" ", "").Equals(string.Empty))
                            endereco += dtEnderecoCliente["bairro"].ToString() + " ";

                        if (!dtEnderecoCliente["municipio"].ToString().Replace(" ", "").Equals(string.Empty))
                            endereco += dtEnderecoCliente["municipio"].ToString() + " ";

                        if (!dtEnderecoCliente["uf"].ToString().Replace(" ", "").Equals(string.Empty))
                            endereco += dtEnderecoCliente["uf"].ToString() + " ";

                        if (!dtEnderecoCliente["cep"].ToString().Replace(" ", "").Equals(string.Empty))
                            endereco += dtEnderecoCliente["cep"].ToString() + " ";

                        if (!dtEnderecoCliente["complemento"].ToString().Replace(" ", "").Equals(string.Empty))
                            endereco += dtEnderecoCliente["complemento"].ToString() + " ";

                        if (endereco.Length > 0)
                            endereco = endereco.Substring(0, endereco.Length - 1);

                        mensagemIF.Add(endereco);
                    }
                }
                PgSqlDataReader dtCliente = cf.ObtemComando(@"SELECT acrescimo_padrao, bairro, bloqueia_cnh_vencido, cartao_fidelidade, 
                                                                                 celular, cep, cnpj_cpf, codigo, complemento, consumidor_padrao, contra_senha, 
                                                                                 controla_capacidade_tanque, controla_combustivel_liberado, controla_limite_veiculo, 
                                                                                 controla_odometro, credito_disponivel, data_alteracao, data_cadastro, data_expedicao_rg, 
                                                                                 desconto_padrao, documento_estrangeiro, email_nfe, exibe_requisicao_pdv, exige_motorista, 
                                                                                 exige_nome_motorista, exige_numero_requisicao, exige_odometro, exige_placa_veiculo, 
                                                                                 exige_requisicao, exige_senha_motorista, exige_token_motorista, exige_veiculo, fantasia_codinome, 
                                                                                 habilita_geracao_ponto, id_classe_cliente, id_cliente, id_mensagem_fiscal, id_municipio, id_usuario_inclusao, 
                                                                                 imprimir_comprovante_venda, inscricao_estadual, inscricao_municipal, limitar_venda, liquida_fatura_np_pista, 
                                                                                 liquida_fatura_vm_pista, liquida_titulo_np_avulso_pista, liquida_titulo_vm_avulso_pista, logradouro, mensagem_venda, 
                                                                                 nascimento, natureza, nome, num_rg, numero, observacao, orgao_expedicao_rg, permite_troca_numerario, registro_excluido, 
                                                                                 restringir_forma_recebimento, restringir_item, restringir_tipo_recebimento, senha, sexo, sincronizacao, 
                                                                                 situacao, situacao_credito, sobrepoe_parametros_classe, telefone, tipo_cliente, tipo_controle_vale_motorista, 
                                                                                 tipo_emissao_documento_fiscal, tipo_logradouro, valor_disponivel_pgto_antecipado, valor_disponivel_venda, 
                                                                                 valor_maximo_troca_numerario, valor_maximo_troca_numerario_dia, vencimento_credito, versao_registro, vias_danfe 
                                                                        FROM cliente WHERE id_cliente = '" + (vendaRow["id_cliente"].ToString()) + "'", ref conexao).ExecuteReader();

                if (dtCliente.Read())
                {
                    if ((ParametroInteiro("configuracao_impressao_rodape") & 8) == 8)
                    {
                        string ieRg = string.Empty;
                        if (!vendaRow["ie_rg_rodape"].ToString().Trim().Equals(string.Empty))
                            ieRg = vendaRow["ie_rg_rodape"].ToString();
                        else if (!(dtCliente["inscricao_estadual"]).ToString().Trim().Equals(string.Empty))
                            ieRg = (dtCliente["inscricao_estadual"].ToString());
                        else if (!(dtCliente["num_rg"]).ToString().Trim().Equals(string.Empty))
                            ieRg = (dtCliente["num_rg"].ToString());
                        if(!ieRg.Equals(string.Empty))
                            mensagemIF.Add(string.Format("Codigo:[{0}] IE/RG: [{1}]", new object[] { (dtCliente["codigo"].ToString()), ieRg }));
                    }
                    if (((ParametroInteiro("configuracao_impressao_rodape") & 8388608) == 8388608)
                        && !(dtCliente["mensagem_venda"].ToString().Replace(" ", "").Equals(string.Empty)))
                    {
                        mensagemIF.Add(((string)dtCliente["mensagem_venda"]));
                    }
                }
                if (ParametroAlfanumerico("imprimir_informacoes_posto_pre_venda_em_qualquer_terminal").Equals("S"))
                {
                    string placaOdometro = string.Empty;

                    if (((ParametroInteiro("configuracao_impressao_rodape") & 128) == 128)
                        && !((vendaRow["placa"].ToString().Replace(" ", "").Equals(string.Empty)) && (vendaRow["unidade_consumidora"].ToString().Replace(" ", "").Equals(string.Empty)) && (((decimal)vendaRow["odometro"]) == 0))
                        && placaOdometro.Equals(string.Empty))
                    {
                        if (!(vendaRow["unidade_consumidora"].ToString().Replace(" ", "").Equals(string.Empty)))
                        {
                            placaOdometro = "UNIDADE CONS: " + vendaRow["unidade_consumidora"].ToString().ToUpper();
                            placaOdometro += " HORI: " + string.Format("{0:n1}", vendaRow["odometro"].ToString());
                        }
                        else
                        {
                            placaOdometro = "PLACA: " + vendaRow["placa"].ToString().Replace(" ", "").ToUpper();
                            placaOdometro += " ODOM: " + string.Format("{0:n1}", vendaRow["odometro"].ToString());
                        }

                        mensagemIF.Add(placaOdometro);
                    }

                    string motoristaRequisicao = string.Empty;

                    if (((ParametroInteiro("configuracao_impressao_rodape") & 256) == 256)
                        && !(vendaRow["motorista"].ToString().Replace(" ", "").Equals(string.Empty) && vendaRow["numero_autorizacao"].ToString().Replace(" ", "").Equals(string.Empty)))
                    {
                        motoristaRequisicao = "MOT: " + vendaRow["motorista"].ToString().PadRight(22).Substring(0, 22);
                        motoristaRequisicao += " REQ: " + vendaRow["numero_autorizacao"].ToString();
                        mensagemIF.Add(motoristaRequisicao);
                    }

                    string media = string.Empty;
                    if (((ParametroInteiro("configuracao_impressao_rodape") & 4194304) == 4194304)
                        && totalLitragemMedia > 0 && ((decimal)vendaRow["quilometragem"]) > 0)
                    {
                        media = "MEDIA: " + (Math.Round((((decimal)vendaRow["quilometragem"]) / totalLitragemMedia), 2)).ToString("N2") + " Km/Litro";
                        mensagemIF.Add(media);
                    }

                    PgSqlDataReader dtItemVenda = cf.ObtemComando(@"SELECT * FROM item_venda 
                                                                    WHERE (id_venda = " + vendaRow["id_venda"].ToString() + ") " +
                                                                    "AND (cancelado = 'N')", ref conexao).ExecuteReader();
                    if ((ParametroInteiro("configuracao_impressao_rodape") & 512) == 512)
                    {
                        while (dtItemVenda.Read())
                        {
                            if (!((string)dtItemVenda["id_atendente"]).Equals(string.Empty))
                            {
                                PgSqlDataReader dtAtendente = cf.ObtemComando(@"SELECT * FROM atendente 
                                                                                        WHERE id_atendente = '" + ((string)dtItemVenda["id_atendente"]) + 
                                                                                        "'", ref conexao).ExecuteReader();
                                if (dtAtendente.Read())
                                    mensagemIF.Add("Atendente: " + dtAtendente["codigo"].ToString() + "-" + dtAtendente["nome"].ToString());

                                break;
                            }
                        }
                    }
                }
                if (((ParametroInteiro("configuracao_impressao_rodape") & 1024) == 1024)
                    && !vendaRow["opcional_1"].ToString().Equals(string.Empty))
                    mensagemIF.Add(this.labelCampoOpcional(ParametroAlfanumerico("configuracao_campo_opcional_1")) + ": " + vendaRow["opcional_1"].ToString());

                if (((ParametroInteiro("configuracao_impressao_rodape") & 2048) == 2048)
                    && !vendaRow["opcional_2"].ToString().Equals(string.Empty))
                    mensagemIF.Add(this.labelCampoOpcional(ParametroAlfanumerico("configuracao_campo_opcional_2")) + ": " + vendaRow["opcional_2"].ToString());

                if (((ParametroInteiro("configuracao_impressao_rodape") & 4096) == 4096)
                    && !vendaRow["opcional_3"].ToString().Equals(string.Empty))
                    mensagemIF.Add(this.labelCampoOpcional(ParametroAlfanumerico("configuracao_campo_opcional_3")) + ": " + vendaRow["opcional_3"].ToString());

                if (((ParametroInteiro("configuracao_impressao_rodape") & 8192) == 8192)
                    && !vendaRow["opcional_4"].ToString().Equals(string.Empty))
                    mensagemIF.Add(this.labelCampoOpcional(ParametroAlfanumerico("configuracao_campo_opcional_4")) + ": " + vendaRow["opcional_4"].ToString());

                if (((ParametroInteiro("configuracao_impressao_rodape") & 16384) == 16384)
                    && !vendaRow["opcional_5"].ToString().Equals(string.Empty))
                    mensagemIF.Add(this.labelCampoOpcional(ParametroAlfanumerico("configuracao_campo_opcional_5")) + ": " + vendaRow["opcional_5"].ToString());

                if (((ParametroInteiro("configuracao_impressao_rodape") & 32768) == 32768)
                    && !ParametroAlfanumerico("texto_rodape_linha_1").Replace(" ", "").Equals(string.Empty))
                    mensagemIF.Add(ParametroAlfanumerico("texto_rodape_linha_1"));

                if (((ParametroInteiro("configuracao_impressao_rodape") & 65536) == 65536)
                    && !ParametroAlfanumerico("texto_rodape_linha_2").Replace(" ", "").Equals(string.Empty))
                    mensagemIF.Add(ParametroAlfanumerico("texto_rodape_linha_2"));

                if (((ParametroInteiro("configuracao_impressao_rodape") & 131072) == 131072)
                    && !ParametroAlfanumerico("texto_rodape_linha_3").Replace(" ", "").Equals(string.Empty))
                    mensagemIF.Add(ParametroAlfanumerico("texto_rodape_linha_3"));

                if (((ParametroInteiro("configuracao_impressao_rodape") & 262144) == 262144)
                    && !ParametroAlfanumerico("texto_rodape_linha_4").Replace(" ", "").Equals(string.Empty))
                    mensagemIF.Add(ParametroAlfanumerico("texto_rodape_linha_4"));

                if (((ParametroInteiro("configuracao_impressao_rodape") & 524288) == 524288)
                    && !ParametroAlfanumerico("texto_rodape_linha_5").Replace(" ", "").Equals(string.Empty))
                    mensagemIF.Add(ParametroAlfanumerico("texto_rodape_linha_5"));
                return true;
            }
            catch (Exception ex)
            {
                logger.Error("Erro ao tentar obter rodapé do cupom: " + ex.Message);
                return false;
            }
        }
        private string labelCampoOpcional(string config)
        {
            logger.Trace(string.Empty);

            string[] split = config.Split(new char[] { ';' });
            foreach (string s in split)
            {
                string valorOpcao = s.Substring(s.IndexOf("=") + 1).Trim();
                if (s.Trim().StartsWith("Titulo="))
                {
                    return valorOpcao;
                }
            }

            return string.Empty;
        }
        private void LimpaAbastecimentos()
        {
            logger.Trace(string.Empty);
            string idTerminalPosWireless = string.Empty;
            string erroValidacao = string.Empty;

            if (!doValidaTerminalPosWireless(out idTerminalPosWireless, out erroValidacao))
            {
                throw new Exception(erroValidacao);
            }

            ConnectionFactory cf = new ConnectionFactory();
            PgSqlConnection conexao = null;

            logger.Debug("Verificando abastecimentos presos.");
            try
            {
                string SQLAtualizaAbastecimento = @"UPDATE abastecimento
                                    SET preco = preco_original,
                                        total = (quantidade * preco_original),
                                        acrescimo = 0,
                                        desconto = 0,
                                        checksum = UPPER(MD5(guid_abastecimento
 					                                || TO_CHAR(data_abastecimento, 'yyyyMMddhh24miss')
 					                                || id_bico_combustivel
 					                                || REPLACE(CAST(encerrante_inicial AS TEXT), '.', '') 
 					                                || REPLACE(CAST(encerrante AS TEXT), '.', '') 
 					                                || CAST(situacao AS TEXT)
 					                                || REPLACE(CAST(quantidade AS TEXT), '.', '')
 					                                || REPLACE(CAST(preco_original AS TEXT), '.', '')
 					                                || TRIM(retorno_automacao)
 					                                || ''
 					                                || '90FF5985D57C42389D631AE4F25C026E'))
                                    WHERE id_terminal_pos_wireless = '" + idTerminalPosWireless + @"' 
                                    AND (COALESCE(codigo_bandeira_tef, '') = ''
                                    AND COALESCE(codigo_rede_tef, '') = ''
                                    AND COALESCE(codigo_tipo_transacao_tef, '') = ''
                                    AND id_forma_recebimento_tef IS NULL
                                    AND (preco <> preco_original OR acrescimo <> 0 OR desconto <> 0)) RETURNING *;";

                PgSqlDataReader drAtualizaAbastec = cf.ObtemComando(SQLAtualizaAbastecimento, ref conexao).ExecuteReader();

                while (drAtualizaAbastec.Read())
                {
                    logger.Debug("Abastecimento ID=[" + drAtualizaAbastec["id_abastecimento"].ToString() + "] Valor Corrigido para original.");
                }

                SQLAtualizaAbastecimento = @"UPDATE abastecimento
                                    SET id_terminal_pos_wireless = NULL
                                    WHERE id_terminal_pos_wireless = '" + idTerminalPosWireless + @"' 
                                    AND (COALESCE(codigo_bandeira_tef, '') = ''
                                    AND COALESCE(codigo_rede_tef, '') = ''
                                    AND COALESCE(codigo_tipo_transacao_tef, '') = ''
                                    AND id_forma_recebimento_tef IS NULL) RETURNING *;";

                drAtualizaAbastec = cf.ObtemComando(SQLAtualizaAbastecimento, ref conexao).ExecuteReader();

                while (drAtualizaAbastec.Read())
                {
                    logger.Debug("Abastecimento ID=[" + drAtualizaAbastec["id_abastecimento"].ToString() + "] liberado pelo POS-Wireless.");
                }
            }
            catch (Exception)
            {
                logger.Error("Erro ao tentar liberar abastecimentos presos no POS-Wireless. [" + idTerminalPosWireless + "]");
                throw new Exception("Erro ao tentar liberar abastecimentos presos no POS-Wireless.");
            }
            finally
            {
                cf.FechaConexao(conexao);
            }
        }
        private string ParametroAlfanumerico(string idParametro)
        {
            logger.Trace(string.Empty);
            logger.Debug("idParametro=" + idParametro);

            string SQLBuscaParametro = @"SELECT valor_alfanumerico FROM sis_parametro WHERE id_parametro = '" + idParametro + "';";

            ConnectionFactory cf = new ConnectionFactory();
            PgSqlConnection conexao = null;

            try
            {
                PgSqlDataReader drBuscaParametro = cf.ObtemComando(SQLBuscaParametro, ref conexao).ExecuteReader();

                if (drBuscaParametro.Read())
                {
                    logger.Debug(idParametro + "=" + (string)drBuscaParametro["valor_alfanumerico"]);
                    return (string)drBuscaParametro["valor_alfanumerico"];
                }
                else
                {
                    logger.Debug(string.Format("Parâmetro não encontrado [{0}].", idParametro));
                    throw new Exception(string.Format("Parâmetro não encontrado [{0}].", idParametro));
                }
            }
            catch (Exception ex)
            {
                logger.Error(ex.ToString());
                throw new Exception(string.Format("Não foi possível localizar o parâmetro [{0}].", idParametro));
            }
            finally
            {
                cf.FechaConexao(conexao);
            }
        }
        private int ParametroInteiro(string idParametro)
        {
            logger.Trace(string.Empty);
            logger.Debug("idParametro=" + idParametro);

            ConnectionFactory cf = new ConnectionFactory();
            PgSqlConnection conexao = null;
            try
            {
                string SQLBuscaParametro = @"SELECT valor_numerico::INT4 FROM sis_parametro WHERE id_parametro = '" + idParametro + "';";
                PgSqlDataReader drBuscaParametro = cf.ObtemComando(SQLBuscaParametro, ref conexao).ExecuteReader();

                if (drBuscaParametro.Read())
                {
                    logger.Debug(idParametro + "=" + (int)drBuscaParametro["valor_numerico"]);
                    return (int)drBuscaParametro["valor_numerico"];
                }
                else
                {
                    logger.Debug(string.Format("Parâmetro não encontrado [{0}].", idParametro));
                    throw new Exception(string.Format("Parâmetro não encontrado [{0}].", idParametro));
                }
            }
            catch (Exception ex)
            {
                logger.Error(ex.ToString());
                throw new Exception(string.Format("Não foi possível localizar o parâmetro [{0}].", idParametro));
            }
            finally
            {
                cf.FechaConexao(conexao);
            }
        }
        private decimal ParametroDecimal(string idParametro)
        {
            logger.Trace(string.Empty);
            logger.Debug("idParametro=" + idParametro);

            ConnectionFactory cf = new ConnectionFactory();
            PgSqlConnection conexao = null;
            try
            {
                string SQLBuscaParametro = @"SELECT valor_numerico FROM sis_parametro WHERE id_parametro = '" + idParametro + "';";
                PgSqlDataReader drBuscaParametro = cf.ObtemComando(SQLBuscaParametro, ref conexao).ExecuteReader();

                if (drBuscaParametro.Read())
                {
                    logger.Debug(idParametro + "=" + (decimal)drBuscaParametro["valor_numerico"]);
                    return (decimal)drBuscaParametro["valor_numerico"];
                }
                else
                {
                    logger.Debug(string.Format("Parâmetro não encontrado [{0}].", idParametro));
                    throw new Exception(string.Format("Parâmetro não encontrado [{0}].", idParametro));
                }
            }
            catch (Exception ex)
            {
                logger.Error(ex.ToString());
                throw new Exception(string.Format("Não foi possível localizar o parâmetro [{0}].", idParametro));
            }
            finally
            {
                cf.FechaConexao(conexao);
            }
        }
        public static bool validaCPF(string cpf, ref string mensagem)
        {
            logger.Trace(string.Empty);
            //------- Rotina para CPF        
            if (cpf.Length == 11)
            {
                int d1, d2;
                int digito1, digito2, resto;
                int digitoCPF;
                string nDigResult;
                d1 = d2 = 0;
                digito1 = digito2 = resto = 0;
                for (int n_Count = 1; n_Count < cpf.Length - 1; n_Count++)
                {
                    digitoCPF = Int32.Parse(cpf.Substring(n_Count - 1, 1));
                    //--------- Multiplique a ultima casa por 2 a seguinte por 3 a seguinte por 4 e assim por diante.
                    d1 = d1 + (11 - n_Count) * digitoCPF;
                    //--------- Para o segundo digito repita o procedimento incluindo o primeiro digito calculado no passo anterior.
                    d2 = d2 + (12 - n_Count) * digitoCPF;
                };
                //--------- Primeiro resto da divisão por 11.
                resto = (d1 % 11);
                //--------- Se o resultado for 0 ou 1 o digito é 0 caso contrário o digito é 11 menos o resultado anterior.
                if (resto < 2)
                    digito1 = 0;
                else
                    digito1 = 11 - resto;
                d2 += 2 * digito1;
                //--------- Segundo resto da divisão por 11.
                resto = (d2 % 11);
                //--------- Se o resultado for 0 ou 1 o digito é 0 caso contrário o digito é 11 menos o resultado anterior.
                if (resto < 2)
                    digito2 = 0;
                else
                    digito2 = 11 - resto;
                //--------- Digito verificador do CPF que está sendo validado.
                string nDigVerific = cpf.Substring(cpf.Length - 2, 2);
                //--------- Concatenando o primeiro resto com o segundo.
                nDigResult = digito1.ToString() + digito2.ToString();
                //--------- Comparar o digito verificador do cpf com o primeiro resto + o segundo resto.
                if (!nDigVerific.Equals(nDigResult))
                    mensagem = "O CPF informado e invalido.";
                return nDigVerific.Equals(nDigResult);
            }
            else
            {
                mensagem = "A quantidade de caracteres do CPF informado e invalida.";
                return false;
            }
        }
        public static bool validaCNPJ(string cnpj, ref string mensagem)
        {
            if (cnpj.Length == 14)
            {
                int soma = 0, dig;
                string cnpj_calc = cnpj.Substring(0, 12);
                char[] chr_cnpj = cnpj.ToCharArray();
                //--------- Primeira parte
                for (int i = 0; i < 4; i++)
                    if (chr_cnpj[i] - 48 >= 0 && chr_cnpj[i] - 48 <= 9)
                        soma += (chr_cnpj[i] - 48) * (6 - (i + 1));
                for (int i = 0; i < 8; i++)
                    if (chr_cnpj[i + 4] - 48 >= 0 && chr_cnpj[i + 4] - 48 <= 9)
                        soma += (chr_cnpj[i + 4] - 48) * (10 - (i + 1));
                dig = 11 - (soma % 11);
                cnpj_calc += (dig == 10 || dig == 11) ?
                    "0" : dig.ToString();
                //--------- Segunda parte
                soma = 0;
                for (int i = 0; i < 5; i++)
                    if (chr_cnpj[i] - 48 >= 0 && chr_cnpj[i] - 48 <= 9)
                        soma += (chr_cnpj[i] - 48) * (7 - (i + 1));
                for (int i = 0; i < 8; i++)
                    if (chr_cnpj[i + 5] - 48 >= 0 && chr_cnpj[i + 5] - 48 <= 9)
                        soma += (chr_cnpj[i + 5] - 48) * (10 - (i + 1));
                dig = 11 - (soma % 11);
                cnpj_calc += (dig == 10 || dig == 11) ?
                            "0" : dig.ToString();
                if (!cnpj.Equals(cnpj_calc))
                    mensagem = "O CNPJ informado e invalido.";
                return cnpj.Equals(cnpj_calc);
            }
            else
            {
                mensagem = "A quantidade de caracteres do CNPJ informado e invalida.";
                return false;
            }
        }
        public string getFormatString(decimal numero)
        {
            if ((numero * 1000) % 1000 == 0)
                return "N0";
            else if ((numero * 1000) % 100 == 0)
                return "N1";
            else if ((numero * 1000) % 10 == 0)
                return "N2";
            else
                return "N3";
        }
        private string obtemQrCode(bool homologacao, string chaveAcessoNFCe, string cnpj, DateTime dataCupom, decimal totalVenda, decimal vIcms, string DigestValue)
        {
            string linkQRCode;
            string parQRCode = "chNFe=" + chaveAcessoNFCe;
            if (homologacao)
            {
                linkQRCode = ParametroAlfanumerico("url_consulta_nfce_homologacao").Replace("?", "").TrimStart().TrimEnd() + "?";
                parQRCode += "&nVersao=100&tpAmb=2";
            }
            else
            {
                linkQRCode = ParametroAlfanumerico("url_consulta_nfce_producao").Replace("?", "").TrimStart().TrimEnd() + "?";
                parQRCode += "&nVersao=100&tpAmb=1";
            }

            parQRCode += (cnpj.Equals(string.Empty) ? "" : "&cDest=" + cnpj)
                + "&dhEmi=" + ArrayBytesToHexadecimalString(converterString(dataCupom.ToString("yyyy-MM-ddTHH:mm:sszzz")))
                + "&vNF=" + totalVenda.ToString("F2").Replace(".", "").Replace(",", ".").Replace(" ", "")
                + "&vICMS=" + vIcms.ToString("F2").Replace(".", "").Replace(",", ".").Replace(" ", "")
                + "&digVal=" + ArrayBytesToHexadecimalString(converterString(DigestValue))
                + "&cIdToken=" + ParametroInteiro("numero_token_nfce").ToString("D6");
            logger.Debug("parQRCode= " + parQRCode);
            string parQRCodeSHA1 = GerarHashSHA1(parQRCode + ParametroAlfanumerico("codigo_token_nfce")).ToLower();
            logger.Debug("parQRCodeSHA1= " + parQRCodeSHA1);

            string parametros = parQRCode + "&cHashQRCode=" + parQRCodeSHA1;

            return linkQRCode + parametros;
        }
        public static string ArrayBytesToHexadecimalString(byte[] a)
        {
            string retornoHex = string.Empty;

            for (int i = 0; i < a.Length; i++)
            {
                retornoHex = retornoHex + string.Format("{0:x}", a[i]).ToUpper().PadLeft(2, '0');
            }

            return retornoHex;
        }
        public static byte[] converterString(string str)
        {
            ASCIIEncoding encoding = new ASCIIEncoding();
            return encoding.GetBytes(str);
        }
        public static string GerarHashSHA1(string str)
        {
            SHA1 hasher = SHA1.Create();
            StringBuilder gerarString = new StringBuilder();
            byte[] array = converterString(str);
            array = hasher.ComputeHash(array);
            foreach (byte item in array)
            {
                gerarString.Append(item.ToString("x2"));
            }
            return gerarString.ToString().ToUpper();
        }
        public static void DescompactarZip(byte[] bArquivoZipado, out byte[] bArquivo)
        {
            string PathArquivoTemporario = Path.Combine(Path.GetTempPath(), System.Guid.NewGuid().ToString().Replace("-", "") + ".tmp");

            try
            {
                MemoryStream ms = new MemoryStream();
                string nomeArquivoZipado = string.Empty;
                using (ZipInputStream s = new ZipInputStream(new MemoryStream(bArquivoZipado)))
                {
                    ZipEntry arquivoZipado;
                    string tmpEntry = String.Empty;
                    bArquivo = new byte[1];

                    while ((arquivoZipado = s.GetNextEntry()) != null)
                    {
                        if (s.Available == 0)
                            continue;

                        nomeArquivoZipado = Path.GetFileName(arquivoZipado.Name);

                        if (nomeArquivoZipado != String.Empty)
                        {
                            s.CopyTo(ms);
                        }
                        s.CloseEntry();
                    }
                    s.Close();
                }

                bArquivo = ms.GetBuffer();
            }
            finally
            {
            }
        }
        private bool doValidaTerminalPosWireless(out string idTerminalPosWireless, out string erroValidacao)
        {
            logger.Trace(string.Empty);
            idTerminalPosWireless = string.Empty;
            string numeroIdentificacao = string.Empty;
            erroValidacao = string.Empty;

            logger.Debug("Verificando situação do POS.");

            ConnectionFactory cf = new ConnectionFactory();
            PgSqlConnection conexao = null;
            try
            {
                string[] stringIdentificacaoTerminal = autenticador.buscaNumeroIdentificacaoTerminal();

                string condicaoPesquisa = string.Empty;
                IList<string> listaIdenticacaoPosWirelessEncontrados = new List<string>();

                foreach (string identificacao in stringIdentificacaoTerminal)
                {
                    if (!identificacao.Trim().Equals(string.Empty))
                        condicaoPesquisa += ",'" + identificacao + "'";
                }

                if (condicaoPesquisa.Equals(string.Empty))
                {
                    erroValidacao = "Nao foi possivel capturar a identificacao do terminal";
                    logger.Error(erroValidacao);
                    return false;
                }
                else
                {
                    condicaoPesquisa = condicaoPesquisa.Substring(1);
                }

                string sqlBuscaTerminalPosWireless = @"SELECT   id_terminal_pos_wireless,
                                                                numero_identificacao
                                                        FROM    terminal_pos_wireless
                                                        WHERE   registro_excluido = 'N'
                                                        AND numero_identificacao IN(" + condicaoPesquisa + ");";

                PgSqlDataReader dr = cf.ObtemComando(sqlBuscaTerminalPosWireless, ref conexao).ExecuteReader();

                while (dr.Read())
                {
                    listaIdenticacaoPosWirelessEncontrados.Add((string)dr["id_terminal_pos_wireless"]);
                    numeroIdentificacao = (string)dr["numero_identificacao"];
                }

                if (listaIdenticacaoPosWirelessEncontrados.Count == 0)
                {
                    erroValidacao = "Terminal(POS) nao cadastrado [";

                    foreach (string identificacao in stringIdentificacaoTerminal)
                        erroValidacao += " | " + identificacao;

                    erroValidacao += "]";
                    erroValidacao = erroValidacao.Replace("[ | ", "[");
                    logger.Error(erroValidacao);

                    return false;
                }
                else if (listaIdenticacaoPosWirelessEncontrados.Count > 1)
                {
                    erroValidacao = "Terminal(POS) duplicado para os numeros de identificação cadastrados [";

                    foreach (string id in listaIdenticacaoPosWirelessEncontrados)
                        erroValidacao += " | " + id;

                    erroValidacao += "]";
                    erroValidacao = erroValidacao.Replace("[ | ", "[");
                    logger.Error(erroValidacao);

                    return false;
                }
                else
                {
                    idTerminalPosWireless = listaIdenticacaoPosWirelessEncontrados[0];
                    logger.Trace("idTerminalPosWireless=" + idTerminalPosWireless);
                    logger.Trace("numeroIdentificacao=" + numeroIdentificacao);
                }

                return true;
            }
            catch (Exception ex)
            {
                logger.Error(ex.Message);
                erroValidacao += ex.Message;
                return false;
            }
            finally
            {
                cf.FechaConexao(conexao);
            }
        }
        private Abastecimento doVerificaCondicaoVendaCliente(Abastecimento abastecimento, out string mensagem)
        {
            logger.Trace(string.Empty);
            logger.Debug("idAbastecimento=" + abastecimento.idAbastecimento);
            logger.Debug("idCliente=" + abastecimento.IdCliente);
            logger.Debug("idFormaRecebimento=" + abastecimento.IdFormaRecebimento);
            logger.Debug("tipoRecebimento=" + abastecimento.TipoRecebimento);
            logger.Debug("IdItem=" + abastecimento.IdItem);

            mensagem = string.Empty;
            ConnectionFactory cf = new ConnectionFactory();
            PgSqlConnection conexao = new PgSqlConnection();

            try
            {
                decimal preco = abastecimento.preco;
                string idClasseCliente = string.Empty;
                string idCategoriaItem = string.Empty;
                DateTime dataAtual = DateTime.Now;

                string SQLBuscaItem = @"SELECT id_categoria_item FROM item WHERE id_item = '" + abastecimento.IdItem + "';";
                using (PgSqlDataReader drItem = cf.ObtemComando(SQLBuscaItem, ref conexao).ExecuteReader())
                {
                    if (drItem.Read())
                    {
                        idCategoriaItem = (string)drItem["id_categoria_item"];
                        logger.Debug("idCategoriaItem=" + idCategoriaItem);
                    }
                }

                decimal descontoPadraoCliente = 0;
                decimal acrescimoPadraoCliente = 0;
                #region DADOS CLIENTE
                string SQLBuscaCliente = @"SELECT id_classe_cliente, desconto_padrao, acrescimo_padrao FROM cliente WHERE id_cliente = '" + abastecimento.IdCliente + "';";
                using (PgSqlDataReader drCliente = cf.ObtemComando(SQLBuscaCliente, ref conexao).ExecuteReader())
                {
                    if (drCliente.Read())
                    {
                        idClasseCliente = (string)drCliente["id_classe_cliente"];
                        logger.Debug("Cliente id_classe_cliente=" + idClasseCliente);
                        descontoPadraoCliente = (decimal)drCliente["desconto_padrao"];
                        logger.Debug("Cliente desconto_padrao=" + descontoPadraoCliente);
                        acrescimoPadraoCliente = (decimal)drCliente["acrescimo_padrao"];
                        logger.Debug("Cliente acrescimo_padrao=" + acrescimoPadraoCliente);
                    }
                }

                #endregion

                decimal descontoAutomatico = 0;
                decimal acrescimoAutomatico = 0;

                decimal totalBrutoCondicao = CalculaTotalItem(abastecimento.quantidade, preco);

                if (preco == abastecimento.preco)
                {
                    decimal diferenca = abastecimento.total - CalculaTotalItem(abastecimento.quantidade, preco);
                    if ((Math.Abs(diferenca) >= (decimal)0.01) && (Math.Abs(diferenca) <= (decimal)0.10))
                    {
                        if (diferenca > 0)
                            totalBrutoCondicao += diferenca;
                        else
                            totalBrutoCondicao -= Math.Abs(diferenca);
                    }
                }

                if (descontoPadraoCliente > 0 || acrescimoPadraoCliente > 0)
                {
                    descontoAutomatico = CalculaValorAcrescimoDesconto(totalBrutoCondicao, descontoPadraoCliente);
                    acrescimoAutomatico = CalculaValorAcrescimoDesconto(totalBrutoCondicao, acrescimoPadraoCliente);
                    logger.Debug("descontoAutomatico=" + descontoAutomatico);
                    logger.Debug("acrescimoAutomatico=" + acrescimoAutomatico);
                }

                #region CONDIÇÕES DE VENDA
                logger.Debug("dataAtual=" + dataAtual.ToString("yyyy-MM-dd HH:mm"));
                string SQLCondicoesVenda =
                @"WITH sub_categoria_item_condicao_venda AS (
	                SELECT 	DISTINCT cv.id_condicao_venda,
		                f.id_categoria_item
	                FROM	condicao_venda AS cv
		                INNER JOIN LATERAL (WITH RECURSIVE wr_categoria_item AS (
			                SELECT	ci.id_categoria_item,
				                ci.id_categoria_item_pai
			                FROM	categoria_item ci
			                WHERE	ci.id_categoria_item = cv.id_categoria_item

			                UNION ALL

			                SELECT	ci.id_categoria_item,
				                ci.id_categoria_item_pai
			                FROM	categoria_item ci
				                INNER JOIN wr_categoria_item sc ON (sc.id_categoria_item = ci.id_categoria_item_pai)
			                )
			                SELECT	id_categoria_item,
				                id_categoria_item_pai
			                FROM	wr_categoria_item
		                ) AS f ON TRUE
                ),
                sub_tags_venda AS (
                SELECT 	id_tag
                FROM 	sis_tag_registro
                WHERE 	'" + abastecimento.IdCliente + @"' <> ''
                AND 	id_entidade = '268A3A67FC884FEFBE0463117D889E75'
                AND		id_chave_registro = CAST(CAST('" + abastecimento.IdCliente + @"' AS TEXT) AS UUID)

                UNION ALL

                SELECT 	id_tag
                FROM 	sis_tag_registro
                WHERE 	'" + idClasseCliente.Trim() + @"' <> ''
                AND 	id_entidade = '540849B3898548ADA7B3744747F1822E'
                AND		id_chave_registro = CAST(CAST('" + idClasseCliente.Trim() + @"' AS TEXT) AS UUID)

                UNION ALL

                SELECT 	id_tag
                FROM 	sis_tag_registro
                WHERE 	'" + abastecimento.IdItem + @"' <> ''
                AND 	id_entidade = '867470B75B49496EA8BC952F581250B3'
                AND		id_chave_registro = CAST(CAST('" + abastecimento.IdItem + @"' AS TEXT) AS UUID)

                UNION ALL

                SELECT 	id_tag
                FROM 	sis_tag_registro
                WHERE 	'" + idCategoriaItem + @"' <> ''
                AND 	id_entidade = 'BF5D8443CF714C208D1CF942E29101FA'
                AND		id_chave_registro IN (SELECT 
								                CAST(f.id_categoria_item AS UUID) AS id_categoria_item
							                FROM	(WITH RECURSIVE wr_categoria_item AS (
									                SELECT	ci.id_categoria_item,
										                ci.id_categoria_item_pai
									                FROM	categoria_item ci
									                WHERE	ci.id_categoria_item = '" + idCategoriaItem + @"'

									                UNION ALL

									                SELECT	ci.id_categoria_item,
										                ci.id_categoria_item_pai
									                FROM	categoria_item ci
										                INNER JOIN wr_categoria_item sc ON (sc.id_categoria_item = ci.id_categoria_item_pai)
									                )
									                SELECT	id_categoria_item,
										                id_categoria_item_pai
									                FROM	wr_categoria_item
								                ) AS f)

                UNION ALL

                SELECT 	id_tag
                FROM 	sis_tag_registro
                WHERE 	'" + abastecimento.IdFormaRecebimento.Trim() + @"' <> ''
                AND 	id_entidade = 'C177E94CD0E64259B82D9695D20E0853'
                AND		id_chave_registro = CAST(CAST('" + abastecimento.IdFormaRecebimento.Trim() + @"' AS TEXT) AS UUID)

                UNION ALL

                SELECT 	id_tag
                FROM 	sis_tag_registro
                WHERE 	" + abastecimento.TipoRecebimento + @" <> 0
                AND 	id_entidade = '871296B9A90245F4B931F93BEA89FB28'
                AND		id_chave_registro = CAST(MD5(CAST(" + abastecimento.TipoRecebimento + @" AS TEXT)) AS UUID))

                SELECT	cv.*
                FROM	condicao_venda AS cv
                WHERE	((cv.id_cliente IS NULL AND 
		                (cv.id_classe_cliente IS NULL
		                OR '" + abastecimento.IdCliente + @"' = ''
		                OR EXISTS(SELECT 1 FROM cliente AS c WHERE c.id_cliente = '" + abastecimento.IdCliente + @"' AND c.id_classe_cliente = cv.id_classe_cliente)))
	                OR cv.id_cliente = '" + abastecimento.IdCliente + @"')
                AND	((cv.id_classe_cliente IS NULL AND
		                (cv.id_cliente IS NULL
		                OR '" + idClasseCliente.Trim() + @"' = ''
		                OR EXISTS(SELECT 1 FROM cliente AS c WHERE c.id_cliente = cv.id_cliente AND c.id_classe_cliente = '" + idClasseCliente.Trim() + @"')))
	                OR cv.id_classe_cliente = '" + idClasseCliente.Trim() + @"')	
                AND	((cv.id_categoria_item IS NULL AND 
		                (cv.id_item IS NULL 
		                OR '" + idCategoriaItem + @"' = ''
		                OR EXISTS(SELECT 1 
				                FROM item AS i
					                INNER JOIN LATERAL (WITH RECURSIVE wr_categoria_item AS (
						                SELECT	ci.id_categoria_item,
							                ci.id_categoria_item_pai
						                FROM	categoria_item ci
						                WHERE	ci.id_categoria_item = i.id_categoria_item

						                UNION ALL

						                SELECT	ci.id_categoria_item,
							                ci.id_categoria_item_pai
						                FROM	categoria_item ci
							                INNER JOIN wr_categoria_item sc ON (sc.id_categoria_item = ci.id_categoria_item_pai)
						                )
						                SELECT	id_categoria_item,
							                id_categoria_item_pai
						                FROM	wr_categoria_item
					                ) AS f ON TRUE
				                WHERE i.id_item = ANY(cv.id_item) AND f.id_categoria_item = '" + idCategoriaItem + @"')))
	                OR '" + idCategoriaItem + @"' IN (SELECT sub.id_categoria_item FROM sub_categoria_item_condicao_venda AS sub WHERE sub.id_condicao_venda = cv.id_condicao_venda))
                AND	((cv.id_item IS NULL AND 
		                (cv.id_categoria_item IS NULL
		                OR '" + abastecimento.IdItem + @"' = ''
		                OR EXISTS(SELECT 1 FROM item AS i WHERE i.id_item = '" + abastecimento.IdItem + @"' AND i.id_categoria_item IN (SELECT sub.id_categoria_item FROM sub_categoria_item_condicao_venda AS sub WHERE sub.id_condicao_venda = cv.id_condicao_venda))))	
	                OR '" + abastecimento.IdItem + @"' = ANY(cv.id_item))
                AND	((cv.id_tipo_recebimento IS NULL AND 
		                (cv.id_forma_recebimento IS NULL
		                OR " + abastecimento.TipoRecebimento + @" = 0
		                OR EXISTS(SELECT 1 FROM forma_recebimento AS fr WHERE fr.id_forma_recebimento = cv.id_forma_recebimento AND fr.id_tipo_recebimento = " + abastecimento.TipoRecebimento + @")))
	                OR cv.id_tipo_recebimento = " + abastecimento.TipoRecebimento + @")
                AND	((cv.id_forma_recebimento IS NULL AND
		                (cv.id_tipo_recebimento IS NULL
		                OR '" + abastecimento.IdFormaRecebimento.Trim() + @"' = ''
		                OR EXISTS(SELECT 1 FROM forma_recebimento AS fr WHERE fr.id_forma_recebimento = '" + abastecimento.IdFormaRecebimento.Trim() + @"' AND fr.id_tipo_recebimento = cv.id_tipo_recebimento)))
	                OR cv.id_forma_recebimento = '" + abastecimento.IdFormaRecebimento.Trim() + @"')
                AND	(cv.inicio_validade IS NULL OR cv.fim_validade IS NULL OR DATE('" + dataAtual.ToString("yyyy-MM-dd") + @"') BETWEEN DATE(cv.inicio_validade) AND DATE(cv.fim_validade))
                AND	(cv.horario_inicio IS NULL OR cv.horario_fim IS NULL OR '" + dataAtual.ToString("HH:mm") + @"' BETWEEN cv.horario_inicio AND cv.horario_fim)
                AND	((EXISTS (SELECT 1 FROM feriado AS f WHERE f.data = DATE('" + dataAtual.ToString("yyyy-MM-dd") + @"')) AND cv.aplica_condicao_feriado = 'S')
	                OR (EXTRACT('DOW' FROM DATE('" + dataAtual.ToString("yyyy-MM-dd") + @"')) = 0 AND cv.aplica_condicao_domingo = 'S')
	                OR (EXTRACT('DOW' FROM DATE('" + dataAtual.ToString("yyyy-MM-dd") + @"')) = 1 AND cv.aplica_condicao_segunda = 'S')
	                OR (EXTRACT('DOW' FROM DATE('" + dataAtual.ToString("yyyy-MM-dd") + @"')) = 2 AND cv.aplica_condicao_terca = 'S')
	                OR (EXTRACT('DOW' FROM DATE('" + dataAtual.ToString("yyyy-MM-dd") + @"')) = 3 AND cv.aplica_condicao_quarta = 'S')
	                OR (EXTRACT('DOW' FROM DATE('" + dataAtual.ToString("yyyy-MM-dd") + @"')) = 4 AND cv.aplica_condicao_quinta = 'S')
	                OR (EXTRACT('DOW' FROM DATE('" + dataAtual.ToString("yyyy-MM-dd") + @"')) = 5 AND cv.aplica_condicao_sexta = 'S')
	                OR (EXTRACT('DOW' FROM DATE('" + dataAtual.ToString("yyyy-MM-dd") + @"')) = 6 AND cv.aplica_condicao_sabado = 'S'))	
                AND ((NOT EXISTS (SELECT 1 FROM JSONB_POPULATE_RECORDSET(NULL::sis_tag_registro, cv.tags_inclusao) AS t)
	                OR EXISTS (SELECT 1 FROM sub_tags_venda WHERE id_tag IN (SELECT t.id_tag FROM JSONB_POPULATE_RECORDSET(NULL::sis_tag_registro, cv.tags_inclusao) AS t))) 
	                AND
	                (NOT EXISTS (SELECT 1 FROM JSONB_POPULATE_RECORDSET(NULL::sis_tag_registro, cv.tags_exclusao) AS t) 
	                OR NOT EXISTS (SELECT 1 FROM sub_tags_venda WHERE id_tag IN (SELECT t.id_tag FROM JSONB_POPULATE_RECORDSET(NULL::sis_tag_registro, cv.tags_exclusao) AS t))))	
                ORDER BY prioridade ASC, data_cadastro DESC";

                PgSqlDataReader drCondicoesVenda = cf.ObtemComando(SQLCondicoesVenda, ref conexao).ExecuteReader();

                while (drCondicoesVenda.Read())
                {
                    #region CondicoesVenda
                    logger.Debug("drCondicoesVenda codigo=" + +(int)drCondicoesVenda["codigo"]);
                    logger.Debug("drCondicoesVenda tipo_condicao=" + (int)drCondicoesVenda["tipo_condicao"]);
                    switch ((int)drCondicoesVenda["tipo_condicao"])
                    {
                        case 1: //Desconto em Valor
                            {
                                if (((decimal)drCondicoesVenda["valor_porcentagem_condicao"]) > 0)
                                    descontoAutomatico += Math.Round(((decimal)drCondicoesVenda["valor_porcentagem_condicao"]) * abastecimento.quantidade * 100) / 100;

                                if (((decimal)drCondicoesVenda["preco_minimo"]) > 0)
                                {
                                    if (preco > ((decimal)drCondicoesVenda["preco_minimo"]))
                                    {
                                        decimal t1 = Math.Round(abastecimento.quantidade * preco, 2, MidpointRounding.ToEven);
                                        decimal t2 = Math.Round(abastecimento.quantidade * ((decimal)drCondicoesVenda["preco_minimo"]), 2, MidpointRounding.ToEven);

                                        decimal descontoMaximo = t1 - t2;

                                        if (descontoAutomatico > descontoMaximo)
                                            descontoAutomatico += descontoMaximo;
                                    }
                                    else
                                        descontoAutomatico += 0;
                                }

                                logger.Debug("valor_porcentagem_condicao=" + (decimal)drCondicoesVenda["valor_porcentagem_condicao"]);
                                logger.Debug("desconto_automatico=" + descontoAutomatico);
                                break;
                            }
                        case 2: //Acréscimo em Valor
                            {
                                if (((decimal)drCondicoesVenda["valor_porcentagem_condicao"]) > 0)
                                    acrescimoAutomatico += Math.Round(((decimal)drCondicoesVenda["valor_porcentagem_condicao"]) * abastecimento.quantidade * 100) / 100;

                                if (((decimal)drCondicoesVenda["preco_maximo"]) > 0)
                                {
                                    if (preco < ((decimal)drCondicoesVenda["preco_maximo"]))
                                    {
                                        decimal t1 = Math.Round(abastecimento.quantidade * preco, 2, MidpointRounding.ToEven);
                                        decimal t2 = Math.Round(abastecimento.quantidade * ((decimal)drCondicoesVenda["preco_maximo"]), 2, MidpointRounding.ToEven);

                                        decimal acrescimoMaximo = t2 - t1;

                                        if (acrescimoAutomatico > acrescimoMaximo)
                                            acrescimoAutomatico += acrescimoMaximo;
                                    }
                                    else
                                        acrescimoAutomatico += 0;
                                }

                                logger.Debug("valor_porcentagem_condicao=" + (decimal)drCondicoesVenda["valor_porcentagem_condicao"]);
                                logger.Debug("acrescimo_automatico=" + acrescimoAutomatico);
                                break;
                            }
                        case 3: //Desconto em Percentual
                            {
                                if (((decimal)drCondicoesVenda["valor_porcentagem_condicao"]) > 0)
                                {
                                    totalBrutoCondicao = CalculaTotalItem(abastecimento.quantidade, preco);
                                    if (preco == abastecimento.preco)
                                    {
                                        decimal diferenca = abastecimento.total - CalculaTotalItem(abastecimento.quantidade, preco);
                                        if ((Math.Abs(diferenca) >= (decimal)0.01) && (Math.Abs(diferenca) <= (decimal)0.10))
                                        {
                                            if (diferenca > 0)
                                                totalBrutoCondicao += diferenca;
                                            else
                                                totalBrutoCondicao -= Math.Abs(diferenca);
                                        }
                                    }
                                    descontoAutomatico += CalculaValorAcrescimoDesconto(totalBrutoCondicao, (decimal)drCondicoesVenda["valor_porcentagem_condicao"]);
                                }

                                if (((decimal)drCondicoesVenda["preco_minimo"]) > 0)
                                {
                                    if (preco > ((decimal)drCondicoesVenda["preco_minimo"]))
                                    {
                                        decimal t1 = Math.Round(abastecimento.quantidade * preco, 2, MidpointRounding.ToEven);
                                        decimal t2 = Math.Round(abastecimento.quantidade * ((decimal)drCondicoesVenda["preco_minimo"]), 2, MidpointRounding.ToEven);

                                        decimal descontoMaximo = t1 - t2;

                                        if (descontoAutomatico > descontoMaximo)
                                            descontoAutomatico += descontoMaximo;
                                    }
                                    else
                                        descontoAutomatico += 0;
                                }

                                logger.Debug("valor_porcentagem_condicao=" + (decimal)drCondicoesVenda["valor_porcentagem_condicao"]);
                                logger.Debug("desconto_automatico=" + descontoAutomatico);
                                break;
                            }
                        case 4: //Acréscimo em Percentual
                            {
                                if (((decimal)drCondicoesVenda["valor_porcentagem_condicao"]) > 0)
                                {
                                    totalBrutoCondicao = CalculaTotalItem(abastecimento.quantidade, preco);
                                    if (preco == abastecimento.preco)
                                    {
                                        decimal diferenca = abastecimento.total - CalculaTotalItem(abastecimento.quantidade, preco);
                                        if ((Math.Abs(diferenca) >= (decimal)0.01) && (Math.Abs(diferenca) <= (decimal)0.10))
                                        {
                                            if (diferenca > 0)
                                                totalBrutoCondicao += diferenca;
                                            else
                                                totalBrutoCondicao -= Math.Abs(diferenca);
                                        }
                                    }
                                    acrescimoAutomatico += CalculaValorAcrescimoDesconto(totalBrutoCondicao, (decimal)drCondicoesVenda["valor_porcentagem_condicao"]);
                                }

                                if (((decimal)drCondicoesVenda["preco_maximo"]) > 0)
                                {
                                    if (preco < ((decimal)drCondicoesVenda["preco_maximo"]))
                                    {
                                        decimal t1 = Math.Round(abastecimento.quantidade * preco, 2, MidpointRounding.ToEven);
                                        decimal t2 = Math.Round(abastecimento.quantidade * ((decimal)drCondicoesVenda["preco_maximo"]), 2, MidpointRounding.ToEven);

                                        decimal acrescimoMaximo = t2 - t1;

                                        if (acrescimoAutomatico > acrescimoMaximo)
                                            acrescimoAutomatico += acrescimoMaximo;
                                    }
                                    else
                                        acrescimoAutomatico += 0;
                                }

                                logger.Debug("valor_porcentagem_condicao=" + (decimal)drCondicoesVenda["valor_porcentagem_condicao"]);
                                logger.Debug("acrescimo_automatico=" + acrescimoAutomatico);
                                break;
                            }
                        case 5: //Preço Fixo
                            {
                                if (abastecimento.IdCliente.Equals(string.Empty) ||
                                    (abastecimento.cnpjCpf != null && !abastecimento.cnpjCpf.Equals(string.Empty)) ||
                                    PodeAplicarPrecoFixoAbastecimento((int)abastecimento.idAbastecimento))
                                {
                                    if (((decimal)drCondicoesVenda["valor_porcentagem_condicao"]) > 0)
                                        preco = (decimal)drCondicoesVenda["valor_porcentagem_condicao"];
                                }

                                logger.Debug("preco=" + preco);
                                break;
                            }
                        case 6: //Faixa de Preço
                            {
                                if ((((decimal)drCondicoesVenda["preco_minimo"]) > 0) && (preco < ((decimal)drCondicoesVenda["preco_minimo"])))
                                {
                                    preco = (decimal)drCondicoesVenda["preco_minimo"];
                                }
                                else if ((((decimal)drCondicoesVenda["preco_maximo"]) > 0) && (preco > ((decimal)drCondicoesVenda["preco_maximo"])))
                                {
                                    preco = (decimal)drCondicoesVenda["preco_maximo"];
                                }

                                logger.Debug("preco=" + preco);
                                break;
                            }
                        case 7: //Quantidade de Itens
                            {
                                if (((int)drCondicoesVenda["quantidade_minima"]) <= abastecimento.quantidade &&
                                    ((decimal)drCondicoesVenda["valor_porcentagem_condicao"]) > 0)
                                    preco = (decimal)drCondicoesVenda["valor_porcentagem_condicao"];

                                logger.Debug("preco=" + preco);
                                break;
                            }
                        case 8: //Nivel de Preço
                            {
                                if (abastecimento.IdCliente.Equals(string.Empty) ||
                                    (abastecimento.cnpjCpf != null && !abastecimento.cnpjCpf.Equals(string.Empty)) ||
                                    PodeAplicarPrecoFixoAbastecimento((int)abastecimento.idAbastecimento))
                                {
                                    decimal p;
                                    if (!ObtemPrecoNivel((int)drCondicoesVenda["nivel_preco"], abastecimento.IdItem, out p, out mensagem))
                                        return null;

                                    preco = p;
                                }

                                logger.Debug("preco=" + preco);
                                break;
                            }
                    }
                    #endregion

                    logger.Debug("aplica_proxima_condicao=" + (string)drCondicoesVenda["aplica_proxima_condicao"]);
                    if (((string)drCondicoesVenda["aplica_proxima_condicao"]).Equals("N"))
                        break;
                }
                #endregion

                decimal totalBrutoCalculado = CalculaTotalItem(abastecimento.quantidade, preco);

                if (abastecimento.preco == preco)
                {
                    logger.Debug("preco=" + preco);
                    logger.Debug("descontoAutomatico-1=" + descontoAutomatico);
                    logger.Debug("acrescimoAutomatico-1=" + acrescimoAutomatico);

                    decimal diferenca = abastecimento.total - totalBrutoCalculado;
                    if ((Math.Abs(diferenca) >= (decimal)0.01) && (Math.Abs(diferenca) <= (decimal)0.10))
                    {
                        if (diferenca > 0)
                            totalBrutoCalculado += diferenca;
                        else
                            totalBrutoCalculado += Math.Abs(diferenca);
                    }
                }

                if (abastecimento.preco != preco ||
                    descontoAutomatico > 0 ||
                    acrescimoAutomatico > 0)
                {
                    logger.Debug("descontoAutomatico-2=" + descontoAutomatico);
                    logger.Debug("acrescimoAutomatico-2=" + acrescimoAutomatico);
                    logger.Debug("totalBrutoCalculado-2=" + totalBrutoCalculado);

                    decimal totalFinal = totalBrutoCalculado - descontoAutomatico + acrescimoAutomatico;
                    descontoAutomatico = acrescimoAutomatico = 0;

                    decimal diferenca = totalFinal - totalBrutoCalculado;
                    logger.Debug("diferenca=" + diferenca);

                    if (diferenca < 0)
                        descontoAutomatico = Math.Abs(diferenca);
                    else if (diferenca > 0)
                        acrescimoAutomatico = diferenca;

                    logger.Debug("Atualizar valores abastecimento.");

                    logger.Debug("preco=" + preco.ToString("N3").Replace(".", "").Replace(",", "."));
                    logger.Debug("acrescimo=" + acrescimoAutomatico.ToString("N2").Replace(".", "").Replace(",", "."));
                    logger.Debug("desconto=" + descontoAutomatico.ToString("N2").Replace(".", "").Replace(",", "."));
                    logger.Debug("total=" + totalFinal.ToString("N2").Replace(".", "").Replace(",", "."));

                    string SQLAtualizaAbastecimento = @"UPDATE  abastecimento
                                                        SET     preco = :preco,
                                                                acrescimo = :acrescimo,
                                                                desconto = :desconto,
                                                                total = :total
                                                        WHERE   id_abastecimento = " + abastecimento.idAbastecimento + ";";

                    var cmd = cf.ObtemComando(SQLAtualizaAbastecimento, ref conexao);

                    var parPreco = cmd.CreateParameter();
                    parPreco.DbType = System.Data.DbType.Decimal;
                    parPreco.ParameterName = "preco";
                    parPreco.Value = preco;
                    cmd.Parameters.Add(parPreco);

                    var parTotal = cmd.CreateParameter();
                    parTotal.DbType = System.Data.DbType.Decimal;
                    parTotal.ParameterName = "total";
                    parTotal.Value = totalFinal;
                    cmd.Parameters.Add(parTotal);

                    var parDesconto = cmd.CreateParameter();
                    parDesconto.DbType = System.Data.DbType.Decimal;
                    parDesconto.ParameterName = "desconto";
                    parDesconto.Value = descontoAutomatico;
                    cmd.Parameters.Add(parDesconto);

                    var parAcrescimo = cmd.CreateParameter();
                    parAcrescimo.DbType = System.Data.DbType.Decimal;
                    parAcrescimo.ParameterName = "acrescimo";
                    parAcrescimo.Value = acrescimoAutomatico;
                    cmd.Parameters.Add(parAcrescimo);

                    cmd.ExecuteNonQuery();

                    logger.Debug("Abastecimento [" + abastecimento.idAbastecimento + "] valores atualizados.");

                    SQLAtualizaAbastecimento = @"UPDATE  abastecimento
                                                SET     checksum = UPPER(MD5(guid_abastecimento
 					                                                        || TO_CHAR(data_abastecimento, 'yyyyMMddhh24miss')
 					                                                        || id_bico_combustivel
 					                                                        || REPLACE(CAST(encerrante_inicial AS TEXT), '.', '') 
 					                                                        || REPLACE(CAST(encerrante AS TEXT), '.', '') 
 					                                                        || CAST(situacao AS TEXT)
 					                                                        || REPLACE(CAST(quantidade AS TEXT), '.', '')
 					                                                        || REPLACE(CAST(preco AS TEXT), '.', '')
 					                                                        || TRIM(retorno_automacao)
 					                                                        || ''
 					                                                        || '90FF5985D57C42389D631AE4F25C026E'))
                                                WHERE   id_abastecimento = " + abastecimento.idAbastecimento + ";";

                    cf.ExecutaComando(SQLAtualizaAbastecimento, ref conexao);

                    logger.Debug("Abastecimento [" + abastecimento.idAbastecimento + "] checksum atualizado.");

                    abastecimento.total = totalFinal;
                    abastecimento.preco = preco;
                    abastecimento.desconto = descontoAutomatico;
                    abastecimento.acrescimo = acrescimoAutomatico;
                    abastecimento.ValorRecebido = totalFinal;
                    abastecimento.ValorRecebidoString = totalFinal.ToString("N2");
                }

                return abastecimento;
            }
            catch (Exception ex)
            {
                logger.Error("Erro ao verificar regras de venda do Cliente. " + ex.ToString());
                throw new Exception("Erro ao verificar regras de venda do Cliente. " + ex.Message);
            }
            finally
            {
                cf.FechaConexao(conexao);
            }
        }
        private bool ObtemPrecoNivel(int nivel, string idItem, out decimal preco, out string mensagem)
        {
            logger.Trace(string.Empty);
            logger.Debug("nivel=" + nivel);
            logger.Debug("idItem=" + idItem);

            preco = 0;
            mensagem = string.Empty;
            int comportamento = 1;

            try
            {
                comportamento = ParametroInteiro("comportamento_quando_nao_tem_preco_no_nivel_definido");
            }
            catch (Exception ex)
            {
                logger.Error(ex);
            }

            decimal preco_1, preco_2, preco_3, preco_4, preco_5;
            string codigo, descricao;
            string SQLBusca = @"SELECT codigo, descricao, preco, preco_2, preco_3, preco_4, preco_5 FROM item WHERE id_item = '" + idItem + "';";

            ConnectionFactory cf = new ConnectionFactory();
            PgSqlConnection conexao = new PgSqlConnection();

            try
            {
                PgSqlDataReader dr = cf.ObtemComando(SQLBusca, ref conexao).ExecuteReader();

                if (dr.Read())
                {
                    preco_1 = (decimal)dr["preco"];
                    preco_2 = (decimal)dr["preco_2"];
                    preco_3 = (decimal)dr["preco_3"];
                    preco_4 = (decimal)dr["preco_4"];
                    preco_5 = (decimal)dr["preco_5"];
                    codigo = (string)dr["codigo"];
                    descricao = (string)dr["descricao"];
                }
                else
                {
                    logger.Debug(string.Format("Valores não encontrados para Item [{0}].", idItem));
                    return false;
                }
            }
            catch (Exception ex)
            {
                logger.Error(ex.ToString());
                return false;
            }
            finally
            {
                cf.FechaConexao(conexao);
            }

            if (nivel <= 1)
            {
                preco = preco_1;
            }
            else if ((nivel == 2 && preco_2 == 0) ||
                (nivel == 3 && preco_3 == 0) ||
                (nivel == 4 && preco_4 == 0) ||
                (nivel == 5 && preco_5 == 0))
            {
                mensagem = "Preco " + nivel + " do item [" + codigo + " - " + descricao + "] nao definido.";
                if (comportamento == 3) // impedir a venda
                {
                    mensagem += " O pagamento nao pode ser realizado.";
                    return false;
                }
                else if (comportamento == 2) // usar preço padrão
                {
                    mensagem += " Será utilizado o Preço Padrão.";
                    preco = preco_1;

                    logger.Info(mensagem);
                }
                else // padrão
                {
                    mensagem += " Será utilizado o próximo nível de preço.";
                    if ((nivel == 5) && (preco_5 > 0))
                        preco = preco_5;
                    else if (((nivel == 4) && (preco_4 > 0)) || ((preco_4 > 0) && (nivel > 4)))
                        preco = preco_4;
                    else if (((nivel == 3) && (preco_3 > 0)) || ((preco_3 > 0) && (nivel > 3)))
                        preco = preco_3;
                    else if (((nivel == 2) && (preco_2 > 0)) || ((preco_2 > 0) && (nivel > 2)))
                        preco = preco_2;
                    else if (((nivel == 1) && (preco_1 > 0)) || ((preco_1 > 0) && (nivel > 1)))
                        preco = preco_1;

                    logger.Info(mensagem);
                }
            }
            else
            {
                if (nivel == 2)
                    preco = preco_2;
                else if (nivel == 3)
                    preco = preco_3;
                else if (nivel == 4)
                    preco = preco_4;
                else if (nivel == 5)
                    preco = preco_5;
            }

            logger.Info("Preço " + nivel + " do item [" + codigo + " - " + descricao + "] = " + preco);
            return true;
        }
        public decimal CalculaTotalItem(decimal quantidade, decimal preco)
        {
            logger.Trace(string.Empty);
            logger.Debug("quantidade=" + quantidade);
            logger.Debug("preco=" + preco);

            decimal retorno = 0;

            try
            {
                retorno = Math.Round(quantidade * preco, 2, MidpointRounding.ToEven);

                return retorno;
            }
            finally
            {
                logger.Debug("retorno=" + retorno);
            }
        }
        public decimal CalculaValorAcrescimoDesconto(decimal valor, decimal percentualAcrescimoDesconto)
        {
            logger.Trace(string.Empty);
            logger.Debug("valor=" + valor);
            logger.Debug("percentualAcrescimoDesconto=" + percentualAcrescimoDesconto);

            decimal retorno = 0;

            try
            {
                retorno = Math.Round((valor * percentualAcrescimoDesconto) / 100, 2, MidpointRounding.ToEven);

                return retorno;
            }
            finally
            {
                logger.Debug("retorno=" + retorno);
            }
        }
        private bool PodeAplicarPrecoFixoAbastecimento(int idAbastecimento)
        {
            logger.Trace(string.Empty);
            ConnectionFactory cf = new ConnectionFactory();
            PgSqlConnection conexao = new PgSqlConnection();
            try
            {
                logger.Debug("Obtendo dados do abastecimento.");

                string SQLObtemAbastecimento = @"SELECT odometro, retorno_automacao FROM abastecimento WHERE id_abastecimento = " + idAbastecimento + ";";

                PgSqlDataReader drAbastecimento = cf.ObtemComando(SQLObtemAbastecimento, ref conexao).ExecuteReader();

                drAbastecimento.Read();

                string retorno = (string)drAbastecimento["retorno_automacao"];
                decimal odometro = (decimal)drAbastecimento["odometro"];

                if ((!retorno.Equals(string.Empty)
                    && (retorno.Substring(98, 16).StartsWith("AA")
                        || retorno.Substring(98, 16).StartsWith("CC")
                        || (retorno.Substring(98, 16).StartsWith("FF")
                            && !retorno.Substring(98, 16).Equals("FFFFFFFFFFFFFFFF"))
                        || odometro > 0))
                    || !verificaAutomacaoComIdentificacaoOnlineHabilitada())
                    return true;
            }
            catch (Exception ex)
            {
                logger.Error(ex.ToString());
            }
            finally
            {
                cf.FechaConexao(conexao);
            }
            return false;
        }
        private bool verificaAutomacaoComIdentificacaoOnlineHabilitada()
        {
            logger.Trace(string.Empty);
            ConnectionFactory cf = new ConnectionFactory();
            PgSqlConnection conexao = null;
            try
            {
                string SQLBuscaQntParametro = @"SELECT COUNT(1) AS qnt
                                            FROM    sis_parametro 
                                            WHERE   id_parametro ILIKE '%tipo_identificacao_online%'
                                            AND     (valor_numerico = 1 OR valor_numerico > 2);";
                PgSqlDataReader drBuscaQntParametro = cf.ObtemComando(SQLBuscaQntParametro, ref conexao).ExecuteReader();

                int quantidade = 0;
                if (drBuscaQntParametro.Read())
                {
                    logger.Debug("quantidade=" + Convert.ToInt32(drBuscaQntParametro["qnt"]));
                    quantidade = Convert.ToInt32(drBuscaQntParametro["qnt"]);
                }

                if (quantidade > 0)
                {
                    logger.Info("Não permitido utilizar preço fixo, pois existe automação com tipo de identificação on-line por cliente.");
                    return true;
                }

                logger.Info("Pode utilizar preço fixo, pois não existe automação com tipo de identificação on-line por cliente.");
            }
            catch (Exception ex)
            {
                logger.Error(ex.ToString());
            }
            finally
            {
                cf.FechaConexao(conexao);
            }
            return false;
        }
    }
}