/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.shape.PathUtils;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.PGPath;
import com.sun.javafx.tk.Toolkit;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.paint.Color;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Shape;

public class Path
extends Shape {
    private Path2D path2d = null;
    private ObjectProperty<FillRule> fillRule;
    private boolean isPathValid;
    private final ObservableList<PathElement> elements;

    public Path() {
        this.setFill(null);
        this.setStroke(Color.BLACK);
        this.impl_cssClearUserSetProperties();
        this.elements = new TrackableObservableList<PathElement>(){

            @Override
            protected void onChanged(ListChangeListener.Change<PathElement> change) {
                ObservableList<PathElement> observableList = change.getList();
                boolean bl = false;
                while (change.next()) {
                    int n;
                    List<PathElement> list = change.getRemoved();
                    for (n = 0; n < change.getRemovedSize(); ++n) {
                        list.get(n).removeNode(Path.this);
                    }
                    for (n = change.getFrom(); n < change.getTo(); ++n) {
                        ((PathElement)observableList.get(n)).addNode(Path.this);
                    }
                    bl |= change.getFrom() == 0;
                }
                if (Path.this.path2d != null) {
                    change.reset();
                    change.next();
                    if (change.getFrom() == change.getList().size() && !change.wasRemoved() && change.wasAdded()) {
                        for (int i = change.getFrom(); i < change.getTo(); ++i) {
                            ((PathElement)observableList.get(i)).impl_addTo(Path.this.path2d);
                        }
                    } else {
                        Path.this.path2d = null;
                    }
                }
                if (bl) {
                    Path.this.isPathValid = Path.this.impl_isFirstPathElementValid();
                }
                Path.this.impl_markDirty(DirtyBits.NODE_CONTENTS);
                Path.this.impl_geomChanged();
            }
        };
    }

    static PGPath.FillRule toPGFillRule(FillRule fillRule) {
        if (fillRule == FillRule.NON_ZERO) {
            return PGPath.FillRule.NON_ZERO;
        }
        return PGPath.FillRule.EVEN_ODD;
    }

    void markPathDirty() {
        this.path2d = null;
        this.impl_markDirty(DirtyBits.NODE_CONTENTS);
        this.impl_geomChanged();
    }

    public final void setFillRule(FillRule fillRule) {
        this.fillRuleProperty().set(fillRule);
    }

    public final FillRule getFillRule() {
        return this.fillRule == null ? FillRule.NON_ZERO : (FillRule)((Object)this.fillRule.get());
    }

    public final ObjectProperty<FillRule> fillRuleProperty() {
        if (this.fillRule == null) {
            this.fillRule = new ObjectPropertyBase<FillRule>(FillRule.NON_ZERO){

                @Override
                public void invalidated() {
                    Path.this.impl_markDirty(DirtyBits.NODE_CONTENTS);
                    Path.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Path.this;
                }

                @Override
                public String getName() {
                    return "fillRule";
                }
            };
        }
        return this.fillRule;
    }

    public final ObservableList<PathElement> getElements() {
        return this.elements;
    }

    @Override
    @Deprecated
    protected PGNode impl_createPGNode() {
        return Toolkit.getToolkit().createPGPath();
    }

    @Deprecated
    public PGPath impl_getPGPath() {
        return (PGPath)this.impl_getPGNode();
    }

    @Override
    @Deprecated
    public Path2D impl_configShape() {
        if (this.isPathValid) {
            if (this.path2d == null) {
                this.path2d = PathUtils.configShape(this.getElements(), this.getFillRule() == FillRule.EVEN_ODD);
            } else {
                this.path2d.setWindingRule(this.getFillRule() == FillRule.NON_ZERO ? 1 : 0);
            }
            return this.path2d;
        }
        return new Path2D();
    }

    @Override
    @Deprecated
    protected Bounds impl_computeLayoutBounds() {
        if (this.isPathValid) {
            return super.impl_computeLayoutBounds();
        }
        return new BoundingBox(0.0, 0.0, -1.0, -1.0);
    }

    private boolean impl_isFirstPathElementValid() {
        ObservableList<PathElement> observableList = this.getElements();
        if (observableList != null && observableList.size() > 0) {
            PathElement pathElement = (PathElement)observableList.get(0);
            if (!pathElement.isAbsolute()) {
                System.err.printf("First element of the path can not be relative. Path: %s\n", this);
                return false;
            }
            if (pathElement instanceof MoveTo) {
                return true;
            }
            System.err.printf("Missing initial moveto in path definition. Path: %s\n", this);
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public void impl_updatePG() {
        super.impl_updatePG();
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            PGPath pGPath = this.impl_getPGPath();
            if (pGPath.acceptsPath2dOnUpdate()) {
                pGPath.updateWithPath2d(this.impl_configShape());
            } else {
                pGPath.reset();
                if (this.isPathValid) {
                    pGPath.setFillRule(Path.toPGFillRule(this.getFillRule()));
                    for (PathElement pathElement : this.getElements()) {
                        pathElement.addTo(pGPath);
                    }
                    pGPath.update();
                }
            }
        }
    }
}

