/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.Logging;
import com.sun.javafx.TempState;
import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.layout.region.BorderImage;
import com.sun.javafx.scene.layout.region.BorderStyle;
import com.sun.javafx.scene.layout.region.ShapeChangeListener;
import com.sun.javafx.scene.layout.region.StrokeBorder;
import com.sun.javafx.sg.BackgroundFill;
import com.sun.javafx.sg.BackgroundImage;
import com.sun.javafx.sg.Border;
import com.sun.javafx.sg.ImageBorder;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.PGRegion;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.Repeat;
import com.sun.javafx.sg.StrokedBorder;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class Region
extends Parent {
    public static final double USE_PREF_SIZE = Double.NEGATIVE_INFINITY;
    public static final double USE_COMPUTED_SIZE = -1.0;
    @Styleable(property="-fx-snap-to-pixel", initial="true")
    private BooleanProperty snapToPixel;
    @Styleable(property="-fx-padding")
    private ObjectProperty<Insets> padding;
    private final InsetsExpression insets = new InsetsExpression();
    private ReadOnlyDoubleWrapper width;
    private ReadOnlyDoubleWrapper height;
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty prefWidth;
    private DoubleProperty prefHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;
    @Styleable(property="-fx-shape", converter="com.sun.javafx.css.converters.StringConverter")
    private Shape shape;
    private ShapeChangeListener shapeChangeListener;
    @Styleable(property="-fx-scale-shape", initial="true")
    private boolean scaleShape = true;
    @Styleable(property="-fx-position-shape", initial="true")
    private boolean positionShape = true;
    @Styleable(property="-fx-background-fills", converter="com.sun.javafx.scene.layout.region.BackgroundFillConverter")
    private com.sun.javafx.scene.layout.region.BackgroundFill[] backgroundFills = null;
    @Styleable(property="-fx-background-images", converter="com.sun.javafx.scene.layout.region.BackgroundImageConverter")
    private com.sun.javafx.scene.layout.region.BackgroundImage[] backgroundImages = null;
    @Styleable(property="-fx-stroke-borders", converter="com.sun.javafx.scene.layout.region.StrokeBorderConverter")
    private StrokeBorder[] strokeBorders = null;
    @Styleable(property="-fx-image-borders", converter="com.sun.javafx.scene.layout.region.BorderImageConverter")
    private BorderImage[] imageBorders = null;

    static double boundedSize(double d, double d2, double d3) {
        return Math.min(Math.max(d, d2), Math.max(d2, d3));
    }

    static double snapSpace(double d, boolean bl) {
        return bl ? (double)Math.round(d) : d;
    }

    static double snapSize(double d, boolean bl) {
        return bl ? Math.ceil(d) : d;
    }

    static double snapPosition(double d, boolean bl) {
        return bl ? (double)Math.round(d) : d;
    }

    static double getMaxAreaBaselineOffset(List<Node> list, Insets[] insetsArray) {
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            Insets insets = insetsArray[i] != null ? insetsArray[i] : Insets.EMPTY;
            d = Math.max(d, (insets != null ? insets.getTop() : 0.0) + node.getBaselineOffset());
        }
        return d;
    }

    static double getMaxBaselineOffset(List<Node> list) {
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            d = Math.max(d, node.getBaselineOffset());
        }
        return d;
    }

    static double computeXOffset(double d, double d2, HPos hPos) {
        switch (hPos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (d - d2) / 2.0;
            }
            case RIGHT: {
                return d - d2;
            }
        }
        return 0.0;
    }

    static double computeYOffset(double d, double d2, VPos vPos) {
        switch (vPos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (d - d2) / 2.0;
            }
            case BOTTOM: {
                return d - d2;
            }
        }
        return 0.0;
    }

    static double max(List<Double> list) {
        double d = 0.0;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                double d2 = list.get(i);
                d = Math.max(d, d2);
            }
        }
        return d;
    }

    public Region() {
        this.setPickOnBounds(true);
    }

    public final BooleanProperty snapToPixelProperty() {
        if (this.snapToPixel == null) {
            this.snapToPixel = new BooleanPropertyBase(true){

                @Override
                public void invalidated() {
                    Region.this.requestLayout();
                    Region.this.impl_cssPropertyInvalidated(StyleableProperties.SNAP_TO_PIXEL);
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "snapToPixel";
                }
            };
        }
        return this.snapToPixel;
    }

    public final void setSnapToPixel(boolean bl) {
        this.snapToPixelProperty().set(bl);
    }

    public final boolean isSnapToPixel() {
        return this.snapToPixel == null ? true : this.snapToPixel.get();
    }

    public final ObjectProperty<Insets> paddingProperty() {
        if (this.padding == null) {
            this.padding = new ObjectPropertyBase<Insets>(Insets.EMPTY){
                private Insets lastValidValue;
                {
                    this.lastValidValue = Insets.EMPTY;
                }

                @Override
                public void invalidated() {
                    Insets insets = (Insets)this.get();
                    if (insets == null) {
                        this.set(this.lastValidValue);
                        throw new NullPointerException("cannot set padding to null");
                    }
                    this.lastValidValue = insets;
                    Region.this.insets.fireValueChanged();
                    Region.this.requestLayout();
                    Region.this.impl_cssPropertyInvalidated(StyleableProperties.PADDING);
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "padding";
                }
            };
        }
        return this.padding;
    }

    public final void setPadding(Insets insets) {
        this.paddingProperty().set(insets);
    }

    public final Insets getPadding() {
        return this.padding == null ? Insets.EMPTY : (Insets)this.padding.get();
    }

    public Insets getInsets() {
        return this.insets.get();
    }

    @Deprecated
    public ObservableObjectValue<Insets> insets() {
        return this.insets;
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.widthPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper widthPropertyImpl() {
        if (this.width == null) {
            this.width = new ReadOnlyDoubleWrapper(0.0){

                @Override
                protected void invalidated() {
                    Region.this.impl_layoutBoundsChanged();
                    Region.this.impl_geomChanged();
                    Region.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Region.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "width";
                }
            };
        }
        return this.width;
    }

    protected void setWidth(double d) {
        this.widthPropertyImpl().set(d);
    }

    public final double getWidth() {
        return this.width == null ? 0.0 : this.width.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.heightPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper heightPropertyImpl() {
        if (this.height == null) {
            this.height = new ReadOnlyDoubleWrapper(0.0){

                @Override
                protected void invalidated() {
                    Region.this.impl_layoutBoundsChanged();
                    Region.this.impl_geomChanged();
                    Region.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Region.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "height";
                }
            };
        }
        return this.height;
    }

    protected void setHeight(double d) {
        this.heightPropertyImpl().set(d);
    }

    public final double getHeight() {
        return this.height == null ? 0.0 : this.height.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Region.this.getParent() != null) {
                        Region.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "minWidth";
                }
            };
        }
        return this.minWidth;
    }

    public final void setMinWidth(double d) {
        this.minWidthProperty().set(d);
    }

    public final double getMinWidth() {
        return this.minWidth == null ? -1.0 : this.minWidth.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Region.this.getParent() != null) {
                        Region.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "minHeight";
                }
            };
        }
        return this.minHeight;
    }

    public final void setMinHeight(double d) {
        this.minHeightProperty().set(d);
    }

    public final double getMinHeight() {
        return this.minHeight == null ? -1.0 : this.minHeight.get();
    }

    public void setMinSize(double d, double d2) {
        this.setMinWidth(d);
        this.setMinHeight(d2);
    }

    public final DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Region.this.getParent() != null) {
                        Region.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "prefWidth";
                }
            };
        }
        return this.prefWidth;
    }

    public final void setPrefWidth(double d) {
        this.prefWidthProperty().set(d);
    }

    public final double getPrefWidth() {
        return this.prefWidth == null ? -1.0 : this.prefWidth.get();
    }

    public final DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Region.this.getParent() != null) {
                        Region.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "prefHeight";
                }
            };
        }
        return this.prefHeight;
    }

    public final void setPrefHeight(double d) {
        this.prefHeightProperty().set(d);
    }

    public final double getPrefHeight() {
        return this.prefHeight == null ? -1.0 : this.prefHeight.get();
    }

    public void setPrefSize(double d, double d2) {
        this.setPrefWidth(d);
        this.setPrefHeight(d2);
    }

    public final DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Region.this.getParent() != null) {
                        Region.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "maxWidth";
                }
            };
        }
        return this.maxWidth;
    }

    public final void setMaxWidth(double d) {
        this.maxWidthProperty().set(d);
    }

    public final double getMaxWidth() {
        return this.maxWidth == null ? -1.0 : this.maxWidth.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (Region.this.getParent() != null) {
                        Region.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Region.this;
                }

                @Override
                public String getName() {
                    return "maxHeight";
                }
            };
        }
        return this.maxHeight;
    }

    public final void setMaxHeight(double d) {
        this.maxHeightProperty().set(d);
    }

    public final double getMaxHeight() {
        return this.maxHeight == null ? -1.0 : this.maxHeight.get();
    }

    public void setMaxSize(double d, double d2) {
        this.setMaxWidth(d);
        this.setMaxHeight(d2);
    }

    @Deprecated
    public void impl_setShape(Shape shape) {
        if (shape != null && !shape.equals(this.impl_getShape())) {
            this.impl_cssPropertyInvalidated(StyleableProperties.SHAPE);
            if (this.shape != null) {
                this.shape.impl_setShapeChangeListener(null);
            }
            this.shape = shape;
            if (shape != null) {
                shape.impl_setShapeChangeListener(this.getShapeChangeListener());
            }
            this.impl_geomChanged();
            this.requestLayout();
            this.impl_markDirty(DirtyBits.REGION_SHAPE);
        }
    }

    @Deprecated
    public Shape impl_getShape() {
        return this.shape;
    }

    private ShapeChangeListener getShapeChangeListener() {
        if (this.shapeChangeListener == null) {
            this.shapeChangeListener = new ShapeChangeListener(){

                @Override
                public void changed() {
                    Region.this.impl_geomChanged();
                    Region.this.requestLayout();
                    Region.this.impl_markDirty(DirtyBits.REGION_SHAPE);
                }
            };
        }
        return this.shapeChangeListener;
    }

    @Deprecated
    public void impl_setScaleShape(boolean bl) {
        if (bl != this.impl_getScaleShape()) {
            this.impl_cssPropertyInvalidated(StyleableProperties.SCALE_SHAPE);
            this.scaleShape = bl;
            this.requestLayout();
            this.impl_markDirty(DirtyBits.REGION_SHAPE);
        }
    }

    @Deprecated
    public boolean impl_getScaleShape() {
        return this.scaleShape;
    }

    @Deprecated
    public void impl_setPositionShape(boolean bl) {
        if (bl != this.impl_getPositionShape()) {
            this.impl_cssPropertyInvalidated(StyleableProperties.POSITION_SHAPE);
            this.positionShape = bl;
            this.requestLayout();
            this.impl_markDirty(DirtyBits.REGION_SHAPE);
        }
    }

    @Deprecated
    public boolean impl_getPositionShape() {
        return this.positionShape;
    }

    @Deprecated
    public void impl_setBackgroundFills(com.sun.javafx.scene.layout.region.BackgroundFill[] backgroundFillArray) {
        if (!Arrays.equals(this.backgroundFills, backgroundFillArray)) {
            this.impl_cssPropertyInvalidated(StyleableProperties.BACKGROUND_FILLS);
            this.backgroundFills = backgroundFillArray;
            this.impl_geomChanged();
            this.impl_markDirty(DirtyBits.SHAPE_FILL);
        }
    }

    @Deprecated
    public com.sun.javafx.scene.layout.region.BackgroundFill[] impl_getBackgroundFills() {
        return this.backgroundFills;
    }

    private void setBackgroundImages(com.sun.javafx.scene.layout.region.BackgroundImage[] backgroundImageArray) {
        if (!Arrays.equals(this.backgroundImages, backgroundImageArray)) {
            this.impl_cssPropertyInvalidated(StyleableProperties.BACKGROUND_IMAGES);
            this.backgroundImages = backgroundImageArray;
            this.impl_geomChanged();
            this.impl_markDirty(DirtyBits.NODE_CONTENTS);
        }
    }

    private void setStrokeBorders(StrokeBorder[] strokeBorderArray) {
        if (!Arrays.equals(this.strokeBorders, strokeBorderArray)) {
            this.impl_cssPropertyInvalidated(StyleableProperties.STROKE_BORDERS);
            this.strokeBorders = strokeBorderArray;
            this.insets.fireValueChanged();
            this.impl_geomChanged();
            this.impl_markDirty(DirtyBits.SHAPE_STROKE);
        }
    }

    private void setImageBorders(BorderImage[] borderImageArray) {
        if (!Arrays.equals(this.imageBorders, borderImageArray)) {
            this.impl_cssPropertyInvalidated(StyleableProperties.IMAGE_BORDERS);
            this.imageBorders = borderImageArray;
            this.insets.fireValueChanged();
            this.impl_geomChanged();
            this.impl_markDirty(DirtyBits.SHAPE_STROKE);
        }
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void resize(double d, double d2) {
        this.setWidth(d);
        this.setHeight(d2);
        PlatformLogger platformLogger = Logging.getLayoutLogger();
        if (platformLogger.isLoggable(400)) {
            platformLogger.finer(this.toString() + " resized to " + d + " x " + d2);
        }
    }

    @Override
    public final double minWidth(double d) {
        double d2 = this.getMinWidth();
        if (d2 == -1.0) {
            return this.computeMinWidth(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    @Override
    public final double minHeight(double d) {
        double d2 = this.getMinHeight();
        if (d2 == -1.0) {
            return this.computeMinHeight(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    @Override
    public final double prefWidth(double d) {
        double d2 = this.getPrefWidth();
        if (d2 == -1.0) {
            return super.prefWidth(d);
        }
        return d2;
    }

    @Override
    public final double prefHeight(double d) {
        double d2 = this.getPrefHeight();
        if (d2 == -1.0) {
            return super.prefHeight(d);
        }
        return d2;
    }

    @Override
    public final double maxWidth(double d) {
        double d2 = this.getMaxWidth();
        if (d2 == -1.0) {
            return this.computeMaxWidth(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    @Override
    public final double maxHeight(double d) {
        double d2 = this.getMaxHeight();
        if (d2 == -1.0) {
            return this.computeMaxHeight(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    protected double computeMinWidth(double d) {
        return this.getInsets().getLeft() + this.getInsets().getRight();
    }

    protected double computeMinHeight(double d) {
        return this.getInsets().getTop() + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = super.computePrefWidth(d);
        return this.getInsets().getLeft() + d2 + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = super.computePrefHeight(d);
        return this.getInsets().getTop() + d2 + this.getInsets().getBottom();
    }

    protected double computeMaxWidth(double d) {
        return Double.MAX_VALUE;
    }

    protected double computeMaxHeight(double d) {
        return Double.MAX_VALUE;
    }

    @Override
    protected void layoutChildren() {
        this.impl_resizeChildren(this.isSnapToPixel());
    }

    protected double snapSpace(double d) {
        return Region.snapSpace(d, this.isSnapToPixel());
    }

    protected double snapSize(double d) {
        return Region.snapSize(d, this.isSnapToPixel());
    }

    protected double snapPosition(double d) {
        return Region.snapPosition(d, this.isSnapToPixel());
    }

    double computeChildMinAreaWidth(Node node, Insets insets) {
        return this.computeChildMinAreaWidth(node, insets, -1.0);
    }

    double computeChildMinAreaWidth(Node node, Insets insets, double d) {
        double d2 = insets != null ? Region.snapSpace(insets.getLeft(), this.isSnapToPixel()) : 0.0;
        double d3 = insets != null ? Region.snapSpace(insets.getRight(), this.isSnapToPixel()) : 0.0;
        double d4 = -1.0;
        if (node.getContentBias() == Orientation.VERTICAL) {
            d4 = this.snapSize(d != -1.0 ? Region.boundedSize(d, node.minHeight(-1.0), node.maxHeight(-1.0)) : node.minHeight(-1.0));
        }
        return d2 + this.snapSize(node.minWidth(d4)) + d3;
    }

    double computeChildMinAreaHeight(Node node, Insets insets) {
        return this.computeChildMinAreaHeight(node, insets, -1.0);
    }

    double computeChildMinAreaHeight(Node node, Insets insets, double d) {
        double d2 = insets != null ? Region.snapSpace(insets.getTop(), this.isSnapToPixel()) : 0.0;
        double d3 = insets != null ? Region.snapSpace(insets.getBottom(), this.isSnapToPixel()) : 0.0;
        double d4 = -1.0;
        if (node.getContentBias() == Orientation.HORIZONTAL) {
            d4 = this.snapSize(d != -1.0 ? Region.boundedSize(d, node.minWidth(-1.0), node.maxWidth(-1.0)) : node.minWidth(-1.0));
        }
        return d2 + this.snapSize(node.minHeight(d4)) + d3;
    }

    double computeChildPrefAreaWidth(Node node, Insets insets) {
        return this.computeChildPrefAreaWidth(node, insets, -1.0);
    }

    double computeChildPrefAreaWidth(Node node, Insets insets, double d) {
        double d2 = insets != null ? Region.snapSpace(insets.getTop(), this.isSnapToPixel()) : 0.0;
        double d3 = insets != null ? Region.snapSpace(insets.getBottom(), this.isSnapToPixel()) : 0.0;
        double d4 = insets != null ? Region.snapSpace(insets.getLeft(), this.isSnapToPixel()) : 0.0;
        double d5 = insets != null ? Region.snapSpace(insets.getRight(), this.isSnapToPixel()) : 0.0;
        double d6 = -1.0;
        if (node.getContentBias() == Orientation.VERTICAL) {
            d6 = this.snapSize(Region.boundedSize(d != -1.0 ? d - d2 - d3 : node.prefHeight(-1.0), node.minHeight(-1.0), node.maxHeight(-1.0)));
        }
        return d4 + this.snapSize(Region.boundedSize(node.prefWidth(d6), node.minWidth(d6), node.maxWidth(d6))) + d5;
    }

    double computeChildPrefAreaHeight(Node node, Insets insets) {
        return this.computeChildPrefAreaHeight(node, insets, -1.0);
    }

    double computeChildPrefAreaHeight(Node node, Insets insets, double d) {
        double d2 = insets != null ? Region.snapSpace(insets.getTop(), this.isSnapToPixel()) : 0.0;
        double d3 = insets != null ? Region.snapSpace(insets.getBottom(), this.isSnapToPixel()) : 0.0;
        double d4 = insets != null ? Region.snapSpace(insets.getLeft(), this.isSnapToPixel()) : 0.0;
        double d5 = insets != null ? Region.snapSpace(insets.getRight(), this.isSnapToPixel()) : 0.0;
        double d6 = -1.0;
        if (node.getContentBias() == Orientation.HORIZONTAL) {
            d6 = this.snapSize(Region.boundedSize(d != -1.0 ? d - d4 - d5 : node.prefWidth(-1.0), node.minWidth(-1.0), node.maxWidth(-1.0)));
        }
        return d2 + this.snapSize(Region.boundedSize(node.prefHeight(d6), node.minHeight(d6), node.maxHeight(d6))) + d3;
    }

    double computeChildMaxAreaWidth(Node node, Insets insets) {
        return this.computeChildMaxAreaWidth(node, insets, -1.0);
    }

    double computeChildMaxAreaWidth(Node node, Insets insets, double d) {
        double d2 = node.maxWidth(-1.0);
        if (d2 == Double.MAX_VALUE) {
            return d2;
        }
        double d3 = insets != null ? Region.snapSpace(insets.getLeft(), this.isSnapToPixel()) : 0.0;
        double d4 = insets != null ? Region.snapSpace(insets.getRight(), this.isSnapToPixel()) : 0.0;
        double d5 = -1.0;
        if (node.getContentBias() == Orientation.VERTICAL) {
            d5 = this.snapSize(d != -1.0 ? Region.boundedSize(d, node.minHeight(-1.0), node.maxHeight(-1.0)) : node.maxHeight(-1.0));
            d2 = node.maxWidth(d5);
        }
        return d3 + this.snapSize(Region.boundedSize(d2, node.minWidth(d5), node.maxWidth(d5))) + d4;
    }

    double computeChildMaxAreaHeight(Node node, Insets insets) {
        return this.computeChildMaxAreaHeight(node, insets, -1.0);
    }

    double computeChildMaxAreaHeight(Node node, Insets insets, double d) {
        double d2 = node.maxHeight(-1.0);
        if (d2 == Double.MAX_VALUE) {
            return d2;
        }
        double d3 = insets != null ? Region.snapSpace(insets.getTop(), this.isSnapToPixel()) : 0.0;
        double d4 = insets != null ? Region.snapSpace(insets.getBottom(), this.isSnapToPixel()) : 0.0;
        double d5 = -1.0;
        if (node.getContentBias() == Orientation.HORIZONTAL) {
            d5 = this.snapSize(d != -1.0 ? Region.boundedSize(d, node.minWidth(-1.0), node.maxWidth(-1.0)) : node.maxWidth(-1.0));
            d2 = node.maxHeight(d5);
        }
        return d3 + this.snapSize(Region.boundedSize(d2, node.minHeight(d5), node.maxHeight(d5))) + d4;
    }

    double computeMaxMinAreaWidth(List<Node> list, Insets[] insetsArray, HPos hPos) {
        return this.computeMaxMinAreaWidth(list, insetsArray, hPos, -1.0);
    }

    double computeMaxMinAreaWidth(List<Node> list, Insets[] insetsArray, HPos hPos, double d) {
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            d2 = Math.max(d2, this.computeChildMinAreaWidth(list.get(i), insetsArray[i], d));
        }
        return d2;
    }

    double computeMaxMinAreaHeight(List<Node> list, Insets[] insetsArray, VPos vPos) {
        return this.computeMaxMinAreaHeight(list, insetsArray, vPos, -1.0);
    }

    double computeMaxMinAreaHeight(List<Node> list, Insets[] insetsArray, VPos vPos, double d) {
        return this.getMaxAreaHeight(list, insetsArray, d, vPos, true);
    }

    double computeMaxPrefAreaWidth(List<Node> list, Insets[] insetsArray, HPos hPos) {
        return this.computeMaxPrefAreaWidth(list, insetsArray, -1.0, hPos);
    }

    double computeMaxPrefAreaWidth(List<Node> list, Insets[] insetsArray, double d, HPos hPos) {
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            d2 = Math.max(d2, this.computeChildPrefAreaWidth(node, insetsArray[i], d));
        }
        return d2;
    }

    double computeMaxPrefAreaHeight(List<Node> list, Insets[] insetsArray, VPos vPos) {
        return this.getMaxAreaHeight(list, insetsArray, -1.0, vPos, false);
    }

    double computeMaxPrefAreaHeight(List<Node> list, Insets[] insetsArray, double d, VPos vPos) {
        return this.getMaxAreaHeight(list, insetsArray, d, vPos, false);
    }

    private double getMaxAreaHeight(List<Node> list, Insets[] insetsArray, double d, VPos vPos, boolean bl) {
        if (vPos == VPos.BASELINE) {
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                Node node = list.get(i);
                double d4 = node.getBaselineOffset();
                double d5 = insetsArray[i] != null ? Region.snapSpace(insetsArray[i].getTop(), this.isSnapToPixel()) : 0.0;
                double d6 = insetsArray[i] != null ? Region.snapSpace(insetsArray[i].getBottom(), this.isSnapToPixel()) : 0.0;
                d2 = Math.max(d2, d4 + d5);
                d3 = Math.max(d3, this.snapSpace(bl ? this.snapSize(node.minHeight(d)) : this.snapSize(node.prefHeight(d))) - d4 + d6);
            }
            return d2 + d3;
        }
        double d7 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            d7 = Math.max(d7, bl ? this.computeChildMinAreaHeight(node, insetsArray[i], d) : this.computeChildPrefAreaHeight(node, insetsArray[i], d));
        }
        return d7;
    }

    protected void positionInArea(Node node, double d, double d2, double d3, double d4, double d5, HPos hPos, VPos vPos) {
        this.positionInArea(node, d, d2, d3, d4, d5, Insets.EMPTY, hPos, vPos);
    }

    protected void positionInArea(Node node, double d, double d2, double d3, double d4, double d5, Insets insets, HPos hPos, VPos vPos) {
        Insets insets2 = insets != null ? insets : Insets.EMPTY;
        this.position(node, d, d2, d3, d4, d5, this.snapSpace(insets2.getTop()), this.snapSpace(insets2.getRight()), this.snapSpace(insets2.getBottom()), this.snapSpace(insets2.getLeft()), hPos, vPos);
    }

    protected void layoutInArea(Node node, double d, double d2, double d3, double d4, double d5, HPos hPos, VPos vPos) {
        this.layoutInArea(node, d, d2, d3, d4, d5, Insets.EMPTY, hPos, vPos);
    }

    protected void layoutInArea(Node node, double d, double d2, double d3, double d4, double d5, Insets insets, HPos hPos, VPos vPos) {
        this.layoutInArea(node, d, d2, d3, d4, d5, insets, true, true, hPos, vPos);
    }

    protected void layoutInArea(Node node, double d, double d2, double d3, double d4, double d5, Insets insets, boolean bl, boolean bl2, HPos hPos, VPos vPos) {
        Insets insets2 = insets != null ? insets : Insets.EMPTY;
        double d6 = this.snapSpace(insets2.getTop());
        double d7 = this.snapSpace(insets2.getBottom());
        double d8 = this.snapSpace(insets2.getLeft());
        double d9 = this.snapSpace(insets2.getRight());
        if (node.isResizable()) {
            Orientation orientation = node.getContentBias();
            double d10 = d3 - d8 - d9;
            double d11 = d4 - d6 - d7;
            double d12 = 0.0;
            double d13 = 0.0;
            if (orientation == null) {
                d12 = Region.boundedSize(bl ? d10 : Math.min(d10, node.prefWidth(-1.0)), node.minWidth(-1.0), node.maxWidth(-1.0));
                d13 = Region.boundedSize(bl2 ? d11 : Math.min(d11, node.prefHeight(-1.0)), node.minHeight(-1.0), node.maxHeight(-1.0));
            } else if (orientation == Orientation.HORIZONTAL) {
                d12 = Region.boundedSize(bl ? d10 : Math.min(d10, node.prefWidth(-1.0)), node.minWidth(-1.0), node.maxWidth(-1.0));
                d13 = Region.boundedSize(Math.min(d11, node.prefHeight(d12)), node.minHeight(d12), node.maxHeight(d12));
            } else {
                d13 = Region.boundedSize(bl2 ? d11 : Math.min(d11, node.prefHeight(-1.0)), node.minHeight(-1.0), node.maxHeight(-1.0));
                d12 = Region.boundedSize(Math.min(d10, node.prefWidth(d13)), node.minWidth(d13), node.maxWidth(d13));
            }
            node.resize(this.snapSize(d12), this.snapSize(d13));
        }
        this.position(node, d, d2, d3, d4, d5, d6, d9, d7, d8, hPos, vPos);
    }

    private void position(Node node, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, HPos hPos, VPos vPos) {
        double d10 = d9 + Region.computeXOffset(d3 - d9 - d7, node.getLayoutBounds().getWidth(), hPos);
        double d11 = d6 + (vPos == VPos.BASELINE ? d5 - node.getBaselineOffset() : Region.computeYOffset(d4 - d6 - d8, node.getLayoutBounds().getHeight(), vPos));
        double d12 = node.isResizable() ? this.snapPosition(d + d10) : d + d10;
        double d13 = node.isResizable() ? this.snapPosition(d2 + d11) : d2 + d11;
        node.relocate(d12, d13);
    }

    @Override
    public void impl_updatePG() {
        int n;
        Object object;
        int n2;
        super.impl_updatePG();
        PGRegion pGRegion = (PGRegion)this.impl_getPGNode();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            pGRegion.setSize((float)this.getWidth(), (float)this.getHeight());
        }
        if (this.impl_isDirty(DirtyBits.SHAPE_FILL)) {
            com.sun.javafx.scene.layout.region.BackgroundFill backgroundFill = null;
            try {
                n2 = this.backgroundFills != null ? this.backgroundFills.length : 0;
                object = new BackgroundFill[n2];
                for (n = 0; n < n2; ++n) {
                    backgroundFill = this.backgroundFills[n];
                    object[n] = new BackgroundFill(Toolkit.getToolkit().getPaint(this.backgroundFills[n].getFill()), (float)this.backgroundFills[n].getTopLeftCornerRadius(), (float)this.backgroundFills[n].getTopRightCornerRadius(), (float)this.backgroundFills[n].getBottomLeftCornerRadius(), (float)this.backgroundFills[n].getBottomRightCornerRadius(), (float)this.backgroundFills[n].getOffsets().getTop(), (float)this.backgroundFills[n].getOffsets().getLeft(), (float)this.backgroundFills[n].getOffsets().getBottom(), (float)this.backgroundFills[n].getOffsets().getRight());
                }
                pGRegion.setBackgroundFills((BackgroundFill[])object);
            }
            catch (Exception exception) {
                System.out.println("Failed to apply background fills to region [" + this.getStyleClass() + "]");
                System.out.println("    because: " + exception.getMessage());
                System.out.println("    failed bf=" + backgroundFill);
                if (backgroundFill != null && backgroundFill.getFill() instanceof LinearGradient) {
                    object = (LinearGradient)backgroundFill.getFill();
                    System.out.println("       startX=" + ((LinearGradient)object).getStartX() + " startY=" + ((LinearGradient)object).getStartY() + " endX=" + ((LinearGradient)object).getEndX() + " endY=" + ((LinearGradient)object).getStartY() + " proportional=" + ((LinearGradient)object).isProportional() + " cycleMethod=" + (Object)((Object)((LinearGradient)object).getCycleMethod()));
                    System.out.println("       stops=");
                    for (Stop stop : ((LinearGradient)object).getStops()) {
                        System.out.println(" (" + stop.getOffset() + "," + stop.getColor() + ")");
                    }
                    System.out.println(" ");
                }
                exception.printStackTrace();
            }
        }
        if (this.impl_isDirty(DirtyBits.SHAPE_STROKE)) {
            double d;
            int n3 = this.imageBorders != null ? this.imageBorders.length : 0;
            n2 = this.strokeBorders != null ? this.strokeBorders.length : 0;
            object = new Border[n3 + n2];
            for (n = 0; n < n3; ++n) {
                double d2 = this.imageBorders[n].isProportionalWidth() ? this.getWidth() : 1.0;
                d = this.imageBorders[n].isProportionalWidth() ? this.getHeight() : 1.0;
                double d3 = this.imageBorders[n].isProportionalSlice() ? this.imageBorders[n].getImage().getWidth() : 1.0;
                double d4 = this.imageBorders[n].isProportionalSlice() ? this.imageBorders[n].getImage().getHeight() : 1.0;
                object[n] = new ImageBorder((float)(this.imageBorders[n].getTopWidth() * d), (float)(this.imageBorders[n].getLeftWidth() * d2), (float)(this.imageBorders[n].getBottomWidth() * d), (float)(this.imageBorders[n].getRightWidth() * d2), (float)this.imageBorders[n].getOffsets().getTop(), (float)this.imageBorders[n].getOffsets().getLeft(), (float)this.imageBorders[n].getOffsets().getBottom(), (float)this.imageBorders[n].getOffsets().getRight(), this.imageBorders[n].getImage().impl_getPlatformImage(), (float)(this.imageBorders[n].getTopSlice() * d4), (float)(this.imageBorders[n].getLeftSlice() * d3), (float)(this.imageBorders[n].getBottomSlice() * d4), (float)(this.imageBorders[n].getRightSlice() * d3), Repeat.values()[this.imageBorders[n].getRepeatX().ordinal()], Repeat.values()[this.imageBorders[n].getRepeatY().ordinal()], this.imageBorders[n].isFillCenter());
            }
            for (n = 0; n < n2; ++n) {
                double d5 = this.strokeBorders[n].isProportionalWidth() ? this.getWidth() : 1.0;
                d = this.strokeBorders[n].isProportionalWidth() ? this.getHeight() : 1.0;
                object[n + n3] = new StrokedBorder((float)(this.strokeBorders[n].getTopWidth() * d), (float)(this.strokeBorders[n].getLeftWidth() * d5), (float)(this.strokeBorders[n].getBottomWidth() * d), (float)(this.strokeBorders[n].getRightWidth() * d5), (float)this.strokeBorders[n].getOffsets().getTop(), (float)this.strokeBorders[n].getOffsets().getLeft(), (float)this.strokeBorders[n].getOffsets().getBottom(), (float)this.strokeBorders[n].getOffsets().getRight(), (float)this.strokeBorders[n].getTopLeftCornerRadius(), (float)this.strokeBorders[n].getTopRightCornerRadius(), (float)this.strokeBorders[n].getBottomLeftCornerRadius(), (float)this.strokeBorders[n].getBottomRightCornerRadius(), Toolkit.getToolkit().getPaint(this.strokeBorders[n].getTopFill()), Toolkit.getToolkit().getPaint(this.strokeBorders[n].getLeftFill()), Toolkit.getToolkit().getPaint(this.strokeBorders[n].getBottomFill()), Toolkit.getToolkit().getPaint(this.strokeBorders[n].getRightFill()), this.createSgBorderStyle(this.strokeBorders[n].getTopStyle()), this.createSgBorderStyle(this.strokeBorders[n].getLeftStyle()), this.createSgBorderStyle(this.strokeBorders[n].getBottomStyle()), this.createSgBorderStyle(this.strokeBorders[n].getRightStyle()));
            }
            pGRegion.setBorders((Border[])object);
        }
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            int n4 = this.backgroundImages != null ? this.backgroundImages.length : 0;
            BackgroundImage[] backgroundImageArray = new BackgroundImage[n4];
            if (this.backgroundImages != null) {
                for (int i = 0; i < n4; ++i) {
                    com.sun.javafx.scene.layout.region.BackgroundImage backgroundImage = this.backgroundImages[i];
                    backgroundImageArray[i] = new BackgroundImage(backgroundImage.getImage().impl_getPlatformImage(), Repeat.values()[backgroundImage.getRepeatX().ordinal()], Repeat.values()[backgroundImage.getRepeatY().ordinal()], (float)backgroundImage.getTop(), (float)backgroundImage.getLeft(), (float)backgroundImage.getBottom(), (float)backgroundImage.getRight(), (float)backgroundImage.getWidth(), (float)backgroundImage.getHeight(), backgroundImage.isProportionalHPos(), backgroundImage.isProportionalVPos(), backgroundImage.isProportionalWidth(), backgroundImage.isProportionalHeight(), backgroundImage.isContain(), backgroundImage.isCover());
                }
            }
            pGRegion.setBackgroundImages(backgroundImageArray);
        }
        if (this.impl_isDirty(DirtyBits.REGION_SHAPE)) {
            if (this.shape == null) {
                pGRegion.setShape(null);
            } else {
                this.shape.impl_syncPGNode();
                pGRegion.setShape((PGShape)this.shape.impl_getPGNode());
            }
            pGRegion.setResizeShape(this.scaleShape);
            pGRegion.setPositionShape(this.positionShape);
        }
    }

    private com.sun.javafx.sg.BorderStyle createSgBorderStyle(BorderStyle borderStyle) {
        if (borderStyle != null && borderStyle != BorderStyle.NONE) {
            if (borderStyle == BorderStyle.SOLID) {
                return com.sun.javafx.sg.BorderStyle.SOLID;
            }
            double[] dArray = borderStyle.getStrokeDashArray() != null ? borderStyle.getStrokeDashArray() : new double[]{};
            float[] fArray = new float[dArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = (float)dArray[i];
            }
            return new com.sun.javafx.sg.BorderStyle(this.toPGStrokeType(borderStyle.getStrokeType()), this.toPGLineCap(borderStyle.getStrokeLineCap()), this.toPGLineJoin(borderStyle.getStrokeLineJoin()), (float)borderStyle.getStrokeMiterLimit(), fArray, (float)borderStyle.getStrokeDashOffset());
        }
        return null;
    }

    @Override
    public PGNode impl_createPGNode() {
        return Toolkit.getToolkit().createPGRegion();
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double d, double d2) {
        Insets insets;
        double d3;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = this.getWidth();
        double d7 = this.getHeight();
        if (this.shape != null && !this.scaleShape) {
            if (this.shape.contains(d, d2)) {
                return true;
            }
            double d8 = this.shape.getLayoutBounds().getWidth();
            d3 = this.shape.getLayoutBounds().getHeight();
            if (this.positionShape) {
                d4 = (this.getWidth() - d8) / 2.0;
                d5 = (this.getHeight() - d3) / 2.0;
                d6 = d4 + d8;
                d7 = d5 + d3;
            } else {
                d4 = this.shape.getLayoutBounds().getMinX();
                d5 = this.shape.getLayoutBounds().getMinY();
                d6 = this.shape.getLayoutBounds().getMaxX();
                d7 = this.shape.getLayoutBounds().getMaxY();
            }
        }
        if (this.backgroundFills != null) {
            for (int i = 0; i < this.backgroundFills.length; ++i) {
                insets = this.backgroundFills[i].getOffsets();
                if (this.backgroundFills[i].getFill() == null) continue;
                d3 = d4 + insets.getLeft();
                double d9 = d5 + insets.getTop();
                double d10 = d6 - insets.getRight();
                double d11 = d7 - insets.getBottom();
                if (!(d >= d3) || !(d2 >= d9) || !(d < d10) || !(d2 < d11)) continue;
                double d12 = this.backgroundFills[i].getTopLeftCornerRadius() / 2.0;
                double d13 = this.backgroundFills[i].getTopRightCornerRadius() / 2.0;
                double d14 = this.backgroundFills[i].getBottomLeftCornerRadius() / 2.0;
                double d15 = this.backgroundFills[i].getBottomRightCornerRadius() / 2.0;
                double d16 = 1.0;
                double d17 = 1.0;
                if (d12 != 0.0 && d < d3 + d12 && d2 < d9 + d12) {
                    d16 = (d - (d3 + d12)) / d12;
                    d17 = (d2 - (d9 + d12)) / d12;
                } else if (d14 != 0.0 && d < d3 + d14 && d2 > d11 - d14) {
                    d16 = (d - (d3 + d14)) / d14;
                    d17 = (d2 - (d11 - d14)) / d14;
                } else if (d13 != 0.0 && d > d10 - d13 && d2 < d9 + d13) {
                    d16 = (d - (d10 - d13)) / d13;
                    d17 = (d2 - (d9 + d13)) / d13;
                } else if (d15 != 0.0 && d > d10 - d15 && d2 > d11 - d15) {
                    d16 = (d - (d10 - d15)) / d15;
                    d17 = (d2 - (d11 - d15)) / d15;
                } else {
                    return true;
                }
                if (!(d16 * d16 + d17 * d17 < 0.5)) continue;
                return true;
            }
        }
        if (this.backgroundImages != null) {
            for (int i = 0; i < this.backgroundImages.length; ++i) {
                if (!(d >= d4 + this.backgroundImages[i].getLeft()) || !(d <= d6 - this.backgroundImages[i].getRight()) || !(d2 >= d5 + this.backgroundImages[i].getTop()) || !(d2 <= d7 - this.backgroundImages[i].getBottom())) continue;
                return true;
            }
        }
        if (this.imageBorders != null) {
            for (int i = 0; i < this.imageBorders.length; ++i) {
                insets = this.imageBorders[i].getOffsets();
                if (!this.borderContains(d, d2, d4 + insets.getLeft(), d5 + insets.getTop(), d6 - insets.getRight(), d7 - insets.getBottom(), this.imageBorders[i].getTopWidth(), this.imageBorders[i].getRightWidth(), this.imageBorders[i].getBottomWidth(), this.imageBorders[i].getLeftWidth())) continue;
                return true;
            }
        }
        if (this.strokeBorders != null) {
            for (int i = 0; i < this.strokeBorders.length; ++i) {
                insets = this.strokeBorders[i].getOffsets();
                if (!this.borderContains(d, d2, d4 + insets.getLeft(), d5 + insets.getTop(), d6 - insets.getRight(), d7 - insets.getBottom(), this.strokeBorders[i].getTopWidth(), this.strokeBorders[i].getRightWidth(), this.strokeBorders[i].getBottomWidth(), this.strokeBorders[i].getLeftWidth())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean borderContains(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        return (d >= d3 && d <= d3 + d10 || d >= d5 - d8 && d <= d5) && d2 >= d4 && d2 <= d6 || (d2 >= d4 && d2 <= d4 + d7 || d2 >= d6 - d9 && d2 <= d6) && d >= d3 && d <= d5;
    }

    @Override
    @Deprecated
    protected Node impl_pickNodeLocal(double d, double d2) {
        if (this.containsBounds(d, d2)) {
            ObservableList<Node> observableList = this.getChildren();
            for (int i = observableList.size() - 1; i >= 0; --i) {
                Node node = ((Node)observableList.get(i)).impl_pickNode(d, d2);
                if (node == null) continue;
                return node;
            }
            if (this.contains(d, d2)) {
                return this;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    protected Node impl_pickNodeLocal(PickRay pickRay) {
        if (this.impl_intersects(pickRay)) {
            ObservableList<Node> observableList = this.getChildren();
            for (int i = observableList.size() - 1; i >= 0; --i) {
                Node node = ((Node)observableList.get(i)).impl_pickNode(pickRay);
                if (node == null) continue;
                return node;
            }
            return this;
        }
        return null;
    }

    @Override
    @Deprecated
    protected Bounds impl_computeLayoutBounds() {
        return new BoundingBox(0.0, 0.0, 0.0, this.getWidth(), this.getHeight(), 0.0);
    }

    @Override
    @Deprecated
    protected final void impl_notifyLayoutBoundsChanged() {
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        BaseBounds baseBounds2;
        Object object;
        int n;
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        if (this.shape != null && !this.scaleShape) {
            d2 = this.shape.getLayoutBounds().getWidth();
            d = this.shape.getLayoutBounds().getHeight();
            if (this.positionShape) {
                d3 = (this.getWidth() - d2) / 2.0;
                d4 = (this.getHeight() - d) / 2.0;
                d5 = d3 + d2;
                d6 = d4 + d;
            } else {
                d3 = this.shape.getLayoutBounds().getMinX();
                d4 = this.shape.getLayoutBounds().getMinY();
                d5 = this.shape.getLayoutBounds().getMaxX();
                d6 = this.shape.getLayoutBounds().getMaxY();
            }
        }
        d2 = d3;
        d = d4;
        double d7 = d5;
        double d8 = d6;
        if (this.backgroundFills != null) {
            for (n = 0; n < this.backgroundFills.length; ++n) {
                object = this.backgroundFills[n].getOffsets();
                d2 = Math.min(d2, d3 + ((Insets)object).getLeft());
                d = Math.min(d, d4 + ((Insets)object).getTop());
                d7 = Math.max(d7, d5 - ((Insets)object).getRight());
                d8 = Math.max(d8, d6 - ((Insets)object).getBottom());
            }
        }
        if (this.backgroundImages != null) {
            for (n = 0; n < this.backgroundImages.length; ++n) {
                d2 = Math.min(d2, d3 + this.backgroundImages[n].getLeft());
                d = Math.min(d, d4 + this.backgroundImages[n].getTop());
                d7 = Math.max(d7, d5 - this.backgroundImages[n].getRight());
                d8 = Math.max(d8, d6 - this.backgroundImages[n].getBottom());
            }
        }
        if (this.imageBorders != null) {
            for (n = 0; n < this.imageBorders.length; ++n) {
                object = this.imageBorders[n].getOffsets();
                d2 = Math.min(d2, d3 + ((Insets)object).getLeft() - this.imageBorders[n].getLeftWidth() / 2.0);
                d = Math.min(d, d4 + ((Insets)object).getTop() - this.imageBorders[n].getTopWidth() / 2.0);
                d7 = Math.max(d7, d5 - ((Insets)object).getRight() + this.imageBorders[n].getRightWidth() / 2.0);
                d8 = Math.max(d8, d6 - ((Insets)object).getBottom() + this.imageBorders[n].getBottomWidth() / 2.0);
            }
        }
        if (this.strokeBorders != null) {
            for (n = 0; n < this.strokeBorders.length; ++n) {
                object = this.strokeBorders[n].getOffsets();
                d2 = Math.min(d2, d3 + ((Insets)object).getLeft() - this.strokeBorders[n].getLeftWidth() / 2.0);
                d = Math.min(d, d4 + ((Insets)object).getTop() - this.strokeBorders[n].getTopWidth() / 2.0);
                d7 = Math.max(d7, d5 - ((Insets)object).getRight() + this.strokeBorders[n].getRightWidth() / 2.0);
                d8 = Math.max(d8, d6 - ((Insets)object).getBottom() + this.strokeBorders[n].getBottomWidth() / 2.0);
            }
        }
        if ((baseBounds2 = super.impl_computeGeomBounds(baseBounds, baseTransform)).isEmpty()) {
            baseBounds = baseBounds.deriveWithNewBounds((float)d2, (float)d, 0.0f, (float)d7, (float)d8, 0.0f);
            baseBounds = baseTransform.transform(baseBounds, baseBounds);
            return baseBounds;
        }
        object = TempState.getInstance().bounds;
        object = ((BaseBounds)object).deriveWithNewBounds((float)d2, (float)d, 0.0f, (float)d7, (float)d8, 0.0f);
        BaseBounds baseBounds3 = baseTransform.transform((BaseBounds)object, (BaseBounds)object);
        baseBounds2 = baseBounds2.deriveWithUnion(baseBounds3);
        return baseBounds2;
    }

    PGShape.StrokeLineCap toPGLineCap(StrokeLineCap strokeLineCap) {
        if (strokeLineCap == StrokeLineCap.SQUARE) {
            return PGShape.StrokeLineCap.SQUARE;
        }
        if (strokeLineCap == StrokeLineCap.BUTT) {
            return PGShape.StrokeLineCap.BUTT;
        }
        return PGShape.StrokeLineCap.ROUND;
    }

    PGShape.StrokeLineJoin toPGLineJoin(StrokeLineJoin strokeLineJoin) {
        if (strokeLineJoin == StrokeLineJoin.MITER) {
            return PGShape.StrokeLineJoin.MITER;
        }
        if (strokeLineJoin == StrokeLineJoin.BEVEL) {
            return PGShape.StrokeLineJoin.BEVEL;
        }
        return PGShape.StrokeLineJoin.ROUND;
    }

    PGShape.StrokeType toPGStrokeType(StrokeType strokeType) {
        if (strokeType == StrokeType.INSIDE) {
            return PGShape.StrokeType.INSIDE;
        }
        if (strokeType == StrokeType.OUTSIDE) {
            return PGShape.StrokeType.OUTSIDE;
        }
        return PGShape.StrokeType.CENTERED;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-snap-to-pixel".equals(string)) {
            this.setSnapToPixel((Boolean)object);
        } else if ("-fx-padding".equals(string)) {
            if (object == null) {
                object = Insets.EMPTY;
            }
            this.setPadding((Insets)object);
        } else if ("-fx-background-fills".equals(string)) {
            List list = (List)object;
            this.impl_setBackgroundFills(list == null || list.isEmpty() ? null : list.toArray(new com.sun.javafx.scene.layout.region.BackgroundFill[list.size()]));
        } else if ("-fx-background-images".equals(string)) {
            List list = (List)object;
            this.setBackgroundImages(list == null || list.isEmpty() ? null : list.toArray(new com.sun.javafx.scene.layout.region.BackgroundImage[list.size()]));
        } else if ("-fx-stroke-borders".equals(string)) {
            List list = (List)object;
            this.setStrokeBorders(list == null || list.isEmpty() ? null : list.toArray(new StrokeBorder[list.size()]));
        } else if ("-fx-image-borders".equals(string)) {
            List list = (List)object;
            this.setImageBorders(list == null || list.isEmpty() ? null : list.toArray(new BorderImage[list.size()]));
        } else if ("-fx-shape".equals(string)) {
            if (object != null) {
                Shape shape = this.shape;
                if (shape instanceof SVGPath) {
                    String string2 = ((SVGPath)shape).getContent();
                    if (!object.equals(string2)) {
                        ((SVGPath)shape).setContent((String)object);
                    }
                } else {
                    SVGPath sVGPath = new SVGPath();
                    sVGPath.setContent((String)object);
                    this.impl_setShape(sVGPath);
                }
            }
        } else if ("-fx-scale-shape".equals(string)) {
            this.impl_setScaleShape((Boolean)object);
        } else if ("-fx-position-shape".equals(string)) {
            this.impl_setPositionShape((Boolean)object);
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-snap-to-pixel".equals(string)) {
            return this.snapToPixel == null || !this.snapToPixel.isBound();
        }
        if ("-fx-padding".equals(string)) {
            return this.padding == null || !this.padding.isBound();
        }
        if ("-fx-background-fills".equals(string)) {
            return true;
        }
        if ("-fx-background-images".equals(string)) {
            return true;
        }
        if ("-fx-stroke-borders".equals(string) || "-fx-image-borders".equals(string)) {
            return true;
        }
        if ("-fx-shape".equals(string)) {
            return true;
        }
        if ("-fx-scale-shape".equals(string)) {
            return true;
        }
        if ("-fx-position-shape".equals(string)) {
            return true;
        }
        return super.impl_cssSettable(string);
    }

    private static class StyleableProperties {
        private static final StyleableProperty PADDING = new StyleableProperty(Region.class, "padding");
        private static final StyleableProperty BACKGROUND_FILLS = new StyleableProperty(Region.class, "backgroundFills", com.sun.javafx.scene.layout.region.BackgroundFill.impl_CSS_STYLEABLES());
        private static final StyleableProperty BACKGROUND_IMAGES = new StyleableProperty(Region.class, "backgroundImages", com.sun.javafx.scene.layout.region.BackgroundImage.impl_CSS_STYLEABLES());
        private static final StyleableProperty IMAGE_BORDERS = new StyleableProperty(Region.class, "imageBorders", BorderImage.impl_CSS_STYLEABLES());
        private static final StyleableProperty STROKE_BORDERS = new StyleableProperty(Region.class, "strokeBorders", StrokeBorder.impl_CSS_STYLEABLES());
        private static final StyleableProperty SHAPE = new StyleableProperty(Region.class, "shape");
        private static final StyleableProperty SCALE_SHAPE = new StyleableProperty(Region.class, "scaleShape");
        private static final StyleableProperty POSITION_SHAPE = new StyleableProperty(Region.class, "positionShape");
        private static final StyleableProperty SNAP_TO_PIXEL = new StyleableProperty(Region.class, "snapToPixel");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Parent.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, PADDING, BACKGROUND_FILLS, BACKGROUND_IMAGES, IMAGE_BORDERS, STROKE_BORDERS, SHAPE, SCALE_SHAPE, POSITION_SHAPE, SNAP_TO_PIXEL);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }

    private final class InsetsExpression
    extends ObjectExpression<Insets> {
        private Insets cache = null;
        private ExpressionHelper<Insets> helper = null;

        private InsetsExpression() {
        }

        void fireValueChanged() {
            this.cache = null;
            ExpressionHelper.fireValueChangedEvent(this.helper);
        }

        @Override
        public Insets get() {
            if (Region.this.imageBorders == null && Region.this.strokeBorders == null) {
                return Region.this.getPadding();
            }
            if (this.cache == null) {
                Insets insets;
                int n;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                if (Region.this.imageBorders != null) {
                    for (n = 0; n < Region.this.imageBorders.length; ++n) {
                        insets = Region.this.imageBorders[n].getOffsets();
                        d3 = Math.max(d3, insets.getLeft() + Region.this.imageBorders[n].getLeftWidth());
                        d = Math.max(d, insets.getTop() + Region.this.imageBorders[n].getTopWidth());
                        d4 = Math.max(d4, insets.getRight() + Region.this.imageBorders[n].getRightWidth());
                        d2 = Math.max(d2, insets.getBottom() + Region.this.imageBorders[n].getBottomWidth());
                    }
                }
                if (Region.this.strokeBorders != null) {
                    for (n = 0; n < Region.this.strokeBorders.length; ++n) {
                        insets = Region.this.strokeBorders[n].getOffsets();
                        d3 = Math.max(d3, insets.getLeft() + Region.this.strokeBorders[n].getLeftWidth());
                        d = Math.max(d, insets.getTop() + Region.this.strokeBorders[n].getTopWidth());
                        d4 = Math.max(d4, insets.getRight() + Region.this.strokeBorders[n].getRightWidth());
                        d2 = Math.max(d2, insets.getBottom() + Region.this.strokeBorders[n].getBottomWidth());
                    }
                }
                Insets insets2 = Region.this.getPadding();
                this.cache = new Insets(Math.max(0.0, d) + insets2.getTop(), Math.max(0.0, d4) + insets2.getRight(), Math.max(0.0, d2) + insets2.getBottom(), Math.max(0.0, d3) + insets2.getLeft());
            }
            return this.cache;
        }

        @Override
        public Insets getValue() {
            return this.get();
        }

        @Override
        public void addListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, invalidationListener);
        }

        @Override
        public void removeListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, invalidationListener);
        }

        @Override
        public void addListener(ChangeListener<? super Insets> changeListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, changeListener);
        }

        @Override
        public void removeListener(ChangeListener<? super Insets> changeListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, changeListener);
        }
    }
}

