/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class FlowPane
extends Pane {
    private static final String MARGIN_CONSTRAINT = "flowpane-margin";
    @Styleable(property="-fx-orientation", initial="horizontal")
    private ObjectProperty<Orientation> orientation;
    @Styleable(property="-fx-hgap", initial="0")
    private DoubleProperty hgap;
    @Styleable(property="-fx-vgap", initial="0")
    private DoubleProperty vgap;
    private DoubleProperty prefWrapLength;
    @Styleable(property="-fx-alignment", initial="top-left")
    private ObjectProperty<Pos> alignment;
    @Styleable(property="-fx-column-halignment", initial="left")
    private ObjectProperty<HPos> columnHalignment;
    @Styleable(property="-fx-row-valignment", initial="center")
    private ObjectProperty<VPos> rowValignment;
    private List<Run> runs = null;
    private double lastMaxRunLength = -1.0;
    boolean computingRuns = false;

    public static void setMargin(Node node, Insets insets) {
        FlowPane.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)FlowPane.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node node) {
        FlowPane.setMargin(node, null);
    }

    public FlowPane() {
    }

    public FlowPane(Orientation orientation) {
        this();
        this.setOrientation(orientation);
    }

    public FlowPane(double d, double d2) {
        this();
        this.setHgap(d);
        this.setVgap(d2);
    }

    public FlowPane(Orientation orientation, double d, double d2) {
        this();
        this.setOrientation(orientation);
        this.setHgap(d);
        this.setVgap(d2);
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new ObjectPropertyBase((Object)Orientation.HORIZONTAL){

                @Override
                public void invalidated() {
                    FlowPane.this.requestLayout();
                    FlowPane.this.impl_cssPropertyInvalidated(StyleableProperties.ORIENTATION);
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set(orientation);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.HORIZONTAL : (Orientation)((Object)this.orientation.get());
    }

    public final DoubleProperty hgapProperty() {
        if (this.hgap == null) {
            this.hgap = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    FlowPane.this.requestLayout();
                    FlowPane.this.impl_cssPropertyInvalidated(StyleableProperties.HGAP);
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "hgap";
                }
            };
        }
        return this.hgap;
    }

    public final void setHgap(double d) {
        this.hgapProperty().set(d);
    }

    public final double getHgap() {
        return this.hgap == null ? 0.0 : this.hgap.get();
    }

    public final DoubleProperty vgapProperty() {
        if (this.vgap == null) {
            this.vgap = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    FlowPane.this.requestLayout();
                    FlowPane.this.impl_cssPropertyInvalidated(StyleableProperties.VGAP);
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "vgap";
                }
            };
        }
        return this.vgap;
    }

    public final void setVgap(double d) {
        this.vgapProperty().set(d);
    }

    public final double getVgap() {
        return this.vgap == null ? 0.0 : this.vgap.get();
    }

    public final DoubleProperty prefWrapLengthProperty() {
        if (this.prefWrapLength == null) {
            this.prefWrapLength = new DoublePropertyBase(400.0){

                @Override
                protected void invalidated() {
                    FlowPane.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "prefWrapLength";
                }
            };
        }
        return this.prefWrapLength;
    }

    public final void setPrefWrapLength(double d) {
        this.prefWrapLengthProperty().set(d);
    }

    public final double getPrefWrapLength() {
        return this.prefWrapLength == null ? 400.0 : this.prefWrapLength.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new ObjectPropertyBase<Pos>(Pos.TOP_LEFT){

                @Override
                public void invalidated() {
                    FlowPane.this.requestLayout();
                    FlowPane.this.impl_cssPropertyInvalidated(StyleableProperties.ALIGNMENT);
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.alignment.get());
    }

    public final ObjectProperty<HPos> columnHalignmentProperty() {
        if (this.columnHalignment == null) {
            this.columnHalignment = new ObjectPropertyBase<HPos>(HPos.LEFT){

                @Override
                public void invalidated() {
                    FlowPane.this.requestLayout();
                    FlowPane.this.impl_cssPropertyInvalidated(StyleableProperties.COLUMN_HALIGNMENT);
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "columnHalignment";
                }
            };
        }
        return this.columnHalignment;
    }

    public final void setColumnHalignment(HPos hPos) {
        this.columnHalignmentProperty().set(hPos);
    }

    public final HPos getColumnHalignment() {
        return this.columnHalignment == null ? HPos.LEFT : (HPos)((Object)this.columnHalignment.get());
    }

    public final ObjectProperty<VPos> rowValignmentProperty() {
        if (this.rowValignment == null) {
            this.rowValignment = new ObjectPropertyBase<VPos>(VPos.CENTER){

                @Override
                public void invalidated() {
                    FlowPane.this.requestLayout();
                    FlowPane.this.impl_cssPropertyInvalidated(StyleableProperties.ROW_VALIGNMENT);
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "rowValignment";
                }
            };
        }
        return this.rowValignment;
    }

    public final void setRowValignment(VPos vPos) {
        this.rowValignmentProperty().set(vPos);
    }

    public final VPos getRowValignment() {
        return this.rowValignment == null ? VPos.CENTER : (VPos)((Object)this.rowValignment.get());
    }

    @Override
    public Orientation getContentBias() {
        return this.getOrientation();
    }

    @Override
    protected double computeMinWidth(double d) {
        if (this.getContentBias() == Orientation.HORIZONTAL) {
            double d2 = 0.0;
            for (int i = 0; i < this.getChildren().size(); ++i) {
                Node node = (Node)this.getChildren().get(i);
                if (!node.isManaged()) continue;
                d2 = Math.max(d2, node.prefWidth(-1.0));
            }
            return this.getInsets().getLeft() + this.snapSize(d2) + this.getInsets().getRight();
        }
        return this.computePrefWidth(d);
    }

    @Override
    protected double computeMinHeight(double d) {
        if (this.getContentBias() == Orientation.VERTICAL) {
            double d2 = 0.0;
            for (int i = 0; i < this.getChildren().size(); ++i) {
                Node node = (Node)this.getChildren().get(i);
                if (!node.isManaged()) continue;
                d2 = Math.max(d2, node.prefHeight(-1.0));
            }
            return this.getInsets().getTop() + this.snapSize(d2) + this.getInsets().getBottom();
        }
        return this.computePrefHeight(d);
    }

    @Override
    protected double computePrefWidth(double d) {
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            return this.getInsets().getLeft() + this.snapSize(this.getPrefWrapLength()) + this.getInsets().getRight();
        }
        double d2 = d != -1.0 ? d : this.getPrefWrapLength();
        List<Run> list = this.getRuns(d2);
        return this.getInsets().getLeft() + this.computeContentWidth(list) + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            double d2 = d != -1.0 ? d : this.getPrefWrapLength();
            List<Run> list = this.getRuns(d2);
            return this.getInsets().getTop() + this.computeContentHeight(list) + this.getInsets().getBottom();
        }
        return this.getInsets().getTop() + this.snapSize(this.getPrefWrapLength()) + this.getInsets().getBottom();
    }

    @Override
    public void requestLayout() {
        if (!this.computingRuns) {
            this.runs = null;
        }
        super.requestLayout();
    }

    private List<Run> getRuns(double d) {
        if (this.runs == null || d != this.lastMaxRunLength) {
            this.computingRuns = true;
            this.lastMaxRunLength = d;
            this.runs = new ArrayList<Run>();
            double d2 = 0.0;
            double d3 = 0.0;
            Run run = new Run();
            double d4 = this.snapSpace(this.getVgap());
            double d5 = this.snapSpace(this.getHgap());
            for (int i = 0; i < this.getChildren().size(); ++i) {
                double d6;
                Node node = (Node)this.getChildren().get(i);
                if (!node.isManaged()) continue;
                LayoutRect layoutRect = new LayoutRect();
                layoutRect.node = node;
                Insets insets = FlowPane.getMargin(node);
                layoutRect.width = this.computeChildPrefAreaWidth(node, insets);
                layoutRect.height = this.computeChildPrefAreaHeight(node, insets);
                double d7 = d6 = this.getOrientation() == Orientation.HORIZONTAL ? layoutRect.width : layoutRect.height;
                if (d2 + d6 > d && d2 > 0.0) {
                    this.normalizeRun(run, d3);
                    d3 = this.getOrientation() == Orientation.HORIZONTAL ? (d3 += run.height + d4) : (d3 += run.width + d5);
                    this.runs.add(run);
                    d2 = 0.0;
                    run = new Run();
                }
                if (this.getOrientation() == Orientation.HORIZONTAL) {
                    layoutRect.x = d2;
                    d2 += layoutRect.width + d5;
                } else {
                    layoutRect.y = d2;
                    d2 += layoutRect.height + d4;
                }
                run.rects.add(layoutRect);
            }
            this.normalizeRun(run, d3);
            this.runs.add(run);
            this.computingRuns = false;
        }
        return this.runs;
    }

    private void normalizeRun(Run run, double d) {
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            run.width = (double)(run.rects.size() - 1) * this.snapSpace(this.getHgap());
            Insets[] insetsArray = new Insets[run.rects.size()];
            for (int i = 0; i < run.rects.size(); ++i) {
                LayoutRect layoutRect = run.rects.get(i);
                insetsArray[i] = FlowPane.getMargin(layoutRect.node);
                arrayList.add(layoutRect.node);
                run.width += layoutRect.width;
                layoutRect.y = d;
            }
            run.height = this.computeMaxPrefAreaHeight(arrayList, insetsArray, this.getRowValignment());
            run.baselineOffset = this.getRowValignment() == VPos.BASELINE ? FlowPane.getMaxAreaBaselineOffset(arrayList, insetsArray) : run.height;
        } else {
            run.height = (double)(run.rects.size() - 1) * this.snapSpace(this.getVgap());
            double d2 = 0.0;
            for (int i = 0; i < run.rects.size(); ++i) {
                LayoutRect layoutRect = run.rects.get(i);
                run.height += layoutRect.height;
                layoutRect.x = d;
                d2 = Math.max(d2, layoutRect.width);
            }
            run.width = d2;
            run.baselineOffset = run.height;
        }
    }

    private double computeContentWidth(List<Run> list) {
        double d = this.getOrientation() == Orientation.HORIZONTAL ? 0.0 : (double)(list.size() - 1) * this.snapSpace(this.getHgap());
        for (int i = 0; i < list.size(); ++i) {
            Run run = list.get(i);
            if (this.getOrientation() == Orientation.HORIZONTAL) {
                d = Math.max(d, run.width);
                continue;
            }
            d += run.width;
        }
        return d;
    }

    private double computeContentHeight(List<Run> list) {
        double d = this.getOrientation() == Orientation.VERTICAL ? 0.0 : (double)(list.size() - 1) * this.snapSpace(this.getVgap());
        for (int i = 0; i < list.size(); ++i) {
            Run run = list.get(i);
            if (this.getOrientation() == Orientation.VERTICAL) {
                d = Math.max(d, run.height);
                continue;
            }
            d += run.height;
        }
        return d;
    }

    @Override
    protected void layoutChildren() {
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = this.getInsets().getTop();
        double d4 = this.getInsets().getLeft();
        double d5 = this.getInsets().getBottom();
        double d6 = this.getInsets().getRight();
        double d7 = this.snapSpace(this.getVgap());
        double d8 = this.snapSpace(this.getHgap());
        double d9 = d - d4 - d6;
        double d10 = d2 - d3 - d5;
        List<Run> list = this.getRuns(this.getOrientation() == Orientation.HORIZONTAL ? d9 : d10);
        for (int i = 0; i < list.size(); ++i) {
            Run run = list.get(i);
            double d11 = d4 + FlowPane.computeXOffset(d9, this.getOrientation() == Orientation.HORIZONTAL ? run.width : this.computeContentWidth(list), this.getAlignment().getHpos());
            double d12 = d3 + FlowPane.computeYOffset(d10, this.getOrientation() == Orientation.VERTICAL ? run.height : this.computeContentHeight(list), this.getAlignment().getVpos());
            for (int j = 0; j < run.rects.size(); ++j) {
                LayoutRect layoutRect = run.rects.get(j);
                double d13 = d11 + layoutRect.x;
                double d14 = d12 + layoutRect.y;
                this.layoutInArea(layoutRect.node, d13, d14, Math.min(this.getOrientation() == Orientation.HORIZONTAL ? layoutRect.width : run.width, d4 + d9 - d13), Math.min(this.getOrientation() == Orientation.VERTICAL ? layoutRect.height : run.height, d3 + d10 - d14), run.baselineOffset, FlowPane.getMargin(layoutRect.node), true, this.getOrientation() == Orientation.VERTICAL || this.getRowValignment() != VPos.BASELINE, this.getColumnHalignment(), this.getRowValignment());
            }
        }
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-alignment".equals(string)) {
            this.setAlignment((Pos)((Object)object));
        } else if ("-fx-column-halignment".equals(string)) {
            this.setColumnHalignment((HPos)((Object)object));
        } else if ("-fx-hgap".equals(string)) {
            this.setHgap((Double)object);
        } else if ("-fx-row-valignment".equals(string)) {
            this.setRowValignment((VPos)((Object)object));
        } else if ("-fx-orientation".equals(string)) {
            this.setOrientation((Orientation)((Object)object));
        } else if ("-fx-vgap".equals(string)) {
            this.setVgap((Double)object);
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-alignment".equals(string)) {
            return this.alignment == null || !this.alignment.isBound();
        }
        if ("-fx-column-halignment".equals(string)) {
            return this.columnHalignment == null || !this.columnHalignment.isBound();
        }
        if ("-fx-hgap".equals(string)) {
            return this.hgap == null || !this.hgap.isBound();
        }
        if ("-fx-row-valignment".equals(string)) {
            return this.rowValignment == null || !this.rowValignment.isBound();
        }
        if ("-fx-orientation".equals(string)) {
            return this.orientation == null || !this.orientation.isBound();
        }
        if ("-fx-vgap".equals(string)) {
            return this.vgap == null || !this.vgap.isBound();
        }
        return super.impl_cssSettable(string);
    }

    private static class Run {
        ArrayList<LayoutRect> rects = new ArrayList();
        double width;
        double height;
        double baselineOffset;

        private Run() {
        }
    }

    private static class LayoutRect {
        public Node node;
        double x;
        double y;
        double width;
        double height;

        private LayoutRect() {
        }

        public String toString() {
            return "LayoutRect node id=" + this.node.getId() + " " + this.x + "," + this.y + " " + this.width + "x" + this.height;
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty ALIGNMENT = new StyleableProperty(FlowPane.class, "alignment");
        private static final StyleableProperty COLUMN_HALIGNMENT = new StyleableProperty(FlowPane.class, "columnHalignment");
        private static final StyleableProperty HGAP = new StyleableProperty(FlowPane.class, "hgap");
        private static final StyleableProperty ROW_VALIGNMENT = new StyleableProperty(FlowPane.class, "rowValignment");
        private static final StyleableProperty ORIENTATION = new StyleableProperty(FlowPane.class, "orientation");
        private static final StyleableProperty VGAP = new StyleableProperty(FlowPane.class, "vgap");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Region.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, ALIGNMENT, COLUMN_HALIGNMENT, HGAP, ROW_VALIGNMENT, ORIENTATION, VGAP);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

