/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class AnchorPane
extends Pane {
    private static final String TOP_ANCHOR = "pane-top-anchor";
    private static final String LEFT_ANCHOR = "pane-left-anchor";
    private static final String BOTTOM_ANCHOR = "pane-bottom-anchor";
    private static final String RIGHT_ANCHOR = "pane-right-anchor";

    public static void setTopAnchor(Node node, Double d) {
        AnchorPane.setConstraint(node, TOP_ANCHOR, d);
    }

    public static Double getTopAnchor(Node node) {
        return (Double)AnchorPane.getConstraint(node, TOP_ANCHOR);
    }

    public static void setLeftAnchor(Node node, Double d) {
        AnchorPane.setConstraint(node, LEFT_ANCHOR, d);
    }

    public static Double getLeftAnchor(Node node) {
        return (Double)AnchorPane.getConstraint(node, LEFT_ANCHOR);
    }

    public static void setBottomAnchor(Node node, Double d) {
        AnchorPane.setConstraint(node, BOTTOM_ANCHOR, d);
    }

    public static Double getBottomAnchor(Node node) {
        return (Double)AnchorPane.getConstraint(node, BOTTOM_ANCHOR);
    }

    public static void setRightAnchor(Node node, Double d) {
        AnchorPane.setConstraint(node, RIGHT_ANCHOR, d);
    }

    public static Double getRightAnchor(Node node) {
        return (Double)AnchorPane.getConstraint(node, RIGHT_ANCHOR);
    }

    public static void clearConstraints(Node node) {
        AnchorPane.setTopAnchor(node, null);
        AnchorPane.setRightAnchor(node, null);
        AnchorPane.setBottomAnchor(node, null);
        AnchorPane.setLeftAnchor(node, null);
    }

    @Override
    protected double computeMinWidth(double d) {
        return this.computeWidth(true);
    }

    @Override
    protected double computeMinHeight(double d) {
        return this.computeHeight(true);
    }

    @Override
    protected double computePrefWidth(double d) {
        return this.computeWidth(false);
    }

    @Override
    protected double computePrefHeight(double d) {
        return this.computeHeight(false);
    }

    private double computeWidth(boolean bl) {
        double d = 0.0;
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Node node = (Node)this.getChildren().get(i);
            if (!node.isManaged()) continue;
            Double d2 = AnchorPane.getLeftAnchor(node);
            Double d3 = AnchorPane.getRightAnchor(node);
            double d4 = d2 != null ? d2 : (d3 != null ? 0.0 : node.getLayoutBounds().getMinX() + node.getLayoutX());
            double d5 = d3 != null ? d3 : 0.0;
            d = Math.max(d, d4 + (bl ? node.minWidth(-1.0) : node.prefWidth(-1.0)) + d5);
        }
        return this.getInsets().getLeft() + d + this.getInsets().getRight();
    }

    private double computeHeight(boolean bl) {
        double d = 0.0;
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Node node = (Node)this.getChildren().get(i);
            if (!node.isManaged()) continue;
            Double d2 = AnchorPane.getTopAnchor(node);
            Double d3 = AnchorPane.getBottomAnchor(node);
            double d4 = d2 != null ? d2 : (d3 != null ? 0.0 : node.getLayoutBounds().getMinY() + node.getLayoutY());
            double d5 = d3 != null ? d3 : 0.0;
            d = Math.max(d, d4 + (bl ? node.minHeight(-1.0) : node.prefHeight(-1.0)) + d5);
        }
        return this.getInsets().getTop() + d + this.getInsets().getBottom();
    }

    private double computeChildWidth(Node node, Double d, Double d2, double d3) {
        if (d != null && d2 != null && node.isResizable()) {
            return this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight() - d - d2;
        }
        return node.prefWidth(d3);
    }

    private double computeChildHeight(Node node, Double d, Double d2, double d3) {
        if (d != null && d2 != null && node.isResizable()) {
            return this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom() - d - d2;
        }
        return node.prefHeight(d3);
    }

    @Override
    protected void layoutChildren() {
        Insets insets = this.getInsets();
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Node node = (Node)this.getChildren().get(i);
            if (!node.isManaged()) continue;
            Double d = AnchorPane.getTopAnchor(node);
            Double d2 = AnchorPane.getBottomAnchor(node);
            Double d3 = AnchorPane.getLeftAnchor(node);
            Double d4 = AnchorPane.getRightAnchor(node);
            double d5 = node.getLayoutX() + node.getLayoutBounds().getMinX();
            double d6 = node.getLayoutY() + node.getLayoutBounds().getMinY();
            double d7 = -1.0;
            double d8 = -1.0;
            Orientation orientation = node.getContentBias();
            if (orientation == Orientation.VERTICAL) {
                d8 = this.computeChildHeight(node, d, d2, -1.0);
                d7 = this.computeChildWidth(node, d3, d4, d8);
            } else if (orientation == Orientation.HORIZONTAL) {
                d7 = this.computeChildWidth(node, d3, d4, -1.0);
                d8 = this.computeChildHeight(node, d, d2, d7);
            } else {
                d7 = this.computeChildWidth(node, d3, d4, -1.0);
                d8 = this.computeChildHeight(node, d, d2, -1.0);
            }
            if (d3 != null) {
                d5 = insets.getLeft() + d3;
            } else if (d4 != null) {
                d5 = this.getWidth() - insets.getRight() - d4 - d7;
            }
            if (d != null) {
                d6 = insets.getTop() + d;
            } else if (d2 != null) {
                d6 = this.getHeight() - insets.getBottom() - d2 - d8;
            }
            node.resizeRelocate(d5, d6, d7, d8);
        }
    }
}

