/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class SplitPane
extends Control {
    @Styleable(property="-fx-orientation", initial="horizontal")
    private ObjectProperty<Orientation> orientation;
    private final ObservableList<Node> items = FXCollections.observableArrayList();
    private final ObservableList<Divider> dividers = FXCollections.observableArrayList();
    private final ObservableList<Divider> unmodifiableDividers = FXCollections.unmodifiableObservableList(this.dividers);
    private final WeakHashMap<Integer, Double> dividerCache = new WeakHashMap();
    private static final String DEFAULT_STYLE_CLASS = "split-pane";
    private static final String PSEUDO_CLASS_HORIZONTAL = "horizontal";
    private static final String PSEUDO_CLASS_VERTICAL = "vertical";
    private static final long VERTICAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("vertical");
    private static final long HORIZONTAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("horizontal");

    public SplitPane() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setFocusTraversable(false);
        this.items.addListener(new ListChangeListener<Node>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Node> change) {
                int n;
                while (change.next()) {
                    int n2;
                    int n3 = n = change.getFrom();
                    for (n2 = 0; n2 < change.getRemovedSize(); ++n2) {
                        if (n3 < SplitPane.this.dividers.size()) {
                            SplitPane.this.dividerCache.put(n3, Double.MAX_VALUE);
                        } else if (n3 == SplitPane.this.dividers.size() && !SplitPane.this.dividers.isEmpty()) {
                            if (change.wasReplaced()) {
                                SplitPane.this.dividerCache.put(n3 - 1, ((Divider)SplitPane.this.dividers.get(n3 - 1)).getPosition());
                            } else {
                                SplitPane.this.dividerCache.put(n3 - 1, Double.MAX_VALUE);
                            }
                        }
                        ++n3;
                    }
                    for (n2 = 0; n2 < SplitPane.this.dividers.size(); ++n2) {
                        if (SplitPane.this.dividerCache.get(n2) != null) continue;
                        SplitPane.this.dividerCache.put(n2, ((Divider)SplitPane.this.dividers.get(n2)).getPosition());
                    }
                }
                SplitPane.this.dividers.clear();
                for (n = 0; n < SplitPane.this.items.size() - 1; ++n) {
                    if (SplitPane.this.dividerCache.containsKey(n) && (Double)SplitPane.this.dividerCache.get(n) != Double.MAX_VALUE) {
                        Divider divider = new Divider();
                        divider.setPosition((Double)SplitPane.this.dividerCache.get(n));
                        SplitPane.this.dividers.add(divider);
                    } else {
                        SplitPane.this.dividers.add(new Divider());
                    }
                    SplitPane.this.dividerCache.remove(n);
                }
            }
        });
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set(orientation);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.HORIZONTAL : (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new ObjectPropertyBase<Orientation>(Orientation.HORIZONTAL){

                @Override
                public void invalidated() {
                    SplitPane.this.impl_cssPropertyInvalidated(StyleableProperties.ORIENTATION);
                    SplitPane.this.impl_pseudoClassStateChanged(SplitPane.PSEUDO_CLASS_VERTICAL);
                    SplitPane.this.impl_pseudoClassStateChanged(SplitPane.PSEUDO_CLASS_HORIZONTAL);
                }

                @Override
                public Object getBean() {
                    return SplitPane.this;
                }

                @Override
                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public ObservableList<Node> getItems() {
        return this.items;
    }

    public ObservableList<Divider> getDividers() {
        return this.unmodifiableDividers;
    }

    public void setDividerPosition(int n, double d) {
        if (this.getDividers().size() <= n) {
            this.dividerCache.put(n, d);
            return;
        }
        if (n >= 0) {
            ((Divider)this.getDividers().get(n)).setPosition(d);
        }
    }

    public void setDividerPositions(double ... dArray) {
        if (this.dividers.isEmpty()) {
            for (int i = 0; i < dArray.length; ++i) {
                this.dividerCache.put(i, dArray[i]);
            }
            return;
        }
        for (int i = 0; i < dArray.length && i < this.dividers.size(); ++i) {
            ((Divider)this.dividers.get(i)).setPosition(dArray[i]);
        }
    }

    public double[] getDividerPositions() {
        double[] dArray = new double[this.dividers.size()];
        for (int i = 0; i < this.dividers.size(); ++i) {
            dArray[i] = ((Divider)this.dividers.get(i)).getPosition();
        }
        return dArray;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-orientation".equals(string)) {
            this.setOrientation((Orientation)((Object)object));
        }
        return super.impl_cssSet(string, object);
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-orientation".equals(string)) {
            return this.orientation == null || !this.orientation.isBound();
        }
        return super.impl_cssSettable(string);
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        return l |= this.getOrientation() == Orientation.VERTICAL ? VERTICAL_PSEUDOCLASS_STATE : HORIZONTAL_PSEUDOCLASS_STATE;
    }

    public static class Divider {
        private DoubleProperty position;

        public final void setPosition(double d) {
            this.positionProperty().set(d);
        }

        public final double getPosition() {
            return this.position == null ? 0.5 : this.position.get();
        }

        public final DoubleProperty positionProperty() {
            if (this.position == null) {
                this.position = new SimpleDoubleProperty(this, "position", 0.5);
            }
            return this.position;
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty ORIENTATION = new StyleableProperty(SplitPane.class, "orientation");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, ORIENTATION);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

