/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.control.Logging;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.stage.PopupWindow;

public class PopupControl
extends PopupWindow
implements Skinnable {
    public static final double USE_PREF_SIZE = Double.NEGATIVE_INFINITY;
    public static final double USE_COMPUTED_SIZE = -1.0;
    private final CSSBridge bridge;
    private String currentSkinClass;
    private final StringProperty id = new SimpleStringProperty(this, "id");
    private final ObservableList<String> styleClass = new TrackableObservableList<String>(){

        @Override
        protected void onChanged(ListChangeListener.Change<String> change) {
            PopupControl.this.bridge.getStyleClass().setAll(PopupControl.this.styleClass);
        }

        @Override
        public String toString() {
            if (this.size() == 0) {
                return "";
            }
            if (this.size() == 1) {
                return (String)this.get(0);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                stringBuilder.append((String)this.get(i));
                if (i + 1 >= this.size()) continue;
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
    };
    private final StringProperty style = new SimpleStringProperty(this, "style");
    @Styleable(property="-fx-skin", converter="com.sun.javafx.css.converters.StringConverter")
    private ObjectProperty<Skin<?>> skin = new ObjectPropertyBase<Skin<?>>(){
        private Skin<?> oldValue;

        @Override
        protected void invalidated() {
            Skin skin;
            PopupControl.this.impl_cssPropertyInvalidated(StyleableProperties.SKIN);
            if (this.oldValue != null) {
                this.oldValue.dispose();
            }
            PopupControl.this.currentSkinClass = (skin = (this.oldValue = (Skin)this.getValue())) == null ? null : skin.getClass().getName();
            PopupControl.this.updateChildren();
            PlatformLogger platformLogger = Logging.getControlsLogger();
            if (platformLogger.isLoggable(300)) {
                platformLogger.finest("Stored skin[" + this.getValue() + "] on " + this);
            }
        }

        @Override
        public Object getBean() {
            return PopupControl.this;
        }

        @Override
        public String getName() {
            return "skin";
        }
    };
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty prefWidth;
    private DoubleProperty prefHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;

    public PopupControl() {
        this.bridge = new CSSBridge();
        this.bridge.idProperty().bind(this.idProperty());
        this.bridge.styleProperty().bind(this.styleProperty());
        this.getContent().add(this.bridge);
    }

    public final void setId(String string) {
        this.id.set(string);
    }

    public final String getId() {
        return (String)this.id.get();
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    public final void setStyle(String string) {
        this.style.set(string);
    }

    public final String getStyle() {
        return (String)this.style.get();
    }

    public final StringProperty styleProperty() {
        return this.style;
    }

    @Override
    public final ObjectProperty<Skin<?>> skinProperty() {
        return this.skin;
    }

    @Override
    public final void setSkin(Skin<?> skin) {
        this.skinProperty().setValue(skin);
    }

    @Override
    public final Skin<?> getSkin() {
        if (this.getScene() != null && this.getScene().getRoot() != null) {
            this.getScene().getRoot().impl_processCSS(true);
        }
        return (Skin)this.skinProperty().getValue();
    }

    private Node getSkinNode() {
        return this.getSkin() == null ? null : this.getSkin().getNode();
    }

    public final void setMinWidth(double d) {
        this.minWidthProperty().set(d);
    }

    public final double getMinWidth() {
        return this.minWidth == null ? -1.0 : this.minWidth.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "minWidth";
                }
            };
        }
        return this.minWidth;
    }

    public final void setMinHeight(double d) {
        this.minHeightProperty().set(d);
    }

    public final double getMinHeight() {
        return this.minHeight == null ? -1.0 : this.minHeight.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "minHeight";
                }
            };
        }
        return this.minHeight;
    }

    public void setMinSize(double d, double d2) {
        this.setMinWidth(d);
        this.setMinHeight(d2);
    }

    public final void setPrefWidth(double d) {
        this.prefWidthProperty().set(d);
    }

    public final double getPrefWidth() {
        return this.prefWidth == null ? -1.0 : this.prefWidth.get();
    }

    public final DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "prefWidth";
                }
            };
        }
        return this.prefWidth;
    }

    public final void setPrefHeight(double d) {
        this.prefHeightProperty().set(d);
    }

    public final double getPrefHeight() {
        return this.prefHeight == null ? -1.0 : this.prefHeight.get();
    }

    public final DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "prefHeight";
                }
            };
        }
        return this.prefHeight;
    }

    public void setPrefSize(double d, double d2) {
        this.setPrefWidth(d);
        this.setPrefHeight(d2);
    }

    public final void setMaxWidth(double d) {
        this.maxWidthProperty().set(d);
    }

    public final double getMaxWidth() {
        return this.maxWidth == null ? -1.0 : this.maxWidth.get();
    }

    public final DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "maxWidth";
                }
            };
        }
        return this.maxWidth;
    }

    public final void setMaxHeight(double d) {
        this.maxHeightProperty().set(d);
    }

    public final double getMaxHeight() {
        return this.maxHeight == null ? -1.0 : this.maxHeight.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "maxHeight";
                }
            };
        }
        return this.maxHeight;
    }

    public void setMaxSize(double d, double d2) {
        this.setMaxWidth(d);
        this.setMaxHeight(d2);
    }

    public final double minWidth(double d) {
        double d2 = this.getMinWidth();
        if (d2 == -1.0) {
            return this.recalculateMinWidth(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    public final double minHeight(double d) {
        double d2 = this.getMinHeight();
        if (d2 == -1.0) {
            return this.recalculateMinHeight(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    public final double prefWidth(double d) {
        double d2 = this.getPrefWidth();
        if (d2 == -1.0) {
            return this.recalculatePrefWidth(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    public final double prefHeight(double d) {
        double d2 = this.getPrefHeight();
        if (d2 == -1.0) {
            return this.recalculatePrefHeight(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    public final double maxWidth(double d) {
        double d2 = this.getMaxWidth();
        if (d2 == -1.0) {
            return this.recalculateMaxWidth(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d);
        }
        return d2;
    }

    public final double maxHeight(double d) {
        double d2 = this.getMaxHeight();
        if (d2 == -1.0) {
            return this.recalculateMaxHeight(d);
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d);
        }
        return d2;
    }

    private double recalculateMinWidth(double d) {
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().minWidth(d);
    }

    private double recalculateMinHeight(double d) {
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().minHeight(d);
    }

    private double recalculateMaxWidth(double d) {
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().maxWidth(d);
    }

    private double recalculateMaxHeight(double d) {
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().maxHeight(d);
    }

    private double recalculatePrefWidth(double d) {
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().prefWidth(d);
    }

    private double recalculatePrefHeight(double d) {
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().prefHeight(d);
    }

    private void updateChildren() {
        Node node = this.getSkinNode();
        if (node != null) {
            this.bridge.getChildren().setAll((Node[])new Node[]{node});
        } else {
            this.bridge.getChildren().clear();
        }
    }

    private void loadSkinClass(String string) {
        if (this.currentSkinClass != null && this.currentSkinClass.equals(string)) {
            return;
        }
        if (string == null || string.isEmpty()) {
            Logging.getControlsLogger().severe("Empty -fx-skin property specified for popup control " + this);
            return;
        }
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (Thread.currentThread().getContextClassLoader() != null) {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                }
                throw classNotFoundException;
            }
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor<?> constructor = null;
            for (Constructor<?> constructor2 : constructorArray) {
                Class<?>[] classArray = constructor2.getParameterTypes();
                if (classArray.length != 1 || !PopupControl.class.isAssignableFrom(classArray[0])) continue;
                constructor = constructor2;
                break;
            }
            if (constructor == null) {
                NullPointerException nullPointerException = new NullPointerException();
                Logging.getControlsLogger().severe("No valid constructor defined in '" + string + "' for popup control " + this + ".\r\nYou must provide a constructor that accepts a single " + "PopupControl parameter in " + string + ".", nullPointerException);
                throw nullPointerException;
            }
            Skin skin = (Skin)constructor.newInstance(this);
            this.setSkin(skin);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logging.getControlsLogger().severe("Failed to load skin '" + string + "' for popup control " + this, invocationTargetException.getCause());
        }
        catch (Exception exception) {
            Logging.getControlsLogger().severe("Failed to load skin '" + string + "' for popup control " + this, exception);
        }
    }

    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-skin".equals(string)) {
            this.loadSkinClass((String)object);
        }
        return true;
    }

    @Deprecated
    protected boolean impl_cssSettable(String string) {
        return "-fx-skin".equals(string) && !this.skinProperty().isBound();
    }

    @Deprecated
    protected void impl_pseudoClassStateChanged(String string) {
        this.bridge.impl_pseudoClassStateChanged(string);
    }

    @Deprecated
    protected void impl_cssPropertyInvalidated(StyleableProperty styleableProperty) {
        this.bridge.impl_cssPropertyInvalidated1(styleableProperty);
    }

    private final class CSSBridge
    extends Group {
        private CSSBridge() {
        }

        @Override
        public void impl_pseudoClassStateChanged(String string) {
            super.impl_pseudoClassStateChanged(string);
        }

        @Override
        protected int[] impl_cssStyleablePropertyBitIndices() {
            return PopupControl.this.impl_cssStyleablePropertyBitIndices();
        }

        @Override
        public Class impl_getClassToStyle() {
            return PopupControl.this.getClass();
        }

        @Override
        protected boolean impl_cssSet(String string, Object object) {
            return PopupControl.this.impl_cssSet(string, object);
        }

        @Override
        public boolean impl_cssSettable(String string) {
            return PopupControl.this.impl_cssSettable(string);
        }

        private void impl_cssPropertyInvalidated1(StyleableProperty styleableProperty) {
            super.impl_cssPropertyInvalidated(styleableProperty);
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty SKIN = new StyleableProperty(PopupControl.class, "skin");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList();
            Collections.addAll(arrayList, SKIN);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

