/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.TitledPane;

public class Accordion
extends Control {
    private final ObservableList<TitledPane> panes = new TrackableObservableList<TitledPane>(){

        @Override
        protected void onChanged(ListChangeListener.Change<TitledPane> change) {
            block0: while (change.next()) {
                if (!change.wasRemoved() || Accordion.this.expandedPane.isBound()) continue;
                for (TitledPane titledPane : change.getRemoved()) {
                    if (change.getAddedSubList().contains(titledPane) || Accordion.this.getExpandedPane() != titledPane) continue;
                    Accordion.this.setExpandedPane(null);
                    continue block0;
                }
            }
        }
    };
    private ObjectProperty<TitledPane> expandedPane = new SimpleObjectProperty<TitledPane>(this, "expandedPane");
    private static final String DEFAULT_STYLE_CLASS = "accordion";

    public Accordion() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setFocusTraversable(false);
    }

    public final void setExpandedPane(TitledPane titledPane) {
        this.expandedPaneProperty().set(titledPane);
    }

    public final TitledPane getExpandedPane() {
        return (TitledPane)this.expandedPane.get();
    }

    public final ObjectProperty<TitledPane> expandedPaneProperty() {
        return this.expandedPane;
    }

    public final ObservableList<TitledPane> getPanes() {
        return this.panes;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, new Object[0]);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

