/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.ChartLayoutAnimator;
import com.sun.javafx.charts.Legend;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public abstract class Chart
extends Region {
    private final Label titleLabel = new Label();
    private final Pane chartContent = new Pane(){

        @Override
        protected void layoutChildren() {
            double d = this.getInsets().getTop();
            double d2 = this.getInsets().getLeft();
            double d3 = this.getInsets().getBottom();
            double d4 = this.getInsets().getRight();
            double d5 = this.getWidth();
            double d6 = this.getHeight();
            double d7 = this.snapSize(d5 - (d2 + d4));
            double d8 = this.snapSize(d6 - (d + d3));
            Chart.this.layoutChartChildren(this.snapPosition(d), this.snapPosition(d2), d7, d8);
        }
    };
    private final ChartLayoutAnimator animator = new ChartLayoutAnimator(this.chartContent);
    private StringProperty title = new StringPropertyBase(){

        @Override
        protected void invalidated() {
            Chart.this.titleLabel.setText(this.get());
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "title";
        }
    };
    @Styleable(property="-fx-title-side", initial="top")
    private ObjectProperty<Side> titleSide = new ObjectPropertyBase<Side>(Side.TOP){

        @Override
        protected void invalidated() {
            Chart.this.requestLayout();
            Chart.this.impl_cssPropertyInvalidated(StyleableProperties.TITLE_SIDE);
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "titleSide";
        }
    };
    private final ObjectProperty<Node> legend = new ObjectPropertyBase<Node>(){
        private Node old = null;

        @Override
        protected void invalidated() {
            Node node = (Node)this.get();
            if (this.old != null) {
                Chart.this.getChildren().remove(this.old);
            }
            if (node != null) {
                Chart.this.getChildren().add(node);
                node.setVisible(Chart.this.isLegendVisible());
            }
            this.old = node;
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "legend";
        }
    };
    @Styleable(property="-fx-legend-visible", initial="true")
    private final BooleanProperty legendVisible = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            boolean bl = this.get();
            Node node = Chart.this.getLegend();
            if (node != null) {
                node.setVisible(bl);
                Chart.this.requestLayout();
            }
            Chart.this.impl_cssPropertyInvalidated(StyleableProperties.LEGEND_VISIBLE);
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "legendVisible";
        }
    };
    @Styleable(property="-fx-legend-side", initial="bottom")
    private ObjectProperty<Side> legendSide = new ObjectPropertyBase<Side>(Side.BOTTOM){

        @Override
        protected void invalidated() {
            Side side = (Side)((Object)this.get());
            Node node = Chart.this.getLegend();
            if (node instanceof Legend) {
                ((Legend)node).setVertical(Side.LEFT.equals((Object)side) || Side.RIGHT.equals((Object)side));
            }
            Chart.this.requestLayout();
            Chart.this.impl_cssPropertyInvalidated(StyleableProperties.LEGEND_SIDE);
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "legendSide";
        }
    };
    private BooleanProperty animated = new SimpleBooleanProperty(this, "animated", true);

    public final String getTitle() {
        return (String)this.title.get();
    }

    public final void setTitle(String string) {
        this.title.set(string);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final Side getTitleSide() {
        return (Side)((Object)this.titleSide.get());
    }

    public final void setTitleSide(Side side) {
        this.titleSide.set(side);
    }

    public final ObjectProperty<Side> titleSideProperty() {
        return this.titleSide;
    }

    protected final Node getLegend() {
        return (Node)this.legend.getValue();
    }

    protected final void setLegend(Node node) {
        this.legend.setValue(node);
    }

    protected final ObjectProperty<Node> legendProperty() {
        return this.legend;
    }

    public final boolean isLegendVisible() {
        return this.legendVisible.getValue();
    }

    public final void setLegendVisible(boolean bl) {
        this.legendVisible.setValue(bl);
    }

    public final BooleanProperty legendVisibleProperty() {
        return this.legendVisible;
    }

    public final Side getLegendSide() {
        return (Side)((Object)this.legendSide.get());
    }

    public final void setLegendSide(Side side) {
        this.legendSide.set(side);
    }

    public final ObjectProperty<Side> legendSideProperty() {
        return this.legendSide;
    }

    public final boolean getAnimated() {
        return this.animated.get();
    }

    public final void setAnimated(boolean bl) {
        this.animated.set(bl);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    protected ObservableList<Node> getChartChildren() {
        return this.chartContent.getChildren();
    }

    public Chart() {
        this.titleLabel.setAlignment(Pos.CENTER);
        this.getChildren().addAll((Node[])new Node[]{this.titleLabel, this.chartContent});
        this.getStyleClass().add("chart");
        this.titleLabel.getStyleClass().add("chart-title");
        this.chartContent.getStyleClass().add("chart-content");
        this.chartContent.setManaged(false);
    }

    void animate(KeyFrame ... keyFrameArray) {
        this.animator.animate(keyFrameArray);
    }

    protected void animate(Animation animation) {
        this.animator.animate(animation);
    }

    protected void requestChartLayout() {
        this.chartContent.requestLayout();
    }

    protected final boolean shouldAnimate() {
        return this.getAnimated() && this.impl_isTreeVisible() && this.getScene() != null;
    }

    protected abstract void layoutChartChildren(double var1, double var3, double var5, double var7);

    @Override
    protected void layoutChildren() {
        double d = this.getInsets().getTop();
        double d2 = this.getInsets().getLeft();
        double d3 = this.getInsets().getBottom();
        double d4 = this.getInsets().getRight();
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        if (this.getTitle() != null) {
            double d7;
            this.titleLabel.setVisible(true);
            if (this.getTitleSide().equals((Object)Side.TOP)) {
                d7 = this.snapSize(this.titleLabel.prefHeight(d5 - d2 - d4));
                this.titleLabel.resizeRelocate(d2, d, d5 - d2 - d4, d7);
                d += d7;
            } else if (this.getTitleSide().equals((Object)Side.BOTTOM)) {
                d7 = this.snapSize(this.titleLabel.prefHeight(d5 - d2 - d4));
                this.titleLabel.resizeRelocate(d2, d6 - d3 - d7, d5 - d2 - d4, d7);
                d3 += d7;
            } else if (this.getTitleSide().equals((Object)Side.LEFT)) {
                d7 = this.snapSize(this.titleLabel.prefWidth(d6 - d - d3));
                this.titleLabel.resizeRelocate(d2, d, d7, d6 - d - d3);
                d2 += d7;
            } else if (this.getTitleSide().equals((Object)Side.RIGHT)) {
                d7 = this.snapSize(this.titleLabel.prefWidth(d6 - d - d3));
                this.titleLabel.resizeRelocate(d5 - d4 - d7, d, d7, d6 - d - d3);
                d4 += d7;
            }
        } else {
            this.titleLabel.setVisible(false);
        }
        Node node = this.getLegend();
        if (node != null && this.isLegendVisible()) {
            if (this.getLegendSide().equals((Object)Side.TOP)) {
                double d8 = this.snapSize(node.prefHeight(d5 - d2 - d4));
                double d9 = this.snapSize(node.prefWidth(-1.0));
                node.resizeRelocate(d2 + (d5 - d2 - d4 - d9) / 2.0, d, d9, d8);
                d += d8;
            } else if (this.getLegendSide().equals((Object)Side.BOTTOM)) {
                double d10 = this.snapSize(node.prefHeight(d5 - d2 - d4));
                double d11 = this.snapSize(node.prefWidth(-1.0));
                node.resizeRelocate(d2 + (d5 - d2 - d4 - d11) / 2.0, d6 - d3 - d10, d11, d10);
                d3 += d10;
            } else if (this.getLegendSide().equals((Object)Side.LEFT)) {
                double d12 = this.snapSize(node.prefWidth(d6 - d - d3));
                double d13 = this.snapSize(node.prefHeight(-1.0));
                node.resizeRelocate(d2, d + (d6 - d - d3 - d13) / 2.0, d12, d13);
                d2 += d12;
            } else if (this.getLegendSide().equals((Object)Side.RIGHT)) {
                double d14 = this.snapSize(node.prefWidth(d6 - d - d3));
                double d15 = this.snapSize(node.prefHeight(-1.0));
                node.resizeRelocate(d5 - d4 - d14, d + (d6 - d - d3 - d15) / 2.0, d14, d15);
                d4 += d14;
            }
        }
        this.chartContent.resizeRelocate(d2, d, d5 - d2 - d4, d6 - d - d3);
    }

    @Override
    protected double computeMinHeight(double d) {
        return 150.0;
    }

    @Override
    protected double computeMinWidth(double d) {
        return 200.0;
    }

    @Override
    protected double computePrefWidth(double d) {
        return 500.0;
    }

    @Override
    protected double computePrefHeight(double d) {
        return 400.0;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-legend-side".equals(string)) {
            this.setLegendSide((Side)((Object)object));
        } else if ("-fx-legend-visible".equals(string)) {
            this.setLegendVisible((Boolean)object);
        } else if ("-fx-title-side".equals(string)) {
            this.setTitleSide((Side)((Object)object));
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-title-side".equals(string)) {
            return this.titleSide == null || !this.titleSide.isBound();
        }
        if ("-fx-legend-visible".equals(string)) {
            return this.legendVisible == null || !this.legendVisible.isBound();
        }
        if ("-fx-legend-side".equals(string)) {
            return this.legendSide == null || !this.legendSide.isBound();
        }
        return super.impl_cssSettable(string);
    }

    private static class StyleableProperties {
        private static final StyleableProperty TITLE_SIDE = new StyleableProperty(Chart.class, "titleSide");
        private static final StyleableProperty LEGEND_SIDE = new StyleableProperty(Chart.class, "legendSide");
        private static final StyleableProperty LEGEND_VISIBLE = new StyleableProperty(Chart.class, "legendVisible");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Region.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, TITLE_SIDE, LEGEND_VISIBLE, LEGEND_SIDE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

