/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.Duration;

public abstract class Axis<T>
extends Region {
    private Text measure = new Text();
    private Label axisLabel = new Label();
    private final Path tickMarkPath = new Path();
    private double oldLength = 0.0;
    private boolean rangeValid = false;
    double maxWidth = 0.0;
    double maxHeight = 0.0;
    private final ObservableList<TickMark<T>> tickMarks = FXCollections.observableArrayList();
    private final ObservableList<TickMark<T>> unmodifiableTickMarks = FXCollections.unmodifiableObservableList(this.tickMarks);
    @Styleable(property="-fx-side")
    private ObjectProperty<Side> side = new ObjectPropertyBase<Side>(){

        @Override
        protected void invalidated() {
            Axis.this.impl_cssPropertyInvalidated(StyleableProperties.SIDE);
            Axis.this.impl_pseudoClassStateChanged(Axis.PSEUDO_CLASS_TOP);
            Axis.this.impl_pseudoClassStateChanged(Axis.PSEUDO_CLASS_RIGHT);
            Axis.this.impl_pseudoClassStateChanged(Axis.PSEUDO_CLASS_BOTTOM);
            Axis.this.impl_pseudoClassStateChanged(Axis.PSEUDO_CLASS_LEFT);
            Axis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "side";
        }
    };
    private ObjectProperty<String> label = new ObjectPropertyBase<String>(){

        @Override
        protected void invalidated() {
            Axis.this.axisLabel.setText((String)this.get());
            Axis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "label";
        }
    };
    @Styleable(property="-fx-tick-mark-visible", initial="true")
    private BooleanProperty tickMarkVisible = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            Axis.this.tickMarkPath.setVisible(this.get());
            Axis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickMarkVisible";
        }
    };
    @Styleable(property="-fx-tick-labels-visible", initial="true")
    private BooleanProperty tickLabelsVisible = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            for (TickMark tickMark : Axis.this.tickMarks) {
                tickMark.setTextVisible(this.get());
            }
            Axis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickLabelsVisible";
        }
    };
    @Styleable(property="-fx-tick-length", initial="8")
    private DoubleProperty tickLength = new DoublePropertyBase(8.0){

        @Override
        protected void invalidated() {
            Axis.this.impl_cssPropertyInvalidated(StyleableProperties.TICK_MARK_LENGTH);
            Axis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickLength";
        }
    };
    private BooleanProperty autoRanging = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            if (this.get()) {
                Axis.this.requestAxisLayout();
            }
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "autoRanging";
        }
    };
    @Styleable(property="-fx-tick-label-font", initial="8 System", inherits=true)
    private ObjectProperty<Font> tickLabelFont = new ObjectPropertyBase<Font>(Font.font("System", 8.0)){

        @Override
        protected void invalidated() {
            Axis.this.impl_cssPropertyInvalidated(StyleableProperties.TICK_LABEL_FONT);
            Font font = (Font)this.get();
            Axis.this.measure.setFont(font);
            for (TickMark tickMark : Axis.this.tickMarks) {
                tickMark.textNode.setFont(font);
            }
            Axis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickLabelFont";
        }
    };
    @Styleable(property="-fx-tick-label-fill", initial="black")
    private ObjectProperty<Paint> tickLabelFill = new ObjectPropertyBase<Paint>((Paint)Color.BLACK){

        @Override
        protected void invalidated() {
            Axis.this.impl_cssPropertyInvalidated(StyleableProperties.TICK_LABEL_FILL);
            Paint paint = (Paint)this.get();
            for (TickMark tickMark : Axis.this.tickMarks) {
                tickMark.textNode.setFill(paint);
            }
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickLabelFill";
        }
    };
    @Styleable(property="-fx-tick-label-gap", initial="5")
    private DoubleProperty tickLabelGap = new DoublePropertyBase(3.0){

        @Override
        protected void invalidated() {
            Axis.this.impl_cssPropertyInvalidated(StyleableProperties.TICK_LABEL_TICK_GAP);
            Axis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickLabelGap";
        }
    };
    private BooleanProperty animated = new SimpleBooleanProperty(this, "animated", true);
    private DoubleProperty tickLabelRotation = new DoublePropertyBase(0.0){

        @Override
        protected void invalidated() {
            Axis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickLabelRotation";
        }
    };
    private static final String PSEUDO_CLASS_TOP = "top";
    private static final String PSEUDO_CLASS_RIGHT = "right";
    private static final String PSEUDO_CLASS_BOTTOM = "bottom";
    private static final String PSEUDO_CLASS_LEFT = "left";
    private static final long TOP_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("top");
    private static final long BOTTOM_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("bottom");
    private static final long LEFT_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("left");
    private static final long RIGHT_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("right");

    public ObservableList<TickMark<T>> getTickMarks() {
        return this.unmodifiableTickMarks;
    }

    public final Side getSide() {
        return (Side)((Object)this.side.get());
    }

    public final void setSide(Side side) {
        this.side.set(side);
    }

    public final ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    public final String getLabel() {
        return (String)this.label.get();
    }

    public final void setLabel(String string) {
        this.label.set(string);
    }

    public final ObjectProperty<String> labelProperty() {
        return this.label;
    }

    public final boolean isTickMarkVisible() {
        return this.tickMarkVisible.get();
    }

    public final void setTickMarkVisible(boolean bl) {
        this.tickMarkVisible.set(bl);
    }

    public final BooleanProperty tickMarkVisibleProperty() {
        return this.tickMarkVisible;
    }

    public final boolean isTickLabelsVisible() {
        return this.tickLabelsVisible.get();
    }

    public final void setTickLabelsVisible(boolean bl) {
        this.tickLabelsVisible.set(bl);
    }

    public final BooleanProperty tickLabelsVisibleProperty() {
        return this.tickLabelsVisible;
    }

    public final double getTickLength() {
        return this.tickLength.get();
    }

    public final void setTickLength(double d) {
        this.tickLength.set(d);
    }

    public final DoubleProperty tickLengthProperty() {
        return this.tickLength;
    }

    public final boolean isAutoRanging() {
        return this.autoRanging.get();
    }

    public final void setAutoRanging(boolean bl) {
        this.autoRanging.set(bl);
    }

    public final BooleanProperty autoRangingProperty() {
        return this.autoRanging;
    }

    public final Font getTickLabelFont() {
        return (Font)this.tickLabelFont.get();
    }

    public final void setTickLabelFont(Font font) {
        this.tickLabelFont.set(font);
    }

    public final ObjectProperty<Font> tickLabelFontProperty() {
        return this.tickLabelFont;
    }

    public final Paint getTickLabelFill() {
        return (Paint)this.tickLabelFill.get();
    }

    public final void setTickLabelFill(Paint paint) {
        this.tickLabelFill.set(paint);
    }

    public final ObjectProperty<Paint> tickLabelFillProperty() {
        return this.tickLabelFill;
    }

    public final double getTickLabelGap() {
        return this.tickLabelGap.get();
    }

    public final void setTickLabelGap(double d) {
        this.tickLabelGap.set(d);
    }

    public final DoubleProperty tickLabelGapProperty() {
        return this.tickLabelGap;
    }

    public final boolean getAnimated() {
        return this.animated.get();
    }

    public final void setAnimated(boolean bl) {
        this.animated.set(bl);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final double getTickLabelRotation() {
        return this.tickLabelRotation.getValue();
    }

    public final void setTickLabelRotation(double d) {
        this.tickLabelRotation.setValue(d);
    }

    public final DoubleProperty tickLabelRotationProperty() {
        return this.tickLabelRotation;
    }

    public Axis() {
        this.getStyleClass().setAll((String[])new String[]{"axis"});
        this.axisLabel.getStyleClass().add("axis-label");
        this.axisLabel.setAlignment(Pos.CENTER);
        this.tickMarkPath.getStyleClass().add("axis-tick-mark");
        this.getChildren().addAll((Node[])new Node[]{this.axisLabel, this.tickMarkPath});
        this.measure.getStyleClass().add("tick-mark");
    }

    protected final boolean isRangeValid() {
        return this.rangeValid;
    }

    protected final void invalidateRange() {
        this.rangeValid = false;
    }

    protected final boolean shouldAnimate() {
        return this.getAnimated() && this.impl_isTreeVisible() && this.getScene() != null;
    }

    @Override
    public void requestLayout() {
    }

    public void requestAxisLayout() {
        super.requestLayout();
    }

    public void invalidateRange(List<T> list) {
        this.invalidateRange();
        this.requestAxisLayout();
    }

    protected abstract Object autoRange(double var1);

    protected abstract void setRange(Object var1, boolean var2);

    protected abstract Object getRange();

    public abstract double getZeroPosition();

    public abstract double getDisplayPosition(T var1);

    public abstract T getValueForDisplay(double var1);

    public abstract boolean isValueOnAxis(T var1);

    public abstract double toNumericValue(T var1);

    public abstract T toRealValue(double var1);

    protected abstract List<T> calculateTickValues(double var1, Object var3);

    @Override
    protected double computePrefHeight(double d) {
        Side side = this.getSide();
        if (side == null) {
            return 50.0;
        }
        if (side.equals((Object)Side.TOP) || side.equals((Object)Side.BOTTOM)) {
            Object object = this.autoRange(d);
            double d2 = 0.0;
            if (this.isTickLabelsVisible()) {
                List<T> list = this.calculateTickValues(d, object);
                for (T t : list) {
                    d2 = Math.max(d2, this.measureTickMarkSize(t, object).getHeight());
                }
            }
            double d3 = this.isTickMarkVisible() ? this.getTickLength() : 0.0;
            double d4 = this.axisLabel.getText() == null || this.axisLabel.getText().length() == 0 ? 0.0 : this.axisLabel.prefHeight(-1.0);
            return d2 + this.getTickLabelGap() + d3 + d4;
        }
        return 100.0;
    }

    @Override
    protected double computePrefWidth(double d) {
        Side side = this.getSide();
        if (side == null) {
            return 50.0;
        }
        if (side.equals((Object)Side.TOP) || side.equals((Object)Side.BOTTOM)) {
            return 100.0;
        }
        Object object = this.autoRange(d);
        double d2 = 0.0;
        if (this.isTickLabelsVisible()) {
            List<T> list = this.calculateTickValues(d, object);
            for (T t : list) {
                d2 = Math.max(d2, this.measureTickMarkSize(t, object).getWidth());
            }
        }
        double d3 = this.isTickMarkVisible() ? this.getTickLength() : 0.0;
        double d4 = this.axisLabel.getText() == null || this.axisLabel.getText().length() == 0 ? 0.0 : this.axisLabel.prefHeight(-1.0);
        return d2 + this.getTickLabelGap() + d3 + d4;
    }

    protected void tickMarksUpdated() {
    }

    @Override
    protected void layoutChildren() {
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = this.getTickLength();
        boolean bl = this.oldLength == 0.0;
        Side side = this.getSide();
        double d4 = Side.TOP.equals((Object)side) || Side.BOTTOM.equals((Object)side) ? d : d2;
        int n = 1;
        int n2 = 0;
        if (this.oldLength != d4 || !this.isRangeValid()) {
            Object object;
            Iterator iterator;
            ArrayList<Object> arrayList;
            Object object3;
            if (this.isAutoRanging()) {
                object3 = this.autoRange(d4);
                this.setRange(object3, this.getAnimated() && !bl && this.impl_isTreeVisible() && !this.isRangeValid());
            } else {
                object3 = this.getRange();
            }
            Iterator iterator2 = this.calculateTickValues(d4, object3);
            this.maxWidth = 0.0;
            this.maxHeight = 0.0;
            if (side != null) {
                if (Side.TOP.equals((Object)side) || Side.BOTTOM.equals((Object)side)) {
                    Iterator<T> object2 = iterator2.iterator();
                    while (object2.hasNext()) {
                        arrayList = object2.next();
                        this.maxWidth = Math.round(Math.max(this.maxWidth, this.measureTickMarkSize(arrayList, object3).getWidth()));
                    }
                } else {
                    Iterator<T> iterator3 = iterator2.iterator();
                    while (iterator3.hasNext()) {
                        arrayList = iterator3.next();
                        this.maxHeight = Math.round(Math.max(this.maxHeight, this.measureTickMarkSize(arrayList, object3).getHeight()));
                    }
                }
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList = new ArrayList();
            if (this.tickMarks.isEmpty()) {
                arrayList2.addAll((Collection<Object>)((Object)iterator2));
            } else {
                for (TickMark tickMark : this.tickMarks) {
                    if (iterator2.contains(tickMark.getValue())) continue;
                    arrayList.add(tickMark);
                }
                iterator = iterator2.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    boolean bl2 = false;
                    for (TickMark tickMark : this.tickMarks) {
                        if (!tickMark.getValue().equals(e)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    arrayList2.add(e);
                }
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                TickMark tickMark;
                final TickMark tickMark2 = tickMark = (TickMark)iterator.next();
                if (this.shouldAnimate()) {
                    object = new FadeTransition(Duration.millis(250.0), tickMark.textNode);
                    ((FadeTransition)object).setToValue(0.0);
                    ((Animation)object).setOnFinished(new EventHandler<ActionEvent>(){

                        @Override
                        public void handle(ActionEvent actionEvent) {
                            Axis.this.getChildren().remove(tickMark2.textNode);
                        }
                    });
                    ((Animation)object).play();
                } else {
                    this.getChildren().remove(tickMark2.textNode);
                }
                this.tickMarks.remove(tickMark2);
            }
            for (Object e : arrayList2) {
                TickMark tickMark = new TickMark();
                tickMark.setValue(e);
                tickMark.textNode.setText(this.getTickMarkLabel(e));
                tickMark.textNode.setFont(this.getTickLabelFont());
                tickMark.textNode.setFill(this.getTickLabelFill());
                tickMark.setTextVisible(this.isTickLabelsVisible());
                if (this.shouldAnimate()) {
                    tickMark.textNode.setOpacity(0.0);
                }
                this.getChildren().add(tickMark.textNode);
                this.tickMarks.add(tickMark);
                if (!this.shouldAnimate()) continue;
                object = new FadeTransition(Duration.millis(750.0), tickMark.textNode);
                ((FadeTransition)object).setFromValue(0.0);
                ((FadeTransition)object).setToValue(1.0);
                ((Animation)object).play();
            }
            this.tickMarksUpdated();
            this.oldLength = d4;
            this.rangeValid = true;
        }
        int n3 = 0;
        if (side != null) {
            if (Side.TOP.equals((Object)side) || Side.BOTTOM.equals((Object)side)) {
                n3 = this.maxWidth > 0.0 ? (int)(d4 / this.maxWidth) : 0;
            } else {
                int n4 = n3 = this.maxHeight > 0.0 ? (int)(d4 / this.maxHeight) : 0;
            }
        }
        if (n3 > 0) {
            n = this.tickMarks.size() / n3 + 1;
        }
        this.tickMarkPath.getElements().clear();
        if (this.getSide().equals((Object)Side.LEFT)) {
            this.tickMarkPath.setLayoutX(-0.5);
            this.tickMarkPath.setLayoutY(0.5);
            if (this.getLabel() != null) {
                this.axisLabel.getTransforms().setAll((Transform[])new Transform[]{new Translate(0.0, d2), new Rotate(-90.0, 0.0, 0.0)});
                this.axisLabel.setLayoutX(0.0);
                this.axisLabel.setLayoutY(0.0);
                this.axisLabel.resize(d2, Math.ceil(this.axisLabel.prefHeight(d)));
            }
            n2 = 0;
            for (TickMark tickMark : this.tickMarks) {
                tickMark.setPosition(this.getDisplayPosition(tickMark.getValue()));
                this.positionTextNode(tickMark.textNode, d - this.getTickLabelGap() - d3, tickMark.getPosition(), this.getTickLabelRotation(), side);
                if (tickMark.getPosition() >= 0.0 && tickMark.getPosition() <= d4) {
                    if (this.isTickLabelsVisible()) {
                        tickMark.textNode.setVisible(n2 % n == 0);
                        ++n2;
                    }
                    this.tickMarkPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(d - d3, tickMark.getPosition()), new LineTo(d, tickMark.getPosition())});
                    continue;
                }
                tickMark.textNode.setVisible(false);
            }
        } else if (this.getSide().equals((Object)Side.RIGHT)) {
            this.tickMarkPath.setLayoutX(0.5);
            this.tickMarkPath.setLayoutY(0.5);
            n2 = 0;
            for (TickMark tickMark : this.tickMarks) {
                tickMark.setPosition(this.getDisplayPosition(tickMark.getValue()));
                this.positionTextNode(tickMark.textNode, this.getTickLabelGap() + d3, tickMark.getPosition(), this.getTickLabelRotation(), side);
                if (tickMark.getPosition() >= 0.0 && tickMark.getPosition() <= d4) {
                    if (this.isTickLabelsVisible()) {
                        tickMark.textNode.setVisible(n2 % n == 0);
                        ++n2;
                    }
                    this.tickMarkPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(0.0, tickMark.getPosition()), new LineTo(d3, tickMark.getPosition())});
                    continue;
                }
                tickMark.textNode.setVisible(false);
            }
            if (this.getLabel() != null) {
                double d5 = Math.ceil(this.axisLabel.prefHeight(d));
                this.axisLabel.getTransforms().setAll((Transform[])new Transform[]{new Translate(0.0, d2), new Rotate(-90.0, 0.0, 0.0)});
                this.axisLabel.setLayoutX(d - d5);
                this.axisLabel.setLayoutY(0.0);
                this.axisLabel.resize(d2, d5);
            }
        } else if (this.getSide().equals((Object)Side.TOP)) {
            this.tickMarkPath.setLayoutX(0.5);
            this.tickMarkPath.setLayoutY(-0.5);
            if (this.getLabel() != null) {
                this.axisLabel.getTransforms().clear();
                this.axisLabel.setLayoutX(0.0);
                this.axisLabel.setLayoutY(0.0);
                this.axisLabel.resize(d, Math.ceil(this.axisLabel.prefHeight(d)));
            }
            n2 = 0;
            for (TickMark tickMark : this.tickMarks) {
                tickMark.setPosition(this.getDisplayPosition(tickMark.getValue()));
                this.positionTextNode(tickMark.textNode, tickMark.getPosition(), d2 - d3 - this.getTickLabelGap(), this.getTickLabelRotation(), side);
                if (tickMark.getPosition() >= 0.0 && tickMark.getPosition() <= d4) {
                    if (this.isTickLabelsVisible()) {
                        tickMark.textNode.setVisible(n2 % n == 0);
                        ++n2;
                    }
                    this.tickMarkPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(tickMark.getPosition(), d2), new LineTo(tickMark.getPosition(), d2 - d3)});
                    continue;
                }
                tickMark.textNode.setVisible(false);
            }
        } else {
            this.tickMarkPath.setLayoutX(0.5);
            this.tickMarkPath.setLayoutY(0.5);
            n2 = 0;
            for (TickMark tickMark : this.tickMarks) {
                double d5 = Math.round(this.getDisplayPosition(tickMark.getValue()));
                tickMark.setPosition(d5);
                this.positionTextNode(tickMark.textNode, d5, d3 + this.getTickLabelGap(), this.getTickLabelRotation(), side);
                if (d5 >= 0.0 && d5 <= d4) {
                    if (this.isTickLabelsVisible()) {
                        tickMark.textNode.setVisible(n2 % n == 0);
                        ++n2;
                    }
                    this.tickMarkPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(d5, 0.0), new LineTo(d5, d3)});
                    continue;
                }
                tickMark.textNode.setVisible(false);
            }
            if (this.getLabel() != null) {
                this.axisLabel.getTransforms().clear();
                double d7 = Math.ceil(this.axisLabel.prefHeight(d));
                this.axisLabel.setLayoutX(0.0);
                this.axisLabel.setLayoutY(d2 - d7);
                this.axisLabel.resize(d, d7);
            }
        }
    }

    private void positionTextNode(Text text, double d, double d2, double d3, Side side) {
        text.setLayoutX(0.0);
        text.setLayoutY(0.0);
        text.setRotate(d3);
        Bounds bounds = text.getBoundsInParent();
        if (side.equals((Object)Side.LEFT)) {
            text.setLayoutX(d - bounds.getWidth() - bounds.getMinX());
            text.setLayoutY(d2 - bounds.getHeight() / 2.0 - bounds.getMinY());
        } else if (side.equals((Object)Side.RIGHT)) {
            text.setLayoutX(d - bounds.getMinX());
            text.setLayoutY(d2 - bounds.getHeight() / 2.0 - bounds.getMinY());
        } else if (side.equals((Object)Side.TOP)) {
            text.setLayoutX(d - bounds.getWidth() / 2.0 - bounds.getMinX());
            text.setLayoutY(d2 - bounds.getHeight() - bounds.getMinY());
        } else {
            text.setLayoutX(d - bounds.getWidth() / 2.0 - bounds.getMinX());
            text.setLayoutY(d2 - bounds.getMinY());
        }
    }

    protected abstract String getTickMarkLabel(T var1);

    protected final Dimension2D measureTickMarkLabelSize(String string, double d) {
        this.measure.setRotate(d);
        this.measure.setText(string);
        Bounds bounds = this.measure.getBoundsInParent();
        return new Dimension2D(bounds.getWidth(), bounds.getHeight());
    }

    protected final Dimension2D measureTickMarkSize(T t, double d) {
        return this.measureTickMarkLabelSize(this.getTickMarkLabel(t), d);
    }

    protected Dimension2D measureTickMarkSize(T t, Object object) {
        return this.measureTickMarkSize(t, this.getTickLabelRotation());
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-side".equals(string)) {
            this.setSide((Side)((Object)object));
        } else if ("-fx-tick-length".equals(string)) {
            this.setTickLength((Double)object);
        } else if ("-fx-tick-label-font".equals(string)) {
            this.setTickLabelFont((Font)object);
        } else if ("-fx-tick-label-fill".equals(string)) {
            this.setTickLabelFill((Paint)object);
        } else if ("-fx-tick-label-gap".equals(string)) {
            this.setTickLabelGap((Double)object);
        } else if ("-fx-tick-mark-visible".equals(string)) {
            this.setTickMarkVisible((Boolean)object);
        } else if ("-fx-tick-labels-visible".equals(string)) {
            this.setTickLabelsVisible((Boolean)object);
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-side".equals(string)) {
            return this.side == null || !this.side.isBound();
        }
        if ("-fx-tick-length".equals(string)) {
            return this.tickLength == null || !this.tickLength.isBound();
        }
        if ("-fx-tick-label-font".equals(string)) {
            return this.tickLabelFont == null || !this.tickLabelFont.isBound();
        }
        if ("-fx-tick-label-fill".equals(string)) {
            return this.tickLabelFill == null || !this.tickLabelFill.isBound();
        }
        if ("-fx-tick-label-gap".equals(string)) {
            return this.tickLabelGap == null || !this.tickLabelGap.isBound();
        }
        if ("-fx-tick-mark-visible".equals(string)) {
            return this.tickMarkVisible == null || !this.tickMarkVisible.isBound();
        }
        if ("-fx-tick-labels-visible".equals(string)) {
            return this.tickLabelsVisible == null || !this.tickLabelsVisible.isBound();
        }
        return super.impl_cssSettable(string);
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        switch (this.getSide()) {
            case TOP: {
                l |= TOP_PSEUDOCLASS_STATE;
                break;
            }
            case RIGHT: {
                l |= RIGHT_PSEUDOCLASS_STATE;
                break;
            }
            case BOTTOM: {
                l |= BOTTOM_PSEUDOCLASS_STATE;
                break;
            }
            case LEFT: {
                l |= LEFT_PSEUDOCLASS_STATE;
            }
        }
        return l;
    }

    private static class StyleableProperties {
        private static final StyleableProperty SIDE = new StyleableProperty(Axis.class, "side");
        private static final StyleableProperty TICK_MARK_LENGTH = new StyleableProperty(Axis.class, "tickLength");
        private static final StyleableProperty TICK_LABEL_FONT = new StyleableProperty(Axis.class, "tickLabelFont", StyleableProperty.createFontSubProperties("-fx-tick-label-font"));
        private static final StyleableProperty TICK_LABEL_FILL = new StyleableProperty(Axis.class, "tickLabelFill");
        private static final StyleableProperty TICK_LABEL_TICK_GAP = new StyleableProperty(Axis.class, "tickLabelGap");
        private static final StyleableProperty TICK_MARK_VISIBLE = new StyleableProperty(Axis.class, "tickMarkVisible");
        private static final StyleableProperty TICK_LABELS_VISIBLE = new StyleableProperty(Axis.class, "tickLabelsVisible");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Region.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, SIDE, TICK_MARK_LENGTH, TICK_LABEL_FONT, TICK_LABEL_FILL, TICK_LABEL_TICK_GAP, TICK_MARK_VISIBLE, TICK_LABELS_VISIBLE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }

    public static final class TickMark<T> {
        private StringProperty label = new StringPropertyBase(){

            @Override
            protected void invalidated() {
                TickMark.this.textNode.setText(this.getValue());
            }

            @Override
            public Object getBean() {
                return TickMark.this;
            }

            @Override
            public String getName() {
                return "label";
            }
        };
        private ObjectProperty<T> value = new SimpleObjectProperty(this, "value");
        private DoubleProperty position = new SimpleDoubleProperty(this, "position");
        private Text textNode = new Text();
        private BooleanProperty textVisible = new BooleanPropertyBase(true){

            @Override
            protected void invalidated() {
                if (!this.get()) {
                    TickMark.this.textNode.setVisible(false);
                }
            }

            @Override
            public Object getBean() {
                return TickMark.this;
            }

            @Override
            public String getName() {
                return "textVisible";
            }
        };

        public final String getLabel() {
            return (String)this.label.get();
        }

        public final void setLabel(String string) {
            this.label.set(string);
        }

        public final StringExpression labelProperty() {
            return this.label;
        }

        public final T getValue() {
            return this.value.get();
        }

        public final void setValue(T t) {
            this.value.set(t);
        }

        public final ObjectExpression<T> valueProperty() {
            return this.value;
        }

        public final double getPosition() {
            return this.position.get();
        }

        public final void setPosition(double d) {
            this.position.set(d);
        }

        public final DoubleExpression positionProperty() {
            return this.position;
        }

        public final boolean isTextVisible() {
            return this.textVisible.get();
        }

        public final void setTextVisible(boolean bl) {
            this.textVisible.set(bl);
        }

        public TickMark() {
            this.textNode.getStyleClass().add("tick-mark");
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

