/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swt;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.EmbeddedStageInterface;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.stage.EmbeddedWindow;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.embed.swt.SWTCursors;
import javafx.embed.swt.SWTEvents;
import javafx.scene.Scene;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class FXCanvas
extends Canvas {
    private HostContainer hostContainer;
    private volatile EmbeddedWindow stage;
    private volatile Scene scene;
    private EmbeddedStageInterface stagePeer;
    private EmbeddedSceneInterface scenePeer;
    private int pWidth = 0;
    private int pHeight = 0;
    private volatile int pPreferredWidth = -1;
    private volatile int pPreferredHeight = -1;
    private IntBuffer pixelsBuf = null;
    int lastWidth;
    int lastHeight;
    IntBuffer lastPixelsBuf = null;

    public FXCanvas(Composite composite, int n) {
        super(composite, n | 0x40000);
        FXCanvas.initFx();
        this.hostContainer = new HostContainer();
        this.registerEventListeners();
    }

    private static void initFx() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty("javafx.macosx.embedded", "true");
                System.setProperty("javafx.embed.isEventThread", "true");
                return null;
            }
        });
        PlatformImpl.startup(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (this.pPreferredWidth != -1 && this.pPreferredHeight != -1) {
            return new Point(this.pPreferredWidth, this.pPreferredHeight);
        }
        return super.computeSize(n, n2, bl);
    }

    public Scene getScene() {
        this.checkWidget();
        return this.scene;
    }

    public void setScene(Scene scene) {
        this.checkWidget();
        if (this.stage == null && scene != null) {
            this.stage = new EmbeddedWindow(this.hostContainer);
            this.stage.show();
        }
        this.scene = scene;
        if (this.stage != null) {
            this.stage.setScene(scene);
        }
        if (this.stage != null && scene == null) {
            this.stage.hide();
            this.stage = null;
        }
    }

    private void registerEventListeners() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                FXCanvas.this.widgetDisposed(disposeEvent);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                FXCanvas.this.paintControl(paintEvent);
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                FXCanvas.this.sendMouseEventToFX(mouseEvent, 0);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                FXCanvas.this.sendMouseEventToFX(mouseEvent, 1);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                if ((mouseEvent.stateMask & SWT.BUTTON_MASK) != 0) {
                    FXCanvas.this.sendMouseEventToFX(mouseEvent, 6);
                } else {
                    FXCanvas.this.sendMouseEventToFX(mouseEvent, 5);
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent mouseEvent) {
                FXCanvas.this.sendMouseEventToFX(mouseEvent, 7);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent mouseEvent) {
                FXCanvas.this.sendMouseEventToFX(mouseEvent, 3);
            }

            public void mouseExit(MouseEvent mouseEvent) {
                FXCanvas.this.sendMouseEventToFX(mouseEvent, 4);
            }

            public void mouseHover(MouseEvent mouseEvent) {
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
                FXCanvas.this.sendMoveEventToFX();
            }

            public void controlResized(ControlEvent controlEvent) {
                FXCanvas.this.sendResizeEventToFX();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                FXCanvas.this.sendFocusEventToFX(focusEvent, true);
            }

            public void focusLost(FocusEvent focusEvent) {
                FXCanvas.this.sendFocusEventToFX(focusEvent, false);
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                FXCanvas.this.sendKeyEventToFX(keyEvent, 1);
            }

            public void keyReleased(KeyEvent keyEvent) {
                FXCanvas.this.sendKeyEventToFX(keyEvent, 2);
            }
        });
    }

    private void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.stage != null) {
            this.stage.hide();
        }
    }

    private void paintControl(PaintEvent paintEvent) {
        if (this.scenePeer == null || this.pixelsBuf == null) {
            return;
        }
        IntBuffer intBuffer = this.pixelsBuf;
        int n = this.pWidth;
        int n2 = this.pHeight;
        if (this.scenePeer.getPixels(this.pixelsBuf, this.pWidth, this.pHeight)) {
            n = this.lastWidth = this.pWidth;
            n2 = this.lastHeight = this.pHeight;
            intBuffer = this.lastPixelsBuf = this.pixelsBuf;
        } else {
            if (this.lastPixelsBuf == null) {
                return;
            }
            n = this.lastWidth;
            n2 = this.lastHeight;
            intBuffer = this.lastPixelsBuf;
        }
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(n, n2, 32, paletteData);
        imageData.setPixels(0, 0, n * n2, intBuffer.array(), 0);
        Image image = new Image((Device)Display.getDefault(), imageData);
        paintEvent.gc.drawImage(image, 0, 0);
        image.dispose();
    }

    private void sendMoveEventToFX() {
        if (this.stagePeer == null) {
            return;
        }
        Point point = this.toDisplay(this.getLocation());
        this.stagePeer.setLocation(point.x, point.y);
    }

    private void sendMouseEventToFX(MouseEvent mouseEvent, int n) {
        if (this.scenePeer == null) {
            return;
        }
        Point point = this.toDisplay(mouseEvent.x, mouseEvent.y);
        boolean bl = (mouseEvent.stateMask & 0x80000) != 0;
        boolean bl2 = (mouseEvent.stateMask & 0x100000) != 0;
        boolean bl3 = (mouseEvent.stateMask & 0x200000) != 0;
        boolean bl4 = (mouseEvent.stateMask & 0x20000) != 0;
        boolean bl5 = (mouseEvent.stateMask & 0x40000) != 0;
        boolean bl6 = (mouseEvent.stateMask & 0x10000) != 0;
        boolean bl7 = (mouseEvent.stateMask & 0x400000) != 0;
        switch (n) {
            case 0: {
                bl |= mouseEvent.button == 1;
                bl2 |= mouseEvent.button == 2;
                bl3 |= mouseEvent.button == 3;
                break;
            }
            case 1: {
                bl &= mouseEvent.button != 1;
                bl2 &= mouseEvent.button != 2;
                bl3 &= mouseEvent.button != 3;
            }
        }
        this.scenePeer.mouseEvent(n, SWTEvents.mouseButtonToEmbedMouseButton(mouseEvent.button, mouseEvent.stateMask), bl, bl2, bl3, mouseEvent.count, mouseEvent.x, mouseEvent.y, point.x, point.y, bl4, bl5, bl6, bl7, SWTEvents.getWheelRotation(mouseEvent), false);
    }

    private void sendKeyEventToFX(KeyEvent keyEvent, int n) {
        if (this.scenePeer == null) {
            return;
        }
        int n2 = keyEvent.stateMask;
        if (n == 1) {
            if (keyEvent.keyCode == 131072) {
                n2 |= 0x20000;
            }
            if (keyEvent.keyCode == 262144) {
                n2 |= 0x40000;
            }
            if (keyEvent.keyCode == 65536) {
                n2 |= 0x10000;
            }
            if (keyEvent.keyCode == 0x400000) {
                n2 |= 0x400000;
            }
        } else {
            if (keyEvent.keyCode == 131072) {
                n2 &= 0xFFFDFFFF;
            }
            if (keyEvent.keyCode == 262144) {
                n2 &= 0xFFFBFFFF;
            }
            if (keyEvent.keyCode == 65536) {
                n2 &= 0xFFFEFFFF;
            }
            if (keyEvent.keyCode == 0x400000) {
                n2 &= 0xFFBFFFFF;
            }
        }
        int n3 = SWTEvents.keyCodeToEmbedKeyCode(keyEvent.keyCode);
        this.scenePeer.keyEvent(SWTEvents.keyIDToEmbedKeyType(n), n3, null, SWTEvents.keyModifiersToEmbedKeyModifiers(n2));
        if (keyEvent.character != '\u0000' && n == 1) {
            char[] cArray = new char[]{keyEvent.character};
            this.scenePeer.keyEvent(2, keyEvent.keyCode, cArray, SWTEvents.keyModifiersToEmbedKeyModifiers(n2));
        }
    }

    private void sendResizeEventToFX() {
        this.redraw();
        this.update();
        this.pWidth = this.getClientArea().width;
        this.pHeight = this.getClientArea().height;
        if (this.pWidth <= 0 || this.pHeight <= 0) {
            this.lastPixelsBuf = null;
            this.pixelsBuf = null;
        } else {
            this.pixelsBuf = IntBuffer.allocate(this.pWidth * this.pHeight);
        }
        if (this.scenePeer == null) {
            return;
        }
        this.stagePeer.setSize(this.pWidth, this.pHeight);
        this.scenePeer.setSize(this.pWidth, this.pHeight);
    }

    private void sendFocusEventToFX(FocusEvent focusEvent, boolean bl) {
        if (this.stage == null || this.stagePeer == null) {
            return;
        }
        int n = bl ? 0 : 3;
        this.stagePeer.setFocused(bl, n);
    }

    private class HostContainer
    implements HostInterface {
        Object lock = new Object();
        boolean queued = false;

        private HostContainer() {
        }

        @Override
        public void setEmbeddedStage(EmbeddedStageInterface embeddedStageInterface) {
            FXCanvas.this.stagePeer = embeddedStageInterface;
            if (FXCanvas.this.stagePeer == null) {
                return;
            }
            if (FXCanvas.this.pWidth > 0 && FXCanvas.this.pHeight > 0) {
                FXCanvas.this.stagePeer.setSize(FXCanvas.this.pWidth, FXCanvas.this.pHeight);
            }
            if (FXCanvas.this.isFocusControl()) {
                FXCanvas.this.stagePeer.setFocused(true, 0);
            }
            FXCanvas.this.sendMoveEventToFX();
            FXCanvas.this.sendResizeEventToFX();
        }

        @Override
        public void setEmbeddedScene(EmbeddedSceneInterface embeddedSceneInterface) {
            FXCanvas.this.scenePeer = embeddedSceneInterface;
            if (FXCanvas.this.scenePeer == null) {
                return;
            }
            if (FXCanvas.this.pWidth > 0 && FXCanvas.this.pHeight > 0) {
                FXCanvas.this.scenePeer.setSize(FXCanvas.this.pWidth, FXCanvas.this.pHeight);
            }
        }

        @Override
        public boolean requestFocus() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (FXCanvas.this.isDisposed()) {
                        return;
                    }
                    FXCanvas.this.forceFocus();
                }
            });
            return true;
        }

        @Override
        public boolean traverseFocusOut(boolean bl) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void repaint() {
            Object object = this.lock;
            synchronized (object) {
                if (this.queued) {
                    return;
                }
                this.queued = true;
                Display.getDefault().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (FXCanvas.this.isDisposed()) {
                                return;
                            }
                            FXCanvas.this.redraw();
                            FXCanvas.this.sendMoveEventToFX();
                        }
                        finally {
                            Object object = HostContainer.this.lock;
                            synchronized (object) {
                                HostContainer.this.queued = false;
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void setPreferredSize(int n, int n2) {
            FXCanvas.this.pPreferredWidth = n;
            FXCanvas.this.pPreferredHeight = n2;
        }

        @Override
        public void setEnabled(boolean bl) {
            FXCanvas.this.setEnabled(bl);
        }

        @Override
        public void setCursor(CursorFrame cursorFrame) {
            FXCanvas.this.setCursor(this.getPlatformCursor(cursorFrame));
        }

        private Cursor getPlatformCursor(CursorFrame cursorFrame) {
            Cursor cursor = cursorFrame.getPlatformCursor(Cursor.class);
            if (cursor != null) {
                return cursor;
            }
            Cursor cursor2 = SWTCursors.embedCursorToCursor(cursorFrame);
            cursorFrame.setPlatforCursor(Cursor.class, cursor2);
            return cursor2;
        }
    }
}

