/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import java.util.Arrays;
import java.util.Collection;
import javafx.animation.AnimationBuilder;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;

public final class TimelineBuilder
extends AnimationBuilder<TimelineBuilder> {
    private boolean __set;
    private Collection<? extends KeyFrame> keyFrames;
    private double targetFramerate;

    protected TimelineBuilder() {
    }

    public static TimelineBuilder create() {
        return new TimelineBuilder();
    }

    public void applyTo(Timeline timeline) {
        super.applyTo(timeline);
        if (this.__set) {
            timeline.getKeyFrames().setAll(this.keyFrames);
        }
    }

    public TimelineBuilder keyFrames(Collection<? extends KeyFrame> collection) {
        this.keyFrames = collection;
        this.__set = true;
        return this;
    }

    public TimelineBuilder keyFrames(KeyFrame ... keyFrameArray) {
        return this.keyFrames(Arrays.asList(keyFrameArray));
    }

    @Override
    public TimelineBuilder targetFramerate(double d) {
        this.targetFramerate = d;
        return this;
    }

    public Timeline build() {
        Timeline timeline = new Timeline(this.targetFramerate);
        this.applyTo(timeline);
        return timeline;
    }
}

