/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.network;

import com.sun.webpane.platform.Invoker;
import com.sun.webpane.webkit.network.ByteBufferAllocator;
import com.sun.webpane.webkit.network.URLConsumer;
import com.sun.webpane.webkit.network.URLFetcher;
import com.sun.webpane.webkit.network.Util;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class URLProcessor
implements URLConsumer {
    private static URLProcessor shared = null;

    private URLProcessor() {
    }

    static URLProcessor sharedInstance() {
        if (shared == null) {
            shared = new URLProcessor();
        }
        return shared;
    }

    private static native void writeCallback(ByteBuffer var0, int var1, int var2, long var3);

    private static native void headerCallback(int var0, long var1, String var3, String var4, String var5, String var6, long var7);

    private static native void didSendDataCallback(long var0, long var2, long var4);

    private static native void endOfDataCallback(long var0);

    private static native void errorCallback(int var0, String var1, String var2, long var3);

    @Override
    public void writeHeaders(final String string, URLConnection uRLConnection, final URLFetcher uRLFetcher) {
        final int n = URLProcessor.getStatus(uRLConnection);
        final long l = URLProcessor.getContentLength(uRLConnection);
        final String string2 = uRLConnection.getContentType();
        final String string3 = URLProcessor.getContentEncoding(uRLConnection);
        final String string4 = URLProcessor.getHeaders(uRLConnection);
        Invoker.getInvoker().invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                if (!uRLFetcher.isCanceled()) {
                    URLProcessor.headerCallback(n, l, string2, string3, string4, URLProcessor.getURL4WK(string), uRLFetcher.getPrivateData());
                }
            }
        });
    }

    @Override
    public void didSendData(final long l, final long l2, final URLFetcher uRLFetcher) {
        Invoker.getInvoker().invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                if (!uRLFetcher.isCanceled()) {
                    URLProcessor.didSendDataCallback(l, l2, uRLFetcher.getPrivateData());
                }
            }
        });
    }

    @Override
    public void writeContent(final ByteBuffer byteBuffer, final ByteBufferAllocator byteBufferAllocator, final URLFetcher uRLFetcher) {
        Invoker.getInvoker().invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                if (!uRLFetcher.isCanceled()) {
                    URLProcessor.writeCallback(byteBuffer, byteBuffer.position(), byteBuffer.remaining(), uRLFetcher.getPrivateData());
                }
                byteBuffer.clear();
                byteBufferAllocator.release(byteBuffer);
            }
        });
    }

    @Override
    public void endOfContent(final URLFetcher uRLFetcher) {
        Invoker.getInvoker().invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                if (!uRLFetcher.isCanceled()) {
                    URLProcessor.endOfDataCallback(uRLFetcher.getPrivateData());
                }
            }
        });
    }

    @Override
    public void error(final String string, final int n, final String string2, final URLFetcher uRLFetcher) {
        Invoker.getInvoker().invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                if (!uRLFetcher.isCanceled()) {
                    URLProcessor.errorCallback(n, URLProcessor.getURL4WK(string), string2, uRLFetcher.getPrivateData());
                }
            }
        });
    }

    private static int getStatus(URLConnection uRLConnection) {
        int n = 0;
        if (uRLConnection instanceof HttpURLConnection) {
            try {
                n = ((HttpURLConnection)uRLConnection).getResponseCode();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n;
    }

    private static long getContentLength(URLConnection uRLConnection) {
        try {
            return Long.parseLong(uRLConnection.getHeaderField("content-length"));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private static String getContentEncoding(URLConnection uRLConnection) {
        int n;
        String string;
        String string2 = uRLConnection.getContentEncoding();
        if (("gzip".equalsIgnoreCase(string2) || "deflate".equalsIgnoreCase(string2)) && (string = uRLConnection.getContentType()) != null && (n = string.indexOf("charset=")) >= 0 && (n = (string2 = string.substring(n + 8)).indexOf(";")) > 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private static String getHeaders(URLConnection uRLConnection) {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, List<String>> map = uRLConnection.getHeaderFields();
        Set<String> set = map.keySet();
        for (String string : set) {
            List<String> list = map.get(string);
            for (String string2 : list) {
                stringBuilder.append(string != null ? string : "").append(':').append(string2).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    private static String getURL4WK(String string) {
        try {
            string = Util.adjustUrlForWebKit(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

