/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap {
    protected final long peer;
    protected final long contextPeer;

    protected long getPeer() {
        return this.peer;
    }

    static NamedNodeMap getImpl(long peer, long contextPeer) {
        return new NamedNodeMapImpl(peer, contextPeer);
    }

    NamedNodeMapImpl(long _peer, long contextPeer) {
        this.peer = _peer;
        this.contextPeer = contextPeer;
        Disposer.addRecord(this, new SelfDisposer(_peer));
    }

    public boolean equals(Object that) {
        if (that instanceof NamedNodeMapImpl) {
            return this.peer == ((NamedNodeMapImpl)that).peer;
        }
        return false;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    @Override
    public Node getNamedItem(String name) {
        long p = NamedNodeMapImpl.getNamedItemImpl(this.getPeer(), name);
        return p == 0L ? null : NodeImpl.getImpl(p, this.contextPeer);
    }

    static native long getNamedItemImpl(long var0, String var2);

    @Override
    public Node setNamedItem(Node node) throws DOMException {
        long p = NamedNodeMapImpl.setNamedItemImpl(this.getPeer(), ((NodeImpl)node).getPeer());
        return p == 0L ? null : NodeImpl.getImpl(p, this.contextPeer);
    }

    static native long setNamedItemImpl(long var0, long var2);

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        long p = NamedNodeMapImpl.removeNamedItemImpl(this.getPeer(), name);
        return p == 0L ? null : NodeImpl.getImpl(p, this.contextPeer);
    }

    static native long removeNamedItemImpl(long var0, String var2);

    @Override
    public Node item(int index) {
        long p = NamedNodeMapImpl.itemImpl(this.getPeer(), index);
        return p == 0L ? null : NodeImpl.getImpl(p, this.contextPeer);
    }

    static native long itemImpl(long var0, int var2);

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) {
        long p = NamedNodeMapImpl.getNamedItemNSImpl(this.getPeer(), namespaceURI, localName);
        return p == 0L ? null : NodeImpl.getImpl(p, this.contextPeer);
    }

    static native long getNamedItemNSImpl(long var0, String var2, String var3);

    @Override
    public Node setNamedItemNS(Node node) throws DOMException {
        long p = NamedNodeMapImpl.setNamedItemNSImpl(this.getPeer(), ((NodeImpl)node).getPeer());
        return p == 0L ? null : NodeImpl.getImpl(p, this.contextPeer);
    }

    static native long setNamedItemNSImpl(long var0, long var2);

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        long p = NamedNodeMapImpl.removeNamedItemNSImpl(this.getPeer(), namespaceURI, localName);
        return p == 0L ? null : NodeImpl.getImpl(p, this.contextPeer);
    }

    static native long removeNamedItemNSImpl(long var0, String var2, String var3);

    @Override
    public int getLength() {
        int p = NamedNodeMapImpl.getLengthImpl(this.getPeer());
        return p;
    }

    static native int getLengthImpl(long var0);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long _peer) {
            this.peer = _peer;
        }

        @Override
        public void dispose() {
            NamedNodeMapImpl.dispose(this.peer);
        }
    }
}

