/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.CSSStyleSheetImpl;
import com.sun.webpane.webkit.dom.DocumentImpl;
import com.sun.webpane.webkit.dom.DocumentTypeImpl;
import com.sun.webpane.webkit.dom.HTMLDocumentImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.html.HTMLDocument;

public class DOMImplementationImpl
implements DOMImplementation {
    protected final long peer;
    protected final long contextPeer;

    protected long getPeer() {
        return this.peer;
    }

    static DOMImplementation getImpl(long peer, long contextPeer) {
        return new DOMImplementationImpl(peer, contextPeer);
    }

    DOMImplementationImpl(long _peer, long contextPeer) {
        this.peer = _peer;
        this.contextPeer = contextPeer;
        Disposer.addRecord(this, new SelfDisposer(_peer));
    }

    public boolean equals(Object that) {
        if (that instanceof DOMImplementationImpl) {
            return this.peer == ((DOMImplementationImpl)that).peer;
        }
        return false;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    @Override
    public boolean hasFeature(String feature, String version) {
        boolean p = DOMImplementationImpl.hasFeatureImpl(this.getPeer(), feature, version);
        return p;
    }

    static native boolean hasFeatureImpl(long var0, String var2, String var3);

    @Override
    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws DOMException {
        long p = DOMImplementationImpl.createDocumentTypeImpl(this.getPeer(), qualifiedName, publicId, systemId);
        return p == 0L ? null : DocumentTypeImpl.getImpl(p, this.contextPeer);
    }

    static native long createDocumentTypeImpl(long var0, String var2, String var3, String var4);

    @Override
    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        long p = DOMImplementationImpl.createDocumentImpl(this.getPeer(), namespaceURI, qualifiedName, ((DocumentTypeImpl)doctype).getPeer());
        return p == 0L ? null : DocumentImpl.getImpl(p, this.contextPeer);
    }

    static native long createDocumentImpl(long var0, String var2, String var3, long var4);

    public CSSStyleSheet createCSSStyleSheet(String title, String media) throws DOMException {
        long p = DOMImplementationImpl.createCSSStyleSheetImpl(this.getPeer(), title, media);
        return p == 0L ? null : CSSStyleSheetImpl.getImpl(p, this.contextPeer);
    }

    static native long createCSSStyleSheetImpl(long var0, String var2, String var3);

    public HTMLDocument createHTMLDocument(String title) {
        long p = DOMImplementationImpl.createHTMLDocumentImpl(this.getPeer(), title);
        return p == 0L ? null : HTMLDocumentImpl.getImpl(p, this.contextPeer);
    }

    static native long createHTMLDocumentImpl(long var0, String var2);

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long _peer) {
            this.peer = _peer;
        }

        @Override
        public void dispose() {
            DOMImplementationImpl.dispose(this.peer);
        }
    }
}

