/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.CSSRuleImpl;
import com.sun.webpane.webkit.dom.CSSValueImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSStyleDeclarationImpl
implements CSSStyleDeclaration {
    protected final long peer;
    protected final long contextPeer;

    protected long getPeer() {
        return this.peer;
    }

    static CSSStyleDeclaration getImpl(long peer, long contextPeer) {
        return new CSSStyleDeclarationImpl(peer, contextPeer);
    }

    CSSStyleDeclarationImpl(long _peer, long contextPeer) {
        this.peer = _peer;
        this.contextPeer = contextPeer;
        Disposer.addRecord(this, new SelfDisposer(_peer));
    }

    public boolean equals(Object that) {
        if (that instanceof CSSStyleDeclarationImpl) {
            return this.peer == ((CSSStyleDeclarationImpl)that).peer;
        }
        return false;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    @Override
    public String getPropertyValue(String propertyName) {
        String p = CSSStyleDeclarationImpl.getPropertyValueImpl(this.getPeer(), propertyName);
        return p;
    }

    static native String getPropertyValueImpl(long var0, String var2);

    @Override
    public CSSValue getPropertyCSSValue(String propertyName) {
        long p = CSSStyleDeclarationImpl.getPropertyCSSValueImpl(this.getPeer(), propertyName);
        return p == 0L ? null : CSSValueImpl.getImpl(p, this.contextPeer);
    }

    static native long getPropertyCSSValueImpl(long var0, String var2);

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        String p = CSSStyleDeclarationImpl.removePropertyImpl(this.getPeer(), propertyName);
        return p;
    }

    static native String removePropertyImpl(long var0, String var2);

    @Override
    public String getPropertyPriority(String propertyName) {
        String p = CSSStyleDeclarationImpl.getPropertyPriorityImpl(this.getPeer(), propertyName);
        return p;
    }

    static native String getPropertyPriorityImpl(long var0, String var2);

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        CSSStyleDeclarationImpl.setPropertyImpl(this.getPeer(), propertyName, value, priority);
    }

    static native void setPropertyImpl(long var0, String var2, String var3, String var4);

    @Override
    public String item(int index) {
        String p = CSSStyleDeclarationImpl.itemImpl(this.getPeer(), index);
        return p;
    }

    static native String itemImpl(long var0, int var2);

    public String getPropertyShorthand(String propertyName) {
        String p = CSSStyleDeclarationImpl.getPropertyShorthandImpl(this.getPeer(), propertyName);
        return p;
    }

    static native String getPropertyShorthandImpl(long var0, String var2);

    public boolean isPropertyImplicit(String propertyName) {
        boolean p = CSSStyleDeclarationImpl.isPropertyImplicitImpl(this.getPeer(), propertyName);
        return p;
    }

    static native boolean isPropertyImplicitImpl(long var0, String var2);

    @Override
    public String getCssText() {
        String p = CSSStyleDeclarationImpl.getCssTextImpl(this.getPeer());
        return p;
    }

    static native String getCssTextImpl(long var0);

    @Override
    public void setCssText(String cssText) throws DOMException {
        CSSStyleDeclarationImpl.setCssTextImpl(this.getPeer(), cssText);
    }

    static native void setCssTextImpl(long var0, String var2);

    @Override
    public int getLength() {
        int p = CSSStyleDeclarationImpl.getLengthImpl(this.getPeer());
        return p;
    }

    static native int getLengthImpl(long var0);

    @Override
    public CSSRule getParentRule() {
        long p = CSSStyleDeclarationImpl.getParentRuleImpl(this.getPeer());
        return p == 0L ? null : CSSRuleImpl.getImpl(p, this.contextPeer);
    }

    static native long getParentRuleImpl(long var0);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long _peer) {
            this.peer = _peer;
        }

        @Override
        public void dispose() {
            CSSStyleDeclarationImpl.dispose(this.peer);
        }
    }
}

