/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.platform.graphics;

import com.sun.webpane.platform.Invoker;
import com.sun.webpane.platform.graphics.GraphicsDecoder;
import com.sun.webpane.platform.graphics.Ref;
import com.sun.webpane.platform.graphics.WCGraphicsContext;
import com.sun.webpane.platform.graphics.WCGraphicsManager;
import com.sun.webpane.platform.graphics.WCRectangle;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCRenderQueue
extends Ref {
    private static final AtomicInteger idCountObj = new AtomicInteger(0);
    private static final Logger log = Logger.getLogger(WCRenderQueue.class.getName());
    public static final int MAX_QUEUE_SIZE = 524288;
    private LinkedList<ByteBuffer> buffers = new LinkedList();
    private WCRectangle clip;
    private int size = 0;
    private AtomicInteger idCount = new AtomicInteger(0);
    private HashMap<Integer, String> strMap = new HashMap();
    private HashMap<Integer, int[]> intArrMap = new HashMap();
    private HashMap<Integer, float[]> floatArrMap = new HashMap();
    private WCGraphicsContext gc;

    public WCRenderQueue(WCGraphicsContext wCGraphicsContext) {
        this.gc = wCGraphicsContext;
    }

    public WCRenderQueue(WCRectangle wCRectangle) {
        this.clip = wCRectangle;
    }

    public synchronized int getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuffer(ByteBuffer byteBuffer) {
        WCRenderQueue wCRenderQueue = this;
        synchronized (wCRenderQueue) {
            if (log.isLoggable(Level.FINE) && this.buffers.isEmpty()) {
                log.log(Level.FINE, "'{'WCRenderQueue{0}[{1}]", new Object[]{this.hashCode(), idCountObj.incrementAndGet()});
            }
            this.buffers.addLast(byteBuffer);
            this.size += byteBuffer.capacity();
        }
        if (this.size > 524288 && this.gc != null) {
            this.flush();
        }
    }

    public synchronized boolean isEmpty() {
        return this.buffers.isEmpty();
    }

    public synchronized void decode(WCGraphicsContext wCGraphicsContext) {
        for (ByteBuffer byteBuffer : this.buffers) {
            try {
                GraphicsDecoder.decode(WCGraphicsManager.getGraphicsManager(), wCGraphicsContext, this, byteBuffer);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
        this.dispose();
    }

    public synchronized void decode() {
        assert (this.gc != null);
        this.decode(this.gc);
    }

    public void flush() {
        if (!this.isEmpty()) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Invoker.getInvoker().invokeOnRenderThread(new Runnable(){

                @Override
                public void run() {
                    WCRenderQueue.this.decode();
                    countDownLatch.countDown();
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                throw new AssertionError((Object)interruptedException);
            }
        }
    }

    private void fwkFlush() {
        this.flush();
    }

    private void fwkAddBuffer(ByteBuffer byteBuffer) {
        this.addBuffer(byteBuffer);
    }

    public WCRectangle getClip() {
        return this.clip;
    }

    public synchronized void dispose() {
        this.strMap.clear();
        this.intArrMap.clear();
        this.floatArrMap.clear();
        final Object[] objectArray = this.buffers.toArray();
        if (objectArray.length > 0) {
            this.buffers.clear();
            Invoker.getInvoker().invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    WCRenderQueue.this.twkRelease(objectArray);
                }
            });
            this.size = 0;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "'}'WCRenderQueue{0}[{1}]", new Object[]{this.hashCode(), idCountObj.decrementAndGet()});
            }
        }
    }

    private native void twkRelease(Object[] var1);

    private int createID() {
        return this.idCount.incrementAndGet();
    }

    private int refString(String string) {
        int n = this.createID();
        this.strMap.put(n, string);
        return n;
    }

    String derefString(int n) {
        return this.strMap.remove(n);
    }

    private int refIntArr(int[] nArray) {
        int n = this.createID();
        this.intArrMap.put(n, nArray);
        return n;
    }

    int[] derefIntArr(int n) {
        return this.intArrMap.remove(n);
    }

    private int refFloatArr(float[] fArray) {
        int n = this.createID();
        this.floatArrMap.put(n, fArray);
        return n;
    }

    float[] derefFloatArr(int n) {
        return this.floatArrMap.remove(n);
    }
}

