/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.platform.event;

import java.util.HashMap;
import java.util.regex.Pattern;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class KeyCodeMap {
    private static HashMap<KeyCode, Integer> keyMap = new HashMap();

    public static int getCode(KeyCode keyCode) {
        return keyMap.get((Object)keyCode);
    }

    public static int getCode(KeyEvent keyEvent) {
        String string = Pattern.compile(".*Unknown keyCode: 0x..").matcher(keyEvent.toString()).replaceFirst("");
        String string2 = Pattern.compile("].*").matcher(string).replaceFirst("");
        int n = Integer.parseInt(string2, 16);
        return n != 13 ? n : 10;
    }

    public static String getKeyText(KeyEvent keyEvent) {
        String string = Pattern.compile(".*Unknown keyCode: 0x..").matcher(keyEvent.toString()).replaceFirst("");
        String string2 = Pattern.compile("].*").matcher(string).replaceFirst("");
        String string3 = "U+" + string2.toUpperCase();
        if ("0d".equals(string2)) {
            string3 = "Enter";
        }
        return string3;
    }

    public static String getKeyText(KeyCode keyCode) {
        String string = String.format("U+%04X", KeyCodeMap.getCode(keyCode));
        if (keyCode.equals((Object)KeyCode.DOWN)) {
            string = "Down";
        } else if (keyCode.equals((Object)KeyCode.UP)) {
            string = "Up";
        } else if (keyCode.equals((Object)KeyCode.LEFT)) {
            string = "Left";
        } else if (keyCode.equals((Object)KeyCode.RIGHT)) {
            string = "Right";
        } else if (keyCode.equals((Object)KeyCode.ENTER)) {
            string = "Enter";
        } else if (keyCode.equals((Object)KeyCode.CONTROL)) {
            string = "Control";
        } else if (keyCode.equals((Object)KeyCode.SHIFT)) {
            string = "Shift";
        } else if (keyCode.equals((Object)KeyCode.ALT)) {
            string = "Alt";
        } else if (keyCode.equals((Object)KeyCode.META)) {
            string = "Meta";
        }
        return string;
    }

    static {
        keyMap.put(KeyCode.ENTER, 10);
        keyMap.put(KeyCode.BACK_SPACE, 8);
        keyMap.put(KeyCode.TAB, 9);
        keyMap.put(KeyCode.CANCEL, 3);
        keyMap.put(KeyCode.CLEAR, 12);
        keyMap.put(KeyCode.SHIFT, 16);
        keyMap.put(KeyCode.CONTROL, 17);
        keyMap.put(KeyCode.ALT, 18);
        keyMap.put(KeyCode.PAUSE, 19);
        keyMap.put(KeyCode.CAPS, 20);
        keyMap.put(KeyCode.ESCAPE, 27);
        keyMap.put(KeyCode.SPACE, 32);
        keyMap.put(KeyCode.PAGE_UP, 33);
        keyMap.put(KeyCode.PAGE_DOWN, 34);
        keyMap.put(KeyCode.END, 35);
        keyMap.put(KeyCode.HOME, 36);
        keyMap.put(KeyCode.LEFT, 37);
        keyMap.put(KeyCode.UP, 38);
        keyMap.put(KeyCode.RIGHT, 39);
        keyMap.put(KeyCode.DOWN, 40);
        keyMap.put(KeyCode.COMMA, 44);
        keyMap.put(KeyCode.MINUS, 45);
        keyMap.put(KeyCode.PERIOD, 46);
        keyMap.put(KeyCode.SLASH, 47);
        keyMap.put(KeyCode.DIGIT0, 48);
        keyMap.put(KeyCode.DIGIT1, 49);
        keyMap.put(KeyCode.DIGIT2, 50);
        keyMap.put(KeyCode.DIGIT3, 51);
        keyMap.put(KeyCode.DIGIT4, 52);
        keyMap.put(KeyCode.DIGIT5, 53);
        keyMap.put(KeyCode.DIGIT6, 54);
        keyMap.put(KeyCode.DIGIT7, 55);
        keyMap.put(KeyCode.DIGIT8, 56);
        keyMap.put(KeyCode.DIGIT9, 57);
        keyMap.put(KeyCode.SEMICOLON, 59);
        keyMap.put(KeyCode.EQUALS, 61);
        keyMap.put(KeyCode.A, 65);
        keyMap.put(KeyCode.B, 66);
        keyMap.put(KeyCode.C, 67);
        keyMap.put(KeyCode.D, 68);
        keyMap.put(KeyCode.E, 69);
        keyMap.put(KeyCode.F, 70);
        keyMap.put(KeyCode.G, 71);
        keyMap.put(KeyCode.H, 72);
        keyMap.put(KeyCode.I, 73);
        keyMap.put(KeyCode.J, 74);
        keyMap.put(KeyCode.K, 75);
        keyMap.put(KeyCode.L, 76);
        keyMap.put(KeyCode.M, 77);
        keyMap.put(KeyCode.N, 78);
        keyMap.put(KeyCode.O, 79);
        keyMap.put(KeyCode.P, 80);
        keyMap.put(KeyCode.Q, 81);
        keyMap.put(KeyCode.R, 82);
        keyMap.put(KeyCode.S, 83);
        keyMap.put(KeyCode.T, 84);
        keyMap.put(KeyCode.U, 85);
        keyMap.put(KeyCode.V, 86);
        keyMap.put(KeyCode.W, 87);
        keyMap.put(KeyCode.X, 88);
        keyMap.put(KeyCode.Y, 89);
        keyMap.put(KeyCode.Z, 90);
        keyMap.put(KeyCode.OPEN_BRACKET, 91);
        keyMap.put(KeyCode.BACK_SLASH, 92);
        keyMap.put(KeyCode.CLOSE_BRACKET, 93);
        keyMap.put(KeyCode.NUMPAD0, 96);
        keyMap.put(KeyCode.NUMPAD1, 97);
        keyMap.put(KeyCode.NUMPAD2, 98);
        keyMap.put(KeyCode.NUMPAD3, 99);
        keyMap.put(KeyCode.NUMPAD4, 100);
        keyMap.put(KeyCode.NUMPAD5, 101);
        keyMap.put(KeyCode.NUMPAD6, 102);
        keyMap.put(KeyCode.NUMPAD7, 103);
        keyMap.put(KeyCode.NUMPAD8, 104);
        keyMap.put(KeyCode.NUMPAD9, 105);
        keyMap.put(KeyCode.MULTIPLY, 106);
        keyMap.put(KeyCode.ADD, 107);
        keyMap.put(KeyCode.SEPARATOR, 108);
        keyMap.put(KeyCode.SUBTRACT, 109);
        keyMap.put(KeyCode.DECIMAL, 110);
        keyMap.put(KeyCode.DIVIDE, 111);
        keyMap.put(KeyCode.DELETE, 127);
        keyMap.put(KeyCode.NUM_LOCK, 144);
        keyMap.put(KeyCode.SCROLL_LOCK, 145);
        keyMap.put(KeyCode.F1, 112);
        keyMap.put(KeyCode.F2, 113);
        keyMap.put(KeyCode.F3, 114);
        keyMap.put(KeyCode.F4, 115);
        keyMap.put(KeyCode.F5, 116);
        keyMap.put(KeyCode.F6, 117);
        keyMap.put(KeyCode.F7, 118);
        keyMap.put(KeyCode.F8, 119);
        keyMap.put(KeyCode.F9, 120);
        keyMap.put(KeyCode.F10, 121);
        keyMap.put(KeyCode.F11, 122);
        keyMap.put(KeyCode.F12, 123);
        keyMap.put(KeyCode.F13, 61440);
        keyMap.put(KeyCode.F14, 61441);
        keyMap.put(KeyCode.F15, 61442);
        keyMap.put(KeyCode.F16, 61443);
        keyMap.put(KeyCode.F17, 61444);
        keyMap.put(KeyCode.F18, 61445);
        keyMap.put(KeyCode.F19, 61446);
        keyMap.put(KeyCode.F20, 61447);
        keyMap.put(KeyCode.F21, 61448);
        keyMap.put(KeyCode.F22, 61449);
        keyMap.put(KeyCode.F23, 61450);
        keyMap.put(KeyCode.F24, 61451);
        keyMap.put(KeyCode.PRINTSCREEN, 154);
        keyMap.put(KeyCode.INSERT, 155);
        keyMap.put(KeyCode.HELP, 156);
        keyMap.put(KeyCode.META, 157);
        keyMap.put(KeyCode.BACK_QUOTE, 192);
        keyMap.put(KeyCode.QUOTE, 222);
        keyMap.put(KeyCode.KP_UP, 224);
        keyMap.put(KeyCode.KP_DOWN, 225);
        keyMap.put(KeyCode.KP_LEFT, 226);
        keyMap.put(KeyCode.KP_RIGHT, 227);
        keyMap.put(KeyCode.DEAD_GRAVE, 128);
        keyMap.put(KeyCode.DEAD_ACUTE, 129);
        keyMap.put(KeyCode.DEAD_CIRCUMFLEX, 130);
        keyMap.put(KeyCode.DEAD_TILDE, 131);
        keyMap.put(KeyCode.DEAD_MACRON, 132);
        keyMap.put(KeyCode.DEAD_BREVE, 133);
        keyMap.put(KeyCode.DEAD_ABOVEDOT, 134);
        keyMap.put(KeyCode.DEAD_DIAERESIS, 135);
        keyMap.put(KeyCode.DEAD_ABOVERING, 136);
        keyMap.put(KeyCode.DEAD_DOUBLEACUTE, 137);
        keyMap.put(KeyCode.DEAD_CARON, 138);
        keyMap.put(KeyCode.DEAD_CEDILLA, 139);
        keyMap.put(KeyCode.DEAD_OGONEK, 140);
        keyMap.put(KeyCode.DEAD_IOTA, 141);
        keyMap.put(KeyCode.DEAD_VOICED_SOUND, 142);
        keyMap.put(KeyCode.DEAD_SEMIVOICED_SOUND, 143);
        keyMap.put(KeyCode.AMPERSAND, 150);
        keyMap.put(KeyCode.ASTERISK, 151);
        keyMap.put(KeyCode.QUOTEDBL, 152);
        keyMap.put(KeyCode.LESS, 153);
        keyMap.put(KeyCode.GREATER, 160);
        keyMap.put(KeyCode.BRACELEFT, 161);
        keyMap.put(KeyCode.BRACERIGHT, 162);
        keyMap.put(KeyCode.AT, 512);
        keyMap.put(KeyCode.COLON, 513);
        keyMap.put(KeyCode.CIRCUMFLEX, 514);
        keyMap.put(KeyCode.DOLLAR, 515);
        keyMap.put(KeyCode.EURO_SIGN, 516);
        keyMap.put(KeyCode.EXCLAMATION_MARK, 517);
        keyMap.put(KeyCode.INVERTED_EXCLAMATION_MARK, 518);
        keyMap.put(KeyCode.LEFT_PARENTHESIS, 519);
        keyMap.put(KeyCode.NUMBER_SIGN, 520);
        keyMap.put(KeyCode.PLUS, 521);
        keyMap.put(KeyCode.RIGHT_PARENTHESIS, 522);
        keyMap.put(KeyCode.UNDERSCORE, 523);
        keyMap.put(KeyCode.WINDOWS, 524);
        keyMap.put(KeyCode.CONTEXT_MENU, 525);
        keyMap.put(KeyCode.FINAL, 24);
        keyMap.put(KeyCode.CONVERT, 28);
        keyMap.put(KeyCode.NONCONVERT, 29);
        keyMap.put(KeyCode.ACCEPT, 30);
        keyMap.put(KeyCode.MODECHANGE, 31);
        keyMap.put(KeyCode.KANA, 21);
        keyMap.put(KeyCode.KANJI, 25);
        keyMap.put(KeyCode.ALPHANUMERIC, 240);
        keyMap.put(KeyCode.KATAKANA, 241);
        keyMap.put(KeyCode.HIRAGANA, 242);
        keyMap.put(KeyCode.FULL_WIDTH, 243);
        keyMap.put(KeyCode.HALF_WIDTH, 244);
        keyMap.put(KeyCode.ROMAN_CHARACTERS, 245);
        keyMap.put(KeyCode.ALL_CANDIDATES, 256);
        keyMap.put(KeyCode.PREVIOUS_CANDIDATE, 257);
        keyMap.put(KeyCode.CODE_INPUT, 258);
        keyMap.put(KeyCode.JAPANESE_KATAKANA, 259);
        keyMap.put(KeyCode.JAPANESE_HIRAGANA, 260);
        keyMap.put(KeyCode.JAPANESE_ROMAN, 261);
        keyMap.put(KeyCode.KANA_LOCK, 262);
        keyMap.put(KeyCode.INPUT_METHOD_ON_OFF, 263);
        keyMap.put(KeyCode.CUT, 65489);
        keyMap.put(KeyCode.COPY, 65485);
        keyMap.put(KeyCode.PASTE, 65487);
        keyMap.put(KeyCode.UNDO, 65483);
        keyMap.put(KeyCode.AGAIN, 65481);
        keyMap.put(KeyCode.FIND, 65488);
        keyMap.put(KeyCode.PROPS, 65482);
        keyMap.put(KeyCode.STOP, 65480);
        keyMap.put(KeyCode.COMPOSE, 65312);
        keyMap.put(KeyCode.ALT_GRAPH, 65406);
        keyMap.put(KeyCode.BEGIN, 65368);
        keyMap.put(KeyCode.UNDEFINED, 0);
        keyMap.put(KeyCode.SOFTKEY_0, 4096);
        keyMap.put(KeyCode.SOFTKEY_1, 4097);
        keyMap.put(KeyCode.SOFTKEY_2, 4098);
        keyMap.put(KeyCode.SOFTKEY_3, 4099);
        keyMap.put(KeyCode.SOFTKEY_4, 4100);
        keyMap.put(KeyCode.SOFTKEY_5, 4101);
        keyMap.put(KeyCode.SOFTKEY_6, 4102);
        keyMap.put(KeyCode.SOFTKEY_7, 4103);
        keyMap.put(KeyCode.SOFTKEY_8, 4104);
        keyMap.put(KeyCode.SOFTKEY_9, 4105);
        keyMap.put(KeyCode.GAME_A, 4106);
        keyMap.put(KeyCode.GAME_B, 4107);
        keyMap.put(KeyCode.GAME_C, 4108);
        keyMap.put(KeyCode.GAME_D, 4109);
        keyMap.put(KeyCode.STAR, 4110);
        keyMap.put(KeyCode.POUND, 4111);
    }
}

