/*
 * Decompiled with CFR 0.152.
 */
package com.sun.t2k;

import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.t2k.CharToGlyphMapper;
import com.sun.t2k.CompositeFontResource;
import com.sun.t2k.CompositeGlyphMapper;
import com.sun.t2k.CompositeStrike;
import com.sun.t2k.Disposer;
import com.sun.t2k.FallbackResource;
import com.sun.t2k.T2KFontFactory;
import com.sun.t2k.T2KFontFile;
import com.sun.t2k.T2KFontStrikeDesc;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class T2KCompositeFontResource
implements CompositeFontResource {
    private FontResource primaryResource;
    private FallbackResource fallbackResource;
    CompositeGlyphMapper mapper;
    Map<FontStrikeDesc, WeakReference<FontStrike>> strikeMap = new ConcurrentHashMap<FontStrikeDesc, WeakReference<FontStrike>>();
    private int hash;

    T2KCompositeFontResource(FontResource fontResource, String string) {
        if (!(fontResource instanceof T2KFontFile)) {
            Thread.dumpStack();
            throw new IllegalStateException("wrong resource type");
        }
        if (string != null) {
            T2KFontFactory.compResourceMap.put(string, this);
        }
        this.primaryResource = fontResource;
        int n = fontResource.getDefaultAAMode();
        this.fallbackResource = FallbackResource.getFallbackResource(n);
    }

    @Override
    public int getNumSlots() {
        return this.fallbackResource.getNumSlots() + 1;
    }

    @Override
    public FontResource getSlotResource(int n) {
        if (n == 0) {
            return this.primaryResource;
        }
        FontResource fontResource = this.fallbackResource.getSlotResource(n - 1);
        if (fontResource != null) {
            return fontResource;
        }
        return this.primaryResource;
    }

    @Override
    public String getFullName() {
        return this.primaryResource.getFullName();
    }

    @Override
    public String getFamilyName() {
        return this.primaryResource.getFamilyName();
    }

    @Override
    public String getStyleName() {
        return this.primaryResource.getStyleName();
    }

    @Override
    public String getLocaleFullName() {
        return this.primaryResource.getLocaleFullName();
    }

    @Override
    public String getLocaleFamilyName() {
        return this.primaryResource.getLocaleFamilyName();
    }

    @Override
    public String getLocaleStyleName() {
        return this.primaryResource.getLocaleStyleName();
    }

    @Override
    public int getNumGlyphs() {
        return this.primaryResource.getNumGlyphs();
    }

    @Override
    public boolean isBold() {
        return this.primaryResource.isBold();
    }

    @Override
    public boolean isItalic() {
        return this.primaryResource.isItalic();
    }

    public boolean supportsGlyphImages() {
        return true;
    }

    @Override
    public CharToGlyphMapper getGlyphMapper() {
        if (this.mapper == null) {
            this.mapper = new CompositeGlyphMapper(this);
        }
        return this.mapper;
    }

    @Override
    public float[] getGlyphBoundingBox(int n, float f, float[] fArray) {
        int n2 = n >>> 24;
        int n3 = n & 0xFFFFFF;
        FontResource fontResource = this.getSlotResource(n2);
        return fontResource.getGlyphBoundingBox(n3, f, fArray);
    }

    @Override
    public float getAdvance(int n, float f) {
        int n2 = n >>> 24;
        int n3 = n & 0xFFFFFF;
        FontResource fontResource = this.getSlotResource(n2);
        return fontResource.getAdvance(n3, f);
    }

    @Override
    public Map<FontStrikeDesc, WeakReference<FontStrike>> getStrikeMap() {
        return this.strikeMap;
    }

    @Override
    public int getDefaultAAMode() {
        return this.getSlotResource(0).getDefaultAAMode();
    }

    @Override
    public FontStrike getStrike(PGFont pGFont, BaseTransform baseTransform) {
        return this.getStrike(pGFont.getSize(), baseTransform, this.getDefaultAAMode());
    }

    @Override
    public FontStrike getStrike(float f, BaseTransform baseTransform) {
        return this.getStrike(f, baseTransform, this.getDefaultAAMode());
    }

    @Override
    public FontStrike getStrike(PGFont pGFont, BaseTransform baseTransform, int n) {
        return this.getStrike(pGFont.getSize(), baseTransform, n);
    }

    @Override
    public FontStrike getStrike(float f, BaseTransform baseTransform, int n) {
        T2KFontStrikeDesc t2KFontStrikeDesc = new T2KFontStrikeDesc(f, baseTransform, n);
        WeakReference<CompositeStrike> weakReference = this.strikeMap.get(t2KFontStrikeDesc);
        CompositeStrike compositeStrike = null;
        if (weakReference != null) {
            compositeStrike = (CompositeStrike)weakReference.get();
        }
        if (compositeStrike == null) {
            compositeStrike = new CompositeStrike(this, f, baseTransform, t2KFontStrikeDesc);
            weakReference = compositeStrike.disposer != null ? Disposer.addRecord(compositeStrike, compositeStrike.disposer) : new WeakReference<CompositeStrike>(compositeStrike);
            this.strikeMap.put(t2KFontStrikeDesc, weakReference);
        }
        return compositeStrike;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof T2KCompositeFontResource)) {
            return false;
        }
        T2KCompositeFontResource t2KCompositeFontResource = (T2KCompositeFontResource)object;
        return this.primaryResource.getFullName().equals(t2KCompositeFontResource.getFullName());
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.primaryResource.getFullName().hashCode();
        return this.hash;
    }
}

