/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.glass.ui.Screen;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.j2d.J2DPresentable;
import com.sun.prism.j2d.J2DPrismGraphics;
import com.sun.prism.j2d.J2DResourceFactory;
import com.sun.prism.j2d.J2DTexture;
import java.awt.Graphics2D;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class J2DRTTexture
extends J2DTexture
implements RTTexture {
    protected J2DResourceFactory factory;
    private boolean opaque;

    public J2DRTTexture(int n, int n2, J2DResourceFactory j2DResourceFactory) {
        super(PixelFormat.INT_ARGB_PRE, n, n2);
        this.factory = j2DResourceFactory;
        this.opaque = false;
    }

    @Override
    public int[] getPixels() {
        DataBuffer dataBuffer = this.bimg.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferInt) {
            return ((DataBufferInt)dataBuffer).getData();
        }
        return null;
    }

    @Override
    public boolean readPixels(Buffer buffer) {
        int n = this.getContentWidth();
        int n2 = this.getContentHeight();
        int[] nArray = this.getPixels();
        buffer.clear();
        for (int i = 0; i < n * n2; ++i) {
            int n3 = nArray[i];
            if (buffer instanceof IntBuffer) {
                ((IntBuffer)buffer).put(n3);
                continue;
            }
            if (!(buffer instanceof ByteBuffer)) continue;
            byte by = (byte)(n3 >> 24);
            byte by2 = (byte)(n3 >> 16);
            byte by3 = (byte)(n3 >> 8);
            byte by4 = (byte)n3;
            ((ByteBuffer)buffer).put(by);
            ((ByteBuffer)buffer).put(by2);
            ((ByteBuffer)buffer).put(by3);
            ((ByteBuffer)buffer).put(by4);
        }
        return true;
    }

    @Override
    public Graphics createGraphics() {
        J2DPresentable j2DPresentable = J2DPresentable.create(this.bimg, this.factory);
        Graphics2D graphics2D = this.bimg.createGraphics();
        return new J2DPrismGraphics(j2DPresentable, graphics2D);
    }

    public Graphics2D createAWTGraphics2D() {
        return this.bimg.createGraphics();
    }

    @Override
    public Screen getAssociatedScreen() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long getNativeDestHandle() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void update(Image image) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n, int n2) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n, int n2, int n3, int n4, boolean bl) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    @Override
    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }
}

