/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.shape;

import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.shape.TessCallbacks;
import com.sun.prism.opengl.glu.GLU;
import com.sun.prism.opengl.glu.GLUtessellator;

public final class TesselatorImpl {
    private final TessCallbacks listener;
    private final GLUtessellator tess;
    private final float[] coords = new float[6];

    public TesselatorImpl() {
        this.listener = new TessCallbacks();
        this.tess = GLU.gluNewTess();
        GLU.gluTessCallback(this.tess, 100100, this.listener);
        GLU.gluTessCallback(this.tess, 100101, this.listener);
        GLU.gluTessCallback(this.tess, 100102, this.listener);
        GLU.gluTessCallback(this.tess, 100105, this.listener);
        GLU.gluTessCallback(this.tess, 100103, this.listener);
        GLU.gluTessCallback(this.tess, 100104, this.listener);
    }

    public int generate(Shape shape, VertexBuffer vertexBuffer) {
        this.listener.setVertexBuffer(vertexBuffer);
        BaseTransform baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        PathIterator pathIterator = shape.getPathIterator(baseTransform, 1.0f);
        GLU.gluTessProperty(this.tess, 100140, pathIterator.getWindingRule() == 1 ? 100131.0 : 100130.0);
        boolean bl = false;
        GLU.gluTessBeginPolygon(this.tess, null);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(this.coords);
            switch (n) {
                case 0: {
                    if (bl) {
                        GLU.gluTessEndContour(this.tess);
                    }
                    GLU.gluTessBeginContour(this.tess);
                    bl = true;
                    double[] dArray = new double[]{this.coords[0], this.coords[1], 0.0};
                    GLU.gluTessVertex(this.tess, dArray, 0, dArray);
                    break;
                }
                case 1: {
                    if (TesselatorImpl.hasInfOrNaN(this.coords, 2)) break;
                    bl = true;
                    double[] dArray = new double[]{this.coords[0], this.coords[1], 0.0};
                    GLU.gluTessVertex(this.tess, dArray, 0, dArray);
                    break;
                }
                case 4: {
                    if (!bl) break;
                    GLU.gluTessEndContour(this.tess);
                    bl = false;
                    break;
                }
                default: {
                    throw new InternalError("Path must be flattened");
                }
            }
            pathIterator.next();
        }
        if (bl) {
            GLU.gluTessEndContour(this.tess);
        }
        GLU.gluTessEndPolygon(this.tess);
        return this.listener.getNumVerts();
    }

    private static boolean hasInfOrNaN(float[] fArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (!Float.isInfinite(fArray[i]) && !Float.isNaN(fArray[i])) continue;
            return true;
        }
        return false;
    }
}

