/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.shape;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathConsumer2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.openpisces.AlphaConsumer;
import com.sun.openpisces.Dasher;
import com.sun.openpisces.Renderer;
import com.sun.openpisces.Stroker;
import com.sun.openpisces.TransformingPathConsumer2D;
import com.sun.prism.BasicStroke;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.ShapeRasterizer;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class OpenPiscesRasterizer
implements ShapeRasterizer {
    private static MaskData emptyData = MaskData.create(new byte[1], 0, 0, 1, 1);
    private static final Renderer savedRenderer = new Renderer(3, 3);
    private static final Stroker savedStroker = new Stroker(savedRenderer);
    private static final Dasher savedDasher = new Dasher(savedStroker);
    private static Consumer savedConsumer;
    private static TransformingPathConsumer2D.FilterSet transformer;

    private static PathConsumer2D initRenderer(BasicStroke basicStroke, BaseTransform baseTransform, Rectangle rectangle, int n) {
        int n2 = basicStroke == null && n == 0 ? 0 : 1;
        savedRenderer.reset(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2);
        PathConsumer2D pathConsumer2D = transformer.getConsumer(savedRenderer, baseTransform);
        if (basicStroke != null) {
            savedStroker.reset(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit());
            savedStroker.setConsumer(pathConsumer2D);
            pathConsumer2D = savedStroker;
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                savedDasher.reset(fArray, basicStroke.getDashPhase());
                pathConsumer2D = savedDasher;
            }
        }
        return pathConsumer2D;
    }

    public static void feedConsumer(PathIterator pathIterator, PathConsumer2D pathConsumer2D) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    pathConsumer2D.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    pathConsumer2D.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    pathConsumer2D.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    pathConsumer2D.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    pathConsumer2D.closePath();
                }
            }
            pathIterator.next();
        }
        pathConsumer2D.pathDone();
    }

    @Override
    public MaskData getMaskData(Shape shape, BasicStroke basicStroke, RectBounds rectBounds, BaseTransform baseTransform, boolean bl) {
        Rectangle rectangle;
        if (basicStroke != null && basicStroke.getType() != 0) {
            shape = basicStroke.createStrokedShape(shape);
            basicStroke = null;
        }
        if (rectBounds == null) {
            if (basicStroke != null) {
                shape = basicStroke.createStrokedShape(shape);
                basicStroke = null;
            }
            rectBounds = new RectBounds();
            rectBounds = (RectBounds)baseTransform.transform(shape.getBounds(), rectBounds);
        }
        if ((rectangle = new Rectangle(rectBounds)).isEmpty()) {
            return emptyData;
        }
        Renderer renderer = null;
        if (shape instanceof Path2D) {
            renderer = this.setupRenderer((Path2D)shape, basicStroke, baseTransform, rectangle);
        }
        if (renderer == null) {
            renderer = this.setupRenderer(shape, basicStroke, baseTransform, rectangle);
        }
        int n = renderer.getOutpixMinX();
        int n2 = renderer.getOutpixMinY();
        int n3 = renderer.getOutpixMaxX();
        int n4 = renderer.getOutpixMaxY();
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (n5 <= 0 || n6 <= 0) {
            return emptyData;
        }
        Consumer consumer = savedConsumer;
        if (consumer == null || n5 * n6 > consumer.getAlphaLength()) {
            int n7 = n5 * n6 + 4095 & 0xFFFFF000;
            savedConsumer = consumer = new Consumer(n7);
            if (PrismSettings.verbose) {
                System.out.println("new alphas");
            }
        }
        consumer.setBoundsNoClone(n, n2, n5, n6);
        renderer.produceAlphas(consumer);
        return consumer.getMaskData();
    }

    public Renderer setupRenderer(Shape shape, BasicStroke basicStroke, BaseTransform baseTransform, Rectangle rectangle) {
        PathIterator pathIterator = shape.getPathIterator(null);
        OpenPiscesRasterizer.feedConsumer(pathIterator, OpenPiscesRasterizer.initRenderer(basicStroke, baseTransform, rectangle, pathIterator.getWindingRule()));
        return savedRenderer;
    }

    public Renderer setupRenderer(Path2D path2D, BasicStroke basicStroke, BaseTransform baseTransform, Rectangle rectangle) {
        PathConsumer2D pathConsumer2D = OpenPiscesRasterizer.initRenderer(basicStroke, baseTransform, rectangle, path2D.getWindingRule());
        float[] fArray = path2D.getFloatCoordsNoClone();
        byte[] byArray = path2D.getCommandsNoClone();
        int n = path2D.getNumCommands();
        int n2 = 0;
        block7: for (int i = 0; i < n; ++i) {
            switch (byArray[i]) {
                case 0: {
                    pathConsumer2D.moveTo(fArray[n2 + 0], fArray[n2 + 1]);
                    n2 += 2;
                    continue block7;
                }
                case 1: {
                    pathConsumer2D.lineTo(fArray[n2 + 0], fArray[n2 + 1]);
                    n2 += 2;
                    continue block7;
                }
                case 2: {
                    pathConsumer2D.quadTo(fArray[n2 + 0], fArray[n2 + 1], fArray[n2 + 2], fArray[n2 + 3]);
                    n2 += 4;
                    continue block7;
                }
                case 3: {
                    pathConsumer2D.curveTo(fArray[n2 + 0], fArray[n2 + 1], fArray[n2 + 2], fArray[n2 + 3], fArray[n2 + 4], fArray[n2 + 5]);
                    n2 += 6;
                    continue block7;
                }
                case 4: {
                    pathConsumer2D.closePath();
                }
            }
        }
        pathConsumer2D.pathDone();
        return savedRenderer;
    }

    static {
        transformer = new TransformingPathConsumer2D.FilterSet();
    }

    private static class Consumer
    implements AlphaConsumer {
        static byte[] savedAlphaMap;
        int x;
        int y;
        int width;
        int height;
        byte[] alphas;
        byte[] alphaMap;
        ByteBuffer alphabuffer;
        MaskData maskdata = new MaskData();

        public Consumer(int n) {
            this.alphas = new byte[n];
            this.alphabuffer = ByteBuffer.wrap(this.alphas);
        }

        public void setBoundsNoClone(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.maskdata.update(this.alphabuffer, n, n2, n3, n4);
        }

        @Override
        public int getOriginX() {
            return this.x;
        }

        @Override
        public int getOriginY() {
            return this.y;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public byte[] getAlphasNoClone() {
            return this.alphas;
        }

        public int getAlphaLength() {
            return this.alphas.length;
        }

        public MaskData getMaskData() {
            return this.maskdata;
        }

        @Override
        public void setMaxAlpha(int n) {
            byte[] byArray = savedAlphaMap;
            if (byArray == null || byArray.length != n + 1) {
                byArray = new byte[n + 1];
                for (int i = 0; i <= n; ++i) {
                    byArray[i] = (byte)((i * 255 + n / 2) / n);
                }
                savedAlphaMap = byArray;
            }
            this.alphaMap = byArray;
        }

        @Override
        public void setAndClearRelativeAlphas(int[] nArray, int n, int n2, int n3) {
            int n4 = this.width;
            int n5 = (n - this.y) * n4;
            byte[] byArray = this.alphas;
            byte[] byArray2 = this.alphaMap;
            int n6 = 0;
            for (int i = 0; i < n4; ++i) {
                nArray[i] = 0;
                byArray[n5 + i] = byArray2[n6 += nArray[i]];
            }
        }

        public void setAndClearRelativeAlphas2(int[] nArray, int n, int n2, int n3) {
            if (n3 >= n2) {
                int n4;
                byte[] byArray = this.alphas;
                byte[] byArray2 = this.alphaMap;
                int n5 = n2 - this.x;
                int n6 = n3 - this.x;
                int n7 = this.width;
                int n8 = (n - this.y) * n7;
                for (n4 = 0; n4 < n5; ++n4) {
                    byArray[n8 + n4] = 0;
                }
                int n9 = 0;
                while (n4 <= n6) {
                    byte by;
                    nArray[n4] = 0;
                    byArray[n8 + n4] = by = byArray2[n9 += nArray[n4]];
                    ++n4;
                }
                nArray[n4] = 0;
                while (n4 < n7) {
                    byArray[n8 + n4] = 0;
                    ++n4;
                }
            } else {
                Arrays.fill(nArray, 0);
            }
        }
    }
}

