/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.prism.impl.BufferUtil;
import com.sun.prism.paint.Color;
import java.nio.ByteBuffer;

public abstract class VertexBuffer {
    protected static final int BYTES_PER_FLOAT = 4;
    protected static final int BYTES_PER_INT = 4;
    protected static final int BYTES_PER_VC = 12;
    protected static final int BYTES_PER_TC = 8;
    protected static final int BYTES_PER_COLOR = 4;
    protected static final int BYTES_PER_VERT = 32;
    protected static final int BYTES_PER_TRI = 96;
    protected static final int BYTES_PER_QUAD = 192;
    protected static final int COLOR_OFFSET = 12;
    protected static final int TC0_OFFSET = 16;
    protected static final int TC1_OFFSET = 24;
    protected ByteBuffer buf;
    protected final boolean isLightweight;

    protected VertexBuffer(int n, boolean bl) {
        int n2 = n * 192;
        this.buf = BufferUtil.newByteBuffer(n2);
        this.isLightweight = bl;
    }

    protected abstract void flush(int var1);

    public abstract void setPerVertexColor(Color var1, float var2);

    public abstract void setPerVertexColor(float var1);

    public abstract void putColor();

    public abstract void putColor(float var1);

    public abstract void putColor(int var1, float var2, float var3, float var4, float var5);

    public abstract void putColor(int var1, float var2);

    public final void rewind() {
        this.buf.rewind();
    }

    public final void flush() {
        int n = this.buf.position() / 32;
        if (n > 0) {
            this.buf.rewind();
            this.flush(n);
        }
    }

    private void flushOrGrow() {
        if (this.isLightweight) {
            int n = (int)((double)this.buf.capacity() * 1.5);
            ByteBuffer byteBuffer = BufferUtil.newByteBuffer(n);
            this.buf.limit(this.buf.position()).rewind();
            byteBuffer.put(this.buf);
            this.buf = byteBuffer;
        } else {
            this.flush();
        }
    }

    private void ensureCapacityForQuad() {
        if (this.buf.remaining() < 192) {
            this.flushOrGrow();
        }
    }

    public void addVert(float f, float f2) {
        if (this.buf.remaining() < 32) {
            this.flushOrGrow();
        }
        this.buf.putFloat(f);
        this.buf.putFloat(f2);
        this.buf.putFloat(0.0f);
        this.putColor();
        this.buf.position(this.buf.position() + 16);
    }

    public void addVert(float f, float f2, float f3, float f4) {
        if (this.buf.remaining() < 32) {
            this.flushOrGrow();
        }
        this.buf.putFloat(f);
        this.buf.putFloat(f2);
        this.buf.putFloat(0.0f);
        this.putColor();
        this.buf.putFloat(f3);
        this.buf.putFloat(f4);
        this.buf.position(this.buf.position() + 8);
    }

    public void addVert(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.buf.remaining() < 32) {
            this.flushOrGrow();
        }
        this.buf.putFloat(f);
        this.buf.putFloat(f2);
        this.buf.putFloat(0.0f);
        this.putColor();
        this.buf.putFloat(f3);
        this.buf.putFloat(f4);
        this.buf.putFloat(f5);
        this.buf.putFloat(f6);
    }

    private void addVertNoCheck(float f, float f2) {
        this.buf.putFloat(f);
        this.buf.putFloat(f2);
        this.buf.putFloat(0.0f);
        this.putColor();
        this.buf.position(this.buf.position() + 16);
    }

    private void addVertNoCheck(float f, float f2, float f3, float f4) {
        this.buf.putFloat(f);
        this.buf.putFloat(f2);
        this.buf.putFloat(0.0f);
        this.putColor();
        this.buf.putFloat(f3);
        this.buf.putFloat(f4);
        this.buf.position(this.buf.position() + 8);
    }

    private void addVertNoCheck(float f, float f2, float f3, float f4, float f5) {
        this.buf.putFloat(f);
        this.buf.putFloat(f2);
        this.buf.putFloat(0.0f);
        this.putColor(f5);
        this.buf.putFloat(f3);
        this.buf.putFloat(f4);
        this.buf.position(this.buf.position() + 8);
    }

    private void addVertNoCheck(float f, float f2, float f3, float f4, float f5, float f6) {
        this.buf.putFloat(f);
        this.buf.putFloat(f2);
        this.buf.putFloat(0.0f);
        this.putColor();
        this.buf.putFloat(f3);
        this.buf.putFloat(f4);
        this.buf.putFloat(f5);
        this.buf.putFloat(f6);
    }

    public void addVerts(VertexBuffer vertexBuffer, int n) {
        int n2;
        int n3 = vertexBuffer.buf.limit();
        vertexBuffer.buf.rewind();
        for (int i = n / 3; i > 0; i -= n2) {
            int n4 = this.buf.remaining() / 96;
            if (n4 <= 0) {
                this.flushOrGrow();
                n4 = this.buf.remaining() / 96;
            }
            n2 = Math.min(n4, i);
            int n5 = n2 * 96;
            vertexBuffer.buf.limit(vertexBuffer.buf.position() + n5);
            this.buf.put(vertexBuffer.buf);
            vertexBuffer.buf.position(vertexBuffer.buf.limit());
        }
        vertexBuffer.buf.limit(n3);
    }

    public void updateVertexColors(int n) {
        int n2 = 28;
        this.buf.rewind();
        this.buf.position(this.buf.position() + 12);
        while (n > 0) {
            this.putColor();
            if (--n <= 0) continue;
            this.buf.position(this.buf.position() + n2);
        }
    }

    public float getVertX(int n) {
        return this.buf.getFloat(n * 32);
    }

    public float getVertY(int n) {
        return this.buf.getFloat(n * 32 + 4);
    }

    public void putVertData(int n, float f, float f2, float f3) {
        this.putColor(n, f);
        int n2 = n * 32 + 16;
        this.buf.putFloat(n2, f2);
        this.buf.putFloat(n2 + 4, f3);
    }

    public void addQuad(float f, float f2, float f3, float f4) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(f, f2);
        this.addVertNoCheck(f, f4);
        this.addVertNoCheck(f3, f2);
        this.addVertNoCheck(f3, f2);
        this.addVertNoCheck(f, f4);
        this.addVertNoCheck(f3, f4);
    }

    public void addQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(f, f2, f5, f6);
        this.addVertNoCheck(f, f4, f5, f8);
        this.addVertNoCheck(f3, f2, f7, f6);
        this.addVertNoCheck(f3, f2, f7, f6);
        this.addVertNoCheck(f, f4, f5, f8);
        this.addVertNoCheck(f3, f4, f7, f8);
    }

    public void addQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(f, f2, f5, f6, f9, f10);
        this.addVertNoCheck(f, f4, f5, f8, f9, f12);
        this.addVertNoCheck(f3, f2, f7, f6, f11, f10);
        this.addVertNoCheck(f3, f2, f7, f6, f11, f10);
        this.addVertNoCheck(f, f4, f5, f8, f9, f12);
        this.addVertNoCheck(f3, f4, f7, f8, f11, f12);
    }

    public void addMappedQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(f, f2, f5, f6);
        this.addVertNoCheck(f, f4, f9, f10);
        this.addVertNoCheck(f3, f2, f7, f8);
        this.addVertNoCheck(f3, f2, f7, f8);
        this.addVertNoCheck(f, f4, f9, f10);
        this.addVertNoCheck(f3, f4, f11, f12);
    }

    public void addMappedQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(f, f2, f5, f6, f13, f14);
        this.addVertNoCheck(f, f4, f9, f10, f17, f18);
        this.addVertNoCheck(f3, f2, f7, f8, f15, f16);
        this.addVertNoCheck(f3, f2, f7, f8, f15, f16);
        this.addVertNoCheck(f, f4, f9, f10, f17, f18);
        this.addVertNoCheck(f3, f4, f11, f12, f19, f20);
    }

    public void addMappedQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(f, f2, f5, f6, f13, f14);
        this.addVertNoCheck(f, f4, f9, f10, f13, f14);
        this.addVertNoCheck(f3, f2, f7, f8, f13, f14);
        this.addVertNoCheck(f3, f2, f7, f8, f13, f14);
        this.addVertNoCheck(f, f4, f9, f10, f13, f14);
        this.addVertNoCheck(f3, f4, f11, f12, f13, f14);
    }

    public void addMappedPgram(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(f, f2, f9, f10, f17, f18);
        this.addVertNoCheck(f5, f6, f13, f14, f17, f18);
        this.addVertNoCheck(f3, f4, f11, f12, f17, f18);
        this.addVertNoCheck(f3, f4, f11, f12, f17, f18);
        this.addVertNoCheck(f5, f6, f13, f14, f17, f18);
        this.addVertNoCheck(f7, f8, f15, f16, f17, f18);
    }

    public void addQuadVO(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.ensureCapacityForQuad();
        this.addVertNoCheck(f3, f4, f7, f8, f);
        this.addVertNoCheck(f3, f6, f7, f10, f2);
        this.addVertNoCheck(f5, f4, f9, f8, f);
        this.addVertNoCheck(f5, f4, f9, f8, f);
        this.addVertNoCheck(f3, f6, f7, f10, f2);
        this.addVertNoCheck(f5, f6, f9, f10, f2);
    }
}

