/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.camera;

import com.sun.javafx.geom.CameraImpl;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.GeneralTransform3D;

public abstract class PrismCameraImpl
implements CameraImpl {
    private Affine3D viewTx = new Affine3D();
    protected GeneralTransform3D projTx = new GeneralTransform3D();
    protected Rectangle viewport = new Rectangle(1, 1);
    protected Vec3d zero = new Vec3d(0.0, 0.0, 0.0);
    protected double aspect;
    protected static final double zNear = 0.1;
    protected static final double zFar = 100.0;

    protected PrismCameraImpl() {
    }

    public Affine3D getViewTransform(Affine3D affine3D) {
        if (affine3D == null) {
            affine3D = new Affine3D();
        }
        affine3D.setTransform(this.viewTx);
        return affine3D;
    }

    public GeneralTransform3D getProjectionTransform(GeneralTransform3D generalTransform3D) {
        if (generalTransform3D == null) {
            generalTransform3D = new GeneralTransform3D();
        }
        generalTransform3D.set(this.projTx);
        return generalTransform3D;
    }

    public Rectangle getViewport(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.setBounds(this.viewport);
        return rectangle;
    }

    public void setZero(Vec3d vec3d) {
        this.zero.set(vec3d);
    }

    public Vec3d getZero(Vec3d vec3d) {
        if (vec3d == null) {
            vec3d = new Vec3d();
        }
        vec3d.set(vec3d);
        return vec3d;
    }

    public GeneralTransform3D getProjViewTx(GeneralTransform3D generalTransform3D, int n, int n2, boolean bl) {
        if (generalTransform3D == null) {
            generalTransform3D = new GeneralTransform3D();
        }
        this.aspect = (double)n / (double)n2;
        this.viewport.setBounds(0, 0, n, n2);
        this.computeProjection(this.projTx, bl);
        this.computeViewTransform(this.viewTx);
        generalTransform3D.set(this.projTx);
        generalTransform3D.mul(this.viewTx);
        return generalTransform3D;
    }

    protected abstract void computeProjection(GeneralTransform3D var1, boolean var2);

    protected abstract void computeViewTransform(Affine3D var1);

    public abstract PickRay computePickRay(float var1, float var2, PickRay var3);
}

