/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.prism.PixelFormat;
import com.sun.prism.impl.BufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class Image {
    private final Buffer pixelBuffer;
    private final int minX;
    private final int minY;
    private final int width;
    private final int height;
    private final int scanlineStride;
    private final PixelFormat pixelFormat;

    public static Image fromIntArgbPreData(int[] nArray, int n, int n2) {
        return new Image(PixelFormat.INT_ARGB_PRE, nArray, n, n2);
    }

    public static Image fromIntArgbPreData(IntBuffer intBuffer, int n, int n2) {
        return new Image(PixelFormat.INT_ARGB_PRE, intBuffer, n, n2);
    }

    public static Image fromIntArgbPreData(IntBuffer intBuffer, int n, int n2, int n3) {
        return new Image(PixelFormat.INT_ARGB_PRE, intBuffer, n, n2, 0, 0, n3);
    }

    public static Image fromByteBgraPreData(byte[] byArray, int n, int n2) {
        return new Image(PixelFormat.BYTE_BGRA_PRE, byArray, n, n2);
    }

    public static Image fromByteBgraPreData(ByteBuffer byteBuffer, int n, int n2) {
        return new Image(PixelFormat.BYTE_BGRA_PRE, byteBuffer, n, n2);
    }

    public static Image fromByteBgraPreData(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return new Image(PixelFormat.BYTE_BGRA_PRE, byteBuffer, n, n2, 0, 0, n3);
    }

    public static Image fromByteRgbData(byte[] byArray, int n, int n2) {
        return new Image(PixelFormat.BYTE_RGB, byArray, n, n2);
    }

    public static Image fromByteRgbData(ByteBuffer byteBuffer, int n, int n2) {
        return new Image(PixelFormat.BYTE_RGB, byteBuffer, n, n2);
    }

    public static Image fromByteRgbData(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return new Image(PixelFormat.BYTE_RGB, byteBuffer, n, n2, 0, 0, n3);
    }

    public static Image fromByteGrayData(byte[] byArray, int n, int n2) {
        return new Image(PixelFormat.BYTE_GRAY, byArray, n, n2);
    }

    public static Image fromByteGrayData(ByteBuffer byteBuffer, int n, int n2) {
        return new Image(PixelFormat.BYTE_GRAY, byteBuffer, n, n2);
    }

    public static Image fromByteGrayData(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return new Image(PixelFormat.BYTE_GRAY, byteBuffer, n, n2, 0, 0, n3);
    }

    public static Image fromByteAlphaData(byte[] byArray, int n, int n2) {
        return new Image(PixelFormat.BYTE_ALPHA, byArray, n, n2);
    }

    public static Image fromByteAlphaData(ByteBuffer byteBuffer, int n, int n2) {
        return new Image(PixelFormat.BYTE_ALPHA, byteBuffer, n, n2);
    }

    public static Image fromByteAlphaData(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return new Image(PixelFormat.BYTE_ALPHA, byteBuffer, n, n2, 0, 0, n3);
    }

    public static Image fromByteApple422Data(byte[] byArray, int n, int n2) {
        return new Image(PixelFormat.BYTE_APPLE_422, byArray, n, n2);
    }

    public static Image fromByteApple422Data(ByteBuffer byteBuffer, int n, int n2) {
        return new Image(PixelFormat.BYTE_APPLE_422, byteBuffer, n, n2);
    }

    public static Image fromByteApple422Data(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return new Image(PixelFormat.BYTE_APPLE_422, byteBuffer, n, n2, 0, 0, n3);
    }

    public static Image fromFloatMapData(FloatBuffer floatBuffer, int n, int n2) {
        return new Image(PixelFormat.FLOAT_XYZW, floatBuffer, n, n2);
    }

    private Image(PixelFormat pixelFormat, int[] nArray, int n, int n2) {
        this(pixelFormat, IntBuffer.wrap(nArray), n, n2);
    }

    private Image(PixelFormat pixelFormat, byte[] byArray, int n, int n2) {
        this(pixelFormat, ByteBuffer.wrap(byArray), n, n2);
    }

    private Image(PixelFormat pixelFormat, Buffer buffer, int n, int n2) {
        this(pixelFormat, buffer, n, n2, 0, 0, 0);
    }

    private Image(PixelFormat pixelFormat, Buffer buffer, int n, int n2, int n3, int n4, int n5) {
        if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Format not supported " + pixelFormat.name());
        }
        if (n5 == 0) {
            n5 = n * pixelFormat.getBytesPerPixelUnit();
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Pixel buffer must be non-null");
        }
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Image dimensions must be > 0");
        }
        if (n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("Image minX and minY must be >= 0");
        }
        if ((n3 + n) * pixelFormat.getBytesPerPixelUnit() > n5) {
            throw new IllegalArgumentException("Image scanlineStride is too small");
        }
        if (n5 % pixelFormat.getBytesPerPixelUnit() != 0) {
            throw new IllegalArgumentException("Image scanlineStride must be a multiple of the pixel stride");
        }
        this.pixelFormat = pixelFormat;
        this.pixelBuffer = buffer;
        this.width = n;
        this.height = n2;
        this.minX = n3;
        this.minY = n4;
        this.scanlineStride = n5;
    }

    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public PixelFormat.DataType getDataType() {
        return this.pixelFormat.getDataType();
    }

    public int getBytesPerPixelUnit() {
        return this.pixelFormat.getBytesPerPixelUnit();
    }

    public Buffer getPixelBuffer() {
        return this.pixelBuffer;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getRowLength() {
        return this.scanlineStride / this.pixelFormat.getBytesPerPixelUnit();
    }

    public boolean isTightlyPacked() {
        return this.minX == 0 && this.minY == 0 && this.width == this.getRowLength();
    }

    public Image createSubImage(int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException("Subimage dimensions must be > 0");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Subimage minX and minY must be >= 0");
        }
        if (n + n3 > this.width) {
            throw new IllegalArgumentException("Subimage minX+width must be <= width of parent image");
        }
        if (n2 + n4 > this.height) {
            throw new IllegalArgumentException("Subimage minY+height must be <= height of parent image");
        }
        return new Image(this.pixelFormat, this.pixelBuffer, n3, n4, this.minX + n, this.minY + n2, this.scanlineStride);
    }

    public Image createPackedCopy() {
        int n = this.width * this.pixelFormat.getBytesPerPixelUnit();
        Buffer buffer = Image.createPackedBuffer(this.pixelBuffer, this.pixelFormat, this.minX, this.minY, this.width, this.height, this.scanlineStride);
        return new Image(this.pixelFormat, buffer, this.width, this.height, 0, 0, n);
    }

    public Image createPackedCopyIfNeeded() {
        int n = this.width * this.pixelFormat.getBytesPerPixelUnit();
        if (n == this.scanlineStride && this.minX == 0 && this.minY == 0) {
            return this;
        }
        return this.createPackedCopy();
    }

    public static Buffer createPackedBuffer(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5) {
        Buffer buffer2;
        if (n5 % pixelFormat.getBytesPerPixelUnit() != 0) {
            throw new IllegalArgumentException("Image scanlineStride must be a multiple of the pixel stride");
        }
        if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Format unsupported " + (Object)((Object)pixelFormat));
        }
        int n6 = pixelFormat.getElemsPerPixelUnit();
        int n7 = n5 / pixelFormat.getBytesPerPixelUnit();
        int n8 = n7 * n6;
        int n9 = n3 * n6;
        int n10 = n9 * n4;
        int n11 = n * n6 + n2 * n8;
        int n12 = 0;
        switch (pixelFormat.getDataType()) {
            case BYTE: {
                ByteBuffer byteBuffer = (ByteBuffer)buffer;
                ByteBuffer byteBuffer2 = BufferUtil.newByteBuffer(n10);
                for (int i = 0; i < n4; ++i) {
                    byteBuffer.limit(n11 + n9);
                    byteBuffer.position(n11);
                    byteBuffer2.limit(n12 + n9);
                    byteBuffer2.position(n12);
                    byteBuffer2.put(byteBuffer);
                    n11 += n8;
                    n12 += n9;
                }
                buffer2 = byteBuffer2;
                break;
            }
            case INT: {
                IntBuffer intBuffer = (IntBuffer)buffer;
                IntBuffer intBuffer2 = BufferUtil.newIntBuffer(n10);
                for (int i = 0; i < n4; ++i) {
                    intBuffer.limit(n11 + n9);
                    intBuffer.position(n11);
                    intBuffer2.limit(n12 + n9);
                    intBuffer2.position(n12);
                    intBuffer2.put(intBuffer);
                    n11 += n8;
                    n12 += n9;
                }
                buffer2 = intBuffer2;
                break;
            }
            case FLOAT: {
                FloatBuffer floatBuffer = (FloatBuffer)buffer;
                FloatBuffer floatBuffer2 = BufferUtil.newFloatBuffer(n10);
                for (int i = 0; i < n4; ++i) {
                    floatBuffer.limit(n11 + n9);
                    floatBuffer.position(n11);
                    floatBuffer2.limit(n12 + n9);
                    floatBuffer2.position(n12);
                    floatBuffer2.put(floatBuffer);
                    n11 += n8;
                    n12 += n9;
                }
                buffer2 = floatBuffer2;
                break;
            }
            default: {
                throw new InternalError("Unknown data type");
            }
        }
        buffer.limit(buffer.capacity());
        buffer.rewind();
        buffer2.limit(buffer2.capacity());
        buffer2.rewind();
        return buffer2;
    }

    public Image iconify(ByteBuffer byteBuffer, int n, int n2) {
        if (this.pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Format not supported " + (Object)((Object)this.pixelFormat));
        }
        int n3 = this.getBytesPerPixelUnit();
        int n4 = n * n3;
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.rewind();
        byteBuffer.get(byArray, 0, byArray.length);
        int[] nArray = new int[n * n2];
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6 = i * n4;
            for (int j = 0; j < n; ++j) {
                byte by;
                byte by2;
                byte by3;
                int n7 = -1;
                if (n3 == 1) {
                    by2 = by3 = byArray[n6++];
                    by = by3;
                } else if (this.pixelFormat == PixelFormat.BYTE_BGRA_PRE) {
                    by3 = byArray[n6++];
                    by2 = byArray[n6++];
                    by = byArray[n6++];
                    n7 = byArray[n6++];
                } else {
                    by = byArray[n6++];
                    by2 = byArray[n6++];
                    by3 = byArray[n6++];
                }
                nArray[n5++] = (n7 & 0xFF) << 24 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
            }
        }
        return new Image(PixelFormat.INT_ARGB_PRE, nArray, n, n2);
    }

    public String toString() {
        return super.toString() + " [format=" + (Object)((Object)this.pixelFormat) + " width=" + this.width + " height=" + this.height + " scanlineStride=" + this.scanlineStride + " minX=" + this.minX + " minY=" + this.minY + " pixelBuffer=" + this.pixelBuffer + " bpp=" + this.getBytesPerPixelUnit() + "]";
    }
}

