/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.logging;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.MemoryHandler;

public class Logger {
    public static final int OFF = Integer.MAX_VALUE;
    public static final int ERROR = 4;
    public static final int WARNING = 3;
    public static final int INFO = 2;
    public static final int DEBUG = 1;
    private static int currentLevel = Integer.MAX_VALUE;
    private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger("com.sun.media.jfxmedia");
    private static ConsoleHandler ch = null;
    private static MemoryHandler cmh = null;
    private static FileHandler fh = null;
    private static MemoryHandler fmh = null;
    private static String fh_pattern = null;
    private static boolean fh_pattern_valid = false;
    private static int fh_limit = 0;
    private static boolean fh_limit_valid = false;
    private static int fh_count = 0;
    private static boolean fh_count_valid = false;
    private static boolean fh_append = false;
    private static boolean fh_append_valid = false;

    private static void startLogger() {
        try {
            String level = System.getProperty("jfxmedia.loglevel", "off").toLowerCase();
            Integer logLevel = level.equals("debug") ? Integer.valueOf(1) : (level.equals("warning") ? Integer.valueOf(3) : (level.equals("error") ? Integer.valueOf(4) : (level.equals("info") ? Integer.valueOf(2) : Integer.valueOf(Integer.MAX_VALUE))));
            logger.setUseParentHandlers(false);
            Logger.setLevel(logLevel);
            Logger.enableConsoleHandler(false, 0, Integer.MAX_VALUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Logger.canLog(1)) {
            Logger.logMsg(1, "Logger initialized");
        }
    }

    private Logger() {
    }

    public static void initNative() {
        Logger.nativeInit();
        Logger.nativeSetNativeLevel(currentLevel);
    }

    private static native void nativeInit();

    public static void setLevel(int level) {
        currentLevel = level;
        logger.setLevel(Logger.getLoggerLevel(currentLevel));
        Logger.setHandlerLevel(ch);
        Logger.setHandlerLevel(cmh);
        Logger.setHandlerLevel(fh);
        Logger.setHandlerLevel(fmh);
        try {
            Logger.nativeSetNativeLevel(level);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    private static Level getLoggerLevel(int level) {
        if (level == Integer.MAX_VALUE) {
            return Level.OFF;
        }
        if (level == 4) {
            return Level.SEVERE;
        }
        if (level == 3) {
            return Level.WARNING;
        }
        if (level == 2) {
            return Level.INFO;
        }
        if (currentLevel == 1) {
            return Level.FINE;
        }
        return Level.OFF;
    }

    private static void setHandlerLevel(Handler handler) {
        if (handler == null) {
            return;
        }
        handler.setLevel(Logger.getLoggerLevel(currentLevel));
    }

    private static native void nativeSetNativeLevel(int var0);

    public static void push() {
        if (cmh != null) {
            cmh.push();
        }
        if (fmh != null) {
            fmh.push();
        }
    }

    public static boolean enableConsoleHandler(boolean buffered, int size, int pushLevel) {
        if (buffered) {
            if (cmh == null && ch == null && (ch = new ConsoleHandler()) != null) {
                Logger.setHandlerLevel(ch);
                cmh = new MemoryHandler(ch, size, Logger.getLoggerLevel(pushLevel));
                if (cmh != null) {
                    Logger.setHandlerLevel(cmh);
                    logger.addHandler(cmh);
                }
                return true;
            }
        } else if (ch == null && (ch = new ConsoleHandler()) != null) {
            Logger.setHandlerLevel(ch);
            logger.addHandler(ch);
            return true;
        }
        return false;
    }

    public static void disableConsoleHandler() {
        if (cmh != null && ch != null) {
            logger.removeHandler(cmh);
            cmh = null;
            ch = null;
        } else if (ch != null) {
            logger.removeHandler(ch);
            ch = null;
        }
    }

    public static ConsoleHandler getConsoleHandler() {
        return ch;
    }

    private static void resetFileHandlerProperties() {
        fh_pattern = null;
        fh_pattern_valid = false;
        fh_limit = 0;
        fh_limit_valid = false;
        fh_count = 0;
        fh_count_valid = false;
        fh_append = false;
        fh_append_valid = false;
    }

    public static void setFileHandlerProperties(String pattern) {
        Logger.resetFileHandlerProperties();
        fh_pattern = pattern;
        fh_pattern_valid = true;
    }

    public static void setFileHandlerProperties(String pattern, boolean append) {
        Logger.resetFileHandlerProperties();
        fh_pattern = pattern;
        fh_pattern_valid = true;
        fh_append = append;
        fh_append_valid = true;
    }

    public static void setFileHandlerProperties(String pattern, int limit, int count) {
        Logger.resetFileHandlerProperties();
        fh_pattern = pattern;
        fh_pattern_valid = true;
        fh_limit = limit;
        fh_limit_valid = true;
        fh_count = count;
        fh_count_valid = true;
    }

    public static void setFileHandlerProperties(String pattern, int limit, int count, boolean append) {
        Logger.resetFileHandlerProperties();
        fh_pattern = pattern;
        fh_pattern_valid = true;
        fh_limit = limit;
        fh_limit_valid = true;
        fh_count = count;
        fh_count_valid = true;
        fh_append = append;
        fh_append_valid = true;
    }

    private static FileHandler createFileHandler() {
        try {
            if (fh_pattern_valid && !fh_limit_valid && !fh_count_valid && !fh_append_valid) {
                return new FileHandler(fh_pattern);
            }
            if (fh_pattern_valid && !fh_limit_valid && !fh_count_valid && fh_append_valid) {
                return new FileHandler(fh_pattern, fh_append);
            }
            if (fh_pattern_valid && fh_limit_valid && fh_count_valid && !fh_append_valid) {
                return new FileHandler(fh_pattern, fh_limit, fh_count);
            }
            if (fh_pattern_valid && fh_limit_valid && fh_count_valid && fh_append_valid) {
                return new FileHandler(fh_pattern, fh_limit, fh_count, fh_append);
            }
            return new FileHandler();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean enableFileHandler(boolean buffered, int size, int pushLevel) {
        if (buffered) {
            if (fmh == null && fh == null && (fh = Logger.createFileHandler()) != null) {
                Logger.setHandlerLevel(fh);
                fmh = new MemoryHandler(fh, size, Logger.getLoggerLevel(pushLevel));
                if (fmh != null) {
                    Logger.setHandlerLevel(fmh);
                    logger.addHandler(fmh);
                }
                return true;
            }
        } else if (fh == null && (fh = Logger.createFileHandler()) != null) {
            Logger.setHandlerLevel(fh);
            logger.addHandler(fh);
            return true;
        }
        return false;
    }

    public static void disableFileHandler() {
        if (fmh != null && fh != null) {
            logger.removeHandler(fmh);
            fmh = null;
            fh = null;
        } else if (fh != null) {
            logger.removeHandler(fh);
            fh = null;
        }
    }

    public static FileHandler getFileHandler() {
        return fh;
    }

    public static boolean canLog(int level) {
        return level >= currentLevel;
    }

    public static void logMsg(int level, String msg) {
        if (level < currentLevel) {
            return;
        }
        if (level == 4) {
            logger.severe(msg);
        } else if (level == 3) {
            logger.warning(msg);
        } else if (level == 2) {
            logger.info(msg);
        } else if (level == 1) {
            logger.fine(msg);
        }
    }

    public static void logMsg(int level, String sourceClass, String sourceMethod, String msg) {
        if (level < currentLevel) {
            return;
        }
        logger.logp(Logger.getLoggerLevel(level), sourceClass, sourceMethod, msg);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Logger.startLogger();
                return null;
            }
        });
    }
}

