/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public abstract class ConnectionHolder {
    private static int DEFAULT_BUFFER_SIZE = 4096;
    ReadableByteChannel channel;
    ByteBuffer buffer = ByteBuffer.allocateDirect(DEFAULT_BUFFER_SIZE);

    static ConnectionHolder createURIConnectionHolder(URI uri) throws IOException {
        return new URIConnectionHolder(uri);
    }

    static ConnectionHolder createFileConectionHolder(URI uri) throws IOException {
        return new FileConnectionHolder(uri);
    }

    public final int readNextBlock() throws IOException {
        this.buffer.rewind();
        if (this.buffer.limit() < this.buffer.capacity()) {
            this.buffer.limit(this.buffer.capacity());
        }
        return this.channel.read(this.buffer);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    abstract int readBlock(long var1, int var3) throws IOException;

    abstract boolean needBuffer();

    abstract boolean isSeekable();

    abstract boolean isRandomAccess();

    public abstract boolean seek(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.channel = null;
        }
    }

    private static class URIConnectionHolder
    extends ConnectionHolder {
        private URI uri;
        private URLConnection urlConnection;

        URIConnectionHolder(URI uri) throws IOException {
            this.uri = uri;
            this.urlConnection = uri.toURL().openConnection();
            this.channel = this.openChannel();
        }

        boolean needBuffer() {
            String scheme = this.uri.getScheme().toLowerCase();
            return "http".equals(scheme);
        }

        boolean isSeekable() {
            return this.urlConnection instanceof HttpURLConnection || this.urlConnection instanceof JarURLConnection;
        }

        boolean isRandomAccess() {
            return false;
        }

        int readBlock(long position, int size) throws IOException {
            return -1;
        }

        public boolean seek(long position) {
            if (this.urlConnection instanceof HttpURLConnection) {
                this.closeConnection();
                try {
                    this.urlConnection = this.uri.toURL().openConnection();
                    HttpURLConnection httpConnection = (HttpURLConnection)this.urlConnection;
                    httpConnection.setRequestMethod("GET");
                    httpConnection.setUseCaches(false);
                    httpConnection.setRequestProperty("Range", "bytes=" + position + "-");
                    if (httpConnection.getResponseCode() != 206) {
                        long skip;
                        if (httpConnection.getResponseCode() != 200) {
                            httpConnection.disconnect();
                            this.urlConnection = this.uri.toURL().openConnection();
                        }
                        while ((position -= (skip = this.urlConnection.getInputStream().skip(position))) > 0L) {
                        }
                    }
                    this.channel = this.openChannel();
                    return true;
                }
                catch (IOException ioex) {
                    return false;
                }
            }
            if (this.urlConnection instanceof JarURLConnection) {
                try {
                    long skip;
                    this.closeConnection();
                    this.urlConnection = this.uri.toURL().openConnection();
                    while ((position -= (skip = this.urlConnection.getInputStream().skip(position))) > 0L) {
                    }
                    this.channel = this.openChannel();
                    return true;
                }
                catch (IOException ioex) {
                    return false;
                }
            }
            return false;
        }

        public void closeConnection() {
            super.closeConnection();
            if (this.urlConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.urlConnection).disconnect();
            }
            this.urlConnection = null;
        }

        private ReadableByteChannel openChannel() throws IOException {
            ReadableByteChannel ch = null;
            try {
                ch = AccessController.doPrivileged(new PrivilegedExceptionAction<ReadableByteChannel>(){

                    @Override
                    public ReadableByteChannel run() throws IOException {
                        return Channels.newChannel(URIConnectionHolder.this.urlConnection.getInputStream());
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
            return ch;
        }
    }

    private static class FileConnectionHolder
    extends ConnectionHolder {
        FileConnectionHolder(URI uri) throws IOException {
            this.channel = this.openFile(uri);
        }

        boolean needBuffer() {
            return false;
        }

        boolean isRandomAccess() {
            return true;
        }

        boolean isSeekable() {
            return true;
        }

        public boolean seek(long position) {
            try {
                ((FileChannel)this.channel).position(position);
                return true;
            }
            catch (IOException ioex) {
                return false;
            }
        }

        int readBlock(long position, int size) throws IOException {
            if (this.buffer.capacity() < size) {
                this.buffer = ByteBuffer.allocateDirect(size);
            }
            this.buffer.rewind().limit(size);
            return ((FileChannel)this.channel).read(this.buffer, position);
        }

        private ReadableByteChannel openFile(final URI uri) throws IOException {
            ReadableByteChannel result = null;
            try {
                result = AccessController.doPrivileged(new PrivilegedExceptionAction<ReadableByteChannel>(){

                    @Override
                    public ReadableByteChannel run() throws IOException {
                        RandomAccessFile file = new RandomAccessFile(new File(uri), "r");
                        return file.getChannel();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
            return result;
        }
    }
}

