/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.geom.CameraImpl;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.quantum.CursorUtils;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.GlassViewEventHandler;
import com.sun.javafx.tk.quantum.PrismPen;
import com.sun.javafx.tk.quantum.WindowStage;
import java.util.concurrent.Future;

public class ViewScene
extends GlassScene {
    private View platformView;
    private PrismPen pen;

    public ViewScene(boolean bl, boolean bl2) {
        super(bl, bl2);
        this.pen = new PrismPen(this, bl2);
        this.platformView = Application.GetApplication().createView(this.pen);
        this.platformView.setEventHandler(new GlassViewEventHandler(this));
    }

    public View getPlatformView() {
        return this.platformView;
    }

    public Future getPenFuture() {
        return this.pen.getFuture();
    }

    public Runnable getPenRunnable() {
        return this.pen.getPaintRunnable();
    }

    public void uploadPixels(Pixels pixels) {
        if (this.platformView != null) {
            this.platformView.uploadPixels(pixels);
        }
    }

    protected PrismPen getPen() {
        return this.pen;
    }

    @Override
    public void setGlassStage(GlassStage glassStage) {
        super.setGlassStage(glassStage);
    }

    WindowStage getWindowStage() {
        return (WindowStage)this.glassStage;
    }

    @Override
    public void setScene(Object object) {
        if (object == null && this.platformView != null) {
            this.platformView.close();
            this.platformView = null;
        }
    }

    @Override
    public void setRoot(PGNode pGNode) {
        super.setRoot(pGNode);
        this.pen.setRoot((NGNode)pGNode);
    }

    @Override
    public void setCamera(CameraImpl cameraImpl) {
        super.setCamera(cameraImpl);
        this.pen.setCamera(cameraImpl);
    }

    @Override
    public void setFillPaint(Object object) {
        super.setFillPaint(object);
        this.pen.setFillPaint(object);
    }

    @Override
    public void setCursor(final Object object) {
        super.setCursor(object);
        Application.postOnEventQueue(new Runnable(){

            @Override
            public void run() {
                CursorFrame cursorFrame = (CursorFrame)object;
                Cursor cursor = CursorUtils.getPlatformCursor(cursorFrame);
                cursor.set();
            }
        });
    }

    @Override
    void repaint() {
        this.pen.repaint();
    }

    @Override
    public void enableInputMethodEvents(boolean bl) {
        this.platformView.enableInputMethodEvents(bl);
    }

    @Override
    public void sceneChanged() {
        super.sceneChanged();
    }
}

