/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.javafx.tk.quantum.CollectedFuture;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.PaintRunnable;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.render.CompletionListener;
import com.sun.prism.render.RenderJob;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class QuantumRenderer
extends ThreadPoolExecutor
implements CompletionListener {
    private static boolean usePurgatory = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("decora.purgatory");
        }
    });
    private static boolean pulsedebug = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("quantum.pulsedebug");
        }
    });
    private Thread _renderer;
    private Throwable _initThrowable = null;
    private AtomicBoolean liveResizeInProgress = new AtomicBoolean(false);
    private CountDownLatch initLatch = new CountDownLatch(1);
    private static QuantumRenderer theInstance;

    private QuantumRenderer() {
        super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.setThreadFactory(new QuantumThreadFactory());
    }

    protected Throwable initThrowable() {
        return this._initThrowable;
    }

    private void setInitThrowable(Throwable throwable) {
        this._initThrowable = throwable;
    }

    protected void stopRenderer() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                QuantumRenderer.this.shutdown();
                return null;
            }
        });
        if (PrismSettings.verbose) {
            System.out.println("QuantumRenderer: shutdown");
        }
        assert (this.isShutdown());
        theInstance = null;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        return (RenderJob)runnable;
    }

    public boolean hasLiveResizeInProgress() {
        return this.liveResizeInProgress.get();
    }

    protected Future submitRenderJob(RenderJob renderJob) {
        return this.submit(renderJob);
    }

    @Override
    public void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        if (usePurgatory) {
            Screen screen = Screen.getMainScreen();
            Renderer renderer = Renderer.getRenderer(PrFilterContext.getInstance(screen));
            renderer.releasePurgatory();
        }
        Disposer.cleanUp();
    }

    @Override
    public void done(RenderJob renderJob) {
        CollectedFuture collectedFuture;
        PaintRenderJob paintRenderJob;
        if (renderJob instanceof PaintRenderJob) {
            paintRenderJob = (PaintRenderJob)renderJob;
            if (pulsedebug) {
                System.out.println("QR: PaintRenderJob(" + renderJob.hashCode() + ") done: upload: " + paintRenderJob.get());
            }
            collectedFuture = CollectedFuture.getInstance();
            if (paintRenderJob.get() != null) {
                collectedFuture.addUploadScene(paintRenderJob.getScene());
            }
        } else {
            throw new IllegalArgumentException("QR: unhandled job: " + renderJob.getClass().getName());
        }
        collectedFuture.renderComplete(paintRenderJob.getScene());
    }

    public void liveResizeRenderJob(GlassScene glassScene) {
        final ViewScene viewScene = (ViewScene)glassScene;
        if (!this.liveResizeInProgress.getAndSet(true)) {
            if (pulsedebug) {
                System.out.println("QR: liveResizeRenderJob");
            }
            RenderJob renderJob = new RenderJob(viewScene.getPenRunnable());
            renderJob.setCompletionListener(new CompletionListener(){

                @Override
                public void done(final RenderJob renderJob) {
                    final Object object = renderJob.get();
                    if (pulsedebug) {
                        System.out.println("QR: liveResizeRenderJob done: upload: " + object);
                    }
                    if (object == null) {
                        QuantumRenderer.this.liveResizeInProgress.set(false);
                    } else {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                viewScene.uploadPixels((Pixels)object);
                                renderJob.setFutureReturn(null);
                                if (pulsedebug) {
                                    System.out.println("QR: liveResizeRenderJob uploaded");
                                }
                                QuantumRenderer.this.liveResizeInProgress.set(false);
                            }
                        };
                        Application.postOnEventQueue(runnable);
                    }
                }
            });
            this.submit(renderJob);
        }
    }

    void checkRendererIdle() {
        if (PrismSettings.threadCheck && PaintRunnable.renderLock.isLocked()) {
            StackTraceElement[] stackTraceElementArray;
            CollectedFuture collectedFuture = CollectedFuture.getInstance();
            System.out.println("ERROR: PrismPen / FX threads co-running: DIRTY: " + collectedFuture.hasDirty().get() + " UPLOAD: " + collectedFuture.hasUpload().get() + " WAITING: " + collectedFuture.getPulseBarrier().getNumberWaiting());
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            QuantumToolkit quantumToolkit = (QuantumToolkit)QuantumToolkit.getToolkit();
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray = map.get(quantumToolkit.getFxUserThread());
            int n = stackTraceElementArray2.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[i];
                System.out.println("FX: " + stackTraceElement);
            }
            for (StackTraceElement stackTraceElement : stackTraceElementArray2 = map.get(this._renderer)) {
                System.out.println("QR: " + stackTraceElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized QuantumRenderer getToolkit() {
        if (theInstance != null) return theInstance;
        Class<QuantumRenderer> clazz = QuantumRenderer.class;
        synchronized (QuantumRenderer.class) {
            QuantumRenderer quantumRenderer;
            block6: {
                quantumRenderer = null;
                try {
                    quantumRenderer = new QuantumRenderer();
                    quantumRenderer.prestartCoreThread();
                    quantumRenderer.initLatch.await();
                }
                catch (Throwable throwable) {
                    quantumRenderer.setInitThrowable(throwable);
                    if (!PrismSettings.verbose) break block6;
                    throwable.printStackTrace();
                }
            }
            if (quantumRenderer.initThrowable() != null) {
                if (!PrismSettings.noFallback) throw new RuntimeException(quantumRenderer.initThrowable());
                System.err.println("Cannot initialize a graphics pipeline, and Prism fallback is disabled");
                throw new InternalError("Could not initialize prism toolkit, and the fallback is disabled.");
            }
            theInstance = quantumRenderer;
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    private class QuantumThreadFactory
    implements ThreadFactory {
        final AtomicInteger threadNumber = new AtomicInteger(0);

        private QuantumThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            final PipelineRunnable pipelineRunnable = new PipelineRunnable(runnable);
            QuantumRenderer.this._renderer = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    Thread thread = new Thread(pipelineRunnable);
                    thread.setName("QuantumRenderer-" + QuantumThreadFactory.this.threadNumber.getAndIncrement());
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread thread, Throwable throwable) {
                            System.out.println(thread.getName() + " uncaught: " + throwable.getClass().getName());
                            throwable.printStackTrace();
                        }
                    });
                    return thread;
                }
            });
            assert (this.threadNumber.get() == 1);
            return QuantumRenderer.this._renderer;
        }
    }

    private class PipelineRunnable
    implements Runnable {
        private Runnable work;

        public PipelineRunnable(Runnable runnable) {
            this.work = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            try {
                if (GraphicsPipeline.createPipeline() == null) {
                    String string = "Error initializing QuantumRenderer: no suitable pipeline found";
                    System.err.println(string);
                    throw new RuntimeException(string);
                }
                Map map = GraphicsPipeline.getPipeline().getDeviceDetails();
                Application.setDeviceDetails(map);
            }
            catch (Throwable throwable) {
                QuantumRenderer.this.setInitThrowable(throwable);
            }
            finally {
                QuantumRenderer.this.initLatch.countDown();
            }
        }

        public void cleanup() {
            GraphicsPipeline graphicsPipeline = GraphicsPipeline.getPipeline();
            if (graphicsPipeline != null) {
                graphicsPipeline.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.init();
                this.work.run();
            }
            finally {
                this.cleanup();
            }
        }
    }
}

